/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.openstack.recovery.utils.OpenStackRecoveryTool;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.tools.OpenStackBasicUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.EndRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Locale;
import java.util.Set;

public class OpenStackSynchronizeDataProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5467416927457531551L;
    private static final Log LOG = LogFactory.getInstance(OpenStackSynchronizeDataProcessor.class);
    private static final long MONITOR_TIME = 1440L;

    protected boolean execute(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        LOG.info((Object)"Enter into OpenStackSynchronizeDataProcessor,recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            return true;
        }
        ProtectGroup pg = context.getProtectGroup();
        String regionUuid = (String)pg.getProps().get("regionId");
        String projUuid = (String)pg.getProps().get("projectId");
        String replicatrionUuid = OpenStackRecoveryTool.getReplicaCgUuid(pg);
        if (this.checkProcType(recoveryPlan, pg)) {
            return true;
        }
        try {
            LOG.info((Object)"Sync begin. replicaUuid:%s, regionUuid:%s, projUuid:%s, recoveryPlan name=%s", new Object[]{replicatrionUuid, regionUuid, projUuid, OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).syncReplication(regionUuid, projUuid, replicatrionUuid, true);
            LOG.info((Object)"Sync monitoring. replicaUuid:%s, regionUuid:%s, projUuid:%s", new Object[]{replicatrionUuid, regionUuid, projUuid});
            for (long index = 0L; index < 1440L; ++index) {
                CommUtil.pauseThread((long)5000L);
                int progress = ((IVolumeService)ServiceLocator.getInstance().getService(IVolumeService.class)).getReplicationSyncProcess(regionUuid, projUuid, replicatrionUuid, true);
                if (100 != progress) continue;
                LOG.info((Object)String.format(Locale.ROOT, "Synchronize replication success. recoveryPlan name=%s", OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), 90160758784000L);
                if (this.changeProtectGroupStatusAndSendMsg(context, pg)) {
                    return false;
                }
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                return true;
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Executing protect group failed.recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)), (Throwable)e, 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)("Executing protect group failed.recoveryPlan name=" + OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947418", new String[0]);
            return false;
        }
        this.updateProcessDetail("lego.err.1073948744", new String[0]);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        LOG.info((Object)"Leave into OpenStackSynchronizeDataProcessor, recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
        return false;
    }

    private boolean checkProcType(RecoveryPlan recoveryPlan, ProtectGroup pg) {
        if (21 == pg.getTemplate().getType() && DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.getValue() != this.getProcType() && !this.isLastSynchronizeProcess()) {
            LOG.info((Object)"Recoveryplan is sync, recoveryPlan name=%s", new Object[]{OpenStackBasicUtil.getRecoveryPlanName(recoveryPlan)});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        return false;
    }

    private boolean changeProtectGroupStatusAndSendMsg(RecoveryProcessorContext context, ProtectGroup pg) {
        if (this.isLastSynchronizeProcess()) {
            Set protectGroups = context.getRecoveryPlan().getProtectGroups();
            String[] pgIds = RecoveryProcessUtil.getProtectGroupIds((Set)protectGroups);
            boolean result = RecoveryProcessUtil.changeProtectGroupStatus((String[])pgIds, (DrmEnumDefine.ProtectGroupStatus)DrmEnumDefine.ProtectGroupStatus.NORMAL);
            if (!result) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("lego.err.-1", new String[0]);
                return true;
            }
            IReprotectService reprotectService = (IReprotectService)ServiceLocator.getInstance().getService(IReprotectService.class);
            reprotectService.sendReprotectSuccessMsg(context.getRecoveryPlan());
            AlarmReporter.restoreAlarm((long)52625455L, (String[])new String[]{pg.getUuid()});
        }
        return false;
    }

    private boolean isLastSynchronizeProcess() {
        return null != this.getNextProcessor() && this.getNextProcessor() instanceof EndRecoveryProcessor;
    }

    protected String generateResultKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SynchronizeReplicationProcessor.des");
    }
}

