/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.recovery.processor.sfs;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsManilaManager;
import com.huawei.ism.drm.openstack.adapter.util.JsonUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.ShareMetadata;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class OpenStackSfsRefactorShareSubProcessor
extends BaseRecoveryProcessor {
    private static final Log LOG = LogFactory.getInstance(OpenStackSfsRefactorShareSubProcessor.class);
    private static final long serialVersionUID = -1972940878679441971L;
    private static ISfsFilemeterManager sfsFilemeterManager = ManagerFactory.getInstance().getSfsFilemeterManager();
    private static ISfsManilaManager sfsManilaManager = ManagerFactory.getInstance().getSfsManilaManager();
    private ProtectObject protectObject;
    private String pgPprojectIdKey;
    private String pgRegionIdKey;
    private String poSharePropKey;
    private String shareName;

    public OpenStackSfsRefactorShareSubProcessor() {
        LOG.debug((Object)"OpenStackSfsShairPairStatusCheckProcessor defautl constructor");
    }

    public OpenStackSfsRefactorShareSubProcessor(ProtectObject protectObject, String pgPprojectIdKey, String pgRegionIdKey, String poSharePropKey, String shareName) {
        this.protectObject = protectObject;
        this.pgPprojectIdKey = pgPprojectIdKey;
        this.pgRegionIdKey = pgRegionIdKey;
        this.poSharePropKey = poSharePropKey;
        this.shareName = shareName;
    }

    public String getName() {
        if ("pd_share".equals(this.poSharePropKey)) {
            return "com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsRefactorPrimaryShareSubProcessor";
        }
        return "com.huawei.ism.drm.openstack.recovery.processor.sfs.OpenStackSfsRefactorSecondaryShareSubProcessor";
    }

    public void updateProcNameParams() {
        this.updateProcessNameParams(new String[]{this.shareName});
    }

    protected boolean execute(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = this.protectObject.getProtectGroup();
        String projUuid = protectGroup.getProperty(this.pgPprojectIdKey);
        String regionUuid = protectGroup.getProperty(this.pgRegionIdKey);
        String tokenId = TokenUtil.getInstance().getTokenId(projUuid);
        UrlBaseParams urlBaseParams = new UrlBaseParams(projUuid, regionUuid, tokenId);
        Share share = JsonUtil.jsonToBean(this.protectObject.getProperty(this.poSharePropKey), Share.class);
        if (VerifyUtil.isEmpty((Object)share) || VerifyUtil.isEmpty((String)share.getShareType())) {
            LOG.error((Object)"The protectObject(%s) of protectGroup(%s) does not contain pdShare or drShare.", new Object[]{this.protectObject.getName(), protectGroup.getName()});
            throw new LegoCheckedException(1073949744L, new String[]{this.protectObject.getName()});
        }
        if ("dr_share".equals(this.poSharePropKey)) {
            this.updateTags(urlBaseParams, share, Collections.singletonList("__type_pd"), Collections.singletonList("__type_dr"));
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            return true;
        }
        this.updateTags(urlBaseParams, share, Collections.singletonList("__type_dr"), Collections.singletonList("__type_pd"));
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    private void updateTags(UrlBaseParams urlBaseParams, Share share, List<String> addTagList, List<String> deleteTagList) {
        Share shareRefreshed = this.getShare(urlBaseParams, share);
        ArrayList<String> tags = new ArrayList<String>();
        Optional.ofNullable(shareRefreshed).map(Share::getMetadata).map(ShareMetadata::getHypermetroTags).ifPresent(shareTags -> tags.addAll(Arrays.asList(shareTags.split("#"))));
        tags.removeAll(deleteTagList);
        for (String tag : addTagList) {
            if (tags.contains(tag)) continue;
            tags.add(tag);
        }
        sfsFilemeterManager.deleteTagToShare(urlBaseParams, share.getId(), share.getName());
        sfsFilemeterManager.addTagToShare(urlBaseParams, share, tags);
    }

    private Share getShare(UrlBaseParams urlBaseParams, Share share) {
        Share shareRefreshed = sfsManilaManager.queryShareById(urlBaseParams, share.getId());
        if (VerifyUtil.isEmpty((Object)shareRefreshed)) {
            LOG.error((Object)"The share(%s) is not exist.", new Object[]{share.getId()});
            throw new LegoCheckedException(1073949744L, new String[]{this.protectObject.getName()});
        }
        return shareRefreshed;
    }
}

