/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.drm.common.sdk.service.IRollBackExecutor;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsFilemeterManager;
import com.huawei.ism.drm.openstack.adapter.manager.ISfsManilaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PoShareInfo;
import com.huawei.ism.drm.openstack.sdk.bo.Share;
import com.huawei.ism.drm.openstack.sdk.bo.SharePair;
import com.huawei.ism.drm.openstack.sdk.bo.UrlBaseParams;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class OpenStackShareRollBackExecutor
implements IRollBackExecutor {
    private static final Log LOGGER = LogFactory.getInstance(OpenStackShareRollBackExecutor.class);
    private static final ISfsManilaManager MANILA = ManagerFactory.getInstance().getSfsManilaManager();
    private static final ISfsFilemeterManager FILEMETER = ManagerFactory.getInstance().getSfsFilemeterManager();

    public String getName() {
        return OpenStackShareRollBackExecutor.class.getSimpleName();
    }

    public boolean execute(String param) {
        PoShareInfo shareInfo = (PoShareInfo)JSONObject.toBean((String)param, PoShareInfo.class);
        if (this.checkParams(shareInfo)) {
            LOGGER.error((Object)"Rollback failed. The parameter is incorrect.");
            return false;
        }
        String tokenId = TokenUtil.getInstance().getTokenId(shareInfo.getProjUuid());
        String drTokenId = TokenUtil.getInstance().getTokenId(shareInfo.getDrProjUuid());
        UrlBaseParams pdUrlBaseParams = new UrlBaseParams(shareInfo.getProjUuid(), shareInfo.getRegionUuid(), tokenId);
        UrlBaseParams drUrlBaseParams = new UrlBaseParams(shareInfo.getDrProjUuid(), shareInfo.getRegionUuid(), drTokenId);
        Share pdShare = MANILA.queryShareById(pdUrlBaseParams, shareInfo.getPdShare().getId());
        if (!VerifyUtil.isEmpty((String)pdShare.getMetadata().getHypermetroTags())) {
            LOGGER.info((Object)"Tags have been set on the primary(%s) end and need to be deleted during rollback.", new Object[]{pdShare.getId()});
            FILEMETER.deleteTagToShare(pdUrlBaseParams, pdShare.getId(), pdShare.getName());
        }
        if (!VerifyUtil.isEmpty((Object)shareInfo.getSharePair()) && !VerifyUtil.isEmpty((String)shareInfo.getSharePair().getSharePairId())) {
            SharePair drSharePair;
            LOGGER.info((Object)"Delete the created pair and file system.");
            SharePair pdSharePair = FILEMETER.querySharePairById(pdUrlBaseParams, shareInfo.getSharePair().getSharePairId());
            if (!VerifyUtil.isEmpty((Object)pdSharePair) && !VerifyUtil.isEmpty((String)pdSharePair.getSharePairId())) {
                FILEMETER.deleteShareAndPair(pdUrlBaseParams, drUrlBaseParams, shareInfo.getSharePair().getSharePairId(), true, false);
            }
            if (!VerifyUtil.isEmpty((Object)(drSharePair = FILEMETER.querySharePairById(drUrlBaseParams, shareInfo.getSharePair().getSharePairId()))) && !VerifyUtil.isEmpty((String)drSharePair.getSharePairId())) {
                FILEMETER.deleteShareAndPair(drUrlBaseParams, null, shareInfo.getSharePair().getSharePairId(), false, true);
            }
        }
        if (!VerifyUtil.isEmpty((Object)shareInfo.getDrShare())) {
            Share drShare = MANILA.queryShareById(drUrlBaseParams, shareInfo.getDrShare().getId());
            LOGGER.info((Object)"Delete share(%s).", new Object[]{shareInfo.getDrShare().getId()});
            FILEMETER.deleteShare(drUrlBaseParams, drShare.getId(), drShare.getName());
        }
        if (VerifyUtil.isEmpty((Object)shareInfo.getDrShare()) && !VerifyUtil.isEmpty((Object)shareInfo.getDrFileSystem())) {
            LOGGER.info((Object)"Delete file systems(%s).", new Object[]{shareInfo.getDrFileSystem().getId()});
            FILEMETER.deleteFileSystem(drUrlBaseParams, shareInfo.getDrFileSystem().getId(), shareInfo.getDrFileSystem().getShareTypeName(), shareInfo.getDrFileSystem().getFsName());
        }
        LOGGER.info((Object)"Rollback succeeded.");
        return true;
    }

    private boolean checkParams(PoShareInfo poShareInfo) {
        if (VerifyUtil.isEmpty((Object)poShareInfo)) {
            LOGGER.error((Object)"The rollback parameter is abnormal. poShareInfo is null.");
            return true;
        }
        if (VerifyUtil.isEmpty((String)poShareInfo.getProjUuid()) || VerifyUtil.isEmpty((String)poShareInfo.getDrProjUuid())) {
            LOGGER.error((Object)"The rollback parameter is abnormal. projectId or drProjectId is null.");
            return true;
        }
        if (VerifyUtil.isEmpty((String)poShareInfo.getRegionUuid()) || VerifyUtil.isEmpty((String)poShareInfo.getDrRegionUuid())) {
            LOGGER.error((Object)"The rollback parameter is abnormal. regionId or drRegionId is null.");
            return true;
        }
        if (VerifyUtil.isEmpty((Object)poShareInfo.getPdShare())) {
            LOGGER.error((Object)"The rollback parameter is abnormal. pdShare is null.");
            return true;
        }
        return false;
    }
}

