/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.drm.common.sdk.service.IRollBackExecutor;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.manager.impl.DrExtendManager;
import com.huawei.ism.drm.openstack.adapter.manager.model.ReattchParam;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaPairInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.msg.ReconnectVolumeInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolAttachInfo;
import com.huawei.ism.drm.openstack.sdk.msg.VolumeReplicationCgInfo;
import com.huawei.ism.drm.openstack.sdk.service.IVolumeService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OpenStackVmResRollBackExecutor
implements IRollBackExecutor {
    private static final Log LOG = LogFactory.getInstance(OpenStackVmResRollBackExecutor.class);
    private static Map<String, Date> cgUuidLockMap = new ConcurrentHashMap<String, Date>();
    private IVolumeService volumeService;

    public void setVolumeService(IVolumeService volumeService) {
        this.volumeService = volumeService;
    }

    public String getName() {
        return "OpenStackVmResRollBackExecutor";
    }

    public boolean execute(String param) {
        if (VerifyUtil.isEmpty((String)param)) {
            LOG.warn((Object)"Param is empty.");
            return true;
        }
        LOG.info((Object)String.format(Locale.ROOT, "Start vmrollback param info=%s", param), 90160758786988L);
        JSONObject json = JSONObject.fromObject((Object)param);
        if (json.containsKey((Object)"rollbackupside")) {
            PoReplicaInfo activePoReplicaInfo = VerifyUtil.isEmpty((Map)json.getJSONObject("replicationInfo")) ? null : (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject("replicationInfo"), PoReplicaInfo.class);
            int operationType = json.getInt("operationType");
            if (OpenstackEnumDefine.RollbackOperationTypeE.ADD_PROTECTOBJECT.getType() == operationType || OpenstackEnumDefine.RollbackOperationTypeE.MODIFY_VOLUME.getType() == operationType) {
                this.switchAllRing(activePoReplicaInfo, operationType, json, false);
            }
            if (!VerifyUtil.isEmpty((Object)activePoReplicaInfo)) {
                this.rollbackWrap(param, activePoReplicaInfo, operationType);
            } else {
                this.rollback(param, "hypermetor_replicationInfo", "hypermetorside");
                this.rollback(param, "replicationInfo", "standbyside");
                this.rollback(param, "remote_replicationInfo", "activeside");
            }
            if (OpenstackEnumDefine.RollbackOperationTypeE.ADD_PROTECTOBJECT.getType() == operationType || OpenstackEnumDefine.RollbackOperationTypeE.MODIFY_VOLUME.getType() == operationType) {
                this.switchAllRing(activePoReplicaInfo, operationType, json, true);
            }
        } else {
            this.rollback(param, "replicationInfo", null);
        }
        if (json.containsKey((Object)"SERVICEINSTANCE_UUID")) {
            LOG.debug((Object)"Vmrollback.vha or csdr instance need update instance status to normal.");
            ServiceInstanceHelper.getInstance().changeStatus(json.get("SERVICEINSTANCE_UUID").toString(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL);
        }
        return true;
    }

    private void rollbackWrap(String param, PoReplicaInfo activePoReplicaInfo, int operationType) {
        LOG.info((Object)"Vmrollback.vmname=%s,vmUUID=%s, vmname belongs to vha+csdr.", new Object[]{activePoReplicaInfo.getVmName(), activePoReplicaInfo.getMoUuid()});
        VolumeReplicationCgInfo cgInfo = null;
        DrExtendManager mgr = new DrExtendManager();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(activePoReplicaInfo.getRegionUuid(), activePoReplicaInfo.getProjUuid());
        if (!VerifyUtil.isEmpty((String)activePoReplicaInfo.getCgUuid())) {
            cgInfo = mgr.queryRealtimeVolumeReplicationCG(activePoReplicaInfo.getRegionUuid(), tokenId, activePoReplicaInfo.getProjUuid(), OpenStackCommonUtil.getIdFromUuid(activePoReplicaInfo.getCgUuid()), new int[0]);
        }
        if (OpenstackEnumDefine.RollbackOperationTypeE.CREATE_PROTECTGROUP.getType() == operationType) {
            LOG.info((Object)"Vmrollback.vmname=%s,vmUUID=%s, start close and delete ring.", new Object[]{activePoReplicaInfo.getVmName(), activePoReplicaInfo.getMoUuid()});
            this.rollBackupCloseAndDeleteRing(param, "replicationInfo");
            LOG.info((Object)"Vmrollback.vmname=%s,vmUUID=%s, end close and delete ring.", new Object[]{activePoReplicaInfo.getVmName(), activePoReplicaInfo.getMoUuid()});
        }
        if (cgInfo != null && !OpenstackEnumDefine.ReplicationRepStatusE.STANDBY.getValue().equals(cgInfo.getReplicationStatus()) || null == cgInfo) {
            LOG.info((Object)"Vmrollback.vmname=%s,vmUUID=%s,delete replicationcg process(standby->hypermetro->production).", new Object[]{activePoReplicaInfo.getVmName(), activePoReplicaInfo.getMoUuid()});
            this.rollback(param, "remote_replicationInfo", "standbyside");
            this.rollback(param, "hypermetor_replicationInfo", "hypermetorside");
            this.rollback(param, "replicationInfo", "activeside");
        } else {
            LOG.info((Object)"Vmrollback.vmname=%s,vmUUID=%s,delete replicationcg process(production->hypermetro->standby,standby switch to active).", new Object[]{activePoReplicaInfo.getVmName(), activePoReplicaInfo.getMoUuid()});
            this.rollback(param, "replicationInfo", "standbyside");
            this.rollback(param, "hypermetor_replicationInfo", "hypermetorside");
            this.rollback(param, "remote_replicationInfo", "activeside");
        }
    }

    private void switchAllRing(PoReplicaInfo activePoReplicaInfo, int operationType, JSONObject json, boolean isOpen) {
        String action = isOpen ? "open" : "close";
        LOG.info((Object)"Vmrollback.vmname=%s,vmUUID=%s, add volume and vm need %s ring.operationType %s", new Object[]{activePoReplicaInfo != null ? activePoReplicaInfo.getVmName() : "", activePoReplicaInfo != null ? activePoReplicaInfo.getMoUuid() : "", action, operationType});
        int template = json.getInt("template");
        Map pgProp = json.toMap(String.class);
        if (34 != template && 37 != template) {
            return;
        }
        String standbyRingUuid = (String)pgProp.get("standbyDRRingUuid");
        String hyperRingUuid = (String)pgProp.get("hyperDRRingID");
        String proRingUuid = (String)pgProp.get("prodRingID");
        String projUuid = (String)pgProp.get("projectId");
        String drProjUuid = (String)pgProp.get("drProjectId");
        String regionUuid = (String)pgProp.get("regionId");
        String drRegionUuid = (String)pgProp.get("drRegionId");
        if (isOpen) {
            this.openRing(drProjUuid, drRegionUuid, standbyRingUuid);
            this.openRing(projUuid, regionUuid, proRingUuid);
            this.openRing(projUuid, regionUuid, hyperRingUuid);
        } else {
            this.closeRing(drProjUuid, drRegionUuid, standbyRingUuid, true);
            this.closeRing(projUuid, regionUuid, proRingUuid, true);
            this.closeRing(projUuid, regionUuid, hyperRingUuid, true);
        }
    }

    private void rollBackupCloseAndDeleteRing(String param, String operationPoRelication) {
        JSONObject json = JSONObject.fromObject((Object)param);
        if (VerifyUtil.isEmpty((Map)json.getJSONObject(operationPoRelication))) {
            LOG.info((Object)"Vmrollback.rollBackupCloseRing json  is null, rollback info=%s, operationPoRelication=%s", new Object[]{param, operationPoRelication});
            return;
        }
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject(operationPoRelication), PoReplicaInfo.class);
        if (VerifyUtil.isEmpty((Object)poReplicaInfo)) {
            LOG.info((Object)"Vmrollback.rollBackup close ring,json to bean error, poReplicaInfo is null");
            return;
        }
        String regionId = poReplicaInfo.getRegionUuid();
        String drRegionId = poReplicaInfo.getDrRegionUuid();
        String projectId = poReplicaInfo.getProjUuid();
        String drProjectId = poReplicaInfo.getDrProjUuid();
        String prodRingID = json.containsKey((Object)"prodRingID") ? json.getString("prodRingID") : null;
        String drStandByRingID = json.containsKey((Object)"standbyDRRingUuid") ? json.getString("standbyDRRingUuid") : null;
        String drHyperMetorRingID = json.containsKey((Object)"hyperDRRingID") ? json.getString("hyperDRRingID") : null;
        this.closRingWrap(poReplicaInfo, regionId, projectId, prodRingID);
        if (!VerifyUtil.isEmpty((String)drStandByRingID)) {
            LOG.debug((Object)"Vmrollback.vmname=%s,vmUUID=%s, close disaster standby ringid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), drStandByRingID});
            this.closeRing(drProjectId, drRegionId, drStandByRingID, true);
        }
        if (!VerifyUtil.isEmpty((String)drHyperMetorRingID)) {
            LOG.debug((Object)"Vmrollback.vmname=%s,vmUUID=%s, close disaster hypermetro ringid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), drHyperMetorRingID});
            this.closeRing(projectId, regionId, drHyperMetorRingID, true);
        }
        if (!VerifyUtil.isEmpty((String)drStandByRingID)) {
            LOG.debug((Object)"Vmrollback.vmname=%s,vmUUID=%s, delete disaster standby ring.ringid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), drStandByRingID});
            this.deleteRing(drProjectId, drRegionId, drStandByRingID, true);
        }
        if (!VerifyUtil.isEmpty((String)drHyperMetorRingID)) {
            LOG.debug((Object)"Vmrollback.vmname=%s,vmUUID=%s, delete disaster hypermetro ring.ringid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), drHyperMetorRingID});
            this.deleteRing(projectId, regionId, drHyperMetorRingID, true);
        }
        if (!VerifyUtil.isEmpty((String)prodRingID)) {
            LOG.debug((Object)"Vmrollback.vmname=%s,vmUUID=%s, delete production  ring.ringid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), prodRingID});
            this.deleteRing(projectId, regionId, prodRingID, true);
        }
    }

    private void closRingWrap(PoReplicaInfo poReplicaInfo, String regionId, String projectId, String prodRingID) {
        if (!VerifyUtil.isEmpty((String)prodRingID)) {
            LOG.debug((Object)"Vmrollback.vmname=%s,vmUUID=%s, close production ring.ringid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), prodRingID});
            this.closeRing(projectId, regionId, prodRingID, true);
        }
    }

    private void rollbackupDeleteVolume(String param, String operationPoRelication, String replicationSide) {
        JSONObject json = JSONObject.fromObject((Object)param);
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject(operationPoRelication), PoReplicaInfo.class);
        String regionId = poReplicaInfo.getRegionUuid();
        String drRegionId = poReplicaInfo.getDrRegionUuid();
        String projectId = poReplicaInfo.getProjUuid();
        String drProjectId = poReplicaInfo.getDrProjUuid();
        LOG.info((Object)"Vmrollback.vmname=%s, start delete volume.vmUUID=%s, replicationSide=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), replicationSide});
        if ("hypermetorside".equals(replicationSide)) {
            drRegionId = regionId;
            drProjectId = projectId;
        }
        if (!"standbyside".equals(replicationSide)) {
            this.deleteVolume(poReplicaInfo, drRegionId, drProjectId);
        }
        LOG.info((Object)"Vmrollback.vmname=%s, end delete volume,vmUUID=%s, replicationSide=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), replicationSide});
    }

    private void openRing(String projUuid, String regionUuid, String ringUuid) {
        try {
            this.volumeService.openRing(regionUuid, projUuid, ringUuid);
        }
        catch (LegoCheckedException e) {
            if (1073947394L == e.getErrorCode()) {
                LOG.error((Object)("Open ring success for rollback, ringUUID : " + ringUuid + " ex: " + ExceptionUtil.getErrorMessage((Throwable)e)));
                return;
            }
            LOG.error((Object)("Open ring fail, ringUUID : " + ringUuid + " ex: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw e;
        }
    }

    private void deleteTagToVm(PoReplicaInfo poReplicationInfo) {
        if (poReplicationInfo == null) {
            LOG.error((Object)"Vmrollback.deleting Tag from vm failed.param error,PoReplicaInfo is null");
            return;
        }
        String reginUuid = poReplicationInfo.getRegionUuid();
        String projectUuid = poReplicationInfo.getProjUuid();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(reginUuid, projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(reginUuid);
        String drRreginUuid = poReplicationInfo.getDrRegionUuid();
        String drProjectUuid = poReplicationInfo.getDrProjUuid();
        String drTokenId = TokenUtil.getInstance().getRegionTokenId(drRreginUuid, drProjectUuid);
        if (VerifyUtil.isEmpty((String)reginUuid) || VerifyUtil.isEmpty((String)projectUuid) || VerifyUtil.isEmpty((String)tokenId) || VerifyUtil.isEmpty((String)openstackUuid)) {
            LOG.error((Object)("Vmrollback.deleting Tag from vm failed.vmUUID=" + poReplicationInfo.getMoUuid() + ",some param is null,reginUuid:" + reginUuid + ", projectUuid:" + projectUuid + ", openstackUuid:" + openstackUuid + ", drRegionUuid:" + drRreginUuid + ", drprojectUuid:" + drProjectUuid));
            return;
        }
        if (VerifyUtil.isEmpty((String)drRreginUuid) || VerifyUtil.isEmpty((String)drProjectUuid) || VerifyUtil.isEmpty((String)drTokenId)) {
            LOG.info((Object)"Vmrollback.deleting Tag from vm failed.vmUUID=%s,some param is null, drRegionUuid:%s, drprojectUuid:%s", new Object[]{poReplicationInfo.getMoUuid(), drRreginUuid, drProjectUuid});
            return;
        }
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        this.removeTag(poReplicationInfo, reginUuid, projectUuid, tokenId, novaMgr);
        OpenStackVM phVm = novaMgr.getVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), new int[0]);
        novaMgr.deleteDrBackUpTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), phVm);
        PhVmInfo phVmInfo = poReplicationInfo.getPhVmInfo();
        if (!VerifyUtil.isEmpty((Object)phVmInfo) && !VerifyUtil.isEmpty((String)phVmInfo.getVmUuid())) {
            LOG.debug((Object)"Vmrollback.start deleting __type_dr Tag from phvm.vmUUID=%s", new Object[]{phVmInfo.getVmUuid()});
            novaMgr.deleteTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), "__type_dr");
            LOG.debug((Object)"Vmrollback.end deleting __type_dr Tag from phvm.vmUUID=%s", new Object[]{phVmInfo.getVmUuid()});
            LOG.debug((Object)"Vmrollback.start deleting __type_pd Tag from phvm.vmUUID=%s", new Object[]{phVmInfo.getVmUuid()});
            novaMgr.deleteTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), "__type_pd");
            LOG.debug((Object)"Vmrollback.end deleting __type_pd Tag from phvm.vmUUID=%s", new Object[]{phVmInfo.getVmUuid()});
            LOG.debug((Object)"Vmrollback.start deleting __type_csha Tag from phvm.vmUUID=%s", new Object[]{phVmInfo.getVmUuid()});
            novaMgr.deleteTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), "__type_csha");
            LOG.debug((Object)"Vmrollback.end deleting __type_csha Tag from phvm.vmUUID=%s", new Object[]{phVmInfo.getVmUuid()});
            OpenStackVM drVm = novaMgr.getVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), new int[0]);
            novaMgr.deleteDrBackUpTagFromVm(drRreginUuid, drTokenId, drProjectUuid, phVmInfo.getVmUuid(), drVm);
        }
    }

    private void removeTag(PoReplicaInfo poReplicationInfo, String reginUuid, String projectUuid, String tokenId, INovaManager novaMgr) {
        LOG.debug((Object)"Vmrollback.start deleting __type_pd Tag from production vm.vmUUID=%s", new Object[]{poReplicationInfo.getMoUuid()});
        novaMgr.deleteTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), "__type_pd");
        LOG.debug((Object)"Vmrollback.end deleting __type_pd Tag from production vm.vmUUID=%s", new Object[]{poReplicationInfo.getMoUuid()});
        LOG.debug((Object)"Vmrollback.start deleting __type_dr Tag from production vm.vmUUID=%s", new Object[]{poReplicationInfo.getMoUuid()});
        novaMgr.deleteTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), "__type_dr");
        LOG.debug((Object)"Vmrollback.end deleting __type_dr Tag from production vm.vmUUID=%s", new Object[]{poReplicationInfo.getMoUuid()});
        LOG.debug((Object)"Vmrollback.start deleting __type_csha Tag from production vm.vmUUID=%s", new Object[]{poReplicationInfo.getMoUuid()});
        novaMgr.deleteTagFromVm(reginUuid, tokenId, projectUuid, poReplicationInfo.getMoUuid(), "__type_csha");
        LOG.debug((Object)"Vmrollback.end deleting __type_csha  Tag from production vm.vmUUID=%s", new Object[]{poReplicationInfo.getMoUuid()});
    }

    private void deleteVolume(PoReplicaInfo poReplicaInfo, String drRegionId, String drProjectId) {
        List pairInfoList = poReplicaInfo.getPairInfos();
        LOG.debug((Object)"Vmrollback.vmname=%s, start delete volume, vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
        for (PoReplicaPairInfo pairInfo : pairInfoList) {
            String drVolumeUuid = pairInfo.getDrVolumeUuid();
            if (VerifyUtil.isEmpty((String)drVolumeUuid)) continue;
            LOG.debug((Object)"Vmrollback.vmname=%s,start delete volume,vmUUID=%s, drVolumeUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), drVolumeUuid});
            this.volumeService.delVolume(drVolumeUuid, drRegionId, drProjectId);
        }
        LOG.debug((Object)"Vmrollback.vmname=%s, end delete volume, vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
    }

    private void deleteReplica(String param, PoReplicaInfo poReplicaInfo, String regionId, String drRegionId, String projectId, String drProjectId) {
        this.removeReplicaFromCg(poReplicaInfo, true);
        this.removeReplicaFromCg(poReplicaInfo, false);
        List pairInfoList = poReplicaInfo.getPairInfos();
        LOG.info((Object)"Vmrollback.vmname=%s, start delete replication and volumeMetadata,vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
        for (PoReplicaPairInfo pairInfo : pairInfoList) {
            boolean isUpgrade;
            JSONObject json;
            String srcReplicaUuid = pairInfo.getReplicaUuid();
            String drReplicaUuid = pairInfo.getDrReplicaUuid();
            if (!VerifyUtil.isEmpty((String)srcReplicaUuid)) {
                LOG.debug((Object)"Vmrollback.vmname=%s, start delete production replication,vmUUID=%s, srcReplicaUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), srcReplicaUuid});
                this.volumeService.delVolReplica(regionId, projectId, srcReplicaUuid, false, false);
            }
            if (!VerifyUtil.isEmpty((String)drReplicaUuid)) {
                LOG.debug((Object)"Vmrollback.vmname=%s, start delete disaster replication,vmUUID=%s, drReplicaUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), drReplicaUuid});
                this.volumeService.delVolReplica(drRegionId, drProjectId, drReplicaUuid, false, false);
            }
            String serviceType = (json = JSONObject.fromObject((Object)param)).containsKey((Object)"serviceInstanceType") ? json.getString("serviceInstanceType") : "";
            String beforeUpgradeType = json.containsKey((Object)"BEFORE_UPGRADE_TYPE") ? json.get("BEFORE_UPGRADE_TYPE").toString() : "";
            boolean bl = isUpgrade = ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.isCurrent(serviceType) && (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.isCurrent(beforeUpgradeType) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.isCurrent(beforeUpgradeType));
            if (!isUpgrade && !VerifyUtil.isEmpty((String)pairInfo.getVolumeUuid())) {
                LOG.debug((Object)"Vmrollback.vmname=%s, start delete production volume metadata,vmUUID=%s, volumeUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), pairInfo.getVolumeUuid()});
                this.volumeService.deleteVolMetadatas(regionId, projectId, OpenStackCommonUtil.getIdFromUuid(pairInfo.getVolumeUuid()), "occupied_volume");
            }
            if (isUpgrade || VerifyUtil.isEmpty((String)pairInfo.getDrVolumeUuid())) continue;
            LOG.debug((Object)"Vmrollback.vmname=%s, start delete replication and volumeMetadata,vmUUID=%s, volumeUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), pairInfo.getDrVolumeUuid()});
            this.volumeService.deleteVolMetadatas(drRegionId, drProjectId, OpenStackCommonUtil.getIdFromUuid(pairInfo.getDrVolumeUuid()), "occupied_volume");
        }
        LOG.info((Object)"Vmrollback.vmname=%s, end delete replication and volumeMetadata,vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
    }

    private void removeReplicaFromCg(PoReplicaInfo poReplicaInfo, boolean isMaster) {
        String cgUuid;
        String regionUuid = isMaster ? poReplicaInfo.getRegionUuid() : poReplicaInfo.getDrRegionUuid();
        String projectUuid = isMaster ? poReplicaInfo.getProjUuid() : poReplicaInfo.getDrProjUuid();
        String string = cgUuid = isMaster ? poReplicaInfo.getCgUuid() : poReplicaInfo.getDrCgUuid();
        if (VerifyUtil.isEmpty((String)cgUuid)) {
            LOG.info((Object)"Vmrollback.vmname=%s, remove replication from Cg,vmUUID=%s, the cg is empty,need not to remove replications.cg is %s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), isMaster ? "production" : "disaster"});
            return;
        }
        Set replicaIdStillInCg = this.volumeService.getReplicaIdsOfCg(regionUuid, projectUuid, cgUuid);
        if (VerifyUtil.isEmpty((Collection)replicaIdStillInCg)) {
            LOG.info((Object)"Vmrollback.vmname=%s, remove replication from Cg,vmUUID=%s, the cg is has no replica now, cguuid=%s, replications cg is %s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), cgUuid, isMaster ? "production" : "disaster"});
            return;
        }
        HashSet<String> replicaIdSet = new HashSet<String>();
        for (PoReplicaPairInfo pairInfo : poReplicaInfo.getPairInfos()) {
            String replicaUuid = isMaster ? pairInfo.getReplicaUuid() : pairInfo.getDrReplicaUuid();
            String replicaId = OpenStackCommonUtil.getIdFromUuid(replicaUuid);
            if (!replicaIdStillInCg.contains(replicaId)) continue;
            replicaIdSet.add(replicaId);
        }
        if (replicaIdSet.isEmpty()) {
            LOG.info((Object)"Vmrollback.vmname=%s, remove replication from Cg,vmUUID=%s, target replications are not in cg now, cguuid=%s, replications cg is %s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), cgUuid, isMaster ? "production" : "disaster"});
            return;
        }
        this.volumeService.updateVolumeReplicationCG(regionUuid, projectUuid, cgUuid, null, replicaIdSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCg(PoReplicaInfo poReplicaInfo, String regionId, String drRegionId, String projectId, String drProjectId) {
        Date date;
        String replicaCgUuid = poReplicaInfo.getCgUuid();
        String drReplicaCgUuid = poReplicaInfo.getDrCgUuid();
        LOG.info((Object)"Vmrollback.vmname=%s, start delete CG,vmUUID=%s, replicaCgUuid=%s, drReplicaCgUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), replicaCgUuid, drReplicaCgUuid});
        if (!VerifyUtil.isEmpty((String)replicaCgUuid)) {
            LOG.debug((Object)"Vmrollback.vmname=%s, delete production CG,cguuid=%s,vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), replicaCgUuid, poReplicaInfo.getMoUuid()});
            this.genCgUuidLock(replicaCgUuid);
            date = cgUuidLockMap.get(replicaCgUuid);
            synchronized (date) {
                LOG.debug((Object)"Vmrollback.vmname=%s,succeed geting lock and start delete productionCG,cguuid=%s,vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), replicaCgUuid, poReplicaInfo.getMoUuid()});
                this.volumeService.delReplicaCG(regionId, projectId, replicaCgUuid, false, false);
                LOG.debug((Object)"Vmrollback.vmname=%s,succeed geting lock and end delete production CG,cguuid=%s,vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), replicaCgUuid, poReplicaInfo.getMoUuid()});
            }
        }
        if (!VerifyUtil.isEmpty((String)drReplicaCgUuid)) {
            LOG.debug((Object)"Vmrollback.vmname=%s delete disaster CG,cguuid=%s,vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), drReplicaCgUuid, poReplicaInfo.getMoUuid()});
            this.genCgUuidLock(drReplicaCgUuid);
            date = cgUuidLockMap.get(drReplicaCgUuid);
            synchronized (date) {
                LOG.debug((Object)"Vmrollback.vmname=%s,succeed geting lock and  start delete disaster CG,cguuid=%s,vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), drReplicaCgUuid, poReplicaInfo.getMoUuid()});
                this.volumeService.delReplicaCG(drRegionId, drProjectId, drReplicaCgUuid, false, false);
                LOG.debug((Object)"Vmrollback.vmname=%s,succeed deleting disaster CG,cguuid=%s,vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), drReplicaCgUuid, poReplicaInfo.getMoUuid()});
            }
        }
        LOG.info((Object)"Vmrollback.vmname=%s, end delete CG,vmUUID=%s, replicaCgUuid=%s, drReplicaCgUuid=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid(), replicaCgUuid, drReplicaCgUuid});
    }

    private synchronized void genCgUuidLock(String cgUuid) {
        if (cgUuidLockMap.containsKey(cgUuid)) {
            return;
        }
        if (cgUuidLockMap.size() > 20) {
            ArrayList<Date> lockObjList = new ArrayList<Date>(cgUuidLockMap.values());
            Collections.sort(lockObjList);
            Date value = (Date)lockObjList.get(0);
            for (Map.Entry<String, Date> entry : cgUuidLockMap.entrySet()) {
                if (!value.equals(entry.getValue())) continue;
                cgUuidLockMap.remove(entry.getKey());
                break;
            }
        }
        cgUuidLockMap.put(cgUuid, new Date());
    }

    public IVolumeService getVolumeService() {
        return this.volumeService;
    }

    private void closeRing(String projId, String regionId, String ringId, boolean splitFlag) {
        LOG.info((Object)"Rollback close ring:ringId=%s,splitFlag:%s", new Object[]{ringId, splitFlag});
        OpenStackCommonUtil.closeRing(this.volumeService, projId, regionId, ringId, String.valueOf(splitFlag));
    }

    private void deleteRing(String projId, String regionId, String ringId, boolean splitFlag) {
        LOG.info((Object)"Rollback delete ring:ringId=%s,splitFlag:%s", new Object[]{ringId, splitFlag});
        OpenStackCommonUtil.deleteRing(this.volumeService, projId, regionId, ringId, String.valueOf(splitFlag));
    }

    private boolean rollback(String param, String operationPoRelication, String replicationSide) {
        JSONObject json = JSONObject.fromObject((Object)param);
        if (this.checkParam(operationPoRelication, replicationSide, json)) {
            return true;
        }
        int operationType = json.getInt("operationType");
        if (null == json.getJSONObject(operationPoRelication)) {
            LOG.error((Object)"Vmrollback failed.rollback json  is null, rollback info=%s, operationPoRelication=%s", new Object[]{param, operationPoRelication});
            return false;
        }
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject(operationPoRelication), PoReplicaInfo.class);
        if (null == poReplicaInfo) {
            LOG.error((Object)"Vmrollback failed.json to bean error, poReplicaInfo is null");
            return false;
        }
        String regionId = poReplicaInfo.getRegionUuid();
        String drRegionId = poReplicaInfo.getDrRegionUuid();
        String projectId = poReplicaInfo.getProjUuid();
        String drProjectId = poReplicaInfo.getDrProjUuid();
        if (VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)drRegionId) || VerifyUtil.isEmpty((String)projectId) || VerifyUtil.isEmpty((String)drProjectId)) {
            LOG.error((Object)("Vmrollback failed. vmname=" + poReplicaInfo.getVmName() + " param is error.regionId=" + regionId + ",drRegionId=" + drRegionId + ",projectId=" + projectId + ",vmUUID=%s" + poReplicaInfo.getMoUuid()));
            return false;
        }
        LOG.info((Object)"Start vmrollback. vmname=%s %s, operationType=%s,vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), replicationSide != null ? ",belong to vha+csdr,replicationSide=" + replicationSide : "belong to other type.", operationType, poReplicaInfo.getMoUuid()});
        if (null != replicationSide && replicationSide.equals("hypermetorside")) {
            drRegionId = regionId;
            drProjectId = projectId;
        }
        this.reconnectVolumesAndDeleteTagToVm(replicationSide, json, operationType, poReplicaInfo);
        if (OpenstackEnumDefine.RollbackOperationTypeE.CREATE_PROTECTGROUP.getType() == operationType) {
            this.deleteCg(poReplicaInfo, regionId, drRegionId, projectId, drProjectId);
        }
        this.deleteReplica(param, poReplicaInfo, regionId, drRegionId, projectId, drProjectId);
        this.rollbackupDeleteVolume(param, operationPoRelication, replicationSide);
        LOG.info((Object)"Vmrollback succeed.vmname=%s,vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
        return true;
    }

    private void reconnectVolumesAndDeleteTagToVm(String replicationSide, JSONObject json, int operationType, PoReplicaInfo poReplicaInfo) {
        String serviceType = json.containsKey((Object)"serviceInstanceType") ? json.getString("serviceInstanceType") : "";
        boolean isSkipReconnect = this.isSkipReconnect(replicationSide, serviceType);
        if (!isSkipReconnect) {
            LOG.info((Object)"Vmrollback.vmname=%s,need to reconnctVolume.vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
            this.reconnectVolumes(poReplicaInfo);
        }
        if (this.isDeleteTag(replicationSide, operationType)) {
            LOG.info((Object)"Vmrollback.vmname=%s, start delete tag from vm.vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
            this.deleteTagToVm(poReplicaInfo);
            LOG.info((Object)"Vmrollback.vmname=%s, end delete tag from vm.vmUUID=%s", new Object[]{poReplicaInfo.getVmName(), poReplicaInfo.getMoUuid()});
        }
    }

    private boolean checkParam(String operationPoRelication, String replicationSide, JSONObject json) {
        String beforeUpgradeType;
        if (json.containsKey((Object)"BEFORE_UPGRADE_TYPE") && this.isNeedRollback(beforeUpgradeType = json.get("BEFORE_UPGRADE_TYPE").toString(), replicationSide)) {
            PoReplicaInfo tempPoReplicaInfo = (PoReplicaInfo)JSONObject.toBean((JSONObject)json.getJSONObject(operationPoRelication), PoReplicaInfo.class);
            LOG.debug((Object)"Vmrollback vmname=%s,Update instance type(VHA+HyperMetroSide and CSDR+ActiveSide)do not need rollback.beforeUpgradeType=%s, replicationSide=%s,vmUUID=%s", new Object[]{tempPoReplicaInfo != null ? tempPoReplicaInfo.getVmName() : " poReplicaInfo is null. ", beforeUpgradeType, replicationSide, tempPoReplicaInfo != null ? tempPoReplicaInfo.getMoUuid() : " is null. "});
            return true;
        }
        return false;
    }

    private void reconnectVolumes(PoReplicaInfo poReplicaInfo) {
        String vmUuid = poReplicaInfo.getMoUuid();
        String reginUuid = poReplicaInfo.getRegionUuid();
        String projectUuid = poReplicaInfo.getProjUuid();
        String tokenId = TokenUtil.getInstance().getRegionTokenId(reginUuid, projectUuid);
        String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(reginUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openstackUuid);
        List pairInfoList = poReplicaInfo.getPairInfos();
        LOG.info((Object)"Vmrollback.vmname=%s, vmUuid=%s, reconnectVolumes begin.", new Object[]{poReplicaInfo.getVmName(), vmUuid});
        for (PoReplicaPairInfo pairInfo : pairInfoList) {
            VolAttachInfo attachInfo;
            String volumeUuid = pairInfo.getVolumeUuid();
            String volumeId = OpenStackCommonUtil.getIdFromUuid(volumeUuid);
            LOG.info((Object)"Vmrollback.vmname=%s, vmUuid=%s,check volumeID=%s is attached.", new Object[]{poReplicaInfo.getVmName(), vmUuid, volumeUuid});
            if (!this.isAttach(reginUuid, projectUuid, vmUuid, volumeId) || !OpenStackCommonUtil.checkHyperMetroVolPath(attachInfo = novaMgr.getVolumeAttachInfo(vmUuid, reginUuid, tokenId, volumeId))) continue;
            LOG.info((Object)"Vmrollback.vmname=%s, vmUuid=%s, volume has HyperMetro Path. volumeId :%s", new Object[]{poReplicaInfo.getVmName(), vmUuid, volumeId});
            ReconnectVolumeInfo reconnVolumeInfo = new ReconnectVolumeInfo();
            reconnVolumeInfo.setVolumeId(volumeId);
            reconnVolumeInfo.setIsHyperMetro(Boolean.valueOf(false));
            novaMgr.reattachAndCheckVolume(new ReattchParam(reginUuid, projectUuid, tokenId), vmUuid, reconnVolumeInfo);
            LOG.info((Object)"Vmrollback.vmname=%s, vmUuid=%s, reconnectVolumes succussfully. volumeId :%s", new Object[]{poReplicaInfo.getVmName(), vmUuid, volumeId});
        }
    }

    private boolean isSkipReconnect(String replicationSide, String serviceType) {
        return ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(serviceType) || Arrays.asList("standbyside", "activeside").contains(replicationSide);
    }

    private boolean isDeleteTag(String replicationSide, int operationType) {
        return !"standbyside".equals(replicationSide) && (OpenstackEnumDefine.RollbackOperationTypeE.CREATE_PROTECTGROUP.getType() == operationType || OpenstackEnumDefine.RollbackOperationTypeE.ADD_PROTECTOBJECT.getType() == operationType);
    }

    private boolean isAttach(String reginUuid, String projectUuid, String vmUuid, String volumeId) {
        return this.volumeService.isAttachVM(reginUuid, projectUuid, vmUuid, volumeId) && OpenStackCommonUtil.isCurrentFCVersionHighThan63();
    }

    private boolean isNeedRollback(String beforeUpgradeType, String replicationSide) {
        return ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(beforeUpgradeType) && "hypermetorside".equals(replicationSide) || ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(beforeUpgradeType) && "activeside".equals(replicationSide);
    }
}

