/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.resource;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.sdk.service.IManagementProtocolService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.drm.galax.sdk.service.IGalaxMgrProtocol;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.model.DrFusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackProject;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.sdk.service.IOpenstackResourceService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public class OpenstackMgrProtocolImpl
implements IGalaxMgrProtocol {
    private static final Log LOG = LogFactory.getInstance(OpenstackMgrProtocolImpl.class);

    public NeMgrProtocolExtend getMgrProtocol(Long moId) {
        IManagementProtocolService service = (IManagementProtocolService)ServiceLocator.getInstance().getService(IManagementProtocolService.class);
        return service.findByMoId(moId);
    }

    public void validate(NeMgrProtocolExtend neMgrProtocol) {
        String ip = neMgrProtocol.getNetworkIpAddress();
        if (VerifyUtil.isEmpty((Object)neMgrProtocol.getMoId())) {
            throw new LegoCheckedException(1073947393L, "moId is empty.");
        }
        if (!CommUtil.checkDrmIpParam((String)ip) && !CommUtil.checkDrmDomainParam((String)ip)) {
            throw new LegoCheckedException(1073947393L, "ip is incorrect.");
        }
        Map extendParams = neMgrProtocol.getExtendParams();
        String authType = (String)extendParams.get("authType");
        String version = (String)extendParams.get("version");
        if (!(DiscParamValidator.stringisNull((String)authType) || "KeyStone".equals(authType) || "IAM".equals(authType))) {
            throw new LegoCheckedException(1073947393L, "authType is incorrect.");
        }
        if (!(DiscParamValidator.stringisNull((String)version) || "6.0".equalsIgnoreCase(version) || "6.1".equalsIgnoreCase(version))) {
            throw new LegoCheckedException(1073947393L, "version is incorrect.");
        }
        if (!this.checkParams(neMgrProtocol.getNetworkUserName(), neMgrProtocol.getNetworkPassword(), (String)extendParams.get("domain"), (String)extendParams.get("port")) || !this.checkRegions((String)extendParams.get("discoveryregions"))) {
            throw new LegoCheckedException(1073947393L, "uname, pwd, domain,port format error");
        }
    }

    private boolean checkParams(String userName, String pwd, String domain, String port) {
        try {
            if (!(CommUtil.checkParam((String)userName, (int)1, (int)255) && CommUtil.checkParam((String)pwd, (int)1, (int)64) && CommUtil.checkParam((String)domain, (int)1, (int)64))) {
                LOG.error((Object)"UserName or pwd is more than max length.", 90160758786989L);
                return false;
            }
            return CommUtil.checkDrmPortParam((String)port);
        }
        catch (Exception e) {
            LOG.error((Object)("Check port is error . parm:" + port + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            return false;
        }
    }

    private boolean checkRegions(String regions) {
        if (VerifyUtil.isEmpty((String)regions)) {
            return true;
        }
        try {
            JSONArray array = JSONArray.fromObject((Object)regions);
            if (null != array && array.size() > 64) {
                LOG.warn((Object)("The number of regions is gt than 64" + regions));
                return false;
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Regions is not a vailid json array." + regions), (Throwable)e);
            return false;
        }
        return true;
    }

    public void updateMgrProtocol(NeMgrProtocolExtend neMgrProtocol) {
        long moId = neMgrProtocol.getMoId();
        FusionSphereOpenStack openstack = (FusionSphereOpenStack)CommonDAOLocator.getMoDao().getMo(FusionSphereOpenStack.class, "moId", (Object)moId);
        if (openstack == null) {
            LOG.error((Object)("Openstack with mo Id(" + moId + ")'NeMgrProtocolExtend dosen't exist.Failed to update."), 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        String uuid = openstack.getUuid();
        IManagementProtocolService service = (IManagementProtocolService)ServiceLocator.getInstance().getService(IManagementProtocolService.class);
        NeMgrProtocolExtend mangementProtocol = service.findByMoId(Long.valueOf(moId));
        if (null == mangementProtocol) {
            LOG.error((Object)("Openstack(" + uuid + ")'NeMgrProtocolExtend dosen't exist.Failed to update."), 90160758786989L);
            throw new LegoCheckedException(201L);
        }
        Map mangementProtocolMap = mangementProtocol.getExtendParams();
        boolean isIPChanged = this.verifyIPAndUpdate(mangementProtocol, neMgrProtocol, openstack);
        boolean regionChanged = this.verifyRegionsAndUpdate(neMgrProtocol, mangementProtocolMap, uuid);
        boolean portChanged = this.verifyPortAndUpdate(mangementProtocolMap, neMgrProtocol);
        boolean loginInfoChanged = this.verifyLoginInfoAndUpdate(mangementProtocol, neMgrProtocol);
        this.checkOpenStackPasswd(mangementProtocolMap, mangementProtocol);
        if (isIPChanged) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)openstack);
            this.saveOrUpdateDrOpenstack(openstack);
        }
        if (regionChanged || isIPChanged || portChanged || loginInfoChanged) {
            mangementProtocol.setExtendParams(mangementProtocolMap);
            service.update(mangementProtocol);
            ManagerFactory.getInstance().removeRegOpenstack(openstack.getUuid());
            if (isIPChanged || portChanged || loginInfoChanged) {
                List projects = ((IOpenstackResourceService)ServiceLocator.getInstance().getService(IOpenstackResourceService.class)).getProjectFromDB(openstack.getUuid(), null);
                for (OpenStackProject porj : projects) {
                    TokenUtil.getInstance().removeToken(porj.getUuid());
                }
            }
        }
    }

    private void checkOpenStackPasswd(Map<String, String> paramMap, NeMgrProtocolExtend extend) {
        OpenstackInfo openInfo = new OpenstackInfo();
        String isIam = paramMap.get("authType");
        openInfo.setPort(paramMap.get("port"));
        openInfo.setDomainName(paramMap.get("domain"));
        openInfo.setUseIAM("IAM".equals(isIam));
        openInfo.setIp(extend.getNetworkIpAddress());
        openInfo.setUser(extend.getNetworkUserName());
        openInfo.setPasswd(extend.getNetworkPassword());
        LOG.info((Object)"CheckOpenStackPasswd:%s, ip:%s,  port:%s", new Object[]{isIam, openInfo.getIp(), openInfo.getPort()});
        String token = TokenUtil.getInstance().getTokenId(openInfo, null);
        if (VerifyUtil.isEmpty((String)token)) {
            throw new LegoCheckedException(1073947691L);
        }
    }

    private boolean verifyRegionsAndUpdate(NeMgrProtocolExtend neMgrProtocol, Map<String, String> mangementProtocolMap, String openstackUuid) {
        String newRegions = (String)neMgrProtocol.getExtendParams().get("discoveryregions");
        String regions = mangementProtocolMap.get("discoveryregions");
        LOG.debug((Object)"NewRegions:%s;regions:%s", new Object[]{newRegions, regions});
        if (VerifyUtil.isEmpty((String)newRegions) && !VerifyUtil.isEmpty((String)regions)) {
            mangementProtocolMap.remove("discoveryregions");
            return true;
        }
        if (!VerifyUtil.isEmpty((String)newRegions) && !newRegions.equals(regions)) {
            if (!this.checkRegions(newRegions)) {
                LOG.error((Object)("New regions is not validate:" + regions));
                throw new LegoCheckedException(1073947393L);
            }
            this.checkRegionUsed(newRegions, openstackUuid);
            mangementProtocolMap.put("discoveryregions", newRegions);
            return true;
        }
        return false;
    }

    private void checkRegionUsed(String regions, String openstackUuid) {
        JSONArray array = JSONArray.fromObject((Object)regions);
        if (null == array || array.isEmpty()) {
            return;
        }
        HashSet<String> regionSet = new HashSet<String>();
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            regionSet.add(array.getString(i));
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        List pgs = pgService.getAllProtectGroupBasicInfo(Long.valueOf(1L), false, true, false);
        if (VerifyUtil.isEmpty((Collection)pgs)) {
            return;
        }
        HashSet<String> usedRegion = new HashSet<String>();
        for (ProtectGroup pg : pgs) {
            String drRegionName;
            if (!openstackUuid.equals(pg.getPoProviderSN())) continue;
            String regionName = (String)pg.getProps().get("regionName");
            if (!VerifyUtil.isEmpty((String)regionName) && !regionSet.contains(regionName)) {
                LOG.warn((Object)("The region(" + regionName + ") used by pg(" + pg.getName() + ").regions is " + regions));
                usedRegion.add(regionName);
            }
            if (VerifyUtil.isEmpty((String)(drRegionName = (String)pg.getProps().get("drRegionName"))) || regionSet.contains(drRegionName)) continue;
            LOG.warn((Object)("The drregion(" + drRegionName + ") used by pg(" + pg.getName() + ").regions is " + regions));
            usedRegion.add(drRegionName);
        }
        if (!usedRegion.isEmpty()) {
            throw new LegoCheckedException(1073947854L, new String[]{OpenStackCommonUtil.getStringFromCollection(usedRegion, ",")}, "there are som region uesd by pg not contains.");
        }
    }

    private boolean verifyIPAndUpdate(NeMgrProtocolExtend mangementProtocolExtend, NeMgrProtocolExtend neMgrProtocolExtend, FusionSphereOpenStack openstack) {
        boolean whetherModify = false;
        String newIp = StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkIpAddress());
        String oldIp = mangementProtocolExtend.getNetworkIpAddress();
        if (!CommUtil.isNullStr((String)newIp) && !oldIp.equals(newIp)) {
            mangementProtocolExtend.setNetworkIpAddress(newIp);
            openstack.setIpAddress(newIp);
            openstack.setLinkIp(newIp);
            whetherModify = true;
        }
        return whetherModify;
    }

    private void saveOrUpdateDrOpenstack(FusionSphereOpenStack openstack) {
        List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrFusionSphereOpenStack where deviceSn = ? and siteId in (select siteId from Site where siteType = 0)", new Object[]{openstack.getSn()});
        if (!VerifyUtil.isEmpty((Collection)resources)) {
            DrFusionSphereOpenStack drVcenter = (DrFusionSphereOpenStack)resources.get(0);
            drVcenter.setStatus(openstack.getStatus() + "");
            drVcenter.setVersion(openstack.getVersion());
            drVcenter.setName(openstack.getName());
            drVcenter.setIpAddress(openstack.getLinkIp());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)drVcenter);
        }
    }

    private boolean verifyPortAndUpdate(Map<String, String> mangementProtocolMap, NeMgrProtocolExtend neMgrProtocolExtend) {
        String newPort;
        String existedPort = mangementProtocolMap.containsKey("port") ? mangementProtocolMap.get("port") : null;
        Map extendParams = neMgrProtocolExtend.getExtendParams();
        String string = newPort = extendParams != null ? (String)extendParams.get("port") : "";
        if (null == existedPort) {
            LOG.error((Object)"Current port is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        if (existedPort.equals(StringEscapeUtils.unescapeHtml4((String)newPort))) {
            LOG.info((Object)"Port does not be modified,port=%s", new Object[]{existedPort});
            return false;
        }
        CommUtil.checkDrmPortParam((String)newPort);
        mangementProtocolMap.put("port", StringEscapeUtils.unescapeHtml4((String)newPort));
        return true;
    }

    private boolean verifyLoginInfoAndUpdate(NeMgrProtocolExtend mangementProtocol, NeMgrProtocolExtend neMgrProtocolExtend) {
        if (VerifyUtil.isEmpty((String)neMgrProtocolExtend.getNetworkUserName()) || VerifyUtil.isEmpty((String)neMgrProtocolExtend.getNetworkPassword())) {
            return false;
        }
        Boolean whetherModify = false;
        if (!mangementProtocol.getNetworkUserName().equals(StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkUserName()))) {
            mangementProtocol.setNetworkUserName(StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkUserName()));
            whetherModify = true;
        }
        if (!mangementProtocol.getNetworkPassword().equals(StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkPassword()))) {
            mangementProtocol.setNetworkPassword(StringEscapeUtils.unescapeHtml4((String)neMgrProtocolExtend.getNetworkPassword()));
            whetherModify = true;
        }
        return whetherModify;
    }

    public String getSubResType() {
        return "ism.drm.deviceType.fusionsphereopenstack.subType";
    }
}

