/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance;

import com.huawei.ism.drm.openstack.sdk.model.FusionSphereOpenStack;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.TimerTask;

public class AutoReportMetersInfo
extends TimerTask {
    private static final Log LOG = LogFactory.getInstance(AutoReportMetersInfo.class);

    @Override
    public void run() {
        String uuid = null;
        try {
            FusionSphereOpenStack openstack = OpenStackCommonUtil.getOpenstack();
            if (VerifyUtil.isEmpty((Object)openstack)) {
                LOG.error((Object)"Openstack is empty.");
                return;
            }
            uuid = openstack.getUuid();
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            meterService.reportAllMeterInfo(openstack.getUuid());
        }
        catch (Exception t) {
            LOG.error((Object)("Timer report meterinfo fail, the uuid is " + uuid + ExceptionUtil.getErrorMessage((Throwable)t)));
        }
    }
}

