/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.checker;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.openstack.adapter.factory.ManagerFactory;
import com.huawei.ism.drm.openstack.adapter.manager.INovaManager;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.sdk.bo.CheckContext;
import com.huawei.ism.drm.openstack.sdk.bo.PhVmInfo;
import com.huawei.ism.drm.openstack.sdk.bo.PoReplicaInfo;
import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackVM;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstChecker;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class HoldVmCheckChecker
implements IServiceInstChecker {
    private static final Log LOG = LogFactory.getInstance(HoldVmCheckChecker.class);

    public void check(CheckContext context) {
        ServiceInstance serviceInstance = context.getInstanceInst();
        ProtectGroup pg = context.getPg();
        String instanceType = serviceInstance.getType();
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(instanceType)) {
            return;
        }
        String regionUuid = (String)pg.getProps().get("drRegionId");
        String projectUuid = (String)pg.getProps().get("drProjectId");
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projectUuid);
        boolean isCshaCsdr = "csha_csdr".equals(serviceInstance.getProtectType()) && !OpenStackCommonUtil.isCsdrCshaMode(pg);
        String hypermetorRegionUuid = isCshaCsdr ? (String)pg.getProps().get("regionId") : regionUuid;
        String hypermetorProjectUuid = isCshaCsdr ? (String)pg.getProps().get("projectId") : projectUuid;
        String hypermetorTokenId = isCshaCsdr ? TokenUtil.getInstance().getRegionTokenId(hypermetorRegionUuid, hypermetorProjectUuid) : tokenId;
        boolean isManualRefresh = this.isManualRefresh(pg);
        for (ProtectObject po : pg.getPolist()) {
            if ("true".equals(po.getProps().get("TOBEDELETED")) || "true".equals(po.getProps().get("OBJ_DELETE_ERROR"))) {
                LOG.debug((Object)"Del po: %s", new Object[]{po.getUuid()});
                continue;
            }
            PoReplicaInfo poReplicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
            if (null == poReplicaInfo) {
                context.getUnConfigHoldVmPo().add(po.getMoUuid());
                continue;
            }
            PhVmInfo phVm = poReplicaInfo.getPhVmInfo();
            if (VerifyUtil.isEmpty((Object)phVm) || VerifyUtil.isEmpty((String)phVm.getVmUuid())) {
                context.getUnConfigHoldVmPo().add(po.getMoUuid());
                continue;
            }
            LOG.debug((Object)"PhVmInfo in db: %s", new Object[]{phVm.getVmUuid()});
            INovaManager novaManager = ManagerFactory.getInstance().getNovaManager(pg.getPoProviderSN());
            OpenStackVM holdUpVm = novaManager.getVm(regionUuid, tokenId, projectUuid, phVm.getVmUuid(), new int[0]);
            if (null == holdUpVm) {
                LOG.error((Object)("holdup Vm is not exist: " + phVm.getVmUuid()));
                phVm.setStatus(OpenstackEnumDefine.HoldVmStatusE.UNEXISTED.getValue());
                context.getUnExistedHoldVmPo().add(po.getMoUuid());
            } else if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.HYPERMETRO.getValue().equals(instanceType)) {
                phVm.setStatus(OpenstackEnumDefine.HoldVmStatusE.NORMAL.getValue());
                this.addTags(pg, regionUuid, po, holdUpVm);
                this.updateVMmetadata(holdUpVm, novaManager, regionUuid, projectUuid, tokenId, poReplicaInfo);
            } else if (OpenStackCommonUtil.isCurrentFCVersionHighThan63() && !ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(instanceType)) {
                this.addTagToHoldVm(holdUpVm, pg, "__type_dr");
                this.updateVMmetadata(holdUpVm, novaManager, regionUuid, projectUuid, tokenId, poReplicaInfo);
            }
            po.getProps().put("replicationInfo", JSONObject.fromObject((Object)poReplicaInfo).toString());
            if ("csha_csdr".equals(serviceInstance.getProtectType())) {
                PoReplicaInfo hypermetorPoReplicaInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
                if (VerifyUtil.isEmpty((Object)hypermetorPoReplicaInfo)) {
                    context.getUnConfigHoldVmPo().add(po.getMoUuid());
                    continue;
                }
                PhVmInfo hypermetorPhVm = hypermetorPoReplicaInfo.getPhVmInfo();
                if (VerifyUtil.isEmpty((Object)hypermetorPhVm) || VerifyUtil.isEmpty((String)hypermetorPhVm.getVmUuid())) {
                    context.getUnConfigHoldVmPo().add(po.getMoUuid());
                    continue;
                }
                LOG.debug((Object)"HypermetorPhVm in db: %s", new Object[]{hypermetorPhVm.getVmUuid()});
                OpenStackVM cshaHoldUpVm = novaManager.getVm(hypermetorRegionUuid, hypermetorTokenId, hypermetorProjectUuid, hypermetorPhVm.getVmUuid(), new int[0]);
                if (VerifyUtil.isEmpty((Object)cshaHoldUpVm)) {
                    LOG.error((Object)("CshaHoldUp Vm is not exist: " + hypermetorPhVm.getVmUuid()));
                    hypermetorPhVm.setStatus(OpenstackEnumDefine.HoldVmStatusE.UNEXISTED.getValue());
                    context.getUnExistedHoldVmPo().add(po.getMoUuid());
                    continue;
                }
                this.updatePoVmNameProps(isManualRefresh, pg, po, holdUpVm, cshaHoldUpVm);
                continue;
            }
            this.updatePoVmNameProps(isManualRefresh, pg, po, holdUpVm, null);
        }
    }

    private void addTags(ProtectGroup pg, String regionUuid, ProtectObject po, OpenStackVM holdUpVm) {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            this.addTagToHoldVm(holdUpVm, pg, "__type_dr");
        }
        this.addTagToHoldVm(holdUpVm, pg, "__type_csha");
        this.addTagToHoldVm(holdUpVm, pg, "dr_backup_region::" + OpenStackCommonUtil.getIdFromUuid(regionUuid));
        this.addTagToHoldVm(holdUpVm, pg, "dr_backup_vm::" + OpenStackCommonUtil.getIdFromUuid(po.getMoUuid()));
    }

    private boolean isManualRefresh(ProtectGroup pg) {
        boolean isManualRefresh = VerifyUtil.isEmpty((String)pg.getProperty("isManualRefresh")) || String.valueOf(1).equals(pg.getProperty("isManualRefresh"));
        return isManualRefresh;
    }

    private void updatePoVmNameProps(boolean isManualRefresh, ProtectGroup pg, ProtectObject po, OpenStackVM holdUpVm, OpenStackVM cshaHoldUpVm) {
        if (!isManualRefresh || null == holdUpVm) {
            LOG.debug((Object)"No need update po(%s:%s) holdUpVm name.", new Object[]{pg.getName(), po.getMoUuid()});
            return;
        }
        PoReplicaInfo poReplicaInfo = (PoReplicaInfo)po.getProperty("replicationInfo", PoReplicaInfo.class);
        poReplicaInfo.getPhVmInfo().setName(holdUpVm.getName());
        po.setProperty("replicationInfo", (Object)JSONObject.fromObject((Object)poReplicaInfo).toString());
        if (34 == pg.getTemplate().getType() && !this.initHypermetorReplication(pg, po, holdUpVm, poReplicaInfo)) {
            return;
        }
        this.updateRecoverySettings(po, holdUpVm, "PLACEHOLDVMNAME");
        if (null == cshaHoldUpVm) {
            LOG.debug((Object)"No need update po(%s:%s) cshaHoldUpVm name.", new Object[]{pg.getName(), poReplicaInfo.getMoUuid()});
            return;
        }
        if (!this.initRemoteReplicationInfo(pg, po, holdUpVm, cshaHoldUpVm, poReplicaInfo)) {
            return;
        }
        this.updateRecoverySettings(po, cshaHoldUpVm, "CSHAPLACEHOLDVMNAME");
    }

    private boolean initRemoteReplicationInfo(ProtectGroup pg, ProtectObject po, OpenStackVM holdUpVm, OpenStackVM cshaHoldUpVm, PoReplicaInfo poReplicaInfo) {
        PoReplicaInfo remotePoReplicaInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
        PoReplicaInfo hypermetorPoReplicaInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
        if (VerifyUtil.isEmpty((Object)remotePoReplicaInfo) || VerifyUtil.isEmpty((Object)remotePoReplicaInfo.getPhVmInfo()) || VerifyUtil.isEmpty((Object)hypermetorPoReplicaInfo) || VerifyUtil.isEmpty((Object)hypermetorPoReplicaInfo.getPhVmInfo())) {
            LOG.error((Object)"Do not update po(%s:%s) cshaHoldUpVm name. ReplicationInfo is not available.", new Object[]{pg.getName(), poReplicaInfo.getMoUuid()});
            return false;
        }
        if (!OpenStackCommonUtil.isCsdrCshaMode(pg)) {
            remotePoReplicaInfo.getPhVmInfo().setName(holdUpVm.getName());
        } else {
            remotePoReplicaInfo.getPhVmInfo().setName(cshaHoldUpVm.getName());
            hypermetorPoReplicaInfo.setVmName(holdUpVm.getName());
            hypermetorPoReplicaInfo.getPhVmInfo().setName(cshaHoldUpVm.getName());
            po.setProperty("hypermetor_replicationInfo", (Object)JSONObject.fromObject((Object)hypermetorPoReplicaInfo).toString());
        }
        po.setProperty("remote_replicationInfo", (Object)JSONObject.fromObject((Object)remotePoReplicaInfo).toString());
        return true;
    }

    private boolean initHypermetorReplication(ProtectGroup pg, ProtectObject po, OpenStackVM holdUpVm, PoReplicaInfo poReplicaInfo) {
        PoReplicaInfo hypermetorPoReplicaInfo = (PoReplicaInfo)po.getProperty("hypermetor_replicationInfo", PoReplicaInfo.class);
        PoReplicaInfo remotePoReplicaInfo = (PoReplicaInfo)po.getProperty("remote_replicationInfo", PoReplicaInfo.class);
        if (VerifyUtil.isEmpty((Object)remotePoReplicaInfo) || VerifyUtil.isEmpty((Object)remotePoReplicaInfo.getPhVmInfo()) || VerifyUtil.isEmpty((Object)hypermetorPoReplicaInfo)) {
            LOG.error((Object)"Do not update po(%s:%s) holdUpVm name. ReplicationInfo is not available.", new Object[]{pg.getName(), poReplicaInfo.getMoUuid()});
            return false;
        }
        remotePoReplicaInfo.getPhVmInfo().setName(holdUpVm.getName());
        po.setProperty("remote_replicationInfo", (Object)JSONObject.fromObject((Object)remotePoReplicaInfo).toString());
        if (OpenStackCommonUtil.isCsdrVhaMode(pg)) {
            hypermetorPoReplicaInfo.setVmName(holdUpVm.getName());
            po.setProperty("hypermetor_replicationInfo", (Object)JSONObject.fromObject((Object)hypermetorPoReplicaInfo).toString());
        }
        return true;
    }

    private void updateVMmetadata(OpenStackVM holdUpVm, INovaManager novaManager, String regionUuid, String projectUuid, String tokenId, PoReplicaInfo poReplicaInfo) {
        if (null == holdUpVm) {
            return;
        }
        if (null != holdUpVm.getMetadata() && holdUpVm.getMetadata().containsKey("_bcm_primary_vm")) {
            return;
        }
        try {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("_bcm_primary_vm", OpenStackCommonUtil.getIdFromUuid(OpenStackCommonUtil.getBcmPrimaryVmUuid(poReplicaInfo)));
            novaManager.updateVMmetadata(holdUpVm.getUuid(), projectUuid, regionUuid, tokenId, metadata);
        }
        catch (Exception e) {
            LOG.error((Object)("updateVMmetadata error." + holdUpVm.getUuid()), (Throwable)e);
        }
    }

    private void addTagToHoldVm(OpenStackVM openStackVM, ProtectGroup protectGroup, String tag) {
        if (null == openStackVM || null != openStackVM.getTags() && openStackVM.getTags().contains(tag)) {
            return;
        }
        String projUuid = protectGroup.getProperty("projectId");
        String regionUuid = protectGroup.getProperty("regionId");
        String openStackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
        INovaManager novaMgr = ManagerFactory.getInstance().getNovaManager(openStackUuid);
        String tokenId = TokenUtil.getInstance().getRegionTokenId(regionUuid, projUuid);
        try {
            novaMgr.addTagToVm(regionUuid, tokenId, projUuid, openStackVM.getUuid(), tag);
        }
        catch (Exception e) {
            LOG.error((Object)"Add tag: %s to csha holdVm: %s error.", new Object[]{e, tag, openStackVM.getUuid()});
        }
    }

    private void updateRecoverySettings(ProtectObject po, OpenStackVM holdUpVm, String key) {
        Session session = null;
        String poId = po.getUuid();
        String holdUpName = holdUpVm.getName();
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            String hql = "update RecoverySetting rs set rs.value=:value where rs.ownerId=:ownerId and rs.name=:name";
            Query query = session.createQuery(hql);
            query.setParameter("value", (Object)holdUpName);
            query.setParameter("ownerId", (Object)poId);
            query.setParameter("name", (Object)key);
            query.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)"Failed to update RecoverySetting.", (Throwable)e, 90160758786898L);
                DBOperationUtil.rollbackSession((Session)session);
                throw new LegoCheckedException(-1L, "Failed to update RecoverySetting.");
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
    }
}

