/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.fault;

import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Arrays;
import java.util.List;

public class OcResponseHandler
implements IResponseHandler {
    private static final Log LOG = LogFactory.getInstance(OcResponseHandler.class);
    private static final int REST_REQUEST_401_STATUS_CODE = 401;
    private static final int REST_REQUEST_200_STATUS_CODE = 200;
    private static final int REST_REQUEST_502_STATUS_CODE = 502;
    private static final int REST_REQUEST_503_STATUS_CODE = 503;
    private static final int REST_REQUEST_504_STATUS_CODE = 504;
    private static final List REST_REQUEST_RETRY_STATUS_CODES = Arrays.asList(502, 503, 504);

    public void handleReponse(ServiceResponse response) {
        if (null == response) {
            LOG.error((Object)"The response message is null.", 90160758787071L);
            throw new LegoCheckedException(1073947407L);
        }
        LOG.info((Object)"Response of ocFault report is [%s][%s]", new Object[]{response.getStatusCode(), response.getContentData()});
        if (response.getStatusCode() == 401) {
            LOG.error((Object)"It is not login, maybe try again.", 90160758787071L);
            throw new LegoCheckedException(1073947691L);
        }
        if (REST_REQUEST_RETRY_STATUS_CODES.contains(response.getStatusCode())) {
            LOG.error((Object)"CTS Service is not available now.");
            throw new LegoCheckedException(1073947395L);
        }
        if (null != response.getContentData() && response.getStatusCode() != 200) {
            JSONObject result = JSONObject.fromObject((Object)response.getResponseString());
            LOG.error((Object)("Get data from oc error: " + result.get("message")), 90160758787071L);
            throw new LegoCheckedException(1073947407L);
        }
    }
}

