/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlanUtil;
import com.huawei.ism.drm.galax.sdk.model.HypermetroDomain;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.sdk.service.IServiceInstanceService;
import com.huawei.ism.drm.openstack.sdk.service.ISfsServiceInstanceService;
import com.huawei.ism.drm.openstack.serviceinstance.ProtectExecutingShareQueue;
import com.huawei.ism.drm.openstack.serviceinstance.task.ServiceInstanceReplicationSyncTask;
import com.huawei.ism.drm.openstack.tools.OpenStackCheckPhVmUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTask;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SfsCreateInstanceTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(SfsCreateInstanceTask.class);
    private static final int DEFAULT_TIMEOUT = Integer.MAX_VALUE;
    private static final int CREATE_PG_TIMEOUT = Integer.MAX_VALUE;
    private static final int MONITOR_INTERVAL = 10;
    private static final List<String> HAVE_RECOVERY_PLAN_INSTANCE_TYPE_LIST = Collections.singletonList(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
    private ProtectGroup pg;

    public SfsCreateInstanceTask(String proId, String type, ProtectGroup pg, ServiceInstanceReplicationSyncTask task) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)pg.getName(), (String)"ism.drm.instance.create", (String)proId, (String)type, (String)"", null), Integer.MAX_VALUE, true);
        this.pg = pg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWork() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
            scOperation.recordingOrder(this.getExtendParam());
        }
        IServiceInstanceService instService = (IServiceInstanceService)ServiceLocator.getInstance().getService(ISfsServiceInstanceService.class);
        instService.checkCreateInstanceParam(this.pg);
        OpenStackCommonUtil.checkPgVolumeCounts(this.pg, 0);
        OpenStackCommonUtil.checkPgVmCounts(this.pg, 0);
        Optional nasRecoveryPlanOption = RecoveryPlanUtil.getNasRecoveryPlan((ProtectGroup)this.pg);
        this.checkNasRecoveryPlanStatus(nasRecoveryPlanOption);
        HypermetroDomain hypermetroDomain = RecoveryPlanUtil.getHypermetroDomainFromPg((ProtectGroup)this.pg);
        String lockKey = nasRecoveryPlanOption.map(RecoveryPlan::getPlanId).orElse(hypermetroDomain.getId());
        boolean hasLocked = RecoveryBackTask.RUN_TASK_LOCKER.isLocked(lockKey);
        try {
            this.tryLockRecoveryPlan(lockKey, hasLocked);
            OpenStackCheckPhVmUtil.checkPhVmsAndRun(this.pg.getPolist(), this::work);
        }
        finally {
            this.unLockRecoveryPlan(lockKey, hasLocked);
        }
    }

    private void checkNasRecoveryPlanStatus(Optional<RecoveryPlan> nasRecoveryPlanOption) {
        String pgPdRegionId;
        if (!nasRecoveryPlanOption.isPresent()) {
            LOG.warn((Object)"The nas recoveryPlanId is empty, no need to check status.");
            return;
        }
        int planStatus = nasRecoveryPlanOption.get().getPlanStatus();
        if (DrmEnumDefine.RecoveryPlanStatusE.READY.getValue() != planStatus && DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() != planStatus) {
            throw new LegoCheckedException(1073948693L, String.format(Locale.ENGLISH, "Create sfs csdr instance failed, nas plan status (%s).", planStatus));
        }
        ProtectGroup pgInPlan = nasRecoveryPlanOption.get().getProtectGroup();
        String nasPdRegionId = CommUtil.getIdFromUuid((String)pgInPlan.getProperty("regionId"));
        if (!Objects.equals(nasPdRegionId, pgPdRegionId = CommUtil.getIdFromUuid((String)this.pg.getProperty("regionId")))) {
            LOG.error((Object)"The added protected group region(%s) is inconsistent with the region(%s) in the NAS recovery plan.", new Object[]{pgPdRegionId, pgPdRegionId});
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void tryLockRecoveryPlan(String lockKey, boolean hasLocked) {
        if (hasLocked) {
            LOG.warn((Object)"The lock %s has already exists.");
            return;
        }
        if (!RecoveryBackTask.RUN_TASK_LOCKER.tryLock(lockKey)) {
            LOG.error((Object)String.format(Locale.ROOT, "The nas recovery plan is executing. lockKey: %s", lockKey), 90160758784001L);
            throw new LegoCheckedException(1073948750L);
        }
    }

    protected void unLockRecoveryPlan(String lockKey, boolean hasLocked) {
        if (hasLocked) {
            LOG.warn((Object)"The lock %s has already exists, no need to unlock in current thread.", new Object[]{lockKey});
            return;
        }
        RecoveryBackTask.RUN_TASK_LOCKER.unlock(lockKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        Object object;
        String instanceUuid = UUIDGenerator.getUUID();
        this.pg.getProps().put("SERVICEINSTANCE_UUID", instanceUuid);
        String regionId = this.pg.getProperty("regionId");
        ArrayList poShareIdList = new ArrayList();
        try {
            this.pg.getPolist().forEach(po -> {
                String shareId = CommUtil.combineString((String[])new String[]{regionId, OpenStackCommonUtil.getIdFromUuid(po.getMoUuid())});
                if (ProtectExecutingShareQueue.isContainShare(shareId)) {
                    return;
                }
                poShareIdList.add(shareId);
                ProtectExecutingShareQueue.offer(shareId);
            });
            IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
            long createPgTaskId = pgService.createProtectGroup(this.pg, false);
            if (!this.monitorTaskResult(createPgTaskId)) {
                LOG.error((Object)("Create protectgroup failed:pgName=" + this.pg.getName()));
                throw new LegoCheckedException(1073948104L, "Create instance failed.");
            }
        }
        finally {
            poShareIdList.forEach(ProtectExecutingShareQueue::remove);
        }
        String type = (String)this.pg.getProps().get("serviceInstanceType");
        String planId = null;
        if (HAVE_RECOVERY_PLAN_INSTANCE_TYPE_LIST.contains(type)) {
            planId = RecoveryPlanUtil.createRecoveryPlan((ProtectGroup)this.pg, (String)ServiceInstaceEnumDefine.ObjectType.SFS.getValue());
            LOG.debug((Object)"Create recovery plan successfully,planId=%s", new Object[]{planId});
            RecoveryPlanUtil.createNasRecoveryPlan((ProtectGroup)this.pg);
        }
        ServiceInstance instance = this.getServiceInstance(instanceUuid, type, planId);
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63() && (object = this.getExtendParam().get("order_instinfo")) instanceof OrderInstanceInfo) {
            OrderInstanceInfo order = (OrderInstanceInfo)object;
            order.setInstanceId(instance.getId());
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
        }
    }

    private ServiceInstance getServiceInstance(String instanceUuid, String type, String planId) {
        ServiceInstance instance = new ServiceInstance();
        instance.setDescription(this.pg.getDescription());
        instance.setName(this.pg.getName());
        instance.setOwnerId(this.pg.getOwnerId());
        instance.setStatus(ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL.getValue());
        String projectUuid = (String)this.pg.getProps().get("projectId");
        String projectId = OpenStackCommonUtil.getIdFromUuid(projectUuid);
        instance.setProjectId(projectId);
        instance.setProtectGroupId(this.pg.getUuid());
        instance.setRecoveryPlanId(planId);
        instance.setUuid(instanceUuid);
        instance.setObjectType(ServiceInstaceEnumDefine.ObjectType.SFS.getValue());
        instance.setCreateTime(Long.valueOf(new Date().getTime()));
        instance.setStartPriority(3);
        instance.setType(type);
        instance.setProtectType(type);
        this.saveServiceInstance(instance);
        return instance;
    }

    private void saveServiceInstance(ServiceInstance instance) {
        try {
            LOG.debug((Object)"Start save ServiceInstance.ServiceInstanceName=%s, ServiceInstanceID=%s,protectGroupID=%s", new Object[]{instance.getName(), instance.getId(), instance.getProtectGroupId()});
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)instance);
            String regionUuid = (String)this.pg.getProps().get("regionId");
            String drRegionUuid = (String)this.pg.getProps().get("drRegionId");
            String openstackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            Map meterInfos = meterService.calculateSfsMeterInfos(this.pg, instance.getProjectId(), openstackUuid, regionUuid);
            meterInfos.put("change_type", "inst_create");
            meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
            meterService.reportChangedMeterInfo(regionUuid, instance, openstackUuid, meterInfos);
            meterService.reportChangedMeterInfo(drRegionUuid, instance, openstackUuid, meterInfos);
            LOG.debug((Object)"End save ServiceInstance.ServiceInstanceName=%s, ServiceInstanceID=%s,protectGroupID=%s", new Object[]{instance.getName(), instance.getId(), instance.getProtectGroupId()});
        }
        catch (Exception e) {
            LOG.error((Object)("Create instance error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073948104L, "create instance error.", (Throwable)e);
        }
    }

    private boolean monitorTaskResult(long taskId) {
        int times;
        IBackTaskService taskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        BackTask task = taskService.readTask(taskId);
        if (task == null) {
            return false;
        }
        for (times = 0xCCCCCCC; times > 0; --times) {
            CommUtil.pauseThread((long)10000L);
            task = taskService.readTask(taskId);
            if (task.getTaskResult() == CommonConstant.BACKTASK_RESULT_FAIL) {
                LOG.error((Object)("The task result is fail,targetName=" + task.getTargetName() + ",reTryTimes=" + (0xCCCCCCC - times)));
                OpenStackCommonUtil.throwTaskError(task);
                return false;
            }
            if (task.getTaskResult() == CommonConstant.BACKTASK_RESULT_SUCCESS) {
                return true;
            }
            LOG.error((Object)"Continue listening.");
        }
        LOG.error((Object)("The task is timeout,taskId=" + taskId + "" + task.getTargetName() + ",reTryTimes=" + (0xCCCCCCC - times)));
        return false;
    }

    protected void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OrderInstanceInfo order = (OrderInstanceInfo)this.getExtendParam().get("order_instinfo");
            order.setInstanceId(this.pg.getProperty("SERVICEINSTANCE_UUID"));
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }
}

