/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.serviceinstance.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.service.IConfigSyncRateService;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.model.ServiceInstance;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.service.impl.RecoveryPlanServiceImpl;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlanUtil;
import com.huawei.ism.drm.openstack.sdk.msg.OrderInstanceInfo;
import com.huawei.ism.drm.openstack.sdk.service.IMeterService;
import com.huawei.ism.drm.openstack.sdk.service.IQuotaService;
import com.huawei.ism.drm.openstack.sdk.service.IScOperationService;
import com.huawei.ism.drm.openstack.serviceinstance.ServiceInstanceHelper;
import com.huawei.ism.drm.openstack.tools.OpenStackCheckPhVmUtil;
import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.replica.retention.service.IReplicaRetentionStrategyManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TimeUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpgradeInstanceTask
extends AbstractBackTask {
    private static final Log LOG = LogFactory.getInstance(UpgradeInstanceTask.class);
    private static final int DEFAULT_TIMEOUT = 2147483;
    private IConfigSyncRateService synService = null;
    private ProtectGroupHelper helper = ProtectGroupHelper.getInstance();
    private IReplicaRetentionStrategyManager retentionManager = null;
    private ProtectGroup pg;
    private String proId;
    private ServiceInstance instance;

    public UpgradeInstanceTask(String proId, String type, ProtectGroup pg, ServiceInstance instance) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)instance.getName(), (String)"ism.drm.instance.upgrade", (String)proId, (String)type, (String)"", null), 2147483, true);
        this.pg = pg;
        this.proId = proId;
        this.instance = instance;
        ProtectGroupServiceImpl serviceImpl = (ProtectGroupServiceImpl)ServiceLocator.getInstance().getService(ProtectGroupServiceImpl.class);
        this.synService = serviceImpl.getConfigSyncRateService();
        this.retentionManager = serviceImpl.getRetentionManager();
    }

    protected void doWork() {
        OpenStackCheckPhVmUtil.checkPhVmsAndRun(this.pg.getPolist(), this::work);
    }

    private void work() {
        if (!ServiceInstanceHelper.getInstance().getLock(this.instance.getId())) {
            LOG.error((Object)("Not get this instance lock,instanceId:" + this.instance.getId()));
            throw new LegoCheckedException(1073948693L);
        }
        try {
            this.upgradeRefineProtectGroup();
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073947451L) {
                ServiceInstanceHelper.getInstance().changeStatus(this.instance.getId(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL);
            }
            this.helper.notifyObserverException(this.pg, 23);
            throw e;
        }
        catch (Exception t) {
            this.helper.notifyObserverException(this.pg, 23);
            ExceptionUtil.rethrowException((Throwable)t, (String)("failed to upgrade protectgroup!" + this.pg.getName()), (long)-1L, (String[])new String[0], (Log)LOG);
        }
        finally {
            ServiceInstanceHelper.getInstance().releaseLock(this.instance.getId());
        }
    }

    private void upgradeRefineProtectGroup() {
        IScOperationService scOperation = (IScOperationService)ServiceLocator.getInstance().getService(IScOperationService.class);
        scOperation.recordingOrder(this.getExtendParam());
        IQuotaService quotaService = (IQuotaService)ServiceLocator.getInstance().getService(IQuotaService.class);
        String quotas = quotaService.calculateUpgradeInstanceQuota(this.instance, this.pg);
        Map extendParam = this.getExtendParam();
        extendParam.put("order_quotas", quotas);
        this.setExtendParam(extendParam);
        String result = quotaService.checkCreateInstanceOutOfQuota(this.proId, this.pg);
        if (!VerifyUtil.isEmpty((String)result)) {
            String[] param = result.split(":");
            LOG.error((Object)("Upgrade instance out of quota:pgName=" + this.pg.getName()));
            throw new LegoCheckedException(1073948125L, param, "Create instance failed.");
        }
        ServiceInstanceHelper.getInstance().changeStatus(this.instance.getId(), ServiceInstaceEnumDefine.ServiceInstanceStatusE.MAINTAIN);
        String beforeUpgradeType = (String)this.pg.getProps().get("BEFORE_UPGRADE_TYPE");
        Map<String, Object> meterInfos = this.calcMeterBeforeUpdate(beforeUpgradeType);
        meterInfos.put("meter_report_time", TimeUtil.getCurrentDate());
        this.upgradeProtectGroup();
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getValue().equals(beforeUpgradeType)) {
            String planId = RecoveryPlanUtil.createRecoveryPlan((ProtectGroup)this.pg, (String)ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue());
            OpenStackCommonUtil.updateRecoverySetting(planId, this.pg.getPolist());
            this.instance.setRecoveryPlanId(planId);
        } else {
            this.updateRecoveryProcess();
        }
        this.instance.setType(ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue());
        this.instance.setProtectType("vha_csdr");
        this.instance.setStatus(ServiceInstaceEnumDefine.ServiceInstanceStatusE.NORMAL.getValue());
        this.saveServiceInstance(this.instance, meterInfos);
        OrderInstanceInfo order = (OrderInstanceInfo)this.getExtendParam().get("order_instinfo");
        order.setInstanceId(this.instance.getId());
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.SUCCESSED.getValue(), this.getExtendParam(), null, null);
        }
    }

    private Map<String, Object> calcMeterBeforeUpdate(String beforeUpgradeType) {
        IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
        Map meterInfos = meterService.calculateMeterInfos(this.pg);
        meterInfos.put("change_type", "inst_upgrade");
        if (ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(beforeUpgradeType)) {
            meterInfos.put("up_downgrade_chage", ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getFrontValue());
        } else {
            meterInfos.put("up_downgrade_chage", ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA.getFrontValue());
        }
        return meterInfos;
    }

    protected void processFailure() {
        if (OpenStackCommonUtil.isCurrentFCVersionHighThan63()) {
            OpenStackCommonUtil.putOrderResult(ServiceInstaceEnumDefine.ServiceInstanceOrderExecuteStatusE.FAILED.getValue(), this.getExtendParam(), this.getErrorCode(), this.getErrorParam());
        }
    }

    private void updateRecoveryProcess() {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlanServiceImpl planServiceImpl = (RecoveryPlanServiceImpl)planService;
        RecoveryPlan recoveryPlan = planServiceImpl.getRecoveryPlan(this.instance.getRecoveryPlanId(), true);
        if (null == recoveryPlan) {
            LOG.error((Object)"RecoveryPlan is null");
            throw new LegoCheckedException(201L);
        }
        HashSet<ProtectGroup> protectGroups = new HashSet<ProtectGroup>();
        protectGroups.add(this.pg);
        recoveryPlan.setProtectGroups(protectGroups);
        Set processes = recoveryPlan.getRecoveryProcesses();
        for (RecoveryProcessDefinition process : processes) {
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == process.getProcType()) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)process);
                continue;
            }
            process.setProtectionType(this.pg.getTemplate().getType());
        }
        IRecoveryManager recoveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
        RecoveryProcessDefinition rpDefinition = recoveryManager.createRecoveryProcessDefinition(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
        Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.resetEnableStatus(this.pg, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
        }
        processes.add(rpDefinition);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
    }

    private void saveServiceInstance(ServiceInstance serviceInstance, Map<String, Object> meterInfo) {
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)serviceInstance);
            String regionUuid = (String)this.pg.getProps().get("regionId");
            String drRegionUuid = (String)this.pg.getProps().get("drRegionId");
            String openStackUuid = OpenStackCommonUtil.getOpenstackUuidFromStr(regionUuid);
            IMeterService meterService = (IMeterService)ServiceLocator.getInstance().getService(IMeterService.class);
            meterService.reportChangedMeterInfo(regionUuid, serviceInstance, openStackUuid, meterInfo);
            meterService.reportChangedMeterInfo(drRegionUuid, serviceInstance, openStackUuid, meterInfo);
        }
        catch (Exception e) {
            LOG.error((Object)("Create instance error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw new LegoCheckedException(1073948104L, "create instance error.", (Throwable)e);
        }
    }

    private void upgradeProtectGroup() {
        MessageEvent event = new MessageEvent();
        event.setMessageType(21);
        ArrayList<ProtectGroup> objectList = new ArrayList<ProtectGroup>();
        objectList.add(this.pg);
        String beforeUpgradeType = (String)this.pg.getProps().get("BEFORE_UPGRADE_TYPE");
        HashMap<String, String> messageMap = new HashMap<String, String>();
        messageMap.put("BEFORE_UPGRADE_TYPE", beforeUpgradeType);
        event.setMessageMap(messageMap);
        event.setObjectList(objectList);
        CreateProtectGroupRefineService service = CreateProtectGroupRefineService.getInstance();
        service.notifyObserver(event, () -> {
            if (!this.retentionManager.checkRetentionStrategy(this.pg)) {
                throw new LegoCheckedException(1073947393L);
            }
            ProtectGroupHelper.getInstance().checkAndBuildReplica(this.pg);
            this.pg.setPrimary(true);
            this.pg.getProps().remove("BEFORE_UPGRADE_TYPE");
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)this.pg);
            this.retentionManager.createRetentionTask(this.pg);
            ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).addObject(this.pg.getOwnerId(), new String[]{this.pg.getUuid()});
            ((IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class)).createTask(this.pg);
            this.createSyncRate();
        });
    }

    private void createSyncRate() {
        try {
            PolicyTemplate policyTemplate = this.pg.getTemplate();
            Map props1 = policyTemplate.getProps();
            String prStr = (String)props1.get("syncRateRecords");
            if (!VerifyUtil.isEmpty((String)prStr)) {
                List pgsrps = ProtectGroupUtil.convertToSyncRatePolicy((PolicyTemplate)policyTemplate);
                this.synService.createSyncRateTask(this.pg, pgsrps);
                this.synService.runAtOnce(this.pg, pgsrps, false);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Create sync rate task failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }
}

