/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.backup.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.system.backup.OpenStackBackupConstants;
import com.huawei.ism.drm.site.sdk.model.ManagementServer;
import com.huawei.ism.drm.site.sdk.service.IManagementServerService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;

public class OpenStackBackupRegisterTask
extends AbstractBackTask {
    public static final int MAX_WAIT_INTERVAL = 60000;
    private static final int DEFAULT_TIMEOUT = 2147483;
    private static final Log LOG = LogFactory.getInstance(OpenStackBackupRegisterTask.class);
    private static final LegoMoGenerator LEGOMOGENERATOR = new LegoMoGenerator();
    private static final int DEFAULT_MAX_RETRIES_THRESHOLD = 16;

    public OpenStackBackupRegisterTask(String taskName, String taskType) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)"eReplication", (String)taskName, (String)"System", (String)taskType, (String)"", (String[])new String[0]), 2147483, true);
    }

    protected void doWork() {
        this.register();
    }

    public void register() {
        int retries = 0;
        boolean isNeedRetry = true;
        do {
            long waitTime = OpenStackBackupRegisterTask.getWaitTimeExp(retries);
            if (retries > 0) {
                CommUtil.pauseThread((long)waitTime);
            }
            if (retries >= 30) {
                this.sendUnifiedBackupRegisterAlarm();
                LOG.info((Object)"Send Unified Backup register interface repeat successful");
            }
            try {
                isNeedRetry = !this.handle();
            }
            catch (Exception e) {
                isNeedRetry = true;
                if (++retries < 32) {
                    LOG.error((Object)"Unified Backup register interface failed, try again. error: %s , retry times: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), retries});
                    continue;
                }
                LOG.debug((Object)"Unified Backup register interface failed, try again. error: ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        } while (isNeedRetry);
        AlarmReporter.restoreAlarm((long)52625508L, (String[])new String[]{"Unified Backup"});
        LOG.info((Object)"Repeat unified backup register task %s times.", new Object[]{String.valueOf(retries)});
    }

    private void sendUnifiedBackupRegisterAlarm() {
        String serverIp = this.getSystemIp();
        String backupIpPort = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        String[] ipPort = backupIpPort.split(":");
        String backupIp = ipPort[0];
        String backupPort = ipPort[1];
        String[] params = new String[]{serverIp, "Unified Backup", backupIp, backupPort};
        AlarmReporter.sendAlarmForNoRepeat((long)52625508L, null, (String)FaultEnum.AlarmResourceType.NETWORKENTITY.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])params);
    }

    public boolean handle() {
        JSONObject result;
        JSONObject registerJsonObject = this.getRegisterJsonObject();
        LOG.info((Object)"Openstack register unified backup request: %s", new Object[]{registerJsonObject});
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            LOG.error((Object)"Register unified backup failed, server urlStr is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String fullUrl = "https://" + urlStr + "/rest/system/v2/action/register";
        LOG.info((Object)"Unified Backup send fullUrl is : %s", new Object[]{fullUrl});
        String response = ClientUtil.sendPostRequest(fullUrl, registerJsonObject.toString(), tokenId);
        LOG.info((Object)"Openstack register unified backup response: %s", new Object[]{response});
        if (VerifyUtil.isEmpty((String)response)) {
            LOG.error((Object)"Openstack register unified backup response is empty.");
            throw new LegoCheckedException(0x300001L);
        }
        try {
            result = JSONObject.fromObject((Object)response);
            LOG.info((Object)"Unified Backup JSONObject result is : %s", new Object[]{result});
        }
        catch (Exception e) {
            LOG.error((Object)"Resolve unified backup register response failed.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
        if (null != result && result.containsKey((Object)"descrption")) {
            String description = result.getString("descrption");
            LOG.info((Object)"Unified Backup register response descrption is : %s", new Object[]{description});
            if ("success".equals(description) || "System to be added is already exists.".equals(description)) {
                LOG.info((Object)"Unified Backup register successed.");
                return true;
            }
            LOG.error((Object)("Unified Backup register failed, error: " + result.getString("errorMsg")));
            return false;
        }
        LOG.error((Object)"Unified Backup register failed.");
        return false;
    }

    public static long getWaitTimeExp(int retryCount) {
        if (retryCount > 5) {
            return 60000L;
        }
        return (long)Math.pow(2.0, Math.max(retryCount, 3)) * 1000L;
    }

    private JSONObject getRegisterJsonObject() {
        String regionId = LegoConfig.getNodeConfig().getKeyValue("config.hcs.node.region");
        ManagementServer local = ((IManagementServerService)ServiceLocator.getInstance().getService(IManagementServerService.class)).getServerInfo();
        if (null == local) {
            throw new LegoCheckedException(2117645L);
        }
        String systemVersion = local.getVersion();
        String ip = this.getSystemIp();
        int restPort = this.getSystemPort();
        if (VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)systemVersion) || VerifyUtil.isEmpty((String)ip)) {
            LOG.error((Object)"Register unified backup failed. regionId: %s, systemVersion: %s, ip: %s", new Object[]{regionId, systemVersion, ip});
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject registerJsonObject = new JSONObject();
        registerJsonObject.put((Object)"ip", (Object)ip);
        registerJsonObject.put((Object)"systemType", (Object)"eReplication");
        registerJsonObject.put((Object)"systemVersion", (Object)systemVersion);
        registerJsonObject.put((Object)"regionId", (Object)regionId);
        JSONObject connectParametersObject = new JSONObject();
        connectParametersObject.put((Object)"restPort", (Object)restPort);
        connectParametersObject.put((Object)"restAuthType", (Object)"IAM");
        connectParametersObject.put((Object)"certs", (Object)"");
        registerJsonObject.put((Object)"connectParameters", (Object)connectParametersObject);
        registerJsonObject.put((Object)"implementsFunctions", (Object)OpenStackBackupConstants.BackupRegisterUrl.stitchString());
        return registerJsonObject;
    }

    private String getSystemIp() {
        return LEGOMOGENERATOR.getInstallServerIp();
    }

    private int getSystemPort() {
        return NumberUtil.convertToInteger((Object)LEGOMOGENERATOR.getInstallServerPort());
    }
}

