/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.bugmanagement.task;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.openstack.adapter.util.ClientUtil;
import com.huawei.ism.drm.openstack.adapter.util.TokenUtil;
import com.huawei.ism.drm.openstack.resource.authentication.AuthenticationHelper;
import com.huawei.ism.drm.openstack.sdk.msg.OpenstackInfo;
import com.huawei.ism.drm.openstack.system.backup.task.OpenStackBackupRegisterTask;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Map;

public class OpenStackVersionReportTask
extends AbstractBackTask {
    private static final int DEFAULT_TIMEOUT = 2147483;
    private static final Log LOG = LogFactory.getInstance(OpenStackVersionReportTask.class);
    private static final LegoMoGenerator LEGOMOGENERATOR = new LegoMoGenerator();
    private static final int DEFAULT_MAX_RETRIES_THRESHOLD = 15;

    public OpenStackVersionReportTask(String taskName, String taskType) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)"eReplication", (String)taskName, (String)"System", (String)taskType, (String)"", (String[])new String[0]), 2147483, true);
    }

    protected void doWork() {
        this.report();
    }

    private void report() {
        int retries = 0;
        boolean isNeedRetry = false;
        do {
            long waitTime = OpenStackBackupRegisterTask.getWaitTimeExp(retries);
            if (retries > 0) {
                CommUtil.pauseThread((long)waitTime);
            }
            try {
                isNeedRetry = !this.handle();
            }
            catch (Exception e) {
                isNeedRetry = true;
                if (++retries < 30) {
                    LOG.error((Object)"BugManagent Version Report failed, try again. error: %s , retry times: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), retries});
                    continue;
                }
                LOG.debug((Object)"BugManagent Version Report failed, try again. error: %s , retry times: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e), retries});
            }
        } while (isNeedRetry);
        LOG.info((Object)"BugManagent Version Report Successful, Version Report task %s times.", new Object[]{String.valueOf(retries)});
    }

    private boolean handle() {
        JSONObject versionJSONObject = this.getVersionJSONObject();
        LOG.info((Object)"OpenStack BugManagement Version Report body: %s", new Object[]{versionJSONObject});
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.om.float");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            LOG.error((Object)"OpenStack BugManagement Version Report failed, server urlStr is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        OpenstackInfo open = AuthenticationHelper.getInstance().getOpenstackInfo();
        String tokenId = TokenUtil.getInstance().getTokenId(open, null);
        String fullUrl = "https://" + urlStr + "/rest/cmdb/v2/system-infos";
        LOG.debug((Object)"OpenStack BugManagement Version Report fullUrl is : %s", new Object[]{fullUrl});
        String response = ClientUtil.sendPutRequest(fullUrl, versionJSONObject.toString(), tokenId);
        LOG.info((Object)"OpenStack BugManagement Version Report response: %s", new Object[]{response});
        if (VerifyUtil.isEmpty((String)response)) {
            LOG.error((Object)"OpenStack BugManagement Version Report response is empty.");
            throw new LegoCheckedException(0x300001L);
        }
        JSONObject result = null;
        try {
            result = JSONObject.fromObject((Object)response);
            LOG.info((Object)"OpenStack BugManagement Version Report response result is : %s", new Object[]{result});
        }
        catch (Exception e) {
            LOG.error((Object)"Resolve OpenStack BugManagement Version Report response response failed.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
        if (!VerifyUtil.isEmpty((Map)result) && result.containsKey((Object)"resultCode")) {
            String resultCode = result.getString("resultCode");
            LOG.info((Object)"OpenStack BugManagement Version Report response resultCode is : %s", new Object[]{resultCode});
            if (resultCode.equals("00000000")) {
                LOG.info((Object)"OpenStack BugManagement Version Report successed.");
                return true;
            }
            LOG.error((Object)"OpenStack BugManagement Version Report failed, The resultData is %s", new Object[]{result.getString("resultData")});
            return false;
        }
        LOG.error((Object)"OpenStack BugManagement Version failed.");
        return false;
    }

    private JSONObject getVersionJSONObject() {
        String version = LegoConfig.getDeployConfig().getKeyValue("version");
        LOG.info((Object)"Current version is %s", new Object[]{version});
        ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
        JSONObject dataObject = new JSONObject();
        dataObject.put((Object)"name", (Object)"eReplication");
        dataObject.put((Object)"alias", (Object)"OceanStor BCManager");
        dataObject.put((Object)"product_name", (Object)"OceanStor BCManager");
        dataObject.put((Object)"product_version", (Object)version);
        ArrayList<String> productPatchVersionList = new ArrayList<String>();
        productPatchVersionList.add(version);
        dataObject.put((Object)"product_patch_version", productPatchVersionList);
        dataObject.put((Object)"ipaddress", (Object)LEGOMOGENERATOR.getInstallServerIp());
        dataObject.put((Object)"sub_system_infos", new ArrayList());
        dataList.add(dataObject);
        JSONObject result = new JSONObject();
        result.put((Object)"system_infos", dataList);
        return result;
    }
}

