/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.unitepassword.service;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.drm.openstack.system.unitepassword.task.UnitePasswordRegistTask;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;

public class UnitePasswordRegistService
implements SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(UnitePasswordRegistService.class);
    private NodeAgentLocalService.Iface client;

    public void setClient(NodeAgentLocalService.Iface client) {
        this.client = client;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && this.available()) {
            logger.info((Object)"Unite Password create a task to handle on register.");
            UnitePasswordRegistTask unitePasswordRegistTask = new UnitePasswordRegistTask("ism.drm.unitepassword.register", "account.register", this.client);
            logger.info((Object)"submit a task for account register.");
            long taskId = BackTaskHandler.getInstance().submitTask((AbstractBackTask)unitePasswordRegistTask);
            logger.info((Object)"submit a task for account register success taskId is: %s", taskId);
        }
    }

    private boolean available() {
        String urlStr = LegoConfig.getInstance().getKeyValue("config.hcs.cert.management.url");
        if (VerifyUtil.isEmpty((String)urlStr)) {
            logger.info((Object)"UnitePassword server url is empty, account register is not supported.");
            return false;
        }
        logger.info((Object)"UnitePassword account register is supported.");
        return true;
    }
}

