/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.system.unitepassword.task;

import com.huawei.ism.drm.openstack.system.unitepassword.UnitePasswordCommon;
import com.huawei.ism.drm.openstack.system.unitepassword.model.SubComponent;
import com.huawei.ism.drm.openstack.system.unitepassword.task.UnitePasswordRegistTask;
import com.huawei.ism.drm.system.thirdservice.sdk.model.Account;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;

public class IAMregistask
extends TimerTask {
    private static final Log logger = LogFactory.getInstance(IAMregistask.class);

    @Override
    public void run() {
        logger.info((Object)"UnitePassword Timer Task Start.");
        int times = 0;
        boolean isSuccessful = false;
        LegoConfig.updateInstance();
        String iamServiceName = LegoConfig.getInstance().getKeyValue("IAM.service.name");
        logger.info((Object)"IAMServiceName is %s ", new Object[]{iamServiceName});
        while (times <= 3 && !isSuccessful) {
            try {
                ArrayList<Account> iAMServiceAccountList = new ArrayList<Account>();
                UnitePasswordRegistTask.createIAMAccount(iAMServiceAccountList, iamServiceName);
                JSONObject iAMJSONObject = this.getIAMJSONObject(iAMServiceAccountList);
                isSuccessful = UnitePasswordCommon.register(iAMJSONObject);
            }
            catch (Exception e) {
                isSuccessful = false;
                ++times;
                logger.error((Object)"Unite Password account register failed, try again. error: %s ", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
        logger.info((Object)"UnitePassword Timer Task result is %s", new Object[]{isSuccessful});
    }

    private JSONObject getIAMJSONObject(List<Account> iAMServiceAccountList) {
        JSONObject iAMJSONObject = new JSONObject();
        String componentName = "eReplication";
        ArrayList<SubComponent> subComponents = new ArrayList<SubComponent>();
        SubComponent subComponent = new SubComponent();
        subComponent.setSubComponentName(componentName);
        subComponent.setCreatedAccountList(iAMServiceAccountList);
        subComponents.add(subComponent);
        iAMJSONObject.put((Object)"componentName", (Object)componentName);
        iAMJSONObject.put((Object)"subComponents", subComponents);
        return iAMJSONObject;
    }
}

