/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.tools;

import com.huawei.ism.drm.openstack.tools.OpenStackCommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OpenStackCheckPhShareUtil {
    private static final Set<String> RUNNING_PH_SHARES = Collections.synchronizedSet(new HashSet());
    private static final Log LOGGER = LogFactory.getInstance(OpenStackCheckPhShareUtil.class);

    public static void checkPhSharesAndRun(Set<ProtectObject> poSet, Runnable run) {
        try {
            run.run();
        }
        finally {
            OpenStackCheckPhShareUtil.releasePhShares(RUNNING_PH_SHARES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCurrentPhSharesToSet(Set<String> usedShares) {
        if (usedShares == null) {
            return;
        }
        Set<String> set = RUNNING_PH_SHARES;
        synchronized (set) {
            usedShares.addAll(RUNNING_PH_SHARES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> checkRunningPhShares(Set<ProtectObject> poSet) {
        if (VerifyUtil.isEmpty(poSet)) {
            return Collections.emptySet();
        }
        HashSet<String> phShareset = new HashSet<String>();
        for (ProtectObject po : poSet) {
            String phVmId = OpenStackCommonUtil.getIdFromUuid(po.getProperty("occupied_vm"));
            String cshaPhVmId = OpenStackCommonUtil.getIdFromUuid(po.getProperty("prod_region_drZoneName"));
            if (!VerifyUtil.isEmpty((String)phVmId)) {
                phShareset.add(phVmId);
            }
            if (VerifyUtil.isEmpty((String)cshaPhVmId)) continue;
            phShareset.add(cshaPhVmId);
        }
        if (VerifyUtil.isEmpty(phShareset)) {
            LOGGER.debug((Object)"phShareset is empty.");
            return phShareset;
        }
        Set<String> set = RUNNING_PH_SHARES;
        synchronized (set) {
            for (String phVmId : phShareset) {
                if (!RUNNING_PH_SHARES.contains(phVmId)) continue;
                LOGGER.error((Object)"the vm(%s) is not avalible because allready used by other pg. RUNNING_PHShares:%s", new Object[]{phVmId, RUNNING_PH_SHARES});
                throw new LegoCheckedException(1073948130L);
            }
            RUNNING_PH_SHARES.addAll(phShareset);
        }
        return phShareset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releasePhShares(Set<String> phShareSet) {
        if (VerifyUtil.isEmpty(phShareSet)) {
            return;
        }
        Set<String> set = RUNNING_PH_SHARES;
        synchronized (set) {
            RUNNING_PH_SHARES.removeAll(phShareSet);
        }
    }
}

