/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.rollback;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.rollback.RollBackTask;
import com.huawei.ism.drm.common.sdk.model.RollBackTaskInfo;
import com.huawei.ism.drm.common.sdk.service.IRollBackExecutor;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;

public class RollBackTaskManager {
    private static final Log logger = LogFactory.getInstance(RollBackTaskManager.class);
    private static Map<String, IRollBackExecutor> executors = new HashMap<String, IRollBackExecutor>();
    private static RollBackTaskManager instance = null;
    private static Object lock = new Object();
    private static final long SCHEDULE_DELAY_TIME = 600000L;
    private static final long SCHEDULE_INTERVAL_TIME = 3600000L;
    private static final int MAX_EXECUTECOUNT = 36;
    private static final Map<String, Timer> TIMER_MAP = new HashMap<String, Timer>();

    private RollBackTaskManager() {
    }

    public static synchronized RollBackTaskManager getInstance() {
        if (null == instance) {
            instance = new RollBackTaskManager();
        }
        return instance;
    }

    public void initialize() {
        List<RollBackTaskInfo> rollbackTaskInfos = this.queryAllTask();
        if (null == rollbackTaskInfos) {
            logger.debug((Object)"RollbackTaskInfos in null when initialize.");
            return;
        }
        for (RollBackTaskInfo taskInfo : rollbackTaskInfos) {
            if (2 != taskInfo.getTaskStatus()) continue;
            try {
                taskInfo.setTaskStatus(Integer.valueOf(-1));
                CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)taskInfo);
            }
            catch (DataAccessException e) {
                logger.error((Object)"Update error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
        List<RollBackTaskInfo> allTasks = this.queryAllTask();
        for (RollBackTaskInfo task : allTasks) {
            this.genRollBackTimerTask(task, true);
        }
    }

    public void onBind(IRollBackExecutor executor, Map properties) {
        executors.put(executor.getName(), executor);
    }

    public void onUnbind(IRollBackExecutor executor, Map properties) {
        executors.remove(executor.getName());
    }

    public String addTask(final RollBackTaskInfo task, boolean executeImmediately) {
        this.checkExecutorName(task.getExecutor());
        Future future = ExecutionService.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return RollBackTaskManager.this.saveTask(task);
            }
        });
        try {
            future.get();
        }
        catch (Exception e) {
            logger.error((Object)"Save taskinfo error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (executeImmediately) {
            this.runAndMonitorTask(task);
        }
        return task.getTaskId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean saveTask(RollBackTaskInfo task) {
        if (VerifyUtil.isEmpty((String)task.getTaskId())) {
            task.setTaskId(UUIDGenerator.getUUID());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)task);
        } else {
            Object object = lock;
            synchronized (object) {
                RollBackTaskInfo rollBackTaskInfo = this.queryTask(task.getTaskId());
                if (null != rollBackTaskInfo) {
                    logger.error((Object)"Task already exist: %s", new Object[]{task.getTaskId()});
                    throw new LegoCheckedException(-1L);
                }
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)task);
            }
        }
        return Boolean.TRUE;
    }

    public long runTask(String taskId) {
        RollBackTaskInfo task = this.queryTask(taskId);
        if (task == null) {
            logger.error((Object)"Task not exist: %s", new Object[]{taskId});
            throw new LegoCheckedException(2117645L);
        }
        this.checkExecutorName(task.getExecutor());
        return this.runTask(task);
    }

    public synchronized RollBackTaskInfo queryTask(String taskId) {
        if (VerifyUtil.isEmpty((String)taskId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RollBackTaskInfo task = (RollBackTaskInfo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(RollBackTaskInfo.class, (Serializable)((Object)taskId));
        return task;
    }

    public List<RollBackTaskInfo> queryAllTask() {
        return CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from RollBackTaskInfo", new Object[0]);
    }

    public synchronized void cancelTimer(String taskId) {
        Timer timer = TIMER_MAP.get(taskId);
        if (timer != null) {
            timer.cancel();
            TIMER_MAP.remove(taskId);
        }
    }

    private synchronized Timer getTimer(String taskId) {
        Timer timer = TIMER_MAP.get(taskId);
        if (timer != null) {
            logger.error((Object)"Add Timer for same task again\uff0c cancel timerTask before this: %s ", new Object[]{taskId});
            timer.cancel();
        }
        timer = new Timer(true);
        TIMER_MAP.put(taskId, timer);
        return timer;
    }

    private void checkExecutorName(String taskExecutor) {
        if (VerifyUtil.isEmpty((String)taskExecutor)) {
            throw new LegoCheckedException(1073947393L);
        }
        boolean hasExecutor = false;
        for (String executorName : executors.keySet()) {
            if (!taskExecutor.equals(executorName)) continue;
            hasExecutor = true;
            break;
        }
        if (!hasExecutor) {
            logger.error((Object)"There is no executor named: %s", new Object[]{taskExecutor});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private synchronized long runTask(RollBackTaskInfo task) {
        RollBackTask backTask = new RollBackTask(executors.get(task.getExecutor()), task.getTaskId(), task.getTargetName());
        return BackTaskHandler.getInstance().submitTask((AbstractBackTask)backTask);
    }

    private synchronized void runAndMonitorTask(final RollBackTaskInfo task) {
        this.runTask(task);
        new Thread(new Runnable(){
            private static final long THREAD_SLEEP_TIME = 5L;
            private String taskId;
            {
                this.taskId = task.getTaskId();
            }

            @Override
            public void run() {
                RollBackTaskInfo taskInDb = RollBackTaskManager.this.queryTask(this.taskId);
                try {
                    while (taskInDb != null && taskInDb.getTaskStatus() != -1) {
                        TimeUnit.SECONDS.sleep(5L);
                        taskInDb = RollBackTaskManager.this.queryTask(this.taskId);
                    }
                }
                catch (InterruptedException e) {
                    logger.error((Object)"Monitor RollBack task failed.error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                }
                if (null != taskInDb) {
                    logger.info((Object)"Generate RollBackTimerTask, taskId is %s", new Object[]{this.taskId});
                    RollBackTaskManager.this.genRollBackTimerTask(taskInDb, false);
                }
            }
        }).start();
    }

    private synchronized void genRollBackTimerTask(RollBackTaskInfo task, boolean isDelay) {
        if (null == task) {
            logger.error((Object)"TaskId is null, no need to generate RollBack Timer task.");
            return;
        }
        if (task.getExecutedCount() >= 36) {
            logger.error((Object)"Task executedCount is up to 36, taskId is %s", new Object[]{task.getTaskId()});
            this.deleteRollBackTask(task);
            return;
        }
        long delayTime = isDelay ? 600000L : 0L;
        Timer timer = this.getTimer(task.getTaskId());
        RollBackTimerTask rollBackimerTask = new RollBackTimerTask(task.getTaskId());
        timer.schedule((TimerTask)rollBackimerTask, delayTime, 3600000L);
        logger.info((Object)"Generated RollBack timer task, taskId is %s", new Object[]{task.getTaskId()});
    }

    private void deleteRollBackTask(RollBackTaskInfo task) {
        logger.info((Object)"Start delete RollBackTask, taskId: %s", new Object[]{task.getTaskId()});
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)task);
        }
        catch (Exception e) {
            logger.error((Object)"Delete RollBackTask error, taskId: %s", new Object[]{task.getTaskId()});
            return;
        }
    }

    private class RollBackTimerTask
    extends TimerTask {
        private String taskId;

        public RollBackTimerTask(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public void run() {
            logger.info((Object)"RollBackTimerTask begin, taskId is %s", new Object[]{this.taskId});
            RollBackTaskInfo taskInfo = RollBackTaskManager.this.queryTask(this.taskId);
            if (null == taskInfo || taskInfo.getExecutedCount() >= 36) {
                logger.error((Object)"Task doesn't exist or executedCount is up to 36, taskId is %s", new Object[]{this.taskId});
                RollBackTaskManager.this.cancelTimer(this.taskId);
                return;
            }
            if (taskInfo.getTaskStatus() == 2) {
                logger.info((Object)"Task(%s) is running, skip this execution.", new Object[]{this.taskId});
                return;
            }
            logger.info((Object)"Update task executedCount to %s", new Object[]{String.valueOf(taskInfo.getExecutedCount() + 1)});
            taskInfo.setExecutedCount(Integer.valueOf(taskInfo.getExecutedCount() + 1));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)taskInfo);
            RollBackTaskManager.this.runTask(taskInfo);
            logger.info((Object)"RollBackTimerTask end, taskId is %s", new Object[]{this.taskId});
        }
    }
}

