/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util;

import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.system.plugin.DrmBaseApplication;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IFaultDefineService;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import java.util.Locale;

public final class AlarmReporter {
    private static DrmBaseApplication sysApp;
    private static final Log logger;
    private static final long[] ALARM_TYPE;

    private AlarmReporter(DrmBaseApplication application) {
        AlarmReporter.setSysApp(application);
    }

    public static void sendAlarm(long alarmID, String sourceId, String sourceType, FaultEnum.AlarmSeverity alarmSeverity, String ... params) {
        String alarmId = "0x" + Long.toHexString(alarmID).toUpperCase(Locale.US);
        AlarmReporter.sendAlarm(alarmId, sourceId, sourceType, alarmSeverity, params);
    }

    public static void sendNoRepeatAlarm(long alarmID, String sourceId, String sourceType, FaultEnum.AlarmSeverity alarmSeverity, String ... params) {
        String alarmId = "0x" + Long.toHexString(alarmID).toUpperCase(Locale.US);
        long moID = sysApp.getManagedSystem().getMoId();
        try {
            LegoAlarm alarmInDB;
            ServiceContext context = ServiceContext.getInstance();
            IFaultDefineService service = (IFaultDefineService)context.lookup("fault/faultDefineService");
            if (null == service) {
                logger.error((Object)"get alarm Service error.", 90160758784001L);
                return;
            }
            FaultDefine faultDefine = service.getFaultDefine(alarmId, "lego.dic.legosystem.maintype", "lego.dic.legosystem.subtype");
            StringBuffer entityBuffer = new StringBuffer();
            entityBuffer.append(moID).append(alarmId);
            String keyIndex = faultDefine.getKeyIndexs();
            if (VerifyUtil.isEmpty((String)keyIndex)) {
                for (String one : params) {
                    entityBuffer.append(one);
                }
            } else {
                String[] indexParam;
                for (String index : indexParam = keyIndex.split(",")) {
                    entityBuffer.append(params[Integer.parseInt(index)]);
                }
            }
            if (null != (alarmInDB = AlarmUtil.getAlarm((String)entityBuffer.toString())) && alarmInDB.getClearStatus() != FaultEnum.ClearState.CLEARED) {
                return;
            }
            AlarmReporter.sendAlarm(alarmId, sourceId, sourceType, alarmSeverity, params);
        }
        catch (Exception e) {
            logger.error((Object)("setFaultDefine exception." + alarmId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public static void sendLicenseAlarmForNoRepeat(long alarmID, String sourceId, String sourceType, FaultEnum.AlarmSeverity alarmSeverity, String[] params) {
        if (VerifyUtil.isEmpty((Object[])params)) {
            logger.error((Object)"params is invalid.", 90160758786989L);
            return;
        }
        String alarmId = "0x" + Long.toHexString(alarmID).toUpperCase(Locale.US);
        long moID = sysApp.getManagedSystem().getMoId();
        String entity = "" + moID + alarmId;
        LegoAlarm alarmInDB = AlarmUtil.getAlarm((String)entity);
        if (alarmInDB != null && alarmInDB.getClearStatus() != FaultEnum.ClearState.CLEARED) {
            return;
        }
        AlarmReporter.sendAlarm(alarmId, sourceId, sourceType, alarmSeverity, params);
    }

    public static void sendLicenseAlarmForParamsNoRepeat(long alarmID, String sourceId, String sourceType, FaultEnum.AlarmSeverity alarmSeverity, String[] params) {
        if (VerifyUtil.isEmpty((Object[])params)) {
            logger.error((Object)"params is invalid.", 90160758786989L);
            return;
        }
        String alarmId = "0x" + Long.toHexString(alarmID).toUpperCase(Locale.US);
        long moID = sysApp.getManagedSystem().getMoId();
        String entity = "" + moID + alarmId;
        LegoAlarm alarmInDB = AlarmUtil.getAlarm((String)entity);
        if (null != alarmInDB && alarmInDB.getClearStatus() != FaultEnum.ClearState.CLEARED && AlarmReporter.isParamsNotChange(alarmInDB.getAlarmParam(), params)) {
            return;
        }
        AlarmReporter.sendAlarm(alarmId, sourceId, sourceType, alarmSeverity, params);
    }

    private static boolean isParamsNotChange(String[] oldParams, String[] newParams) {
        if (oldParams == null && newParams == null) {
            return true;
        }
        if (oldParams == null || newParams == null || oldParams.length != newParams.length) {
            return false;
        }
        for (int i = 0; i < oldParams.length; ++i) {
            if (oldParams[i].equals(newParams[i])) continue;
            return false;
        }
        return true;
    }

    public static void sendAlarmForNoRepeat(long alarmID, String sourceId, String sourceType, FaultEnum.AlarmSeverity alarmSeverity, String[] params) {
        if (VerifyUtil.isEmpty((Object[])params) || params.length < 2) {
            logger.error((Object)"params is invalid.", 90160758786989L);
            return;
        }
        String alarmId = "0x" + Long.toHexString(alarmID).toUpperCase(Locale.US);
        long moID = sysApp.getManagedSystem().getMoId();
        String entity = "" + moID + alarmId + params[1];
        LegoAlarm alarmInDB = AlarmUtil.getAlarm((String)entity);
        if (null != alarmInDB && alarmInDB.getClearStatus() != FaultEnum.ClearState.CLEARED && alarmInDB.getAlarmParam().length >= 2 && alarmInDB.getAlarmParam()[0].equals(params[0])) {
            return;
        }
        AlarmReporter.sendAlarm(alarmId, sourceId, sourceType, alarmSeverity, params);
    }

    public static void sendLogAlarmForNoRepeat(long alarmID, String sourceId, String sourceType, FaultEnum.AlarmSeverity alarmSeverity, String[] params) {
        if (VerifyUtil.isEmpty((Object[])params) || params.length < 2) {
            logger.error((Object)"params is invalid.", 90160758786989L);
            return;
        }
        String alarmId = "0x" + Long.toHexString(alarmID).toUpperCase(Locale.US);
        long moID = sysApp.getManagedSystem().getMoId();
        String entity = "" + moID + alarmId + params[0];
        LegoAlarm alarmInDB = AlarmUtil.getAlarm((String)entity);
        if (null != alarmInDB && alarmInDB.getClearStatus() != FaultEnum.ClearState.CLEARED && alarmInDB.getAlarmParam().length >= 2 && alarmInDB.getAlarmParam()[0].equals(params[0])) {
            return;
        }
        AlarmReporter.sendAlarm(alarmId, sourceId, sourceType, alarmSeverity, params);
    }

    public static void sendAlarm(String alarmId, String sourceId, String sourceType, FaultEnum.AlarmSeverity alarmSeverity, String ... params) {
        LegoAlarm alarm = new LegoAlarm();
        alarm.setAlarmId(alarmId);
        alarm.setMoIP("127.0.0.1");
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setAlarmLevel(alarmSeverity);
        alarm.setAlarmParam(params);
        alarm.setSourceId(sourceId);
        alarm.setSourceType(sourceType);
        try {
            boolean isSuccessed = ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateLegoAlarm(alarm);
            if (!isSuccessed) {
                logger.error((Object)"generate fault alarm failed.see lego logs", 90160758786989L);
            }
        }
        catch (Exception e) {
            logger.error((Object)("generate fault alarm failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public static void restoreAlarm(long alarmID, String ... params) {
        String hexAlarmId = "0x" + Long.toHexString(alarmID).toUpperCase(Locale.US);
        AlarmReporter.restoreAlarm(hexAlarmId, params);
    }

    public static void restoreAlarm(String alarmID, String ... params) {
        long moID = sysApp.getManagedSystem().getMoId();
        String entity = "" + moID + alarmID + (VerifyUtil.isEmpty((Object[])params) ? "" : params[0]);
        LegoAlarm alarmInDB = AlarmUtil.getAlarm((String)entity);
        if (alarmInDB == null || alarmInDB.getClearStatus().getValue() == FaultEnum.ClearState.CLEARED.getValue()) {
            return;
        }
        try {
            AlarmReporter.setFaultDefine(alarmInDB);
            alarmInDB.setClearTime(System.currentTimeMillis());
            ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateLegoRestoreAlarm(alarmInDB);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"generate fault alarm failed", (Throwable)e, 90160758784001L);
        }
    }

    public static void restoreAllAlarm(String pgId) {
        for (long alarmType : ALARM_TYPE) {
            try {
                AlarmReporter.restoreAlarm(alarmType, pgId);
            }
            catch (Exception e) {
                logger.error((Object)"restore fault alarm failed.see lego logs.", 90160758786989L);
            }
        }
    }

    private static void setFaultDefine(LegoAlarm alarmInDB) {
        if (!"0x3230015".equals(alarmInDB.getAlarmId())) {
            alarmInDB.setFaultDefine(null);
            return;
        }
        try {
            ServiceContext context = ServiceContext.getInstance();
            IFaultDefineService service = (IFaultDefineService)context.lookup("fault/faultDefineService");
            if (null == service) {
                logger.error((Object)"get alarm Service error.", 90160758784001L);
                return;
            }
            FaultDefine faultDefine = service.getFaultDefine(alarmInDB.getAlarmId(), alarmInDB.getMoMainType(), alarmInDB.getMoSubType());
            alarmInDB.setFaultDefine(faultDefine);
        }
        catch (Exception e) {
            logger.error((Object)("setFaultDefine exception." + alarmInDB.getAlarmId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    public static void generatePolicyUnknowErrorAlarm(String policyId, String policyName) {
        AlarmReporter.sendAlarm(52625416L, policyId, FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), FaultEnum.AlarmSeverity.CRITICAL, policyId, policyName);
    }

    public static void generateSystemVersionNotMatchAlarm(Long moId, String ip) {
        if (null == moId) {
            logger.error((Object)"moid is null.", 90160758784002L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)ip)) {
            logger.error((Object)"ip is empty.", 90160758784002L);
            throw new LegoCheckedException(1073947393L);
        }
        AlarmReporter.sendAlarm(52625436L, null, FaultEnum.AlarmResourceType.UNDEFINED.getValue(), FaultEnum.AlarmSeverity.CRITICAL, moId.toString(), ip);
    }

    public static void restoreSystemVersionNotMatchAlarm(Long moId) {
        if (null == moId) {
            logger.error((Object)"moid is null.", 90160758784002L);
            throw new LegoCheckedException(1073947393L);
        }
        AlarmReporter.restoreAlarm(52625436L, moId.toString());
    }

    public static void generateRemoteServerFaultAlarm(Long moId, String ip) {
        if (null == moId) {
            logger.error((Object)"moid is null.", 90160758784002L);
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)ip)) {
            logger.error((Object)"ip is empty.", 90160758784002L);
            throw new LegoCheckedException(1073947393L);
        }
        AlarmReporter.sendAlarm(52625435L, null, FaultEnum.AlarmResourceType.UNDEFINED.getValue(), FaultEnum.AlarmSeverity.MAJOR, moId.toString(), ip);
    }

    public static void restoreRemoteServerFaultAlarm(Long moId) {
        if (null == moId) {
            logger.error((Object)"moid is null.", 90160758784002L);
            throw new LegoCheckedException(1073947393L);
        }
        AlarmReporter.restoreAlarm(52625435L, moId.toString());
    }

    private static void setSysApp(DrmBaseApplication sysApp) {
        AlarmReporter.sysApp = sysApp;
    }

    static {
        logger = LogFactory.getInstance(AlarmReporter.class);
        ALARM_TYPE = new long[]{52625416L, 52625436L, 52625421L, 52625430L, 52625431L};
    }
}

