/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.base.util.xml;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class XmlParser {
    private static final Log logger = LogFactory.getInstance(XmlParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document init(URL processFileUrl) {
        InputStream inputStream = null;
        Document document = null;
        try {
            inputStream = processFileUrl.openStream();
            document = this.init(inputStream);
        }
        catch (Exception e) {
            logger.error((Object)("Reading template file failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            this.closeInputStream(inputStream);
        }
        return document;
    }

    public Document init(InputStream inputStream) {
        try {
            return CommonUtil.createSAXReader().read(inputStream);
        }
        catch (Exception e) {
            logger.error((Object)("Initializing document failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return null;
        }
    }

    public Document init(File xmlFile) {
        try {
            return CommonUtil.createSAXReader().read(xmlFile);
        }
        catch (Exception e) {
            logger.error((Object)("Initializing document failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return null;
        }
    }

    public String getAttribute(Element element, String attrName) {
        Attribute attribute = element.attribute(attrName);
        if (attribute == null) {
            return "";
        }
        return attribute.getValue();
    }

    public Element getRootElement(Document document) {
        if (document == null) {
            return null;
        }
        return document.getRootElement();
    }

    public String getText(Element parent, String xPath) {
        List<Node> nodes = this.getNodes(parent, xPath);
        String text = null;
        if (nodes != null && !nodes.isEmpty()) {
            text = nodes.get(0).getText();
        }
        return text;
    }

    public List<Node> getNodes(Element parent, String xPath) {
        return CommonUtil.getNodes((Element)parent, (String)xPath);
    }

    private void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                logger.error((Object)("Closing input stream failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
        }
    }
}

