/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.cert.CertUriResolver;
import com.huawei.ism.drm.cert.CertificateManagementWidgetJob;
import com.huawei.ism.drm.cert.ServerCertificateValidateJob;
import com.huawei.ism.drm.cert.component.DependedCertificateService;
import com.huawei.ism.drm.cert.sdk.model.CertificateContent;
import com.huawei.ism.drm.cert.sdk.model.CertificateOperateStatus;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateNotice;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateTaskData;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateTaskStatus;
import com.huawei.ism.drm.cert.sdk.model.RevokedCertificate;
import com.huawei.ism.drm.cert.sdk.service.ICertificateHandler;
import com.huawei.ism.drm.cert.sdk.service.ICertificateManagementService;
import com.huawei.ism.drm.cert.sdk.service.ICertificateManagementWidget;
import com.huawei.ism.drm.cert.sdk.service.ICertificateService;
import com.huawei.ism.drm.cert.sdk.service.ISysCertRmiService;
import com.huawei.ism.drm.cert.sdk.service.ISystemCertificateService;
import com.huawei.ism.drm.cert.task.CertificateOperateTask;
import com.huawei.ism.drm.cert.task.CertificateRollbackTask;
import com.huawei.ism.drm.cert.task.RevokCertificateTask;
import com.huawei.ism.drm.util.Base64;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.comm.keystore.KeystoreUtil;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.comm.security.SecurityCertificateManager;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.dao.DataAccessException;
import sun.security.x509.X500Name;

@Service(name="com.huawei.ism.drm.cert.sdk.service.ISysCertRmiService", desc="", interfaceClass=ISysCertRmiService.class)
public class SystemCertificateService
extends BaseService
implements ISystemCertificateService,
Runnable,
SystemStatusChangedListener {
    public static final String CERT_EXT = ".cert";
    public static final String SERVICE_NAME = "eReplication";
    private static final Log logger = LogFactory.getInstance(SystemCertificateService.class);
    private static final long TIMEOUT = 1800L;
    private static final long INTERVAL = 10L;
    private Scheduler scheduler;
    private NodeAgentLocalService.Iface nodeAgentLocalService;
    private List<ICertificateService> componentCertificateServices = new ArrayList<ICertificateService>();
    private List<ICertificateManagementService> certificateManagementServices = new ArrayList<ICertificateManagementService>();
    private List<ICertificateHandler> certificateHandlers = new ArrayList<ICertificateHandler>();
    private BlockingQueue<CertificateOperateTask> queue = new LinkedBlockingQueue<CertificateOperateTask>();
    private BlockingQueue<RevokedCertificate> revokedCertificatesQueue = new LinkedBlockingQueue<RevokedCertificate>();
    private AtomicInteger jobIndex = new AtomicInteger(0);

    public NodeAgentLocalService.Iface getNodeAgentLocalService() {
        return this.nodeAgentLocalService;
    }

    public void setNodeAgentLocalService(NodeAgentLocalService.Iface nodeAgentLocalService) {
        this.nodeAgentLocalService = nodeAgentLocalService;
    }

    public void addComponentCertificateService(ICertificateService service, Map properties) {
        if (!this.componentCertificateServices.contains(service)) {
            this.componentCertificateServices.add(service);
            service.setNodeAgentLocalService(this.nodeAgentLocalService);
            service.setSystemCertificateService((ISystemCertificateService)this);
            service.getCertificateSummaries().forEach(summary -> summary.setCertificateService(service));
        }
    }

    public void addCertificateManagementService(ICertificateManagementService service, Map properties) {
        if (!this.certificateManagementServices.contains(service)) {
            this.certificateManagementServices.add(service);
        }
    }

    public void addCertificateHandler(ICertificateHandler handler, Map properties) {
        if (!this.certificateHandlers.contains(handler)) {
            this.certificateHandlers.add(handler);
        }
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.componentCertificateServices.forEach(ICertificateService::initialize);
            new Thread((Runnable)this, "Certificate-Task-Thread").start();
            new Thread(() -> this.runRevokCertificate()).start();
        }
    }

    private void initializeSchedule() {
        try {
            CommonUtil.sleep((long)10000L);
            logger.info((Object)"start initialize.");
            JobDataMap data = new JobDataMap();
            data.put(SystemCertificateService.class.getName(), (Object)this);
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.scheduleJob(JobBuilder.newJob(ServerCertificateValidateJob.class).usingJobData(data).build(), TriggerBuilder.newTrigger().withIdentity("Server-CertificateContent-Validate").startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)new CronExpression("0 0 0 * * ?"))).build());
            this.scheduler.scheduleJob(JobBuilder.newJob(ServerCertificateValidateJob.class).usingJobData(data).build(), TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForTotalCount((int)1)).build());
            this.getCertificateManagementWidgets("once:startup").forEach(this::scheduleOnceJob);
            this.getCertificateManagementWidgets("cron:.*").forEach(this::scheduleCronJob);
            this.scheduler.start();
        }
        catch (ParseException | SchedulerException e) {
            logger.error((Object)"start quartz failed", e, 90160758784001L);
            throw new LegoCheckedException(-1L, e);
        }
        logger.info((Object)"initialize end.");
    }

    private Stream<ICertificateManagementWidget> getCertificateManagementWidgets(String rule) {
        logger.info((Object)"getCertificateManagementWidgets: %s", new Object[]{this.certificateManagementServices.toString()});
        return this.certificateManagementServices.stream().filter(ICertificateManagementService::available).flatMap(service -> service.getCertificateManagementWidgets().stream()).filter(widget -> widget.getSchedule().matches(rule));
    }

    public void registerCertificate() {
        this.getCertificateManagementWidgets("once:startup").forEach(item -> item.process(this.getAllRegisterableCertificates()));
    }

    private void scheduleCronJob(ICertificateManagementWidget widget) {
        String schedule = widget.getSchedule();
        int index = schedule.indexOf(58);
        if (index == -1) {
            logger.error((Object)("invalid schedule: " + schedule));
            return;
        }
        String cron = schedule.substring(index + 1);
        JobDetail detail = this.createCertificateManagementWidgetJobDetail(widget);
        try {
            this.scheduler.scheduleJob(detail, TriggerBuilder.newTrigger().withIdentity("Certificate-Cron-Job-" + this.jobIndex.addAndGet(1)).startNow().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)new CronExpression(cron))).build());
        }
        catch (ParseException | SchedulerException e) {
            logger.error((Object)("Fail to schedule cron job for " + widget.getSchedule()), e);
        }
    }

    private void scheduleOnceJob(ICertificateManagementWidget widget) {
        logger.info((Object)"scheduleOnceJob: %s", new Object[]{widget});
        JobDetail detail = this.createCertificateManagementWidgetJobDetail(widget);
        try {
            this.scheduler.scheduleJob(detail, TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForTotalCount((int)1)).build());
        }
        catch (SchedulerException e) {
            logger.error((Object)("Fail to schedule once job for " + widget.getSchedule()), (Throwable)e);
        }
    }

    private JobDetail createCertificateManagementWidgetJobDetail(ICertificateManagementWidget widget) {
        logger.info((Object)"createCertificateManagementWidgetJobDetail: %s", new Object[]{widget});
        List categories = Optional.ofNullable(widget.getCertificateManagementService().getCertificateSummaryCategories()).orElse(Collections.emptyList());
        logger.info((Object)"categories: %s", new Object[]{categories.toString()});
        List summaries = this.getAllRegisterableCertificates().stream().filter(summary -> categories.contains(summary.getCategory())).collect(Collectors.toList());
        JobDataMap data = new JobDataMap();
        data.put(ISystemCertificateService.class.getName(), (Object)this);
        data.put(ICertificateManagementWidget.class.getName(), (Object)widget);
        data.put(Object.class.getName(), summaries);
        return JobBuilder.newJob(CertificateManagementWidgetJob.class).usingJobData(data).build();
    }

    public boolean available() {
        return this.certificateManagementServices.stream().anyMatch(ICertificateManagementService::available);
    }

    public CertificateOperateStatus updateCertificate(CertificateUpdateParam param) {
        String certName;
        if (!this.available()) {
            return CertificateOperateStatus.failed((String)"Non-private cloud scenarios do not support this operation");
        }
        if (param.getCert() != null) {
            certName = param.getCert().getCertName();
        } else if (!VerifyUtil.isEmpty((Collection)param.getSmCerts())) {
            certName = ((CertificateContent)param.getSmCerts().get(0)).getCertName();
        } else {
            return CertificateOperateStatus.errorParam((String)"The value of 'cert' field is not provided");
        }
        CertificateSummary summary = this.getCertificateSummaryByCertName(certName);
        if (summary == null) {
            return CertificateOperateStatus.errorParam((String)("Not supported cert name: " + certName));
        }
        return summary.submitCertificateUpdateTask(this.queue, param, true, true);
    }

    public CertificateOperateStatus rollbackCertificate(CertificateUpdateNotice notice) {
        BackTask task = this.queryIndependentBackTask(notice.getTaskId());
        if (task == null) {
            return CertificateOperateStatus.errorParam((String)("Task is not exists. task id: " + notice.getTaskId())).name(null);
        }
        String certName = task.getTargetName();
        ICertificateHandler handler = this.getCertificateHandlerByCertName(certName);
        if (handler == null) {
            return CertificateOperateStatus.errorParam((String)("Not supported cert name: " + certName)).name(certName);
        }
        CertificateRollbackTask rollback = new CertificateRollbackTask(this, notice, task);
        try {
            BackTaskHandler.getInstance().submitTask((AbstractBackTask)rollback);
            logger.info((Object)"rollback cert for %s", new Object[]{certName});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Fail to submit update task for cert " + rollback.getCertName()), (Throwable)e);
            return CertificateOperateStatus.failed((String)("Fail to submit update task for cert " + rollback.getCertName())).name(certName);
        }
        return CertificateOperateStatus.success().name(certName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        logger.info((Object)"cert service start thread to handle on register or update task.");
        this.initializeSchedule();
        while (true) {
            CertificateOperateTask task;
            try {
                task = this.queue.take();
            }
            catch (InterruptedException e) {
                logger.error((Object)"Take task failed", (Throwable)e);
                continue;
            }
            String certName = task.getCertName();
            AtomicBoolean submit = new AtomicBoolean();
            try {
                logger.info((Object)"submit a task for cert %s", new Object[]{certName});
                long taskId = BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
                logger.info((Object)"submit a task for cert %s success", new Object[]{certName});
                submit.set(true);
                logger.info((Object)"monitor a task for cert %s, task id is ", new Object[]{certName, taskId});
                BackTaskUtil.monitorTaskResult((long)1800L, (long)10L, () -> ((CertificateOperateTask)task).getBackTask());
            }
            catch (LegoCheckedException e) {
                if (submit.get()) {
                    logger.error((Throwable)e, (Object)"monitor a task for cert %s failed", new Object[]{certName});
                } else {
                    logger.error((Object)("Fail to submit update task error, certName=" + certName), (Throwable)e);
                }
                task.notifyCertificateUpdateStatus("11111111", "Fail to submit update task for cert " + certName);
                logger.info((Object)"finish task process for cert %s", new Object[]{certName});
                CommonUtil.sleep((long)20000L);
                logger.info((Object)"finish waiting for 20s, cert %s", new Object[]{certName});
                continue;
            }
            catch (Throwable e2) {
                logger.error((Object)("Fail to submit update task. unknown error, certName=" + certName), e2);
                task.notifyCertificateUpdateStatus("11111111", "Fail to submit update task for cert " + certName);
                {
                    catch (Throwable throwable) {
                        logger.info((Object)"finish task process for cert %s", new Object[]{certName});
                        CommonUtil.sleep((long)20000L);
                        logger.info((Object)"finish waiting for 20s, cert %s", new Object[]{certName});
                        throw throwable;
                    }
                }
                logger.info((Object)"finish task process for cert %s", new Object[]{certName});
                CommonUtil.sleep((long)20000L);
                logger.info((Object)"finish waiting for 20s, cert %s", new Object[]{certName});
                continue;
            }
            logger.info((Object)"finish task process for cert %s", new Object[]{certName});
            CommonUtil.sleep((long)20000L);
            logger.info((Object)"finish waiting for 20s, cert %s", new Object[]{certName});
            continue;
            break;
        }
    }

    public void notifyCertificateUpdateStatus(String taskId, String certName, String resultCode, String errorMsg, boolean quiet) {
        logger.debug((Object)"notify certificate update status: %s", new Object[]{taskId});
        for (ICertificateManagementService certificateManagementService : this.certificateManagementServices) {
            try {
                certificateManagementService.notifyCertificateStatus(taskId, resultCode, errorMsg, certName);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)String.format(Locale.ENGLISH, "%s:update certificate status failed, %s", certificateManagementService.getClass().getSimpleName(), taskId));
                if (quiet) continue;
                throw e;
            }
        }
    }

    public CertificateUpdateTaskStatus queryCertificateUpdateTaskStatus(String taskId) {
        List<BackTask> tasks;
        try {
            tasks = this.queryBackTasks(taskId);
        }
        catch (DataAccessException e) {
            logger.error((Object)"query back task failed, may database restarting.", (Throwable)e);
            BackTask task = new BackTask();
            task.setTaskResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_PROCESS));
            tasks = Collections.singletonList(task);
        }
        if (tasks.isEmpty()) {
            return null;
        }
        if (tasks.size() == 1) {
            return this.castAsCertificateUpdateTaskStatus(tasks.get(0));
        }
        BackTask running = this.findRunningBackTask(tasks);
        if (running != null) {
            return this.castAsCertificateUpdateTaskStatus(running);
        }
        BackTask failed = this.findFailedBackTask(tasks);
        if (failed != null) {
            return this.castAsCertificateUpdateTaskStatus(failed);
        }
        return this.castAsCertificateUpdateTaskStatus(tasks.get(0));
    }

    private BackTask findFailedBackTask(List<BackTask> tasks) {
        return this.findBackTask(tasks, CommonConstant.BACKTASK_RESULT_FAIL);
    }

    private BackTask findBackTask(List<BackTask> tasks, int result) {
        return tasks.stream().filter(task -> task.getTaskResult() == result).findFirst().orElse(null);
    }

    private BackTask findRunningBackTask(List<BackTask> tasks) {
        return this.findBackTask(tasks, CommonConstant.BACKTASK_RESULT_PROCESS);
    }

    private CertificateUpdateTaskStatus castAsCertificateUpdateTaskStatus(BackTask task) {
        CertificateUpdateTaskStatus status = new CertificateUpdateTaskStatus();
        status.setResultCode("00000000");
        Integer result = task.getTaskResult();
        CertificateUpdateTaskData data = status.getData();
        if (result == CommonConstant.BACKTASK_RESULT_FAIL) {
            data.setUpdateStatus("failed");
            JSONObject object = new JSONObject();
            object.set((Object)"code", (Object)Optional.ofNullable(task.getTaskDetail()).orElse("-1"));
            object.set((Object)"args", Arrays.asList((Object[])Optional.ofNullable(task.getTaskDetailParas()).orElse(new String[0])));
            data.setDetail(object.toString());
        } else if (result == CommonConstant.BACKTASK_RESULT_SUCCESS) {
            data.setUpdateStatus("success");
        } else {
            data.setUpdateStatus("running");
        }
        return status;
    }

    private List<BackTask> queryBackTasks(String taskId) {
        return Stream.concat(this.getBackTasksInDatabase(taskId), this.queryBackTasksInQueue(taskId)).collect(Collectors.toList());
    }

    private Stream<BackTask> queryBackTasksInQueue(String taskId) {
        return this.queue.stream().map(AbstractBackTask::getBackTask).filter(task -> CertificateOperateTask.isMatchedTask(task, Collections.singletonMap("ism.drm.cert.update", "cert.update"), Collections.singletonMap("ism.drm.cert.notify", "cert.notify"))).filter(task -> CertificateOperateTask.isMatchedTask(task, taskId));
    }

    private Stream<BackTask> getBackTasksInDatabase(String taskId) {
        List items = CommonDAOLocator.getBaseDao().find("from BackTask where taskName = ? and type = ? and taskLink like ?", new Object[]{"ism.drm.cert.update", "cert.update", "x://" + taskId + "?%"});
        if (items == null || items.isEmpty()) {
            return Stream.empty();
        }
        return items.stream().filter(BackTask.class::isInstance).map(BackTask.class::cast);
    }

    private BackTask queryIndependentBackTask(String taskId) {
        List<BackTask> tasks = this.queryBackTasks(taskId);
        if (tasks.isEmpty()) {
            return null;
        }
        return tasks.stream().filter(task -> task.getTaskLink() != null && task.getTaskLink().contains("independent=true")).findFirst().orElse(null);
    }

    public ICertificateService getCertificateServiceByCertName(String certName) {
        return this.componentCertificateServices.stream().filter(service -> service.getCertificateSummaryByCertName(certName) != null).findFirst().orElse(null);
    }

    public static String getComponentCertificateName(String name) {
        return SERVICE_NAME + '-' + name;
    }

    public CertificateSummary getCertificateSummaryByCertName(String certName) {
        return this.componentCertificateServices.stream().flatMap(e -> e.getCertificateSummaries().stream()).filter(certificateSummary -> Objects.equals(certificateSummary.getCertName(), certName)).findFirst().orElse(null);
    }

    public ICertificateHandler getCertificateHandlerByCertName(String certName) {
        CertificateSummary summary = this.getCertificateSummaryByCertName(certName);
        return summary != null ? this.getCertificateHandler(summary) : null;
    }

    public ICertificateHandler getCertificateHandler(CertificateSummary summary) {
        return this.getCertificateHandler(summary, true);
    }

    public ICertificateHandler getCertificateHandler(CertificateSummary summary, boolean onlyRegisterable) {
        if (onlyRegisterable && !this.isRegisterableCertificate(summary)) {
            logger.error((Object)"not supported for cert %s, which category is %s", new Object[]{summary.getCertName(), summary.getCategory()});
            return null;
        }
        return this.certificateHandlers.stream().filter(handler -> handler.suitable(summary)).findFirst().orElse(null);
    }

    public List<CertificateSummary> getAllRegisterableCertificates() {
        return this.getAllCertificateSummaries().stream().filter(this::isRegisterableCertificate).collect(Collectors.toList());
    }

    private boolean isRegisterableCertificate(CertificateSummary summary) {
        return this.certificateManagementServices.stream().anyMatch(service -> service.getCertificateSummaryCategories().contains(summary.getCategory()));
    }

    public List<CertificateSummary> getAllCertificateSummaries() {
        return this.componentCertificateServices.stream().flatMap(service -> service.getCertificateSummaries().stream()).collect(Collectors.toList());
    }

    public List<CertificateSummary> getAllServerCertificateSummaries() {
        return this.getCertificateSummariesByType(CertUriResolver.SERVER.toString());
    }

    public List<CertificateSummary> getAllDependCertificateSummaries() {
        return this.getCertificateSummariesByType(CertUriResolver.DEPEND.toString());
    }

    private List<CertificateSummary> getCertificateSummariesByType(String use) {
        return this.getAllCertificateSummaries().stream().filter(summary -> use.equalsIgnoreCase(summary.getType())).collect(Collectors.toList());
    }

    public static Path getComponentCertificatePath() {
        return SystemCertificateService.getComponentCertificatePath(false);
    }

    public static Path getComponentCertificatePath(boolean quiet) {
        String base = PathUtil.getLegoRuntimePath((boolean)quiet);
        if (base == null) {
            logger.info((Object)"not found LegoRuntime path.");
            return null;
        }
        return Paths.get(base, "certs/components");
    }

    public CertificateOperateStatus revokeCertificate(CertificateUpdateParam param) {
        if (VerifyUtil.isEmpty((Object)param)) {
            logger.error((Object)"param  is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.available()) {
            return CertificateOperateStatus.failed((String)"Non-private cloud scenarios do not support this operation");
        }
        if (!VerifyUtil.isEmpty((String)param.getCrl())) {
            this.analysisCrl(param.getCrl());
        }
        if (!VerifyUtil.isEmpty((String)param.getSmCrl())) {
            this.analysisCrl(param.getSmCrl());
        }
        return CertificateOperateStatus.success();
    }

    public void analysisCrl(String crl) {
        if (VerifyUtil.isEmpty((String)crl)) {
            logger.error((Object)"crl is empty");
            return;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL aCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(Base64.base64ToByteArray((String)crl)));
            ArrayList<RevokedCertificate> revokedCertificateList = new ArrayList<RevokedCertificate>();
            Set<? extends X509CRLEntry> tSet = aCrl.getRevokedCertificates();
            if (VerifyUtil.isEmpty(tSet)) {
                logger.debug((Object)"crl is empty.");
                return;
            }
            this.serialNumberToUpperCase(revokedCertificateList, tSet);
            this.saveCrl(revokedCertificateList);
            HashMap bcmCertificateMap = new HashMap();
            HashMap<String, String> commonNameMap = new HashMap<String, String>();
            KeyStore keyStore = KeystoreUtil.loadKeyStore((String)BcmX509TrustManager.KEYSTORE_FILE, (String)SecurityCertificateManager.getKeyStorePassword(), (String)KeyStore.getDefaultType());
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(alias);
                String serialNumber = x509Certificate.getSerialNumber().toString(16).toUpperCase(Locale.ENGLISH);
                this.getCommonName(commonNameMap, x509Certificate, serialNumber);
                CommUtil.addSetToMap(bcmCertificateMap, (Object)serialNumber, (Object)alias);
            }
            for (RevokedCertificate revokedCertificate : revokedCertificateList) {
                Set aliasSet = (Set)bcmCertificateMap.get(revokedCertificate.getSerialNumber());
                if (VerifyUtil.isEmpty((Collection)aliasSet)) continue;
                revokedCertificate.setAliasSet(aliasSet);
                revokedCertificate.setCommonName((String)commonNameMap.get(revokedCertificate.getSerialNumber()));
                logger.info((Object)"cert:%s add to revokedCertificatesQueue", new Object[]{revokedCertificate.toString()});
                this.revokedCertificatesQueue.add(revokedCertificate);
            }
        }
        catch (Exception e) {
            logger.error((Object)"load crl error.", (Throwable)e);
            ExceptionUtil.rethrowException((Throwable)e, (String)"load crl error.", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    private void serialNumberToUpperCase(List<RevokedCertificate> revokedCertificateList, Set<? extends X509CRLEntry> tSet) {
        for (X509CRLEntry x509CRLEntry : tSet) {
            String serialNumber = x509CRLEntry.getSerialNumber().toString(16).toUpperCase(Locale.ENGLISH);
            RevokedCertificate revokedCertificate = new RevokedCertificate();
            revokedCertificate.setCreateDate(new Date());
            revokedCertificate.setRevocationDate(x509CRLEntry.getRevocationDate());
            revokedCertificate.setSerialNumber(serialNumber);
            revokedCertificateList.add(revokedCertificate);
        }
    }

    private void saveCrl(List<RevokedCertificate> revokedCertificateList) {
        try {
            List lineList;
            if (revokedCertificateList == null || revokedCertificateList.isEmpty()) {
                return;
            }
            Set revokedCertSnSet = revokedCertificateList.stream().map(RevokedCertificate::getSerialNumber).collect(Collectors.toSet());
            File crlFile = new File(PathUtil.getRuntimePath() + File.separator + "LegoRuntime" + File.separator + "certs" + File.separator + "bcm.crl");
            if (crlFile.exists() && crlFile.isFile() && (lineList = FileUtil.readLines((File)crlFile)) != null && !lineList.isEmpty()) {
                revokedCertSnSet.addAll(lineList);
            }
            logger.info((Object)"save crl:%s", new Object[]{String.valueOf(revokedCertSnSet)});
            if (!VerifyUtil.isEmpty(revokedCertSnSet)) {
                FileUtil.writeLines((File)crlFile, new ArrayList(revokedCertSnSet));
            }
        }
        catch (Exception e) {
            logger.error((Object)"saveCrl error!", (Throwable)e);
        }
    }

    private void getCommonName(Map<String, String> commonNameMap, X509Certificate x509Certificate, String serialNumber) {
        try {
            X500Name x500Name;
            String commonName;
            Principal principal = x509Certificate.getSubjectDN();
            if (principal instanceof X500Name && (commonName = (x500Name = (X500Name)principal).getCommonName()) != null) {
                commonNameMap.put(serialNumber, commonName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getCommonName error for:%s", new Object[]{e, serialNumber});
        }
    }

    private DependedCertificateService getDependedCertificateService() {
        return this.componentCertificateServices.stream().filter(service -> service instanceof DependedCertificateService).findFirst().orElse(null);
    }

    private void runRevokCertificate() {
        logger.info((Object)"cert service start thread to handle on register or update task.");
        while (true) {
            try {
                while (true) {
                    RevokedCertificate revokedCertificate = this.revokedCertificatesQueue.take();
                    RevokCertificateTask revokCertificateTask = new RevokCertificateTask(revokedCertificate, this.getDependedCertificateService(), this.getNodeAgentLocalService());
                    logger.info((Object)"submit revoke cert task for cert:%s", new Object[]{revokedCertificate.toString()});
                    BackTaskHandler.getInstance().submitTask((AbstractBackTask)revokCertificateTask);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Revoke Take task failed", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

