/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.handler;

import com.huawei.ism.drm.cert.handler.ServerCertificateHandler;
import com.huawei.ism.drm.cert.sdk.model.CertificateAuthority;
import com.huawei.ism.drm.cert.sdk.model.CertificateContent;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.ism.drm.util.Base64;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;

public class JksServerCertificateHandler
extends ServerCertificateHandler {
    private static final String TYPE = "JKS";
    private static final Log logger = LogFactory.getInstance(JksServerCertificateHandler.class);

    public JksServerCertificateHandler() {
        super(TYPE);
    }

    public void saveCertificateToFileSystem(CertificateUpdateParam param, Consumer<Parameter> handler) {
        logger.debug((Object)"save file to filesystem.");
        CertificateContent cert = param.getCert();
        File file = null;
        char[] password = cert.getPriKeyPwd().toCharArray();
        KeyStore keyStore = this.getKeyStore();
        int n = param.getCas().size();
        for (int i = 0; i < n; ++i) {
            String ca = ((CertificateAuthority)param.getCas().get(i)).getCaContent();
            this.loadCA(keyStore, cert.getCertName(), ca, i);
        }
        List<Map.Entry<String, Map.Entry<PrivateKey, Certificate>>> entries = this.loadCertContent(cert.getCertContent(), password);
        if (entries.size() != 1) {
            logger.error((Object)"number of key pair in cert content is not one");
            throw new LegoCheckedException(1073947471L, "number of key pair in cert content is not one");
        }
        this.setKeyEntry(password, keyStore, entries);
        FileOutputStream stream = null;
        try {
            File temp = file = this.createTempFile(cert.getCertName(), cert.getCertName(), "config.cert.jks.suffix", ".keystore");
            stream = new FileOutputStream(temp);
            keyStore.store(stream, password);
            handler.accept(new Parameter(Collections.singletonMap("password", cert.getPriKeyPwd()), Collections.singletonList(JksServerCertificateHandler.getRelativizeCertTempPath(temp))));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            try {
                String message = "Fail to save certificate file(s) for " + cert.getCertName();
                logger.error((Object)(message + ExceptionUtil.getErrorMessage((Throwable)e)));
                throw new LegoCheckedException(1073947473L, null, message + new JSONObject().set((Object)"taskId", (Object)param.getTaskId()).set((Object)"certName", (Object)cert.getCertName()).toString());
            }
            catch (Throwable throwable) {
                CommonUtil.close(stream);
                if (file != null && !file.delete()) {
                    logger.error((Object)("delete temp file failed. file name: " + file.getName()));
                }
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)stream);
        if (file != null && !file.delete()) {
            logger.error((Object)("delete temp file failed. file name: " + file.getName()));
        }
    }

    private void setKeyEntry(char[] password, KeyStore keyStore, List<Map.Entry<String, Map.Entry<PrivateKey, Certificate>>> entries) {
        Map.Entry<String, Map.Entry<PrivateKey, Certificate>> entry = entries.get(0);
        String alias = entry.getKey();
        Map.Entry<PrivateKey, Certificate> pair = entry.getValue();
        PrivateKey privateKey = pair.getKey();
        Certificate certificate = pair.getValue();
        try {
            keyStore.setKeyEntry(alias, privateKey, password, new Certificate[]{certificate});
        }
        catch (KeyStoreException e) {
            logger.error((Object)"import key pair into keystore failed");
            throw new LegoCheckedException("import key pair into keystore failed", (Throwable)e);
        }
    }

    private KeyStore getKeyStore() {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(TYPE);
            keyStore.load(null, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.error((Object)"initialize keystore failed");
            throw new LegoCheckedException("initialize keystore failed", (Throwable)e);
        }
        return keyStore;
    }

    private void loadCA(KeyStore keyStore, String certName, String ca, int index) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(Base64.base64ToByteArray((String)ca));){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(stream);
            keyStore.setCertificateEntry(certName + "-ca-" + index, cert);
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            throw new LegoCheckedException(1073947472L, "load CA failed", (Throwable)e);
        }
    }

    private List<Map.Entry<String, Map.Entry<PrivateKey, Certificate>>> loadCertContent(String content, char[] password) {
        Enumeration<String> aliases;
        KeyStore keystore;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(Base64.base64ToByteArray((String)content));){
            keystore = KeyStore.getInstance("PKCS12");
            keystore.load(stream, password);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new LegoCheckedException(0x300001L, "load key pair failed", (Throwable)e);
        }
        try {
            aliases = keystore.aliases();
        }
        catch (KeyStoreException e) {
            throw new LegoCheckedException(0x300001L, "obtain aliases of key pair failed", (Throwable)e);
        }
        ArrayList<Map.Entry<String, Map.Entry<PrivateKey, Certificate>>> entries = new ArrayList<Map.Entry<String, Map.Entry<PrivateKey, Certificate>>>();
        while (aliases.hasMoreElements()) {
            Certificate certificate;
            Key key;
            String alias = aliases.nextElement();
            try {
                key = keystore.getKey(alias, password);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                logger.error((Object)("obtain private key failed. alias: " + alias), (Throwable)e);
                continue;
            }
            if (!(key instanceof PrivateKey)) {
                logger.debug((Object)String.format(Locale.ENGLISH, "key '%s' is not a private key", alias));
                continue;
            }
            PrivateKey privateKey = (PrivateKey)key;
            try {
                certificate = keystore.getCertificate(alias);
            }
            catch (KeyStoreException e) {
                logger.error((Object)("obtain public key failed. alias: " + alias), (Throwable)e);
                continue;
            }
            AbstractMap.SimpleEntry<PrivateKey, Certificate> pair = new AbstractMap.SimpleEntry<PrivateKey, Certificate>(privateKey, certificate);
            entries.add(new AbstractMap.SimpleEntry<String, AbstractMap.SimpleEntry<PrivateKey, Certificate>>(alias, pair));
        }
        return entries;
    }
}

