/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.handler;

import com.huawei.ism.drm.cert.handler.ServerCertificateHandler;
import com.huawei.ism.drm.cert.sdk.model.CertificateContent;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.ism.drm.wcc.util.WccHelper;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.Constants;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.function.Consumer;

public class PemServerCertificateHandler
extends ServerCertificateHandler {
    private static final String FORMAT = "pem";
    private static final Log logger = LogFactory.getInstance(PemServerCertificateHandler.class);

    public PemServerCertificateHandler() {
        super(FORMAT);
    }

    @Override
    protected String validateCert(CertificateUpdateParam param) {
        return Optional.ofNullable(super.validateCert(param)).orElseGet(() -> PemServerCertificateHandler.validateCertPriKey(param.getCert()));
    }

    public void saveCertificateToFileSystem(CertificateUpdateParam param, Consumer<Parameter> handler) {
        LinkedHashMap<String, String> fileMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> passMap = new LinkedHashMap<String, String>();
        String nginxPassword = "";
        try {
            nginxPassword = WccHelper.getInstance().decrypt(LegoConfig.getInstance().getKeyValue("nginx.keypass"));
        }
        catch (IOException e) {
            logger.error((Object)"Get nginx keypass from lego.properties failed.");
        }
        if (!VerifyUtil.isEmpty((Object)param.getCert())) {
            CertificateContent cert2 = param.getCert();
            fileMap.put("crt", cert2.getCertContent());
            fileMap.put("key", cert2.getPriKey());
            passMap.put("password", cert2.getPriKeyPwd());
            passMap.put("nginxPassword", nginxPassword);
        } else {
            CertificateContent smSigCert = param.getSmCerts().stream().filter(cert -> Constants.CertType.SIGNATURE.getValue().equalsIgnoreCase(cert.getCertUsage())).findFirst().get();
            CertificateContent smEncCert = param.getSmCerts().stream().filter(cert -> Constants.CertType.ENCRYPTION.getValue().equalsIgnoreCase(cert.getCertUsage())).findFirst().get();
            fileMap.put("sigCrt", smSigCert.getCertContent());
            fileMap.put("sigKey", smSigCert.getPriKey());
            passMap.put("sigPassword", smSigCert.getPriKeyPwd());
            fileMap.put("encCrt", smEncCert.getCertContent());
            fileMap.put("encKey", smEncCert.getPriKey());
            passMap.put("encPassword", smEncCert.getPriKeyPwd());
            passMap.put("nginxPassword", nginxPassword);
        }
        this.saveCertificateToFileSystem(param, passMap, true, handler, fileMap);
    }
}

