/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.handler;

import com.huawei.ism.drm.cert.CertificateResolver;
import com.huawei.ism.drm.cert.handler.CertificateHandler;
import com.huawei.ism.drm.cert.sdk.model.CertificateContent;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.Constants;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;

public abstract class ServerCertificateHandler
extends CertificateHandler {
    protected static final String PASSWORD = "password";
    private static final Log logger = LogFactory.getInstance(ServerCertificateHandler.class);
    private String format;
    private CertificateResolver certificateResolver = new CertificateResolver();

    public ServerCertificateHandler(String format) {
        super("server");
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public CertificateResolver getCertificateResolver() {
        return this.certificateResolver;
    }

    public void setCertificateResolver(CertificateResolver certificateResolver) {
        this.certificateResolver = certificateResolver;
    }

    private static String getCertificateDescription(String component) {
        String zh = LegoConfig.getInstance().getKeyValue("cert." + component + ".description.zh");
        String en = LegoConfig.getInstance().getKeyValue("cert." + component + ".description.en");
        return zh + "##" + en;
    }

    @Override
    public boolean suitable(CertificateSummary certificate) {
        logger.info((Object)"%s suitable: %s, format: %s", new Object[]{certificate.getCertName(), certificate.getCertFormat(), this.format});
        return super.suitable(certificate) && this.format.equalsIgnoreCase(certificate.getCertFormat());
    }

    public boolean fulfil(CertificateSummary summary) {
        if (!this.suitable(summary)) {
            logger.debug((Object)"Not support to fulfil summary: %s", new Object[]{Optional.ofNullable(summary).map(CertificateSummary::getCertName).orElse(null)});
            return false;
        }
        String component = summary.getComponentName();
        logger.info((Object)"fulfil certificate for certificate %s, component name is %s", new Object[]{summary.getCertName(), component});
        X509Certificate certificate = this.certificateResolver.resolveX509Certificate(component);
        if (certificate == null) {
            logger.info((Object)"fulfil certificate failed.");
            return false;
        }
        summary.setSubjectName(certificate.getSubjectX500Principal().getName());
        summary.setNotAfter(this.format(certificate.getNotAfter()));
        summary.setNotBefore(this.format(certificate.getNotBefore()));
        if (!Constants.CipherType.GENERAL_CIPHER.getValue().equals(LegoConfig.getInstance().getKeyValue("cipher.type", Constants.CipherType.GENERAL_CIPHER.getValue()))) {
            CertificateSummary smSigCert = new CertificateSummary();
            smSigCert.setKeyAlgorithm("sm2");
            smSigCert.setSubjectName(certificate.getSubjectX500Principal().getName());
            smSigCert.setNotAfter(this.format(certificate.getNotAfter()));
            smSigCert.setNotBefore(this.format(certificate.getNotBefore()));
            smSigCert.setCaType(Integer.valueOf(1));
            smSigCert.setKeySize(256);
            smSigCert.setCertUsage(Constants.CertType.SIGNATURE.getValue());
            ArrayList<CertificateSummary> smCertList = new ArrayList<CertificateSummary>();
            smCertList.add(smSigCert);
            CertificateSummary smEncCert = new CertificateSummary();
            smEncCert.setKeyAlgorithm("sm2");
            smEncCert.setSubjectName(certificate.getSubjectX500Principal().getName());
            smEncCert.setNotAfter(this.format(certificate.getNotAfter()));
            smEncCert.setNotBefore(this.format(certificate.getNotBefore()));
            smEncCert.setCaType(Integer.valueOf(1));
            smEncCert.setKeySize(256);
            smEncCert.setCertUsage(Constants.CertType.ENCRYPTION.getValue());
            smCertList.add(smEncCert);
            summary.setSmCertList(smCertList);
            summary.setSupportSM(Boolean.valueOf(true));
        }
        logger.info((Object)"fulfil certificate succeed.");
        return true;
    }

    private String format(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    protected static String validateCertPriKey(CertificateContent cert) {
        if (VerifyUtil.isEmpty((String)cert.getPriKey())) {
            return "value of field 'cert.priKey' is not provided";
        }
        if (!ParamChecker.checkBase64((String)cert.getPriKey())) {
            return "value of field 'cert.priKey' is not correct";
        }
        return "";
    }

    @Override
    protected String validateCert(CertificateUpdateParam param) {
        return Optional.ofNullable(super.validateCert(param)).orElseGet(() -> this.validateAllCert(param));
    }

    private String validateAllCert(CertificateUpdateParam param) {
        StringBuilder msg = new StringBuilder();
        if (!VerifyUtil.isEmpty((Object)param.getCert())) {
            msg.append(ServerCertificateHandler.validateCertPriKey(param.getCert()));
        } else if (!VerifyUtil.isEmpty((Collection)param.getSmCerts())) {
            param.getSmCerts().forEach(smCert -> msg.append(ServerCertificateHandler.validateCertPriKey(smCert)));
        } else {
            return "no cert";
        }
        return msg.toString();
    }
}

