/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.AbstractProtectionRecoveryService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.DrmObjectSerializableUtil;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanCreateEventHandler;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

public abstract class AbstractRecoveryPlanService
extends AbstractProtectionRecoveryService
implements IRecoveryPlanService {
    private static final Log logger = LogFactory.getInstance(AbstractRecoveryPlanService.class);
    private static final long MAX_RECOVERY_PLAN_NUM = 2000L;
    private static final Object RECOVERY_PLAN_LOCK = new Object();
    private IBizScopeManager bizScopeManager;
    private List<IRecoveryPlanCreateEventHandler> recoveryPlanCreateEventHandlers = new ArrayList<IRecoveryPlanCreateEventHandler>();

    public IBizScopeManager getBizScopeManager() {
        return this.bizScopeManager;
    }

    public void setBizScopeManager(IBizScopeManager bizScopeManager) {
        this.bizScopeManager = bizScopeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRecoveryPlan(long userID, RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            logger.error((Object)"The parameter recoveryPlan is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String planId = UUIDGenerator.getUUID();
        recoveryPlan.setPlanStatus(DrmEnumDefine.RecoveryPlanStatusE.READY.getValue());
        recoveryPlan.setPlanId(planId);
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            return this.createRecoveryPlan(userID, recoveryPlan, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createMultiRecoveryPlan(long userID, RecoveryPlan recoveryPlan) {
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            String planId = UUIDGenerator.getUUID();
            recoveryPlan.setPlanStatus(DrmEnumDefine.RecoveryPlanStatusE.READY.getValue());
            recoveryPlan.setPlanId(planId);
            return this.createRecoveryPlan(userID, recoveryPlan, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRpBasicInfo(String planId, Integer planUse, String planName, String planDesc) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)planName)) {
            logger.error((Object)("The parameter is null. PlanId:" + planId + ",PlanName:" + planName), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            RecoveryPlan recoveryPlan;
            if (this.isExistedRecoveryPlanByName(planName, planId, planUse)) {
                logger.error((Object)("The plan name already exists. PlanName:" + planName + ",PlanId:" + planId), 90160758784001L);
                throw new LegoCheckedException(1073947392L);
            }
            if (this.isExistedRecoveryPlanById(planId)) {
                recoveryPlan = this.getRecoveryPlan(planId);
                if (null == recoveryPlan) {
                    logger.error((Object)("The recovery plan does not exist. PlanId:" + planId), 90160758784001L);
                    throw new LegoCheckedException(1073947394L);
                }
            } else {
                logger.error((Object)("The recovery plan does not exist. PlanId:" + planId + ",PlanName:" + planName), 90160758784001L);
                throw new LegoCheckedException(201L);
            }
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.MODIFY_BASIC_INFO);
            recoveryPlan.setName(planName);
            recoveryPlan.setDescription(planDesc);
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
        }
    }

    public void saveOrUpdateGlobalSettings(String planId, Map<String, Object> globalSettings) {
        if (VerifyUtil.isEmpty((String)planId) || null == globalSettings) {
            throw new LegoCheckedException(-1L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        this.saveOrUpdateGlobalSettings(recoveryPlan, globalSettings);
    }

    public void saveOrUpdateRecoveryPlan(RecoveryPlan recoveryPlan) {
        try {
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateGlobalSettings failed.", (long)-1L, null, (Log)logger);
        }
    }

    public void saveOrUpdateRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (!this.checkRecoverySettings(planId, settings)) {
            throw new LegoCheckedException(-1L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            logger.error((Object)("Recovery plan does not exist. PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            logger.error((Object)"IRecoveryProcessProvider is null!");
            throw new LegoCheckedException(1073947393L);
        }
        provider.checkRecoverySettings(settings);
        RecoveryServiceUtil.checkRecoveryOperationPrivilegeBySite(recoveryPlan, null);
        this.saveOrUpdateRecoverySettings(recoveryPlan, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecoveryPlan(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        logger.info((Object)"begin to delete recovery plan %s.", new Object[]{recoveryPlanId});
        Object object = RECOVERY_PLAN_LOCK;
        synchronized (object) {
            this.deleteRecoveryPlan(recoveryPlanId);
        }
        this.bizScopeManager.deleteScopeObject(recoveryPlanId);
        logger.info((Object)"delete recovery plan %s success.", new Object[]{recoveryPlanId});
    }

    public List<RecoveryPlan> getAllRecoveryPlan() {
        ArrayList<RecoveryPlan> recoveryPlans = new ArrayList();
        try {
            recoveryPlans = this.getBaseDao().getHibernateTemplate().find("from RecoveryPlan", new Object[0]);
            return recoveryPlans;
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery plans failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            return recoveryPlans;
        }
    }

    public List<RecoveryPlan> getAllRecoveryPlan(long userID) {
        logger.debug((Object)"getAllRecoveryPlan");
        List recoveryPlans = this.getAllRecoveryPlan();
        if (!VerifyUtil.isEmpty(recoveryPlans)) {
            recoveryPlans = ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).filterObject(Long.valueOf(userID), recoveryPlans);
        }
        return recoveryPlans;
    }

    public boolean isUsedProtectGroupByRp(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(pgId, false);
        if (null == protectGroup) {
            logger.error((Object)("ProtectGroup(" + pgId + ") not exist"));
            throw new LegoCheckedException(1073947394L);
        }
        String planId = this.getAssociatedRecoveryPlanWithProtectGroup(protectGroup.getUuid());
        return !VerifyUtil.isEmpty((String)planId);
    }

    public boolean isUsedProtectGroupByAllRp(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            String errMsg = "pgId is empty.[{0}]";
            logger.error((Object)MessageFormatUtil.format((String)errMsg, (Object[])new Object[]{pgId}));
            throw new LegoCheckedException(1073947393L, new String[]{pgId});
        }
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup protectGroup = pgService.getProtectGroupBasicInfo(pgId, false);
        if (null == protectGroup) {
            String errMsg = "ProtectGroup is not exist.[{0}]";
            logger.error((Object)MessageFormatUtil.format((String)errMsg, (Object[])new Object[]{pgId}));
            throw new LegoCheckedException(1073947394L, new String[]{pgId});
        }
        List<String> list = this.getAssociatedRecoveryPlanListWithProtectGroup(protectGroup.getUuid(), new ArrayList<Integer>());
        return !VerifyUtil.isEmpty(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecoverySetting> getRecoverySettings(String planId, String itemKey) {
        ArrayList<RecoverySetting> settings = new ArrayList<RecoverySetting>();
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHQL = "from RecoverySetting RS where RS.recoveryPlan.planId=:planId and RS.name=:itemKey";
            Query query = session.createQuery(queryHQL);
            query.setString("planId", planId);
            query.setString("itemKey", itemKey);
            List results = query.list();
            if (null != results && !results.isEmpty()) {
                for (Object result : results) {
                    settings.add((RecoverySetting)result);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Querying recovery settings failed. Id:" + planId + ",key:" + itemKey + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoverySetting getRecoverySetting(String planId, String ownerId, String itemKey) {
        RecoverySetting recoverySetting = null;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String queryHQL = "from RecoverySetting RS where RS.recoveryPlan.planId=:planId and RS.ownerId=:ownerId and RS.name=:itemKey";
            Query query = session.createQuery(queryHQL);
            query.setString("planId", planId);
            query.setString("ownerId", ownerId);
            query.setString("itemKey", itemKey);
            List results = query.list();
            if (null != results && 1 == results.size()) {
                recoverySetting = (RecoverySetting)results.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Querying recovery settings failed. Id:" + planId + ",key:" + itemKey + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return recoverySetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RecoveryProcessDefinition> getRecoveryProcesses(String recoveryPlanId, int procType) {
        Set<RecoveryProcessDefinition> processes;
        Session session = null;
        try {
            session = this.getHibernateSession();
            processes = this.getRecoveryProcesses(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType), session);
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery process failed. PlanId:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            processes = new HashSet<RecoveryProcessDefinition>();
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return processes;
    }

    public List<RecoveryProcessor> getRecoveryProcessors(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        RecoveryProcessDefinition rpDefinition;
        if (VerifyUtil.isEmpty((String)planId) || null == procType) {
            throw new LegoCheckedException(1073947393L);
        }
        Set<RecoveryProcessDefinition> rpDefinitions = this.getRecoveryProcesses(planId, procType.getValue());
        if (VerifyUtil.isEmpty(rpDefinitions)) {
            IRecoveryManager recoveryManager = (IRecoveryManager)ServiceLocator.getInstance().getService(IRecoveryManager.class);
            RecoveryPlan plan = this.getRecoveryPlanWithProcess(planId);
            rpDefinition = recoveryManager.createRecoveryProcessDefinition(plan, procType);
        } else {
            Iterator<RecoveryProcessDefinition> iterator = rpDefinitions.iterator();
            if (!iterator.hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            rpDefinition = iterator.next();
        }
        if (null == rpDefinition) {
            logger.error((Object)"The process definition does not exist.", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        List<RecoveryProcessor> sortedProcessors = RecoveryServiceUtil.sortRecoveryProcessors(rpDefinition.getRecoveryProcessors());
        ArrayList<RecoveryProcessor> processors = new ArrayList<RecoveryProcessor>();
        for (RecoveryProcessor processor : sortedProcessors) {
            RecoveryProcessor newProcessor = this.getRecoveryProcessor(processor);
            processors.add(newProcessor);
        }
        return processors;
    }

    private RecoveryProcessor getRecoveryProcessor(RecoveryProcessor processor) {
        RecoveryProcessor newProcessor = new RecoveryProcessor();
        newProcessor.setPlanId(processor.getPlanId());
        newProcessor.setProcId(processor.getProcId());
        newProcessor.setProcType(processor.getProcType());
        newProcessor.setIsEditable(processor.getIsEditable());
        newProcessor.setIsEnabled(processor.getIsEnabled());
        newProcessor.setIsPreset(processor.getIsPreset());
        processor.updateProcessName();
        processor.updateDescription();
        newProcessor.setProcName(processor.getProcName());
        newProcessor.setDescription(processor.getDescription());
        newProcessor.setProcessId(processor.getProcessId());
        return newProcessor;
    }

    public String getHostName(String hostId, Site site, ProtectGroup pg) {
        String hostName = "--";
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(hostId);
        if (null != drResource) {
            return drResource.getName();
        }
        DrResource cloudServer = (DrResource)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(DrResource.class, (Serializable)((Object)hostId));
        if (!VerifyUtil.isEmpty((Object)cloudServer)) {
            return cloudServer.getName();
        }
        return hostName;
    }

    public boolean checkNasRecoveryPlanInit() {
        return true;
    }

    public String getAssociatedRecoveryPlanWithProtectGroup(String protectGroupId) {
        ArrayList<Integer> planUseNotIn = new ArrayList<Integer>();
        planUseNotIn.add(RecoveryPlanUse.INTERNAL_USE.getValue());
        List<String> planIds = this.getAssociatedRecoveryPlanListWithProtectGroup(protectGroupId, planUseNotIn);
        if (VerifyUtil.isEmpty(planIds)) {
            return null;
        }
        return planIds.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAssociatedRecoveryPlanListWithProtectGroup(String protectGroupId, List<Integer> planUseNotIn) {
        Session session = null;
        try {
            List planIds;
            session = this.getHibernateSession();
            String querySQL = "select PLANID from ti_drp_r_pg where PGID=:pgId";
            if (!VerifyUtil.isEmpty(planUseNotIn)) {
                querySQL = "select r.PLANID from ti_drp_r_pg r left join ti_recoveryplan l  on r.PLANID = l.PLANID where r.PGID=:pgId";
                StringBuilder sb = new StringBuilder();
                sb.append(" and l.PLANUSE not in(");
                for (int i = 0; i < planUseNotIn.size(); ++i) {
                    sb.append(planUseNotIn.get(i));
                    if (i >= planUseNotIn.size() - 1) continue;
                    sb.append(", ");
                }
                sb.append(") ");
                querySQL = querySQL + sb.toString();
            }
            NativeQuery query = session.createSQLQuery(querySQL);
            query.setString("pgId", protectGroupId);
            List list = planIds = query.list();
            return list;
        }
        catch (Exception e) {
            logger.error((Object)("Getting recovery plan associated with pg failed. PgId:" + protectGroupId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return null;
    }

    public void setPoRepToRecoveryPlan(RecoveryPlan recoveryPlan) {
        logger.debug((Object)"setPoRepToRecoveryPlan");
        Set pgSet = recoveryPlan.getProtectGroups();
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        for (ProtectGroup pg : pgSet) {
            List queryProtectGroupReplicaByGroup = replicaService.queryProtectGroupReplicaByGroup(pg.getUuid(), "", true, null);
            pg.getReplicaList().clear();
            pg.getReplicaList().addAll(queryProtectGroupReplicaByGroup);
        }
    }

    protected Session getHibernateSession() {
        HibernateTemplate template = this.getBaseDao().getHibernateTemplate();
        Session session = template.getSessionFactory().openSession();
        return session;
    }

    protected boolean isNotZeroCountQueryResult(List<?> countQueryResult) {
        BigInteger count;
        Object obj;
        return null != countQueryResult && !countQueryResult.isEmpty() && (obj = countQueryResult.get(0)) instanceof BigInteger && 0 != (count = (BigInteger)obj).intValue();
    }

    protected void updatePoRecoveryStatus(Set<ProtectGroup> protectGroups, Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap, Session session) {
        if (VerifyUtil.isEmpty(protectGroups) || VerifyUtil.isEmpty(poRecoveryStatusMap) || null == session) {
            logger.debug((Object)"not need updatePoRecoveryStatus exit null param.");
            return;
        }
        String updateSQL = "UPDATE ti_protectobject SET PORECOVERYSTATUS=:poRecoveryStatus where POID in (:poIds)";
        HashMap<Integer, ArrayList<String>> groups = new HashMap<Integer, ArrayList<String>>();
        for (ProtectGroup protectGroup : protectGroups) {
            for (ProtectObject protectObject : protectGroup.getPolist()) {
                DrmEnumDefine.ProtectObjectRecoveryStatusE poRecoveryStatus = poRecoveryStatusMap.get(protectObject.getUuid());
                if (null == poRecoveryStatus) continue;
                ArrayList<String> group = (ArrayList<String>)groups.get(poRecoveryStatus.getValue());
                if (group == null) {
                    group = new ArrayList<String>();
                    groups.put(poRecoveryStatus.getValue(), group);
                }
                group.add(protectObject.getUuid());
            }
        }
        for (Map.Entry next : groups.entrySet()) {
            Integer poRecoveryStatus = (Integer)next.getKey();
            List poIds = (List)next.getValue();
            NativeQuery query = session.createSQLQuery(updateSQL);
            query.setInteger("poRecoveryStatus", poRecoveryStatus.intValue());
            query.setParameterList("poIds", (Collection)poIds);
            query.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveOrUpdateRecoveryLogs(List<RecoveryLog> recoveryLogs) {
        Session session = null;
        try {
            HibernateTemplate template = this.getBaseDao().getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            session.beginTransaction();
            for (RecoveryLog recoveryLog : recoveryLogs) {
                recoveryLog.setIsSynchronized(Boolean.valueOf(true));
                session.saveOrUpdate((Object)recoveryLog);
                for (RecoveryProcessorDetail detail : recoveryLog.getRecoveryProcessDetails()) {
                    session.saveOrUpdate((Object)detail);
                }
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Exception)e, (String)"Hibernate execute failed", (long)0x300001L, (String[])new String[0]);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    protected Set<RecoveryProcessDefinition> getRecoveryProcesses(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, Session session) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(planId, false, false);
        if (null == recoveryPlan) {
            logger.error((Object)("The recovery plan does not exist.PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        return this.getRecoveryProcesses(session, recoveryPlan, type);
    }

    public Set<RecoveryProcessDefinition> getRecoveryProcesses(Session session, RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        List recoveryProcesses;
        String planId = recoveryPlan.getPlanId();
        HashSet<RecoveryProcessDefinition> processes = new HashSet<RecoveryProcessDefinition>();
        ProtectGroup protectGroup = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == protectGroup) {
            logger.error((Object)("The protectGroup does not exist.PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        if (null == planId || null == session) {
            return processes;
        }
        String queryHQL = "from RecoveryProcessDefinition rproc where rproc.planId=:planId";
        if (null != type) {
            queryHQL = queryHQL + " and rproc.procType=:procType";
        }
        Query query = session.createQuery(queryHQL);
        query.setString("planId", planId);
        if (null != type) {
            query.setInteger("procType", type.getValue());
        }
        if (null != (recoveryProcesses = query.list()) && !recoveryProcesses.isEmpty()) {
            for (Object obj : recoveryProcesses) {
                RecoveryProcessDefinition rpDefinition = (RecoveryProcessDefinition)obj;
                Set<RecoveryProcessor> recoveryProcessors = AbstractRecoveryPlanService.getRecoveryProcessors(rpDefinition.getProcessId(), type, session);
                for (RecoveryProcessor processor : recoveryProcessors) {
                    processor.resetEnableStatus(protectGroup, type);
                }
                rpDefinition.setRecoveryProcessors(recoveryProcessors);
                processes.add(rpDefinition);
            }
        }
        return processes;
    }

    protected Set<RecoveryProcessDefinition> constructRecoveryProcessDefinitions(List<?> result) {
        HashSet<RecoveryProcessDefinition> rpDefinitions = new HashSet<RecoveryProcessDefinition>();
        for (Object object : result) {
            Object[] values;
            if (!(object instanceof Object[]) || (values = (Object[])object).length != 6) continue;
            RecoveryProcessDefinition rpDefinition = new RecoveryProcessDefinition();
            rpDefinition.setProcessId(CommUtil.convertToString((Object)values[0]));
            rpDefinition.setProcType(CommUtil.convertToInteger((Object)values[1]).intValue());
            rpDefinition.setAppType(CommUtil.convertToInteger((Object)values[2]).intValue());
            rpDefinition.setProtectionType(CommUtil.convertToInteger((Object)values[3]).intValue());
            rpDefinition.setPlanId(CommUtil.convertToString((Object)values[4]));
            rpDefinition.setDisasterSiteId(CommUtil.convertToString((Object)values[5]));
            rpDefinitions.add(rpDefinition);
        }
        return rpDefinitions;
    }

    protected static Set<RecoveryProcessor> getRecoveryProcessors(String processId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, Session session) {
        List recoveryProcessors;
        HashSet<RecoveryProcessor> processors = new HashSet<RecoveryProcessor>();
        if (null == processId || null == session) {
            return processors;
        }
        String queryHQL = "from RecoveryProcessor rProcessor where rProcessor.processId=:processId and rProcessor.parentProc is null";
        if (null != type) {
            queryHQL = queryHQL + " and rProcessor.procType=:procType";
        }
        Query query = session.createQuery(queryHQL);
        query.setString("processId", processId);
        if (null != type) {
            query.setInteger("procType", type.getValue());
        }
        if (null != (recoveryProcessors = query.list()) && !recoveryProcessors.isEmpty()) {
            for (Object obj : recoveryProcessors) {
                processors.add((RecoveryProcessor)obj);
            }
        }
        return processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isRecoveryPlanExisted(String planId) {
        Session session;
        boolean isExsited;
        block4: {
            isExsited = false;
            session = null;
            try {
                String querySQL = "select count(*) from ti_recoveryplan where planid=:planId";
                session = this.getHibernateSession();
                NativeQuery query = session.createSQLQuery(querySQL);
                query.setString("planId", planId);
                List results = query.list();
                if (null == results || results.isEmpty()) break block4;
                isExsited = true;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Querying recovery plan failed. Id:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return isExsited;
    }

    private boolean checkRecoverySettings(String planId, List<RecoverySetting> settings) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty(settings)) {
            return false;
        }
        for (RecoverySetting setting : settings) {
            RecoveryPlan plan = setting.getRecoveryPlan();
            if (null != plan && null != plan.getPlanId() && plan.getPlanId().equals(planId)) continue;
            return false;
        }
        return true;
    }

    private void deleteRecoveryPlan(String recoveryPlanId) {
        long startA = System.currentTimeMillis();
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(recoveryPlanId, false, false);
        if (null == recoveryPlan) {
            logger.error((Object)("The recovery plan does not exist.PlanId:" + recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        long startB = System.currentTimeMillis();
        logger.info((Object)"getRecoveryPlan cost time:%s", new Object[]{String.valueOf(startB - startA)});
        this.deleteRecoveryPlan(recoveryPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExistedRecoveryPlanById(String recoveryPlanId) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExist = false;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySQL = "select PLANID from ti_recoveryplan where PLANID=:planId";
            NativeQuery query = session.createSQLQuery(querySQL);
            query.setString("planId", recoveryPlanId);
            List recoveryPlans = query.list();
            if (null != recoveryPlans && !recoveryPlans.isEmpty()) {
                isExist = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Checking whether the recovery plan existed failed. PlanId:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRecoveryPlan(RecoveryPlan recoveryPlan) {
        Session session = null;
        try {
            session = this.getHibernateSession();
            session.beginTransaction();
            String deleteDetailSql = "delete from ti_recoveryprocessordetail where logid in (select logid from ti_recoverylog where planid=:planid)";
            NativeQuery sqlQuery = session.createSQLQuery(deleteDetailSql);
            sqlQuery.setString("planid", recoveryPlan.getPlanId());
            long startA = System.currentTimeMillis();
            sqlQuery.executeUpdate();
            long startB = System.currentTimeMillis();
            session.delete((Object)recoveryPlan);
            long startC = System.currentTimeMillis();
            session.getTransaction().commit();
            long startD = System.currentTimeMillis();
            logger.info((Object)("delete detail cost time:" + (startB - startA) + ", delete cost time:" + (startC - startB) + ", commit cost time:" + (startD - startC)));
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e, (String)("Deleting recovery plan failed. Id:" + recoveryPlan.getPlanId()), (long)1073948688L, null, (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExistedAssociatedRecoveryPlan(Set<ProtectGroup> protectGroups) {
        if (VerifyUtil.isEmpty(protectGroups)) {
            logger.error((Object)"The parameter is invalid.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isExisted = false;
        Session session = null;
        try {
            session = this.getHibernateSession();
            String querySQL = "select a.PLANID from ti_drp_r_pg a left join ti_recoveryplan b on a.PLANID=b.PLANID where a.PGID=:pgId and b.PLANUSE !=" + RecoveryPlanUse.INTERNAL_USE.getValue();
            for (ProtectGroup protectGroup : protectGroups) {
                NativeQuery query = session.createSQLQuery(querySQL);
                query.setString("pgId", protectGroup.getUuid());
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results)) continue;
                isExisted = true;
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Getting associated recovery plan failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return isExisted;
    }

    private void checkRecoveryPlanForCreate(RecoveryPlan recoveryPlan, boolean supportMultiPlan) {
        this.checkParameterValidityForCreate(recoveryPlan);
        Integer planUse = recoveryPlan.getUse();
        if (VerifyUtil.isEmpty((Object)planUse)) {
            planUse = RecoveryPlanUse.PUBLIC_USE.getValue();
        }
        if (this.isExistedRecoveryPlanByName(recoveryPlan.getName(), planUse)) {
            logger.error((Object)("The plan name already exists. PlanName:" + recoveryPlan.getName()), 90160758784001L);
            String productSiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
            ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
            Site productSite = siteService.getSiteById(productSiteId);
            List localSites = siteService.getAllLocalSites();
            boolean isProductLocal = localSites.contains(productSite);
            Set<String> disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan);
            boolean isDisasterLocal = RecoveryServiceUtil.isExistLocalRecoverySite(disasterSiteIds);
            if (isProductLocal && !isDisasterLocal) {
                throw new LegoCheckedException(1073948725L);
            }
            if (!isProductLocal && isDisasterLocal) {
                throw new LegoCheckedException(1073948726L);
            }
            throw new LegoCheckedException(1073947392L);
        }
        if (!supportMultiPlan && this.isExistedAssociatedRecoveryPlan(recoveryPlan.getProtectGroups())) {
            logger.error((Object)("The associated recovery plan already exists. PlanName:" + recoveryPlan.getName()), 90160758784001L);
            throw new LegoCheckedException(1073948694L);
        }
        this.checkRecoveryPlanNumLimit(recoveryPlan);
    }

    private String createRecoveryPlan(long userID, RecoveryPlan recoveryPlan, boolean isNeedSyncCreate) {
        return this.createRecoveryPlan(userID, recoveryPlan, isNeedSyncCreate, false);
    }

    /*
     * Exception decompiling
     */
    private String createRecoveryPlan(long userID, RecoveryPlan recoveryPlan, boolean isNeedSyncCreate, boolean supportMultiPlan) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Session createRecoveryPlanMainMethod(RecoveryPlan recoveryPlan, boolean isNeedSyncCreate) {
        Set processes = null;
        if (isNeedSyncCreate) {
            processes = RecoveryServiceUtil.getInitRecoveryProcessDefinitions(recoveryPlan);
            recoveryPlan.setProcessesSerialMsg(DrmObjectSerializableUtil.serializableObj(processes));
        } else {
            String planSerialMsg = recoveryPlan.getProcessesSerialMsg();
            processes = DrmObjectSerializableUtil.reverseeObj(planSerialMsg, Set.class);
        }
        recoveryPlan.setRecoveryProcesses(processes);
        if (VerifyUtil.isEmpty((Object)recoveryPlan.getCreateTime())) {
            recoveryPlan.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        }
        Session session = this.getHibernateSession();
        session.beginTransaction();
        session.save((Object)recoveryPlan);
        this.updatePoRecoveryStatus((Set<ProtectGroup>)recoveryPlan.getProtectGroups(), DrmEnumDefine.ProtectObjectRecoveryStatusE.NOT_STARTED, session);
        if (this.recoveryPlanCreateEventHandlers != null) {
            for (IRecoveryPlanCreateEventHandler handler : this.recoveryPlanCreateEventHandlers) {
                HibernateUtil.execute(() -> handler.handle(recoveryPlan), session);
            }
        }
        session.save((Object)recoveryPlan);
        session.getTransaction().commit();
        return session;
    }

    private void resetRecoveryPlanGlobalSetting(RecoveryPlan recoveryPlan, Map<String, Object> settings) {
        HashMap<String, String> globalSetting = recoveryPlan.getGlobalSettings();
        if (VerifyUtil.isEmpty(settings)) {
            globalSetting = new HashMap<String, String>();
            recoveryPlan.setGlobalSettings(globalSetting);
            return;
        }
        Set<Map.Entry<String, Object>> entrySet = settings.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            globalSetting.put(key, String.valueOf(value));
        }
    }

    private void resetRecoveryPlanSettings(RecoveryPlan recoveryPlan, List<RecoverySetting> settings) {
        if (VerifyUtil.isEmpty(settings)) {
            return;
        }
        Set preSettings = recoveryPlan.getRecoverySettings();
        for (RecoverySetting setting : settings) {
            boolean isExisted = false;
            for (RecoverySetting preSetting : preSettings) {
                if (!setting.getRecoveryPlan().getPlanId().equals(preSetting.getRecoveryPlan().getPlanId()) || !setting.getOwnerId().equals(preSetting.getOwnerId()) || !setting.getName().equals(preSetting.getName())) continue;
                preSetting.setValue(setting.getValue());
                isExisted = true;
            }
            if (isExisted) continue;
            preSettings.add(setting);
        }
    }

    private void checkRecoveryPlanNumLimit(RecoveryPlan recoveryPlan) {
        int count = this.getValidRecoveryPlanNum();
        if ((long)count < 2000L) {
            return;
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == pg) {
            throw new LegoCheckedException(1073947393L);
        }
        String productSiteId = pg.getProductSiteId();
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List localSites = siteService.getAllLocalSites();
        Site productSite = siteService.getSiteById(productSiteId);
        boolean isProductLocal = localSites.contains(productSite);
        long errorCode = 1073948715L;
        if (isProductLocal) {
            errorCode = 1073948714L;
        }
        throw new LegoCheckedException(errorCode, new String[]{String.valueOf(2000L)});
    }

    private void checkParameterValidityForCreate(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((String)recoveryPlan.getName()) || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        IProtectGroupService protectGroupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup persistentPG = protectGroupService.getProtectGroupByID(protectGroup.getUuid(), false);
        if (persistentPG.isInvalid()) {
            logger.error((Object)("Protect Group has been invalid. Id:" + protectGroup.getUuid()), 90160758784001L);
            throw new LegoCheckedException(1073948693L);
        }
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(persistentPG);
        if (null == provider) {
            logger.error((Object)("There is no matched provider. Id:" + protectGroup.getUuid()), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        boolean isMatched = provider.isSuitableProtectGroup(DrmEnumDefine.RecoveryPlanTypeE.getType((int)recoveryPlan.getPlanType()), persistentPG);
        if (!isMatched) {
            logger.error((Object)("Protect Group is not matched for the specified plan type. Id:" + protectGroup.getUuid() + ",PlanType:" + recoveryPlan.getPlanType()), 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getValidRecoveryPlanNum() {
        Session session;
        int count;
        block4: {
            count = 0;
            session = null;
            try {
                Object obj;
                String querySQL = "select count(*) from ti_recoveryplan where PLANSTATUS != -1 and PLANUSE = 0 ";
                session = this.getHibernateSession();
                NativeQuery query = session.createSQLQuery(querySQL);
                List recoveryPlans = query.list();
                if (null == recoveryPlans || recoveryPlans.isEmpty() || !((obj = recoveryPlans.get(0)) instanceof BigInteger)) break block4;
                count = ((BigInteger)obj).intValue();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Checking back recovery task count failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveOrUpdateRecoverySettings(RecoveryPlan recoveryPlan, List<RecoverySetting> settings) {
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING);
        this.resetRecoveryPlanSettings(recoveryPlan, settings);
        Session session = null;
        try {
            session = this.getHibernateSession();
            session.beginTransaction();
            for (RecoverySetting recoverySetting : recoveryPlan.getRecoverySettings()) {
                session.saveOrUpdate((Object)recoverySetting);
            }
            session.getTransaction().commit();
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateRecoverySettings failed.", (long)-1L, null, (Log)logger);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
    }

    private void saveOrUpdateGlobalSettings(RecoveryPlan recoveryPlan, Map<String, Object> globalSettings) {
        RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.MOIFY_RECOVERY_SETTING);
        this.resetRecoveryPlanGlobalSetting(recoveryPlan, globalSettings);
        try {
            this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateGlobalSettings failed.", (long)-1L, null, (Log)logger);
        }
    }

    private void updatePoRecoveryStatus(Set<ProtectGroup> protectGroups, DrmEnumDefine.ProtectObjectRecoveryStatusE poRecoveryStatus, Session session) {
        String updateSQL = "UPDATE ti_protectobject SET PORECOVERYSTATUS=:poRecoveryStatus where PGID=:pgId";
        for (ProtectGroup pg : protectGroups) {
            NativeQuery query = session.createSQLQuery(updateSQL);
            query.setInteger("poRecoveryStatus", poRecoveryStatus.getValue());
            query.setString("pgId", pg.getUuid());
            query.executeUpdate();
        }
    }
}

