/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanObserverManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.process.RecoveryPreCheckerManager;
import com.huawei.ism.drm.recovery.framework.process.RecoveryPreProcessorManager;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTask;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTaskExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.task.ReprotectCallBackExcuteRecoveryTask;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.base.util.KeyLocker;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Service(name="com.huawei.ism.drm.drp.sdk.service.IRecoveryManager", desc="", interfaceClass=IRecoveryManager.class)
public class RecoveryManager
extends BaseService
implements IRecoveryManager {
    private static final Log logger = LogFactory.getInstance(RecoveryManager.class);
    private static final String URL_TEST = "/ws/recoveryplans/{planId}/action/test";
    private static final String URL_TESTCLEANUP = "/ws/recoveryplans/{planId}/action/testCleanup";
    private static final String URL_PLANEDMIGRATION = "/ws/recoveryplans/{planId}/action/plannedMigration";
    private static final String URL_HOTMIGRATION = "/ws/recoveryplans/{planId}/action/hotMigration";
    private static final String URL_REPROTECT = "/ws/recoveryplans/{planId}/action/reprotect";
    private static final String URL_ACTION_CONTINUE = "/ws/recoveryplans/{planId}/action/{actionType}/continue";
    private static final String SEPARATOR = ":";
    private static final KeyLocker CREATE_TASK_LOCKER = new KeyLocker(RecoveryManager.class, "CREATE_TASK_LOCK");
    private static final Set<DrmEnumDefine.RecoveryPlanExecuteTypeE> CHECK_AZ_REGION_EXECUTE_TYPE_SET = ImmutableSet.of((Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION, (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT, (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, (Object)DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING, (Object[])new DrmEnumDefine.RecoveryPlanExecuteTypeE[0]);
    private IRecoveryPlanService recoveryPlanService;

    public IRecoveryPlanService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public void setRecoveryPlanService(IRecoveryPlanService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDisasterRecovery(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            this.checkParameters(recoveryPlanId, recoveryContext, operator);
            RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
            IRecoveryProcessProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
            ProtectGroup pg = recoveryPlan.getProtectGroup();
            this.checkMatchAz2Region(recoveryContext, pg, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
            Map settings = provider.checkRecoveryContext(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, recoveryContext, operator);
            String newDisasterSiteId = null;
            Object disasterSiteValue = settings.get("DISASTER_SITE_ID");
            if (disasterSiteValue != null) {
                newDisasterSiteId = String.valueOf(disasterSiteValue);
            }
            RecoveryServiceUtil.checkRecoveryOperationPrivilegeBySite(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, newDisasterSiteId);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY);
            this.dealGlobalSettings(recoveryPlan);
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            this.checkInstanceStatusAndHoldVm(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    public void startPlanedMotion(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.migration(recoveryPlanId, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, URL_PLANEDMIGRATION);
    }

    private void migration(String recoveryPlanId, Map<String, String> recoveryContext, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType, String urlMigration) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        this.dealGlobalSettings(recoveryPlan);
        this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, excuteType);
    }

    public void continuePlannedMigration(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        this.dealGlobalSettings(recoveryPlan);
        Boolean isContinue = Boolean.parseBoolean(recoveryContext.get("recovery_continue_key"));
        this.handleRecoveryContinue(recoveryPlan, isContinue, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
    }

    public void startHotMigration(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.migration(recoveryPlanId, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION, URL_HOTMIGRATION);
    }

    private IRecoveryProcessProvider getRecoveryProcessProvider(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            throw new LegoCheckedException(201L);
        }
        this.checkIfProtectObjectExisted(recoveryPlan);
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            throw new LegoCheckedException(1073947393L);
        }
        return provider;
    }

    private void dealGlobalSettings(RecoveryPlan recoveryPlan) {
        Map globalSettings = recoveryPlan.getGlobalSettings();
        if (globalSettings.containsKey("RECOVERY_EXTEND_ATTRIBUTES")) {
            globalSettings.put("RECOVERY_EXTEND_ATTRIBUTES", "-1");
        }
        globalSettings.remove("REPLICA_ID");
    }

    public void startRecoveryDrilling(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        this.dealGlobalSettings(recoveryPlan);
        this.prepareSuffixType(recoveryPlanId, recoveryContext, "Drilling");
        if (!recoveryContext.containsKey("recovery_region_id")) {
            IRecoveryProcessProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
            String recoverySiteId = provider.getRecoverySiteId(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, recoveryContext);
            Site recoverySite = RecoveryServiceUtil.getRecoverySite(recoverySiteId);
            recoveryContext.put("recovery_region_id", recoverySite.getRegionId());
        }
        this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
    }

    public void cleanRecoveryDrilling(String recoveryPlanId, User operator, Map<String, String> recoveryContext) {
        this.checkParameters(recoveryPlanId, operator);
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(recoveryPlanId);
        this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING);
    }

    private RecoveryPlan getRecoveryPlan(String recoveryPlanId) {
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        if (recoveryPlan == null) {
            throw new LegoCheckedException(201L);
        }
        this.checkIfProtectObjectExisted(recoveryPlan);
        return recoveryPlan;
    }

    public void reprotectRecoveryPlan(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        if (recoveryPlan == null) {
            throw new LegoCheckedException(201L);
        }
        RecoveryServiceUtil.checkReprotectOperationPrivilege(recoveryPlan);
        this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryContinue(RecoveryPlan recoveryPlan, Boolean isContinue, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE executeType) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            this.checkRecoveryPlanPaused(recoveryPlan);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.getType((int)executeType.getValue()));
            RecoveryProcessDefinition rpDefinition = recoveryPlan.getRecoveryProcess(executeType);
            if (rpDefinition == null) {
                logger.error((Object)"rpDefinition is null.");
                throw new LegoCheckedException(1073947393L);
            }
            HashMap<String, String> recoveryContext = new HashMap<String, String>();
            recoveryContext.put("IS_CONTINUE_PROCESS", isContinue.toString());
            this.submitRecoveryBackTask(recoveryPlan, rpDefinition, operator, recoveryContext);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryOperation(RecoveryPlan recoveryPlan, Map<String, String> recoveryContext, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        this.checkMatchAz2Region(recoveryContext, pg, execType);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
            if (provider == null) {
                logger.error((Object)"provider is null. RecoveryPlanId is %s .", new Object[]{recoveryPlanId});
                return;
            }
            HashMap<String, Object> settings = new HashMap<String, String>();
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)execType)) {
                settings.putAll(recoveryContext);
            } else {
                settings = provider.checkRecoveryContext(recoveryPlanId, execType, recoveryContext, operator);
            }
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.getType((int)execType.getValue()));
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            this.checkInstanceStatusAndHoldVm(recoveryPlan, execType);
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, execType);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, recoveryContext);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    private void checkMatchAz2Region(Map<String, String> recoveryContext, ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (!CHECK_AZ_REGION_EXECUTE_TYPE_SET.contains(execType)) {
            return;
        }
        String pgRegionId = (String)pg.getProps().get("regionId");
        if (!VerifyUtil.isEmpty((String)pgRegionId) && pgRegionId.contains(SEPARATOR)) {
            pgRegionId = pgRegionId.split(SEPARATOR)[1];
        }
        String azId = recoveryContext.get("az_id");
        String regionId = recoveryContext.get("region_id");
        String pgazId = (String)pg.getProps().get("zoneName");
        if (!(VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)pgRegionId) || regionId.equals(pgRegionId))) {
            logger.error((Object)"Region or az message error, regionId: %s, pgRegionId: %s.", new Object[]{regionId, pgRegionId});
            throw new LegoCheckedException(1073949727L);
        }
        if (!(VerifyUtil.isEmpty((String)azId) || VerifyUtil.isEmpty((String)pgazId) || azId.equals(pgazId))) {
            logger.error((Object)"Region or az message error, azId: %s, pgazId: %s.", new Object[]{azId, pgazId});
            throw new LegoCheckedException(1073949727L);
        }
    }

    protected void checkRecoveryPlanExecuting(String recoveryPlanId) {
        if (RecoveryBackTask.RUN_TASK_LOCKER.isLocked(recoveryPlanId)) {
            logger.error((Object)String.format(Locale.ROOT, "The recovery plan is executing. PlanId: %s", recoveryPlanId), 90160758784001L);
            String objectType = Optional.ofNullable(this.recoveryPlanService.queryRecoveryPlan(recoveryPlanId, false, true)).map(RecoveryPlan::getObjectType).orElse(ServiceInstaceEnumDefine.ObjectType.ECS_BMS.getValue());
            if (ServiceInstaceEnumDefine.ObjectType.NAS.getValue().equals(objectType)) {
                throw new LegoCheckedException(1073947490L);
            }
            throw new LegoCheckedException(1073948750L);
        }
    }

    private void checkRecoveryPlanPaused(RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue() != recoveryPlan.getPlanStatus()) {
            String msg = String.format(Locale.ROOT, "The recovery plan is not paused. PlanId: %s", recoveryPlan.getPlanId());
            logger.error((Object)msg);
            throw new LegoCheckedException(msg);
        }
    }

    protected void tryLockRecoveryPlan(String recoveryPlanId) {
        if (!CREATE_TASK_LOCKER.tryLock(recoveryPlanId)) {
            logger.error((Object)String.format(Locale.ROOT, "The recovery plan is executing. PlanId: %s", recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(1073948750L);
        }
    }

    protected void unLockRecoveryPlan(String recoveryPlanId) {
        CREATE_TASK_LOCKER.unlock(recoveryPlanId);
    }

    protected RecoveryPlan updateRecoveryPlanSetting(RecoveryPlan recoveryPlan, Map<String, Object> settings) {
        if (recoveryPlan == null || settings == null || settings.isEmpty()) {
            return recoveryPlan;
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId(recoveryPlan);
        settings.put("PRODUCT_SITE_ID", productSiteId);
        HashSet<RecoverySetting> recoverySettings = recoveryPlan.getRecoverySettings();
        if (null == recoverySettings) {
            recoverySettings = new HashSet<RecoverySetting>();
            recoveryPlan.setRecoverySettings(recoverySettings);
        }
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String disasterSiteId = String.valueOf(settings.get("DISASTER_SITE_ID"));
        Set<Map.Entry<String, Object>> settingsEntrySet = settings.entrySet();
        for (Map.Entry<String, Object> entry : settingsEntrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Map)) {
                globalSettings.put(key, String.valueOf(value));
                continue;
            }
            Map subSettingsMap = (Map)value;
            Set subEntrySet = subSettingsMap.entrySet();
            for (Map.Entry subEntry : subEntrySet) {
                Object subKey = subEntry.getKey();
                Object subValue = subEntry.getValue();
                RecoverySetting recoverySetting = new RecoverySetting();
                recoverySetting.setRecoveryPlan(recoveryPlan);
                recoverySetting.setDisasterSiteId(disasterSiteId);
                recoverySetting.setOwnerId(String.valueOf(subKey));
                recoverySetting.setName(key);
                recoverySetting.setValue(String.valueOf(subValue));
                RecoveryServiceUtil.resetRecoverySetting(recoverySettings, recoverySetting);
            }
        }
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
        return recoveryPlan;
    }

    protected void checkParameters(String recoveryPlanId, User operator) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || VerifyUtil.isEmpty((Object)operator) || VerifyUtil.isEmpty((String)operator.getUserName())) {
            logger.error((Object)"Invalid parameter.", 90160758786876L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkParameters(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || recoveryContext == null || VerifyUtil.isEmpty((Object)operator) || VerifyUtil.isEmpty((String)operator.getUserName())) {
            logger.error((Object)"Invalid parameter.", 90160758786876L);
        }
    }

    protected synchronized void submitRecoveryBackTask(RecoveryPlan plan, RecoveryProcessDefinition rpDefinition, User operator, Map<String, String> recoveryContext) {
        if (plan == null) {
            logger.error((Object)"plan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (rpDefinition == null) {
            logger.error((Object)"rpDefinition is null.");
            throw new LegoCheckedException(1073947393L);
        }
        this.recoveryPlanService.checkBackendRecoveryTaskCount(plan);
        DrmEnumDefine.RecoveryPlanExecuteTypeE rpExecuteType = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)rpDefinition.getProcType());
        Map<String, Object> initialContextData = this.getInitialContextData(plan, rpExecuteType);
        initialContextData.put("RecoveryProcessDefinition", rpDefinition);
        this.setSuffixTypeToContextData(recoveryContext, initialContextData);
        this.setIsConfirmReprotectionToContextData(recoveryContext, initialContextData);
        this.setContinueTagToContextData(recoveryContext, initialContextData);
        RecoveryBackTask recoveryBackTask = new RecoveryBackTask();
        recoveryBackTask.setInitialContextData(initialContextData);
        recoveryBackTask.setRecoveryPlan(plan);
        recoveryBackTask.setRecoveryPlanExecuteType(rpExecuteType);
        recoveryBackTask.setOperator(operator);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)rpExecuteType)) {
            ReprotectCallBackExcuteRecoveryTask callBackTask = new ReprotectCallBackExcuteRecoveryTask();
            recoveryBackTask.setCallBaskTask(callBackTask);
        }
        RecoveryProcessSerialExecutor recoveryTemplate = this.getRecoveryTemplate(rpDefinition, rpExecuteType);
        recoveryBackTask.setRecoveryProcessTemplate(recoveryTemplate);
        if (!ServiceInstaceEnumDefine.ObjectType.NAS.getValue().equals(plan.getObjectType())) {
            RecoveryPreCheckerManager.getInstance().check(plan, rpExecuteType);
            Map<String, Object> preProcessResults = RecoveryPreProcessorManager.getInstance().process(plan, rpExecuteType);
            recoveryBackTask.setPreProcessResults(preProcessResults);
        }
        logger.info((Object)"Begin submit recovery task. Plan name:%s,id: %s, status:%s, task type:%s", new Object[]{plan.getName(), plan.getPlanId(), plan.getPlanStatus(), rpExecuteType});
        RecoveryBackTaskExecutor.submitRecoveryBackTask(recoveryBackTask);
    }

    private void setIsConfirmReprotectionToContextData(Map<String, String> recoveryContext, Map<String, Object> initialContextData) {
        if (VerifyUtil.isEmpty(recoveryContext) || !recoveryContext.containsKey("is_confirm_reprotection")) {
            return;
        }
        initialContextData.put("IS_CONFIRM_REPROTECTION", recoveryContext.get("is_confirm_reprotection"));
    }

    private void setContinueTagToContextData(Map<String, String> recoveryContext, Map<String, Object> initialContextData) {
        if (VerifyUtil.isEmpty(recoveryContext) || !recoveryContext.containsKey("IS_CONTINUE_PROCESS")) {
            return;
        }
        initialContextData.put("IS_CONTINUE_PROCESS", recoveryContext.get("IS_CONTINUE_PROCESS"));
    }

    protected void setSuffixTypeToContextData(Map<String, String> recoveryContext, Map<String, Object> initialContextData) {
        if (VerifyUtil.isEmpty(recoveryContext) || !recoveryContext.containsKey("NameSuffixKey")) {
            logger.info((Object)"context is empty.");
            return;
        }
        String suffix = recoveryContext.get("NameSuffixKey");
        logger.info((Object)"name suffix key: %s.", new Object[]{suffix});
        initialContextData.put("NameSuffixKey", suffix);
    }

    protected void prepareSuffixType(String recoveryPlanId, Map<String, String> recoveryContext, String initSuffix) {
        logger.info((Object)"prepare initial suffix.");
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(recoveryPlanId, true, false);
        if (recoveryPlan == null) {
            logger.error((Object)"recovery plan is null, id: %s.", new Object[]{recoveryPlanId});
            throw new LegoCheckedException(201L);
        }
        String suffix = initSuffix + "_" + recoveryPlan.getName();
        logger.info((Object)"name suffix in params: %s.", new Object[]{suffix});
        recoveryContext.put("NameSuffixKey", suffix);
    }

    protected RecoveryProcessSerialExecutor getRecoveryTemplate(RecoveryProcessDefinition rpDefinition, DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType) {
        if (rpDefinition == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Set processors = rpDefinition.getRecoveryProcessors();
        List<? extends IProcessor> sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation(processors);
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(sortedProcessors, recoveryPlanExecuteType);
        if (executor == null) {
            logger.error((Object)"Creating recovery process executor failed.", 90160758784001L);
            throw new LegoCheckedException(0x300001L);
        }
        return executor;
    }

    protected RecoveryProcessDefinition getRecoveryProcessDef(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        IRecoveryProcessProvider provider;
        RecoveryProcessDefinition rpDefinition = recoveryPlan.getRecoveryProcess(execType);
        if (rpDefinition == null || this.doUpgradeForAutoPlanMotion(recoveryPlan, execType, rpDefinition)) {
            rpDefinition = this.createRecoveryProcessDefinition(recoveryPlan, execType);
        }
        if ((provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan)) == null) {
            throw new LegoCheckedException(1073947393L);
        }
        provider.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, true);
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        if (protectGroup == null) {
            logger.error((Object)("The protectGroup does not exist.PlanId:" + recoveryPlan.getPlanId()), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.resetEnableStatus(protectGroup, execType);
        }
        return rpDefinition;
    }

    public RecoveryProcessDefinition createRecoveryProcessDefinition(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType(recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"recoveryPlanId is %s .", new Object[]{recoveryPlan.getPlanId()});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        RecoveryProcessDefinition rpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, execType, protectGroup);
        HashSet<RecoveryProcessDefinition> recoveryProcesses = recoveryPlan.getRecoveryProcesses();
        if (recoveryProcesses == null) {
            recoveryProcesses = new HashSet<RecoveryProcessDefinition>();
            recoveryPlan.setRecoveryProcesses(recoveryProcesses);
        }
        recoveryProcesses.add(rpDefinition);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
        return rpDefinition;
    }

    protected void checkIfProtectObjectExisted(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList protectObjects = new ArrayList();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) continue;
            protectObjects.addAll(protectGroup.getPolist());
        }
        if (protectObjects.isEmpty()) {
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected Map<String, Object> getInitialContextData(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE rpExecuteType) {
        ProtectGroupReplica replica;
        HashMap<String, Object> initialContextData = new HashMap<String, Object>();
        String disasterSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
        String replicaId = (String)plan.getGlobalSettings().get("REPLICA_ID");
        if (VerifyUtil.isEmpty((Collection)plan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = plan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        if (ServiceInstaceEnumDefine.ObjectType.NAS.getValue().equals(plan.getObjectType())) {
            initialContextData.put("Recovery_ProtectGroup", protectGroup);
        }
        if ((replica = RecoveryProcessUtil.getProtectGroupReplicaByReplicaId(protectGroup, replicaId)) == null) {
            replica = RecoveryProcessUtil.getProtectGroupReplicaBySiteId(protectGroup, disasterSiteId);
        }
        if (replica == null) {
            logger.error((Object)"getReplica failed:%s ,pg:%s .", new Object[]{replicaId, protectGroup.getName()});
            return initialContextData;
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        replica = replicaService.queryProtectGroupReplicaById(replica.getId());
        logger.info((Object)"Initial context data, PlanId:%s, SiteId:%s, ReplicaId:%s, Replica:%s", new Object[]{plan.getPlanId(), disasterSiteId, replicaId, replica});
        Set<ProtectObject> protectObjects = RecoveryProcessUtil.getRecoveryProtectObjects(protectGroup, replica, rpExecuteType);
        initialContextData.put("Recovery_ProtectObjects", protectObjects);
        initialContextData.put("Recovery_ProtectGroup", protectGroup);
        initialContextData.put("Recovery_PgReplica", replica);
        return initialContextData;
    }

    private void checkInstanceStatusAndHoldVm(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        MessageEvent event = new MessageEvent();
        HashMap<String, DrmEnumDefine.RecoveryPlanExecuteTypeE> messageMap = new HashMap<String, DrmEnumDefine.RecoveryPlanExecuteTypeE>();
        messageMap.put("message_event_excute_type", type);
        event.setMessageMap(messageMap);
        event.setMessageType(7);
        ArrayList<RecoveryPlan> objectList = new ArrayList<RecoveryPlan>();
        objectList.add(recoveryPlan);
        event.setObjectList(objectList);
        IRecoveryPlanObserverManager observerManager = (IRecoveryPlanObserverManager)ServiceLocator.getInstance().getService(IRecoveryPlanObserverManager.class);
        observerManager.notifyObserverList(event, "before");
    }

    public boolean doUpgradeForAutoPlanMotion(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, RecoveryProcessDefinition rpDefinition) {
        logger.info((Object)"doUpgradeForAutoPlanMotion: recoveryPlan %s, execType %s", new Object[]{recoveryPlan.getName(), execType.getValue()});
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        if (!Arrays.asList(34, 22, 21).contains(protectGroup.getTemplate().getType())) {
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != execType.getValue()) {
            return false;
        }
        Set set = rpDefinition.getRecoveryProcessors().stream().filter(processor -> processor.getProcName().contains("OpenStackReverseStorageRepDirectionProcessor")).collect(Collectors.toSet());
        if (!set.isEmpty()) {
            logger.info((Object)"no need refactPlanMotionProcessDefinition: %s", new Object[]{recoveryPlan.getName()});
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue() == recoveryPlan.getPlanStatus()) {
            logger.info((Object)"%s is PLANED_MOTION_FAILED, need refact definition.", new Object[]{recoveryPlan.getName()});
            this.refactPlanMotionProcessDefinition(recoveryPlan, rpDefinition, protectGroup);
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.READY.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue() == recoveryPlan.getPlanStatus()) {
            logger.info((Object)"recoveryPlan(%s), status(%s), need refact definition.", new Object[]{recoveryPlan.getName(), recoveryPlan.getPlanStatus()});
            recoveryPlan.getRecoveryProcesses().remove(rpDefinition);
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.deleteRecoveryProcessDefinition(rpDefinition);
            return true;
        }
        return false;
    }

    private void refactPlanMotionProcessDefinition(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, ProtectGroup protectGroup) {
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType(recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        if (provider == null) {
            logger.error((Object)"Can not find suitable provider");
            throw new LegoCheckedException(2117645L);
        }
        RecoveryProcessDefinition reprotectedRpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT, protectGroup);
        List<RecoveryProcessor> reProcessors = RecoveryServiceUtil.sortRecoveryProcessors(reprotectedRpDefinition.getRecoveryProcessors());
        ArrayList<Class<? extends RecoveryProcessor>> procClsList = new ArrayList<Class<? extends RecoveryProcessor>>();
        for (int ix = 3; ix < reProcessors.size(); ++ix) {
            procClsList.add(reProcessors.get(ix).getClass());
        }
        this.refactRecoveryProcessors(recoveryPlan, rpDefinition, procClsList);
    }

    private void refactRecoveryProcessors(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, List<Class<? extends RecoveryProcessor>> procClsList) {
        RecoveryProcessor lastProcessor = RecoveryServiceUtil.getLastRecoveryProcessor(rpDefinition.getRecoveryProcessors());
        if (lastProcessor == null || VerifyUtil.isEmpty(procClsList)) {
            logger.error((Object)"refact processDefinition error. Can not find the last processor .");
            return;
        }
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        logger.info((Object)"recoveryPlan(%s), need delete definition %s.", new Object[]{recoveryPlan.getName(), rpDefinition.getName()});
        Set recoveryProcesses = recoveryPlan.getRecoveryProcesses();
        recoveryProcesses.remove(rpDefinition);
        recoveryProcessService.deleteRecoveryProcessDefinition(rpDefinition);
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            logger.error((Object)"Can not find suitable provider");
            throw new LegoCheckedException(2117645L);
        }
        provider.insertRecoveryProcessors(rpDefinition, lastProcessor.getPreviousProcessor().getClass(), procClsList, true, false);
        provider.deleteRecoveryProcessors(rpDefinition, lastProcessor.getProcId(), false);
        for (RecoveryProcessor pro : rpDefinition.getRecoveryProcessors()) {
            pro.setProcessId(rpDefinition.getProcessId());
            pro.setPlanId(recoveryPlan.getPlanId());
            if (!procClsList.contains(pro.getClass())) continue;
            pro.setIsPreset(Boolean.valueOf(true));
            pro.setIsEditable(Boolean.valueOf(false));
        }
        recoveryProcesses.add(rpDefinition);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
    }
}

