/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.dao.HibernateUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.service.impl.RecoveryPlanServiceImpl;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class RecoveryProcessServiceImpl
implements IRecoveryProcessService {
    private static final Log logger = LogFactory.getInstance(RecoveryProcessServiceImpl.class);
    private static Map<Integer, Integer> statusMapping = new HashMap<Integer, Integer>();
    private IRecoveryPlanService recoveryPlanService;
    private IMoDao moDao;
    private Scheduler quartzScheduler;

    public void setRecoveryPlanService(IRecoveryPlanService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    public IRecoveryPlanService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public IMoDao getMoDao() {
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public void initialize() {
        List recoveryPlans = this.recoveryPlanService.getAllRecoveryPlan();
        if (VerifyUtil.isEmpty((Collection)recoveryPlans)) {
            return;
        }
        for (RecoveryPlan recoveryPlan : recoveryPlans) {
            Integer status;
            DrmEnumDefine.RecoveryPlanStatusE curPlanStatus = DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus());
            this.changePlanStatusToFailed(recoveryPlan, curPlanStatus);
            if (null != recoveryPlan.getUse() && recoveryPlan.getUse().intValue() == RecoveryPlanUse.INTERNAL_USE.getValue() && null != (status = statusMapping.get(recoveryPlan.getPlanStatus()))) {
                recoveryPlan.setPlanStatus(status.intValue());
            }
            this.updateRecoveryPlan(recoveryPlan);
            RecoveryLog recoveryLog = this.recoveryPlanService.getLatestRecoveryLog(recoveryPlan.getPlanId());
            if (recoveryLog != null && !this.bothArePaused(recoveryPlan, recoveryLog)) {
                logger.info((Object)"Set RecoveryLog Failed planId:%s, planStatus:%s, logId:%s, change before logStatus:%s", new Object[]{recoveryPlan.getPlanId(), recoveryPlan.getPlanStatus(), recoveryLog.getLogId(), recoveryLog.getLogStatus()});
                if (recoveryPlan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue()) {
                    recoveryPlan.setPlanStatus(DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue());
                    this.updateRecoveryPlan(recoveryPlan);
                }
                this.updateRecoveryLog(recoveryLog.getLogId(), DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue(), String.valueOf(new Date().getTime()));
                this.synchronizedDelVmRecoveryProcessDetailFailed(recoveryLog.getLogId());
            }
            this.updateRecoveryProcessDetail();
        }
        try {
            this.quartzScheduler = StdSchedulerFactory.getDefaultScheduler();
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            logger.error((Object)"start quartz failed", (Throwable)e, 90160758784001L);
            return;
        }
    }

    private boolean bothArePaused(RecoveryPlan recoveryPlan, RecoveryLog recoveryLog) {
        return recoveryLog.getLogStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED.getValue() && recoveryPlan.getPlanStatus() == DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue();
    }

    private void synchronizedDelVmRecoveryProcessDetailFailed(String recoveryLog) {
        Optional<RecoveryProcessorDetail> recoveryProcessDetail = this.getDelVmRecoveryProcessDetailByLogId(recoveryLog);
        recoveryProcessDetail.ifPresent(detail -> {
            logger.info((Object)"Set RecoveryProcessDetail Failed, detailId:%s", new Object[]{detail.getDetailId()});
            detail.setProcessDetail("lego.err.1073947452");
            detail.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.RUNNING.getValue());
            this.updateRecoveryProcessDetail((RecoveryProcessorDetail)detail);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRecoveryLog(RecoveryLog recoveryLog, RecoveryProcessDefinition processes) {
        if (null == recoveryLog || null == processes || VerifyUtil.isEmpty((Collection)processes.getRecoveryProcessors())) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return null;
        }
        String recoveryLogId = null;
        Session session = null;
        try {
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            recoveryLog.setLogId(UUIDGenerator.getUUID());
            session.beginTransaction();
            session.save((Object)recoveryLog);
            this.createRecoveryProcessDetails(processes, recoveryLog.getLogId(), session);
            session.getTransaction().commit();
            recoveryLogId = recoveryLog.getLogId();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("Creating recovery log failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return recoveryLogId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryLog queryRecoveryLog(RecoveryLog param) {
        Session session = null;
        RecoveryLog log = null;
        try {
            String hql = "FROM RecoveryLog log WHERE log.logStatus=? AND log.planId=? AND log.recoverySiteId=? AND log.productionSiteId=? AND log.logType=?";
            if (VerifyUtil.isEmpty((String)param.getRecoverySiteId())) {
                hql = "FROM RecoveryLog log WHERE log.logStatus=? AND log.planId=? AND log.productionSiteId=? AND log.logType=?";
            }
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            Query query = session.createQuery(hql, RecoveryLog.class);
            this.buildQueryLogParam(param, (Query<RecoveryLog>)query);
            List list = query.list();
            if (list.size() != 1) {
                throw new LegoCheckedException(String.format(Locale.ROOT, "RecoveryLog records size is %s.", list.size()));
            }
            log = (RecoveryLog)list.get(0);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"query RecoveryLog[planId:%s] log failed:%s .", new Object[]{param.getPlanId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return log;
    }

    private void buildQueryLogParam(RecoveryLog param, Query<RecoveryLog> query) {
        query.setParameter(0, (Object)param.getLogStatus());
        query.setParameter(1, (Object)param.getPlanId());
        if (VerifyUtil.isEmpty((String)param.getRecoverySiteId())) {
            query.setParameter(2, (Object)param.getProductionSiteId());
            query.setParameter(3, (Object)param.getLogType());
        } else {
            query.setParameter(2, (Object)param.getRecoverySiteId());
            query.setParameter(3, (Object)param.getProductionSiteId());
            query.setParameter(4, (Object)param.getLogType());
        }
    }

    public String createRecoveryProcessDetail(RecoveryProcessorDetail recoveryProcessDetail, boolean isUpdate) {
        if (null == recoveryProcessDetail) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return null;
        }
        String recoveryProcId = null;
        try {
            HibernateTemplate hibernateTpl = this.moDao.getHibernateTemplate();
            if (isUpdate) {
                hibernateTpl.update((Object)recoveryProcessDetail);
            } else {
                hibernateTpl.save((Object)recoveryProcessDetail);
            }
            recoveryProcId = recoveryProcessDetail.getDetailId();
        }
        catch (Exception e) {
            logger.error((Object)("Creating process detail failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return recoveryProcId;
    }

    public boolean deleteRecoveryProcessor(String procId) {
        if (VerifyUtil.isEmpty((String)procId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return false;
        }
        boolean isSuccess = true;
        try {
            RecoveryProcessor recoveryProcessor = this.getRecoveryProcess(procId);
            this.deleteRecoveryProcessor(recoveryProcessor);
        }
        catch (Exception e) {
            logger.error((Object)"deleteRecoveryProcessor failed.");
            isSuccess = false;
        }
        return isSuccess;
    }

    public void deleteRecoveryProcessor(RecoveryProcessor recoveryProcessor) {
        if (VerifyUtil.isEmpty((Object)recoveryProcessor)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            this.moDao.getHibernateTemplate().delete((Object)recoveryProcessor);
            logger.debug((Object)this.recordDeletedRecoveryProcess(recoveryProcessor), 90160758784000L);
        }
        catch (Exception e) {
            String errorMsg = "Delete recovery process failed. ProcId:" + recoveryProcessor.getProcId() + ",Name:" + recoveryProcessor.getName();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryPlan(String recoveryPlanId, int planStatus, DrmEnumDefine.RecoveryPlanExecuteTypeE planExecuteType, Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap, Integer planProgress, int processStatus) {
        boolean updateResult = false;
        if (!this.checkParametersForUpdate(recoveryPlanId, planStatus, planExecuteType, planProgress)) {
            return updateResult;
        }
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlan(recoveryPlanId, false, false);
        if (null == recoveryPlan) {
            logger.error((Object)("The recovery plan does not exist. Id:" + recoveryPlanId), 90160758784001L);
            return updateResult;
        }
        try {
            recoveryPlan.setLastExecuteType(planExecuteType.getValue());
            recoveryPlan.setPlanStatus(planStatus);
            recoveryPlan.setProcessStatus(processStatus);
            if (null != planProgress) {
                recoveryPlan.setPlanProgress(planProgress.intValue());
            }
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.equals((Object)planExecuteType)) {
                recoveryPlan.setLastTestStatus(planStatus);
                String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
                recoveryPlan.getGlobalSettings().put(disasterSiteId + "_TestResult", String.valueOf(planStatus));
                String hostOrGroupId = RecoveryServiceUtil.getDisasterHostSN(recoveryPlan);
                if (!VerifyUtil.isEmpty((String)hostOrGroupId)) {
                    recoveryPlan.getGlobalSettings().put(hostOrGroupId + "_TestResult", String.valueOf(planStatus));
                }
            }
            logger.info((Object)"Update recovery plan status. Plan name: %s, Id:%s, Status:%s,Execute type: %s, Progress: %s", new Object[]{recoveryPlan.getName(), recoveryPlan.getPlanId(), planStatus, planExecuteType, planProgress});
            Session session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                session.beginTransaction();
                session.saveOrUpdate((Object)recoveryPlan);
                RecoveryPlanServiceImpl planServiceImpl = (RecoveryPlanServiceImpl)this.recoveryPlanService;
                planServiceImpl.updatePoRecoveryStatus(recoveryPlan.getProtectGroups(), poRecoveryStatusMap, session);
                session.getTransaction().commit();
            }
            catch (Exception e) {
                try {
                    DBOperationUtil.rollbackSession(session);
                    ExceptionUtil.rethrowException((Throwable)e, (String)"saveOrUpdateRecoverySettings failed.", (long)-1L, null, (Log)logger);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
            DBOperationUtil.closeSession(session);
            updateResult = true;
        }
        catch (Exception e) {
            logger.error((Object)("Updating recovery plan failed. Id:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryPlanProgress(String recoveryPlanId, int progressRatio) {
        int planProgress;
        NativeQuery query;
        Session session;
        boolean updateResult;
        block9: {
            List results;
            block8: {
                updateResult = false;
                if (VerifyUtil.isEmpty((String)recoveryPlanId) || 0 > progressRatio || 100 < progressRatio) {
                    logger.error((Object)("The parameter is invalid. Id:" + recoveryPlanId + ",ProgressRatio:" + progressRatio), 90160758784001L);
                    return updateResult;
                }
                session = null;
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                String querySQL = "select PLANPROGRESS from ti_recoveryplan where PLANID=:recoveryPlanId";
                query = session.createSQLQuery(querySQL);
                query.setString("recoveryPlanId", recoveryPlanId);
                results = query.list();
                if (!VerifyUtil.isEmpty((Collection)results)) break block8;
                logger.error((Object)("The recovery plan does not exist. Id:" + recoveryPlanId), 90160758784001L);
                boolean bl = updateResult;
                DBOperationUtil.closeSession(session);
                return bl;
            }
            planProgress = (Integer)results.get(0);
            if (0 >= planProgress) {
                planProgress = 0;
            }
            if (100 > (planProgress += progressRatio)) break block9;
            logger.warn((Object)("The progress is extend 100. PlanId:" + recoveryPlanId + ", planProgress: " + planProgress + ",progressRatio: " + progressRatio));
            boolean bl = true;
            DBOperationUtil.closeSession(session);
            return bl;
        }
        try {
            String updateSQL = "update ti_recoveryplan set PLANPROGRESS=:planProgress where PLANID=:recoveryPlanId";
            query = session.createSQLQuery(updateSQL);
            query.setInteger("planProgress", planProgress);
            query.setString("recoveryPlanId", recoveryPlanId);
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
            updateResult = true;
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("Updating recovery plan progress failed. Id:" + recoveryPlanId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryProcessorDetail getRecoveryProcessDetail(String logId, String procId) {
        Session session;
        RecoveryProcessorDetail detail;
        block5: {
            if (VerifyUtil.isEmpty((String)logId) || VerifyUtil.isEmpty((String)procId)) {
                logger.error((Object)"The parameter is null.", 90160758784001L);
                return null;
            }
            detail = null;
            session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                String queryHQL = "from RecoveryProcessorDetail where parentDetailId=null and logId=:logId and procId=:procId";
                Query query = session.createQuery(queryHQL);
                query.setString("logId", logId);
                query.setString("procId", procId);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) break block5;
                detail = (RecoveryProcessorDetail)results.get(0);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting recovery process detail failed. LogId:" + logId + ",ProcId:" + procId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return detail;
    }

    public boolean updateRecoveryPlan(RecoveryPlan recoveryPlan) {
        boolean updateResult = false;
        if (null == recoveryPlan) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return updateResult;
        }
        try {
            ProtectGroup protectGroup = (ProtectGroup)recoveryPlan.getProtectGroups().iterator().next();
            if (30 == protectGroup.getTemplate().getType() && RecoveryPlanUse.PUBLIC_USE.getValue() == recoveryPlan.getUse().intValue()) {
                recoveryPlan.setPlanType(DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue());
            }
            this.moDao.getHibernateTemplate().saveOrUpdate((Object)recoveryPlan);
            updateResult = true;
        }
        catch (Exception e) {
            logger.error((Object)("Updating recovery plan failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return updateResult;
    }

    public boolean saveOrUpdateRecoveryProcessDetail(RecoveryProcessorDetail processDetail) {
        boolean updateResult = false;
        if (null == processDetail) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return updateResult;
        }
        try {
            this.moDao.getHibernateTemplate().saveOrUpdate((Object)processDetail);
            updateResult = true;
        }
        catch (Exception e) {
            logger.error((Object)("Updating recovery process detail failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryProcessDetail(RecoveryProcessorDetail processDetail) {
        boolean updateResult = false;
        if (null == processDetail || null == processDetail.getDetailId()) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return updateResult;
        }
        Session session = null;
        try {
            StringBuilder updateSQL = new StringBuilder();
            updateSQL.append("update ti_recoveryprocessordetail set PROCESSSTATUS=:processStatus, ENDTIME=:endTime");
            updateSQL.append(", PROCESSDETAIL=:processDetail, PROCESSDETAILPARAMS=:processDetailParams");
            updateSQL.append(", ISSKIPPED=:isSkipped");
            if (null != processDetail.getProcessName()) {
                updateSQL.append(", PROCESSNAME=:processName");
            }
            if (null != processDetail.getProcessNameParams()) {
                updateSQL.append(", PROCESSNAMEPARAMS=:processNameParams");
            }
            updateSQL.append(" where DETAILID=:detailId");
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(updateSQL.toString());
            query.setInteger("processStatus", processDetail.getProcessStatus());
            query.setString("endTime", processDetail.getEndTime());
            query.setString("processDetail", processDetail.getProcessDetail());
            query.setString("processDetailParams", processDetail.getProcessDetailParams());
            query.setBoolean("isSkipped", processDetail.getIsSkipped().booleanValue());
            if (null != processDetail.getProcessName()) {
                query.setString("processName", processDetail.getProcessName());
            }
            if (null != processDetail.getProcessNameParams()) {
                query.setString("processNameParams", processDetail.getProcessNameParams());
            }
            query.setString("detailId", processDetail.getDetailId());
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
            updateResult = true;
            DBOperationUtil.closeSession(session);
        }
        catch (Exception e) {
            DBOperationUtil.rollbackSession(session);
            logger.error((Object)("Updating recovery process detail failed. Id:" + processDetail.getDetailId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        finally {
            DBOperationUtil.closeSession(session);
        }
        return updateResult;
    }

    public boolean updateRecoveryProcessDetail(String procDetailId, int procDetailStatus, String procEndTime, String procDetail, String procDetailParams) {
        if (VerifyUtil.isEmpty((String)procDetailId) || null == DrmEnumDefine.RecoveryPlanExecuteResultE.getType((int)procDetailStatus) || VerifyUtil.isEmpty((String)procEndTime)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return false;
        }
        RecoveryProcessorDetail processDetail = new RecoveryProcessorDetail();
        processDetail.setDetailId(procDetailId);
        processDetail.setProcessStatus(procDetailStatus);
        processDetail.setEndTime(procEndTime);
        processDetail.setProcessDetail(procDetail);
        processDetail.setProcessDetailParams(procDetailParams);
        return this.updateRecoveryProcessDetail(processDetail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryProcessor(RecoveryProcessor recoveryProcess) {
        boolean updateResult = false;
        if (null == recoveryProcess) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return updateResult;
        }
        Session session = null;
        try {
            if (!VerifyUtil.isEmpty((String)recoveryProcess.getProcId()) && recoveryProcess.getIsNeedSave().booleanValue()) {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                session.beginTransaction();
                session.saveOrUpdate((Object)recoveryProcess);
                session.getTransaction().commit();
            }
            updateResult = true;
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("Updating recovery process failed. " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return updateResult;
    }

    public void updateRecoveryProcessDefinition(RecoveryProcessDefinition rpDefinition) {
        Session session = HibernateUtil.getSession();
        if (session != null) {
            session.saveOrUpdate((Object)rpDefinition);
        } else {
            this.moDao.getHibernateTemplate().saveOrUpdate((Object)rpDefinition);
        }
    }

    public boolean deleteRecoveryProcessDefinition(RecoveryProcessDefinition rpDefinition) {
        boolean isSuccess = false;
        if (VerifyUtil.isEmpty((Object)rpDefinition)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            this.moDao.getHibernateTemplate().delete((Object)rpDefinition);
            isSuccess = true;
        }
        catch (Exception e) {
            String errorMsg = "Delete rpDefinition failed. Plan id:" + rpDefinition.getPlanId() + ",Id:" + rpDefinition.getProcessId();
            ExceptionUtil.rethrowException((Throwable)e, (String)errorMsg, (long)-1L, (String[])new String[0], (Log)logger);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRecoveryLog(String recoveryLogId, int logStatus, String endTime) {
        boolean updateResult = false;
        if (VerifyUtil.isEmpty((String)recoveryLogId) || null == DrmEnumDefine.RecoveryPlanExecuteResultE.getType((int)logStatus) || VerifyUtil.isEmpty((String)endTime)) {
            logger.error((Object)("The parameter is null. logId:" + recoveryLogId + ",LogStatus:" + logStatus + ",EndTime:" + endTime), 90160758784001L);
            return updateResult;
        }
        Session session = null;
        try {
            String updateSQL = "update ti_recoverylog set LOGSTATUS=:logStatus, ENDTIME=:endTime where LOGID=:logId";
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query = session.createSQLQuery(updateSQL);
            query.setInteger("logStatus", logStatus);
            query.setString("endTime", endTime);
            query.setString("logId", recoveryLogId);
            session.beginTransaction();
            query.executeUpdate();
            session.getTransaction().commit();
            updateResult = true;
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("Updating recovery log failed. Id:" + recoveryLogId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecoveryProcessor> getRecoveryProcessors(String planId, List<QueryCondition> conditions, Class<? extends RecoveryProcessor> cls) {
        RecoveryProcessDefinition rpDefinition;
        Session session;
        List<Object> recoveryProcessors;
        block6: {
            recoveryProcessors = new ArrayList<RecoveryProcessor>();
            if (VerifyUtil.isEmpty((String)planId)) {
                logger.error((Object)"The parameter is null.", 90160758784001L);
                return recoveryProcessors;
            }
            session = null;
            rpDefinition = this.getRecoveryProcessDefinition(planId, conditions);
            if (null != rpDefinition) break block6;
            ArrayList<RecoveryProcessor> arrayList = recoveryProcessors;
            DBOperationUtil.closeSession(session);
            return arrayList;
        }
        try {
            HibernateTemplate template = this.moDao.getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            recoveryProcessors = session.createCriteria(cls).add((Criterion)Restrictions.eq((String)"processId", (Object)rpDefinition.getProcessId())).list();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Getting recovery processes failed. PlanId:" + planId + ",ClassName:" + cls.getSimpleName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return recoveryProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryProcessDefinition getRecoveryProcessDefinition(String planId, List<QueryCondition> conditions) {
        Session session;
        RecoveryProcessDefinition rpDefinition;
        block6: {
            if (null == planId || VerifyUtil.isEmpty(conditions)) {
                return null;
            }
            rpDefinition = null;
            session = null;
            try {
                HibernateTemplate template = this.moDao.getHibernateTemplate();
                session = template.getSessionFactory().openSession();
                List criterionList = this.moDao.translatePropsToCriterions(conditions);
                Criteria criteria = session.createCriteria(RecoveryProcessDefinition.class);
                criteria.add((Criterion)Restrictions.eq((String)"planId", (Object)planId));
                for (Criterion criterion : criterionList) {
                    criteria.add(criterion);
                }
                criteria.add((Criterion)Restrictions.eq((String)"planId", (Object)planId));
                List results = criteria.list();
                if (VerifyUtil.isEmpty((Collection)results) || results.size() != 1) break block6;
                rpDefinition = (RecoveryProcessDefinition)results.get(0);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting recovery process definition failed. PlanId:" + planId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return rpDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSubRecoveryProcessor(String procId) {
        if (VerifyUtil.isEmpty((String)procId)) {
            logger.error((Object)"The parameter is null.", 90160758784001L);
            return false;
        }
        RecoveryProcessor recoveryProcess = this.getRecoveryProcess(procId);
        boolean isSuccess = true;
        if (null == recoveryProcess) {
            logger.error((Object)("The recovery process does not exist. ProcId:" + procId), 90160758784001L);
            return isSuccess;
        }
        Session session = null;
        try {
            HibernateTemplate template = this.moDao.getHibernateTemplate();
            session = template.getSessionFactory().openSession();
            ArrayList<String> logMessages = new ArrayList<String>();
            session.beginTransaction();
            this.deleteSubProcess(session, recoveryProcess, logMessages);
            session.getTransaction().commit();
            for (String logMessage : logMessages) {
                logger.debug((Object)logMessage, 90160758784000L);
            }
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("Delete sub recovery process failed. ProcId:" + procId), 90160758784001L);
                isSuccess = false;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return isSuccess;
    }

    private void createRecoveryProcessDetails(RecoveryProcessDefinition processes, String logId, Session session) {
        List<RecoveryProcessor> sortedProcesses = RecoveryServiceUtil.sortRecoveryProcessors(processes.getRecoveryProcessors());
        for (RecoveryProcessor process : sortedProcesses) {
            if (!process.getIsEnabled().booleanValue()) continue;
            process.updateProcessName();
            RecoveryProcessorDetail newDetail = new RecoveryProcessorDetail();
            newDetail.setDetailId(UUIDGenerator.getUUID());
            newDetail.setProcessName(process.getProcName());
            newDetail.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            newDetail.setProcId(process.getProcId());
            newDetail.setLogId(logId);
            RecoveryProcessor preProcessor = RecoveryProcessUtil.getValidPreviousProcessor(process);
            RecoveryProcessor nextProcessor = RecoveryProcessUtil.getValidNextProcessor(process);
            String previousProcId = null != preProcessor ? preProcessor.getProcId() : null;
            String nextProcId = null != nextProcessor ? nextProcessor.getProcId() : null;
            newDetail.setPreviousProcId(previousProcId);
            newDetail.setNextProcId(nextProcId);
            session.save((Object)newDetail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryProcessor getRecoveryProcess(String procId) {
        Session session;
        RecoveryProcessor recoveryProcess;
        block4: {
            recoveryProcess = null;
            session = null;
            try {
                HibernateTemplate template = this.moDao.getHibernateTemplate();
                session = template.getSessionFactory().openSession();
                String queryHQL = "from RecoveryProcessor rp where rp.procId=:procId";
                Query query = session.createQuery(queryHQL);
                query.setString("procId", procId);
                List recoveryProcesses = query.list();
                if (null == recoveryProcesses || recoveryProcesses.isEmpty()) break block4;
                recoveryProcess = (RecoveryProcessor)recoveryProcesses.get(0);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting recovery process failed. Id:" + procId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return recoveryProcess;
    }

    private void deleteSubProcess(Session session, RecoveryProcessor recoveryProcess, List<String> logMessages) {
        if (null != recoveryProcess.getChildProc() && !recoveryProcess.getChildProc().isEmpty()) {
            for (RecoveryProcessor subProcess : recoveryProcess.getChildProc()) {
                session.delete((Object)subProcess);
                String logMsg = this.recordDeletedRecoveryProcess(subProcess);
                logMessages.add(logMsg);
            }
        }
    }

    private String recordDeletedRecoveryProcess(RecoveryProcessor recoveryProcess) {
        StringBuilder builder = new StringBuilder();
        builder.append("The process is deleted. ProcName:");
        builder.append(recoveryProcess.getProcName());
        builder.append(",ProcType:");
        builder.append(recoveryProcess.getProcType());
        builder.append(",ProcId:");
        builder.append(recoveryProcess.getProcId());
        builder.append(",PlanId:");
        builder.append(recoveryProcess.getPlanId());
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecoveryProcessDetail() {
        Session session = null;
        try {
            String updateSQL1 = "update ti_recoveryprocessordetail set PROCESSNAMEPARAMS=:procNameParams ";
            updateSQL1 = updateSQL1 + "where PROCESSSTATUS=3 and (PROCESSNAMEPARAMS is null or PROCESSNAMEPARAMS='')";
            String updateSQL2 = "update ti_recoveryprocessordetail set PROCESSSTATUS=1 ,PROCESSDETAIL=:detail where PROCESSSTATUS=3";
            session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery query1 = session.createSQLQuery(updateSQL1);
            NativeQuery query2 = session.createSQLQuery(updateSQL2);
            String[] strArray = new String[6];
            for (int i = 0; i < strArray.length; ++i) {
                strArray[i] = "--";
            }
            query1.setString("procNameParams", RecoveryProcessUtil.constructParamsString(strArray));
            query2.setString("detail", "lego.err.1073947452");
            session.beginTransaction();
            query1.executeUpdate();
            query2.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)("Updating recovery process detail failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    private boolean checkParametersForUpdate(String recoveryPlanId, int planStatus, DrmEnumDefine.RecoveryPlanExecuteTypeE planExecuteType, Integer planProgress) {
        boolean isValidPlanProgress = false;
        if (null == planProgress || 0 <= planProgress && 100 >= planProgress) {
            isValidPlanProgress = true;
        }
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || !isValidPlanProgress || null == DrmEnumDefine.RecoveryPlanStatusE.getType((int)planStatus) || null == planExecuteType) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            return false;
        }
        return true;
    }

    private void changePlanStatusToFailed(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanStatusE curPlanStatus) {
        Integer targetStatus = curPlanStatus.getFailStatusWhenRunning();
        if (null != targetStatus) {
            recoveryPlan.setPlanStatus(targetStatus.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<RecoveryProcessorDetail> getDelVmRecoveryProcessDetailByLogId(String recoveryLogId) {
        Session session;
        RecoveryProcessorDetail detail;
        block5: {
            if (VerifyUtil.isEmpty((String)recoveryLogId)) {
                logger.error((Object)"The parameter is null.", 90160758784001L);
                return Optional.empty();
            }
            detail = null;
            session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                String queryHQL = "FROM RecoveryProcessorDetail where logId=:logId and PROCESSSTATUS=:processStatus";
                Query query = session.createQuery(queryHQL);
                query.setString("logId", recoveryLogId);
                query.setInteger("processStatus", DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED.getValue());
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) break block5;
                detail = (RecoveryProcessorDetail)results.get(0);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)String.format(Locale.ROOT, "Getting delVm recovery process detail failed. LogId:%s,errorMessage: %s", recoveryLogId, ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return Optional.ofNullable(detail);
    }

    static {
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING.getValue(), DrmEnumDefine.RecoveryPlanStatusE.MOUNTING_REPLICA.getValue());
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING.getValue(), DrmEnumDefine.RecoveryPlanStatusE.UMOUNTING_REPLICA.getValue());
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.MOUNT_FAILED.getValue());
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.MOUNT_COMPLETED.getValue());
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_COMPLETED.getValue());
        statusMapping.put(DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED.getValue(), DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_FAILED.getValue());
    }
}

