/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.Query;

public class RecoveryResourceServiceImpl
implements IRecoveryResourceService {
    private static final Log logger = LogFactory.getInstance(RecoveryResourceServiceImpl.class);
    private IMoDao moDao;

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public IMoDao getMoDao() {
        return this.moDao;
    }

    public Site getStorageRegisteredSite(String deviceSN) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        DrResource drResource = resourceService.getDrResourceBySn(deviceSN);
        if (drResource == null) {
            logger.error((Object)("The device does not exist. DevSN:" + deviceSN), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        return siteService.getSiteById(drResource.getSiteId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrResource getDrResourceByID(String hostOrGroupId) {
        Session session;
        DrResource drResource;
        block4: {
            drResource = null;
            session = null;
            try {
                session = this.moDao.getHibernateTemplate().getSessionFactory().openSession();
                String queryHQL = "from DrResource where deviceSn=:deviceSn";
                Query query = session.createQuery(queryHQL);
                query.setString("deviceSn", hostOrGroupId);
                List results = query.list();
                if (VerifyUtil.isEmpty((Collection)results) || 1 != results.size()) break block4;
                drResource = (DrResource)results.get(0);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Getting drresource failed. Id:" + hostOrGroupId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return drResource;
    }

    public <T extends ManagedObject> List<T> queryMoList(Class<T> clz, Map<String, Object> queryCondition) {
        if (VerifyUtil.isEmpty(clz)) {
            throw new LegoCheckedException(1073947393L);
        }
        return CommonDAOLocator.getMoDao().findMoBy(clz, queryCondition);
    }
}

