/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public final class RecoveryServiceUtil {
    private static final Log logger = LogFactory.getInstance(RecoveryServiceUtil.class);
    private static final int LOG_DETAIL_LIMIT = 64;

    private RecoveryServiceUtil() {
    }

    public static void checkOperationPrivilegeBySite(RecoveryPlan recoveryPlan) {
        boolean isLocalRecoverySite;
        Set<String> disasterSiteIds;
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)("recoveryPlan: " + recoveryPlan.getPlanId()), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        String productSiteId = ((ProtectGroup)iterator.next()).getProductSiteId();
        Site productSite = siteService.getSiteById(productSiteId);
        List localSites = siteService.getAllLocalSites();
        if (localSites.contains(productSite) && !VerifyUtil.isEmpty(disasterSiteIds = RecoveryServiceUtil.getDisasterSiteIds(recoveryPlan)) && 1 == disasterSiteIds.size() && !(isLocalRecoverySite = RecoveryServiceUtil.isExistLocalRecoverySite(disasterSiteIds))) {
            throw new LegoCheckedException(1073948711L);
        }
    }

    public static void checkReprotectOperationPrivilege(RecoveryPlan recoveryPlan) {
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            return;
        }
        provider.checkIfAllowReprotect(recoveryPlan);
    }

    public static void checkRecoveryOperationPrivilegeBySite(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType) {
        RecoveryServiceUtil.checkOperationPrivilegeBySite(recoveryPlan);
        String curDisasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        if (VerifyUtil.isEmpty((String)curDisasterSiteId)) {
            logger.info((Object)"curDisasterSiteId is null: %s", new Object[]{recoveryPlan.getName()});
            return;
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site curDisasterSite = siteService.getSiteById(curDisasterSiteId);
        if (null == curDisasterSite) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.READY.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() == recoveryPlan.getPlanStatus()) {
            return;
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue() == recoveryPlan.getPlanStatus() && (null == procType || DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == procType.getValue())) {
            return;
        }
    }

    public static void checkRecoveryOperationPrivilegeBySite(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String newDisasterSiteId) {
        RecoveryServiceUtil.checkOperationPrivilegeBySite(recoveryPlan);
        logger.debug((Object)("recoveryPlan is: " + recoveryPlan.getName()));
    }

    public static List<RecoveryProcessorDetail> sortRecoveryProcessorDetails(List<RecoveryProcessorDetail> details) {
        ArrayList<RecoveryProcessorDetail> sortedDetails = new ArrayList<RecoveryProcessorDetail>();
        if (VerifyUtil.isEmpty(details)) {
            logger.debug((Object)"details is null");
            return sortedDetails;
        }
        boolean containsEndProcessor = details.stream().anyMatch(detail -> detail.getProcessName().contains("EndRecoveryProcessor") || detail.getProcessName().contains("ism.drm.planedmotion.end.process.name"));
        RecoveryProcessorDetail firstDetail = RecoveryServiceUtil.getFirstRecoveryProcessorDetail(details, containsEndProcessor);
        if (null == firstDetail) {
            return details;
        }
        sortedDetails.add(firstDetail);
        while (null != firstDetail && !VerifyUtil.isEmpty((String)firstDetail.getNextProcId())) {
            String nextProcId = firstDetail.getNextProcId();
            firstDetail = null;
            for (RecoveryProcessorDetail detail2 : details) {
                if (!VerifyUtil.isEmpty((String)detail2.getParentDetailId()) && !containsEndProcessor || !detail2.getProcId().equals(nextProcId)) continue;
                firstDetail = detail2;
                RecoveryServiceUtil.limitLogDetailSize(firstDetail);
                sortedDetails.add(firstDetail);
            }
        }
        if (sortedDetails.size() != details.size()) {
            return details;
        }
        return sortedDetails;
    }

    private static void limitLogDetailSize(RecoveryProcessorDetail detail) {
        if (VerifyUtil.isEmpty((Object)detail) || VerifyUtil.isEmpty((Collection)detail.getChildDetails()) || detail.getChildDetails().size() < 64) {
            logger.debug((Object)"The log detail size is less than the threshold(%s).", new Object[]{String.valueOf(64)});
            return;
        }
        detail.setChildDetails(detail.getChildDetails().stream().sorted(Comparator.comparingInt(RecoveryProcessorDetail::getProcessStatus).reversed()).limit(64L).collect(Collectors.toList()));
    }

    public static List<RecoveryProcessor> sortRecoveryProcessors(Set<RecoveryProcessor> processors) {
        ArrayList<RecoveryProcessor> processorList = new ArrayList<RecoveryProcessor>();
        RecoveryProcessor startRecoveryProcessor = null;
        for (RecoveryProcessor processor : processors) {
            if (null != processor.getPreviousProcessor()) continue;
            startRecoveryProcessor = processor;
            break;
        }
        if (startRecoveryProcessor != null) {
            do {
                processorList.add(startRecoveryProcessor);
            } while (null != (startRecoveryProcessor = startRecoveryProcessor.getNextProcessor()));
        }
        if (processorList.size() != processors.size()) {
            processorList.clear();
            for (RecoveryProcessor processor : processors) {
                processorList.add(processor);
            }
        }
        return processorList;
    }

    public static DrmEnumDefine.AppType getAppType(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (ServiceInstaceEnumDefine.ObjectType.NAS.getValue().equals(recoveryPlan.getObjectType())) {
            return DrmEnumDefine.AppType.NAS;
        }
        Set pgs = recoveryPlan.getProtectGroups();
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        int poType = ((ProtectGroup)iterator.next()).getPoType();
        DrmEnumDefine.AppType appType = DrmEnumDefine.AppType.getType((int)poType);
        return appType;
    }

    public static String getProductSiteId(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        Set pgs = recoveryPlan.getProtectGroups();
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        return ((ProtectGroup)iterator.next()).getProductSiteId();
    }

    public static Set<String> getDisasterSiteIds(RecoveryPlan recoveryPlan) {
        HashSet<String> disasterSites = new HashSet<String>();
        Set protectGroups = recoveryPlan.getProtectGroups();
        for (ProtectGroup protectGroup : protectGroups) {
            Set gpReplicas = protectGroup.getReplicaList();
            for (ProtectGroupReplica gpReplica : gpReplicas) {
                disasterSites.add(gpReplica.getRecoverySite());
            }
        }
        logger.info((Object)"recoveryPlan is:%s", new Object[]{recoveryPlan.getName()});
        return disasterSites;
    }

    public static Set<String> getDisasterSiteIds(ProtectGroup protectGroup) {
        HashSet<String> disasterSites = new HashSet<String>();
        Set gpReplicas = protectGroup.getReplicaList();
        for (ProtectGroupReplica gpReplica : gpReplicas) {
            disasterSites.add(gpReplica.getRecoverySite());
        }
        logger.info((Object)"protectGroup is:%s", new Object[]{protectGroup.getName()});
        return disasterSites;
    }

    public static boolean isExistLocalRecoverySite(Set<String> disasterSiteIds) {
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        List localSites = siteService.getAllLocalSites();
        boolean isLoacalDisasterSite = false;
        for (String disasterSiteId : disasterSiteIds) {
            logger.info((Object)"disasterSiteId is:%s", new Object[]{disasterSiteId});
            Site disasterSite = siteService.getSiteById(disasterSiteId);
            if (null == disasterSite || !localSites.contains(disasterSite)) continue;
            isLoacalDisasterSite = true;
            break;
        }
        return isLoacalDisasterSite;
    }

    public static IRecoveryProcessProvider getRecoveryProcessProvider(RecoveryPlan recoveryPlan) {
        Set pgs = recoveryPlan.getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)pgs)) {
            logger.error((Object)("There is no protect group. planId:" + recoveryPlan.getPlanId()), 90160758784001L);
            return null;
        }
        Iterator iterator = pgs.iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)("iterator is null. planId:" + recoveryPlan.getPlanId()), 90160758784001L);
            return null;
        }
        return RecoveryServiceUtil.getRecoveryProcessProvider((ProtectGroup)iterator.next());
    }

    public static IRecoveryProcessProvider getRecoveryProcessProvider(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            logger.error((Object)"Protect group is null.", 90160758784001L);
            return null;
        }
        int poType = protectGroup.getPoType();
        DrmEnumDefine.AppType appType = DrmEnumDefine.AppType.getType((int)poType);
        if (null == appType) {
            logger.error((Object)("There is no matched APP_TYPE. poType:" + poType), 90160758784001L);
            return null;
        }
        IRecoveryProcessProvider procProvider = RecoveryProcessorMgr.getInstance().getRecoveryProcessProvider(appType.name());
        if (null == procProvider) {
            logger.error((Object)("The recovery process provider is null. appType:" + appType.name()), 90160758784001L);
        }
        return procProvider;
    }

    public static RecoveryProcessDefinition getInitRecoveryProcessDefinition(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE procyType) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType(recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)("iterator is null: " + recoveryPlan.getPlanId()), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessDefinition rpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, procyType, protectGroup);
        return rpDefinition;
    }

    public static Set<RecoveryProcessDefinition> getInitRecoveryProcessDefinitions(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (null == provider) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)("iterator is null: " + recoveryPlan.getPlanId()), 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup firstProtectGroup = (ProtectGroup)iterator.next();
        DrmEnumDefine.AppType appType = DrmEnumDefine.AppType.getType((int)firstProtectGroup.getPoType());
        if (null == appType) {
            logger.error((Object)("There is no matched APP_TYPE. poType:" + firstProtectGroup.getPoType()), 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        Set processes = provider.getRecoveryProcesses(recoveryPlan, appType, firstProtectGroup);
        return processes;
    }

    public static void updateProgressRatio(List<? extends RecoveryProcessor> processors) {
        List<RecoveryProcessor> newProcessors = RecoveryServiceUtil.filterEnabledProcessors(processors);
        if (null == newProcessors || newProcessors.isEmpty()) {
            logger.debug((Object)"param is null");
            return;
        }
        int totalProgressRatio = 100;
        RecoveryProcessor proc = newProcessors.get(0);
        if (null != proc.getParentProc() && !(proc.getParentProc() instanceof IInitialChildProcessor)) {
            totalProgressRatio = proc.getParentProc().getProgressRatio();
        }
        int avgProgressRatio = totalProgressRatio / newProcessors.size();
        int index = 0;
        int countProgressRatio = 0;
        for (RecoveryProcessor recoveryProcessor : newProcessors) {
            if (++index == newProcessors.size()) {
                recoveryProcessor.setProgressRatio(totalProgressRatio - countProgressRatio);
                continue;
            }
            countProgressRatio += avgProgressRatio;
            recoveryProcessor.setProgressRatio(avgProgressRatio);
        }
    }

    public static boolean isContainSite(List<Site> sites, String siteId) {
        if (VerifyUtil.isEmpty(sites) || VerifyUtil.isEmpty((String)siteId)) {
            logger.debug((Object)"param is null");
            return false;
        }
        for (Site site : sites) {
            if (!site.getSiteId().equals(siteId)) continue;
            return true;
        }
        return false;
    }

    public static List<? extends IProcessor> sortAndUpdateProcessorRation(Set<RecoveryProcessor> processors) {
        List<RecoveryProcessor> rProcessors = RecoveryServiceUtil.sortRecoveryProcessors(processors);
        RecoveryServiceUtil.updateProgressRatio(rProcessors);
        return rProcessors;
    }

    public static void resetRecoverySetting(Set<RecoverySetting> oldSettings, RecoverySetting newSetting) {
        if (VerifyUtil.isEmpty(oldSettings)) {
            logger.debug((Object)"oldSettings is null");
            oldSettings.add(newSetting);
        }
        boolean isExistedSetting = false;
        for (RecoverySetting oldSetting : oldSettings) {
            if (!oldSetting.getOwnerId().equals(newSetting.getOwnerId()) || !oldSetting.getName().equals(newSetting.getName())) continue;
            oldSetting.setValue(newSetting.getValue());
            if (!VerifyUtil.isEmpty((String)newSetting.getDisasterSiteId())) {
                oldSetting.setDisasterSiteId(newSetting.getDisasterSiteId());
            }
            isExistedSetting = true;
            break;
        }
        if (!isExistedSetting) {
            oldSettings.add(newSetting);
        }
    }

    public static List<RecoverySetting> filterAddedRecoverySettings(Set<RecoverySetting> oldSettings, Set<RecoverySetting> newSettings) {
        ArrayList<RecoverySetting> addedRecoverySettings = new ArrayList<RecoverySetting>();
        if (VerifyUtil.isEmpty(newSettings)) {
            logger.debug((Object)"newSettings is null");
            return addedRecoverySettings;
        }
        for (RecoverySetting newSetting : newSettings) {
            boolean isExistedSetting = false;
            for (RecoverySetting oldSetting : oldSettings) {
                if (!oldSetting.getOwnerId().equals(newSetting.getOwnerId()) || !oldSetting.getName().equals(newSetting.getName())) continue;
                isExistedSetting = true;
                break;
            }
            if (isExistedSetting) continue;
            addedRecoverySettings.add(newSetting);
        }
        return addedRecoverySettings;
    }

    public static String getDisasterHostSN(RecoveryPlan recoveryPlan) {
        String hostOrGroupId = (String)recoveryPlan.getGlobalSettings().get("PG_DISASTER_HOST");
        if (VerifyUtil.isEmpty((String)hostOrGroupId)) {
            Set settings = RecoveryUtil.getRecoverySettingsByItemKey((String)recoveryPlan.getPlanId(), (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
            if (null == settings) {
                return hostOrGroupId;
            }
            Iterator iterator = settings.iterator();
            if (iterator.hasNext()) {
                hostOrGroupId = ((RecoverySetting)iterator.next()).getValue();
            }
        }
        logger.info((Object)"hostOrGroupId is: %s", new Object[]{hostOrGroupId});
        return hostOrGroupId;
    }

    public static Site getRecoverySite(String recoverySiteId) {
        if (VerifyUtil.isEmpty((String)recoverySiteId)) {
            throw new LegoCheckedException(201L);
        }
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site recoverySite = siteService.getSiteById(recoverySiteId);
        if (null == recoverySite) {
            logger.info((Object)"recoverySiteId is: %s", new Object[]{recoverySiteId});
            throw new LegoCheckedException(201L);
        }
        return recoverySite;
    }

    public static void setProtectGroupsInvalidByPlan(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        try {
            RecoveryProcessorMgr processMgr = RecoveryProcessorMgr.getInstance();
            IRecoveryProcessHandler recoveryProcessHandler = processMgr.getRecoveryProcessHandler();
            String productSiteId = RecoveryServiceUtil.getProductSiteId(plan);
            Site productSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productSiteId);
            boolean operationResult = recoveryProcessHandler.setProtectGroupsInvalid(productSite, plan.getProtectGroups(), type);
            if (!operationResult) {
                logger.error((Object)("Setting protect group invalid failed. planId:" + plan.getPlanId()));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Setting protect group invalid failed. planId:" + plan.getPlanId() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private static List<RecoveryProcessor> filterEnabledProcessors(List<? extends RecoveryProcessor> processors) {
        ArrayList<RecoveryProcessor> newProcessors = new ArrayList<RecoveryProcessor>();
        if (null == processors || processors.isEmpty()) {
            logger.debug((Object)"param is null");
            return newProcessors;
        }
        for (RecoveryProcessor recoveryProcessor : processors) {
            if (null == recoveryProcessor || !recoveryProcessor.getIsEnabled().booleanValue()) continue;
            RecoveryServiceUtil.filterEnabledProcessor(recoveryProcessor, newProcessors);
        }
        return newProcessors;
    }

    private static void filterEnabledProcessor(RecoveryProcessor processor, List<RecoveryProcessor> newProcessors) {
        if (processor instanceof IInitialChildProcessor) {
            for (RecoveryProcessor childProcessor : RecoveryServiceUtil.sortRecoveryProcessors(processor.getChildProc())) {
                if (null == childProcessor || !childProcessor.getIsEnabled().booleanValue()) continue;
                RecoveryServiceUtil.filterEnabledProcessor(childProcessor, newProcessors);
            }
        } else {
            if (null == processor.getNextCascadeProcessor()) {
                newProcessors.add(processor);
                return;
            }
            RecoveryProcessor tempProcessor = processor;
            do {
                if (!tempProcessor.getIsEnabled().booleanValue()) continue;
                newProcessors.add(tempProcessor);
            } while (null != (tempProcessor = tempProcessor.getNextCascadeProcessor()));
        }
    }

    private static RecoveryProcessorDetail getFirstRecoveryProcessorDetail(List<RecoveryProcessorDetail> details, boolean containsEndProcessor) {
        RecoveryProcessorDetail firstDetail = null;
        for (RecoveryProcessorDetail detail : details) {
            if (!VerifyUtil.isEmpty((String)detail.getParentDetailId()) && !containsEndProcessor || !VerifyUtil.isEmpty((String)detail.getPreviousProcId()) || VerifyUtil.isEmpty((String)detail.getNextProcId())) continue;
            firstDetail = detail;
            break;
        }
        return firstDetail;
    }

    public static RecoveryProcessor getLastRecoveryProcessor(Set<RecoveryProcessor> processors) {
        RecoveryProcessor lastProcessor = null;
        for (RecoveryProcessor processor : processors) {
            if (null != processor.getNextProcessor()) continue;
            lastProcessor = processor;
            break;
        }
        return lastProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getAllMoNameMap(List<String> uuidList) {
        Session session;
        HashMap<String, String> nameMap;
        block7: {
            nameMap = new HashMap<String, String>();
            session = null;
            try {
                NativeQuery query;
                List results;
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                StringBuilder querSQL = new StringBuilder();
                querSQL.append("select UUID,NAME from T_managedobject");
                if (!VerifyUtil.isEmpty(uuidList)) {
                    querSQL.append(" where UUID in (");
                    for (int i = 0; i < uuidList.size(); ++i) {
                        String uuid = uuidList.get(i);
                        querSQL.append("'" + StringEscapeUtil.escapeSql((String)uuid) + "'");
                        if (i >= uuidList.size() - 1) continue;
                        querSQL.append(",");
                    }
                    querSQL.append(")");
                }
                if (VerifyUtil.isEmpty((Collection)(results = (query = session.createSQLQuery(querSQL.toString())).list()))) break block7;
                for (Object object : results) {
                    Object[] values;
                    if (!(object instanceof Object[]) || (values = (Object[])object).length < 2) continue;
                    String uuid = String.valueOf(values[0]);
                    String name = String.valueOf(values[1]);
                    nameMap.put(uuid, name);
                }
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("Failed to query queryReplicaProps!" + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
        return nameMap;
    }
}

