/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.license;

import com.huawei.ism.drm.license.sdk.ILicenseInter;
import com.huawei.ism.drm.system.info.sdk.model.SoftwareInfo;
import com.huawei.ism.drm.system.info.sdk.service.ISoftwareInfoService;
import com.huawei.lego.cbb.license.sdk.model.ConsumeLicense;
import com.huawei.lego.cbb.license.sdk.model.FeatureBo;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.license.sdk.model.ResourceItemBo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LicenseOverflowStackControl {
    private static final Log logger = LogFactory.getInstance(LicenseOverflowStackControl.class);
    private static volatile LicenseOverflowStackControl licenseControl = null;
    private Map<String, ResourceItemBo> licenseUsedItem = new ConcurrentHashMap<String, ResourceItemBo>();
    private Map<Long, List<ConsumeLicense>> threads = new ConcurrentHashMap<Long, List<ConsumeLicense>>();
    private final Object threadLock = new Object();
    private ILicenseInter licenseService = (ILicenseInter)ServiceLocator.getInstance().getService(ILicenseInter.class);

    private LicenseOverflowStackControl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LicenseOverflowStackControl getInstance() {
        if (licenseControl != null) return licenseControl;
        Class<LicenseOverflowStackControl> clazz = LicenseOverflowStackControl.class;
        synchronized (LicenseOverflowStackControl.class) {
            if (licenseControl != null) return licenseControl;
            licenseControl = new LicenseOverflowStackControl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return licenseControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLicenseUsedItem() {
        Object object = this.threadLock;
        synchronized (object) {
            this.licenseUsedItem = new ConcurrentHashMap<String, ResourceItemBo>();
        }
    }

    public void checkLicenseEnable(String typeLicStr, int count) {
        logger.info((Object)"checkLicenseEnable: licenseType:%s, count:%s", new Object[]{typeLicStr, count});
        if (this.licenseService.isBasicVersion()) {
            logger.error((Object)"checkLicenseEnable: License is a basic version.");
            throw new LegoCheckedException(1073947430L);
        }
        if (this.isLicenseNoNumControl()) {
            logger.debug((Object)"checkLicenseEnable: License  control is not enable.");
            return;
        }
        if (!this.isLicenseEnable(typeLicStr, count)) {
            logger.error((Object)"checkLicenseEnable: license is not enough.");
            throw new LegoCheckedException(1073947451L);
        }
    }

    private boolean isLicenseEnable(String type, int count) {
        if (this.isNewType(type) && this.isOldLicense()) {
            if ("LSTQVHA_CSDR".equals(type) || "LSTQCSHA_CSDR".equals(type)) {
                count *= 2;
            }
            return this.overflowStackLicense("LSTQDPMP", count);
        }
        if ("LSTQVHA_CSDR".equals(type)) {
            if (!this.overflowStackLicense("LSTQCSDR", count)) {
                return false;
            }
            return this.overflowStackLicense("LSTQVHA", count);
        }
        if ("LSTQCSHA_CSDR".equals(type)) {
            if (!this.overflowStackLicense("LSTQCSDR", count)) {
                return false;
            }
            return this.overflowStackLicense("LSTQCSHA", count);
        }
        return this.overflowStackLicense(type, count);
    }

    private boolean isLicenseNoNumControl() {
        ISoftwareInfoService softInfoService = (ISoftwareInfoService)ServiceLocator.getInstance().getService(ISoftwareInfoService.class);
        SoftwareInfo softInfo = softInfoService.getSoftwareInfo();
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        return null == licenseBo && !this.licenseService.isLicenseProbationTimeout() || "UltraVR".equals(softInfo.getProductModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean overflowStackLicense(String type, int count) {
        Object object = this.threadLock;
        synchronized (object) {
            ResourceItemBo usedItem = this.getUsedLicense(type);
            if (VerifyUtil.isEmpty((Object)usedItem)) {
                logger.error((Object)"usedItem is null.");
                return false;
            }
            ResourceItemBo licenseItem = this.getTotalLicense(type);
            if (VerifyUtil.isEmpty((Object)licenseItem)) {
                logger.error((Object)"licenseItem(%s) is null. But license count is %s", new Object[]{type, count});
                return count <= 0;
                {
                }
            }
            int licenseCount = Integer.parseInt(licenseItem.getItemValue());
            logger.info((Object)"overflow stack license.Type : %s ,count: %s, consumeNum : %s,licenseCount: %s", new Object[]{type, count, usedItem.getConsumeNum(), licenseCount});
            if (count > 0 && Integer.parseInt(usedItem.getConsumeNum()) + count > licenseCount) {
                logger.error((Object)"license is not enough.");
                return false;
            }
            if (!this.recordThreadAndLicenseInfo(type, count)) {
                logger.error((Object)"current thread speeds two same license.");
                return false;
            }
            usedItem.setConsumeNum(Integer.parseInt(usedItem.getConsumeNum()) + count + "");
            this.licenseUsedItem.put(type, usedItem);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noticeTaskSuccess() {
        logger.info((Object)"LicenseCount: noticeTaskSuccess.");
        Object object = this.threadLock;
        synchronized (object) {
            Long threadId = Thread.currentThread().getId();
            if (this.threads.containsKey(threadId)) {
                List<ConsumeLicense> consumeLicenses = this.threads.get(threadId);
                this.threads.remove(threadId);
                this.reviseLicenseUsedItem(consumeLicenses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noticeTaskError() {
        logger.info((Object)"LicenseCount: noticeTaskError.");
        Object object = this.threadLock;
        synchronized (object) {
            Long threadId = Thread.currentThread().getId();
            List<ConsumeLicense> consumeLicenses = this.threads.get(threadId);
            if (VerifyUtil.isEmpty(consumeLicenses)) {
                logger.error((Object)"licenseInfo is null");
                return;
            }
            for (ConsumeLicense cl : consumeLicenses) {
                ResourceItemBo resBo = this.licenseUsedItem.get(cl.getItemName());
                resBo.setConsumeNum(Integer.parseInt(resBo.getConsumeNum()) - cl.getConsumeNum() + "");
            }
            List<ConsumeLicense> removedConsumeLicense = this.threads.get(threadId);
            this.threads.remove(threadId);
            this.reviseLicenseUsedItem(removedConsumeLicense);
        }
    }

    private ResourceItemBo getTotalLicense(String type) {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (null == licenseBo) {
            return null;
        }
        return this.getResControlBean(licenseBo, type);
    }

    private boolean isNewType(String type) {
        return "LSTQCSHA".equals(type) || "LSTQCSDR".equals(type) || "LSTQVHA".equals(type) || "LSTQVHA_CSDR".equals(type) || "LSTQCSHA_CSDR".equals(type);
    }

    private boolean isOldLicense() {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        return this.getResControlBean(licenseBo, "LSTQCSHA") == null && this.getResControlBean(licenseBo, "LSTQCSDR") == null && this.getResControlBean(licenseBo, "LSTQVHA") == null;
    }

    private ResourceItemBo getResControlBean(LicenseInfoBo licenseBo, String resName) {
        List fitems = licenseBo.getFeaBolst();
        if (fitems == null) {
            logger.error((Object)"fea bo list is empty", 90160758787071L);
            return null;
        }
        try {
            for (FeatureBo fitem : fitems) {
                List resList = fitem.getReslst();
                if (resList == null || resList.isEmpty()) continue;
                for (ResourceItemBo item : resList) {
                    if (!resName.equals(item.getItemName())) continue;
                    return item;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("get ResourceItemBo fail" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        return null;
    }

    private ResourceItemBo getUsedLicense(String type) {
        if (!VerifyUtil.isEmpty((Object)this.licenseUsedItem.get(type))) {
            return this.licenseUsedItem.get(type);
        }
        ResourceItemBo usedLicense = this.countResConsumeNum(type);
        if (null == usedLicense) {
            return null;
        }
        if (0L != usedLicense.getErrorCode()) {
            throw new LegoCheckedException(usedLicense.getErrorCode(), usedLicense.getParameters());
        }
        this.licenseUsedItem.put(type, usedLicense);
        return usedLicense;
    }

    private ResourceItemBo countResConsumeNum(String type) {
        LicenseInfoBo licenseBo = this.licenseService.getLicenseNotUpdateUseNum();
        if (null == licenseBo) {
            return null;
        }
        ResourceItemBo resItem = this.getResControlBean(licenseBo, type);
        if (null == resItem) {
            resItem = new ResourceItemBo();
            resItem.setItemName(type);
            resItem.setItemValue("0");
        }
        ArrayList<ResourceItemBo> resList = new ArrayList<ResourceItemBo>();
        resList.add(resItem);
        this.licenseService.countResUseNum(resList);
        ResourceItemBo newLicenseBo = new ResourceItemBo();
        newLicenseBo.setItemValue(resItem.getItemValue());
        newLicenseBo.setConsumeNum(resItem.getConsumeNum());
        return newLicenseBo;
    }

    private boolean recordThreadAndLicenseInfo(String type, Integer useCount) {
        if (useCount <= 0) {
            return true;
        }
        Long threadId = Thread.currentThread().getId();
        if (!VerifyUtil.isEmpty((Collection)this.threads.get(threadId))) {
            List<ConsumeLicense> consumeLicenses = this.threads.get(threadId);
            for (ConsumeLicense cl : consumeLicenses) {
                if (!cl.getItemName().equals(type)) continue;
                return false;
            }
            ConsumeLicense nowConsumeLicense = new ConsumeLicense(threadId.longValue(), type, useCount.intValue());
            consumeLicenses.add(nowConsumeLicense);
            return true;
        }
        ArrayList<ConsumeLicense> consumeLicenses = new ArrayList<ConsumeLicense>();
        ConsumeLicense consumeLicense = new ConsumeLicense(threadId.longValue(), type, useCount.intValue());
        consumeLicenses.add(consumeLicense);
        this.threads.put(threadId, consumeLicenses);
        return true;
    }

    private void reviseLicenseUsedItem(List<ConsumeLicense> removedConsumeLicenses) {
        if (this.threads.size() != 0) {
            this.threads.keySet().removeIf(threadId -> {
                ThreadMXBean tmx = ManagementFactory.getThreadMXBean();
                ThreadInfo info = tmx.getThreadInfo((long)threadId);
                return null == info;
            });
            if (this.threads.size() != 0) {
                return;
            }
        }
        for (ConsumeLicense removedConsumeLicense : removedConsumeLicenses) {
            ResourceItemBo usedLicense = this.countResConsumeNum(removedConsumeLicense.getItemName());
            if (null == usedLicense || 0L != usedLicense.getErrorCode()) {
                return;
            }
            int usedConsumeLicense = Integer.parseInt(usedLicense.getConsumeNum());
            for (Map.Entry<Long, List<ConsumeLicense>> threadEntry : this.threads.entrySet()) {
                List<ConsumeLicense> consumeLicenses = threadEntry.getValue();
                for (ConsumeLicense consumeLicense : consumeLicenses) {
                    if (!removedConsumeLicense.getItemName().equals(consumeLicense.getItemName())) continue;
                    usedConsumeLicense += consumeLicense.getConsumeNum();
                }
            }
            ResourceItemBo resBo = this.licenseUsedItem.get(removedConsumeLicense.getItemName());
            logger.info((Object)"ReviseLicenseUsedItem. LicenseType: %s, In memory : %s, In database : %s, In database plus threads : %s.", new Object[]{removedConsumeLicense.getItemName(), resBo.getConsumeNum(), Integer.parseInt(usedLicense.getConsumeNum()), usedConsumeLicense});
            if (Integer.parseInt(resBo.getConsumeNum()) == usedConsumeLicense) continue;
            logger.error((Object)"An error occurred in record license. revise now!!!");
            resBo.setConsumeNum(usedLicense.getConsumeNum());
        }
    }
}

