/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.license;

import com.adaptivelm.license.base.LicLogLevelEnum;
import com.adaptivelm.license.basecallback.LicBaseCallbackGetEsn;
import com.adaptivelm.license.basecallback.LicBaseCallbackPsRead;
import com.adaptivelm.license.basecallback.LicBaseCallbackPsWrite;
import com.adaptivelm.license.basecallback.LicBaseCallbacks;
import com.adaptivelm.license.common.LicenseException;
import com.adaptivelm.license.lkmgr.LicLkActiveRslts;
import com.adaptivelm.license.lkmgr.LicLkBbomTypeEnum;
import com.adaptivelm.license.lkmgr.LicLkPrdAndLic;
import com.adaptivelm.license.lkmgr.LicLkStore;
import com.adaptivelm.license.lkmgr.LicLkStoreBbom;
import com.adaptivelm.license.productmgr.LicPrdBBOMInfo;
import com.adaptivelm.license.productmgr.LicPrdBaseInfo;
import com.adaptivelm.license.productmgr.LicPrdExtendInfo;
import com.adaptivelm.license.productmgr.LicPrdInfo;
import com.adaptivelm.license.service.LicenseConfigService;
import com.adaptivelm.license.service.LicenseOperationService;
import com.adaptivelm.license.statemgr.LicStateChkCfg;
import com.adaptivelm.license.statemgr.LicStateChkItemEnumType;
import com.adaptivelm.license.statemgr.LicStateLicEnumType;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.license.LicenseKey;
import com.huawei.ism.drm.license.RDAppCallback;
import com.huawei.lego.cbb.license.sdk.model.FeatureBo;
import com.huawei.lego.cbb.license.sdk.model.FunctionItemBo;
import com.huawei.lego.cbb.license.sdk.model.LicenseInfoBo;
import com.huawei.lego.cbb.license.sdk.model.ResourceItemBo;
import com.huawei.lego.cbb.license.sdk.model.po.LicenseInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.hibernate.Session;

public class RDLicenseFactory {
    private static final Log LOGGER = LogFactory.getInstance(RDLicenseFactory.class);
    private static final String LIC_FILES_TMP = "lic/lctm";
    private static final String PRD_NAME = "OceanStor BCManager";
    private static final String PRD_VER = "8";
    private static final int PRD_ID = 0;
    private static final int RES_MAX_COUNT = 10000;
    private static final int FUN_BASE_COUNT = 10001;
    private static final Object ACTIVE_LIC_LOCK = new Object();
    private static RDLicenseFactory instance = null;
    private LicenseOperationService almOperService = new LicenseOperationService();
    private LicenseConfigService almConfService = new LicenseConfigService();
    private String productKeyInfo = LicenseKey.getInstance().getKey();

    private RDLicenseFactory() {
        if (this.productKeyInfo == null) {
            throw new LegoCheckedException(1073947436L);
        }
        try {
            this.registerCallback();
            this.setLogLevel();
            this.almConfService.start();
            this.prdAdd();
            this.stateCheckCfg();
        }
        catch (LicenseException e) {
            LOGGER.error((Object)"Init RDLicenseFactory failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Init RDLicenseFactory failed.");
        }
    }

    public static synchronized RDLicenseFactory getInstance() {
        if (instance == null) {
            try {
                instance = new RDLicenseFactory();
            }
            catch (LegoCheckedException e) {
                instance = null;
                throw e;
            }
        }
        return instance;
    }

    private void registerCallback() {
        LicBaseCallbacks callBacks = new LicBaseCallbacks();
        RDAppCallback callBackFuncs = new RDAppCallback();
        callBacks.setGetEsnCallback((LicBaseCallbackGetEsn)callBackFuncs);
        callBacks.setPsReadCallback((LicBaseCallbackPsRead)callBackFuncs);
        callBacks.setPsWriteCallback((LicBaseCallbackPsWrite)callBackFuncs);
        try {
            this.almConfService.registBaseCallback(callBacks);
            LOGGER.info((Object)"Register base callback functions succeed.");
        }
        catch (LicenseException e) {
            LOGGER.error((Object)"Register base callback functions failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Register base callback functions failed.");
        }
    }

    private void setLogLevel() {
        try {
            this.almConfService.setLogLevel(LicLogLevelEnum.ALM_LOG_LEVEL_INFO);
        }
        catch (LicenseException e) {
            LOGGER.error((Object)"Set log level failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Set log level failed.");
        }
    }

    private void registerBbomInfo(ArrayList<LicPrdBBOMInfo> itemList) {
        List<String> countItemList = Arrays.asList("LSTQDPMN", "LSTQDPMP", "LSTQCSHA", "LSTQCSDR", "LSTQVHA", "LSTQARK");
        for (int i = 0; i < countItemList.size(); ++i) {
            LicPrdBBOMInfo itemInfo = new LicPrdBBOMInfo();
            itemInfo.setType(LicLkBbomTypeEnum.ALM_LIC_BBOM_RESOURCE);
            itemInfo.setBbomId(i + 1);
            itemInfo.setName(countItemList.get(i));
            itemInfo.setMaxVal(10000L);
            itemInfo.setDfltVal(1L);
            itemInfo.setMinVal(0L);
            itemList.add(itemInfo);
        }
        List<String> controlItemList = Arrays.asList("LSTQDPMM", "LSTQDPMH");
        for (int i = 0; i < controlItemList.size(); ++i) {
            LicPrdBBOMInfo itemInfo = new LicPrdBBOMInfo();
            itemInfo.setType(LicLkBbomTypeEnum.ALM_LIC_BBOM_FUNCTION);
            itemInfo.setBbomId(i + 10001);
            itemInfo.setName(controlItemList.get(i));
            itemInfo.setDfltVal(0L);
            itemList.add(itemInfo);
        }
    }

    private void prdAdd() {
        LicPrdBaseInfo prdBase = new LicPrdBaseInfo();
        prdBase.setPrdName(PRD_NAME);
        prdBase.setPrdVer(PRD_VER);
        prdBase.setPrdId(0);
        ArrayList<LicPrdBBOMInfo> itemList = new ArrayList<LicPrdBBOMInfo>();
        this.registerBbomInfo(itemList);
        LicPrdExtendInfo extendInfo = new LicPrdExtendInfo();
        extendInfo.setSafeTimeEnable(false);
        extendInfo.setEsnVerMisOnce(false);
        extendInfo.setUseMinValInPartOver(false);
        extendInfo.setFixTimeSupport(false);
        extendInfo.setForceCmpSupport(false);
        LicPrdInfo node = new LicPrdInfo();
        node.setBase(prdBase);
        node.setPrdKey(this.productKeyInfo);
        node.setBboms(itemList);
        node.setExtend(extendInfo);
        ArrayList<LicPrdInfo> prdInfoList = new ArrayList<LicPrdInfo>();
        prdInfoList.add(node);
        try {
            int registerResult = this.almConfService.prdAdd(prdInfoList);
            if (node.getRet() != 0 || registerResult != 0) {
                LOGGER.error((Object)"Register bbom Info failed: almConfService.prdAdd fail");
                throw new LegoCheckedException("almConfService.prdAdd failed.");
            }
            LOGGER.info((Object)"Register bbom Info success.");
        }
        catch (LicenseException e) {
            LOGGER.error((Object)"Register bbom Info failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Register bbom Info failed.");
        }
    }

    private void stateCheckCfg() {
        LicStateChkCfg prdVerCfg = new LicStateChkCfg();
        prdVerCfg.setItemType(LicStateChkItemEnumType.ALM_STATE_VERIFY_ITEM_PRD_VER);
        prdVerCfg.setMisStateType(LicStateLicEnumType.ALM_STATE_LIC_VALID);
        prdVerCfg.setMisStateByGoOnType(LicStateLicEnumType.ALM_STATE_LIC_VALID);
        prdVerCfg.setIgnore(false);
        prdVerCfg.setIgnoreUpAndLower(false);
        LicStateChkCfg prdNameCfg = new LicStateChkCfg();
        prdNameCfg.setItemType(LicStateChkItemEnumType.ALM_STATE_VERIFY_ITEM_PRD_NAME);
        prdNameCfg.setMisStateType(LicStateLicEnumType.ALM_STATE_LIC_INVALID);
        prdNameCfg.setMisStateByGoOnType(LicStateLicEnumType.ALM_STATE_LIC_INVALID);
        prdNameCfg.setIgnore(false);
        prdNameCfg.setIgnoreUpAndLower(false);
        LicStateChkCfg esnCfg = new LicStateChkCfg();
        esnCfg.setItemType(LicStateChkItemEnumType.ALM_STATE_VERIFY_ITEM_ESN);
        esnCfg.setMisStateType(LicStateLicEnumType.ALM_STATE_LIC_INVALID);
        esnCfg.setMisStateByGoOnType(LicStateLicEnumType.ALM_STATE_LIC_INVALID);
        esnCfg.setIgnore(false);
        esnCfg.setIgnoreUpAndLower(true);
        LicStateChkCfg deadlineOverCfg = new LicStateChkCfg();
        deadlineOverCfg.setItemType(LicStateChkItemEnumType.ALM_STATE_VERIFY_ITEM_DEADLINE_OVER);
        deadlineOverCfg.setMisStateType(LicStateLicEnumType.ALM_STATE_LIC_GRACE_PERIOD);
        deadlineOverCfg.setMisStateByGoOnType(LicStateLicEnumType.ALM_STATE_LIC_GRACE_PERIOD);
        deadlineOverCfg.setIgnore(false);
        deadlineOverCfg.setIgnoreUpAndLower(false);
        LicStateChkCfg rvkCfg = new LicStateChkCfg();
        rvkCfg.setItemType(LicStateChkItemEnumType.ALM_STATE_VERIFY_ITEM_RVK);
        rvkCfg.setMisStateType(LicStateLicEnumType.ALM_STATE_LIC_GRACE_PERIOD);
        rvkCfg.setMisStateByGoOnType(LicStateLicEnumType.ALM_STATE_LIC_GRACE_PERIOD);
        rvkCfg.setIgnore(false);
        rvkCfg.setIgnoreUpAndLower(false);
        ArrayList<LicStateChkCfg> stateChkCfgInfo = new ArrayList<LicStateChkCfg>();
        stateChkCfgInfo.add(prdVerCfg);
        stateChkCfgInfo.add(prdNameCfg);
        stateChkCfgInfo.add(esnCfg);
        stateChkCfgInfo.add(deadlineOverCfg);
        stateChkCfgInfo.add(rvkCfg);
        try {
            this.almConfService.stateCheckCfg(0, stateChkCfgInfo);
        }
        catch (LicenseException e) {
            LOGGER.error((Object)"StateCheckCfg failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("stateCheckCfg failed.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FileInputStream getLicInputStream(byte[] licFile, File file) {
        try (FileOutputStream output = new FileOutputStream(file);){
            output.write(licFile);
            output.flush();
            FileInputStream fileInputStream = new FileInputStream(this.getTmpFile());
            return fileInputStream;
        }
        catch (IOException e) {
            LOGGER.error((Object)"ActivateLic IOException: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073947422L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseInfo activateLic(byte[] licFile) {
        Object object = ACTIVE_LIC_LOCK;
        synchronized (object) {
            LicenseInfo licenseInfo;
            File file = new File(this.getTmpFile());
            try (FileInputStream fileInputStream = this.getLicInputStream(licFile, file);){
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Check licFile size: %s", licFile.length));
                ArrayList<LicLkPrdAndLic> licActiveList = new ArrayList<LicLkPrdAndLic>();
                LicLkPrdAndLic node = new LicLkPrdAndLic();
                node.setPrdId(0);
                node.setFileInputSteam(fileInputStream);
                licActiveList.add(node);
                LicLkActiveRslts activeRslts = this.almOperService.licGeneralActive(licActiveList);
                if (activeRslts.getFailNum() != 0) {
                    LOGGER.error((Object)"LicGeneralActive failed, failed num: %s", new Object[]{String.valueOf(activeRslts.getFailNum())});
                    throw new LegoCheckedException(1073947422L);
                }
                LOGGER.info((Object)"Active LicenseKey Success.");
            }
            catch (LicenseException e) {
                LOGGER.error((Object)"ActivateLic LicenseException: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(1073947422L);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"LicGeneralActive failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(1073947422L);
            }
            catch (IOException e) {
                LOGGER.error((Object)"ActivateLic IOException: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(1073947422L);
            }
            finally {
                this.deleteLicenseFile(file);
            }
            try {
                LicLkStore lkStore = this.almOperService.licGeneralQuery(0);
                licenseInfo = new LicenseInfo();
                licenseInfo.setProductESN((String)lkStore.getGeneral().getEsns().get(0));
                licenseInfo.setProductName(lkStore.getGeneral().getFilePrdName());
                licenseInfo.setProductVers(lkStore.getGeneral().getFilePrdVer());
                licenseInfo.setFile(this.createBlob(licFile));
                licenseInfo.setUploadTime(System.currentTimeMillis());
                licenseInfo.setInUse(true);
                licenseInfo.setSoftId(lkStore.getGeneral().getSoftId());
            }
            catch (LicenseException e) {
                LOGGER.error((Object)"Query license error when activateLic: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException("Query license error when activateLic.");
            }
            return licenseInfo;
        }
    }

    private Blob createBlob(byte[] licFile) {
        Session session;
        block4: {
            Blob blob;
            session = null;
            IBaseDao baseDao = CommonDAOLocator.getBaseDao();
            try {
                session = Objects.requireNonNull(baseDao.getHibernateTemplate().getSessionFactory()).openSession();
                if (null == session) break block4;
                blob = session.getLobHelper().createBlob(licFile);
            }
            catch (Exception e) {
                try {
                    LOGGER.error((Object)"CreateBlob Exception: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                    throw new LegoCheckedException("createBlob Exception.");
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
            }
            DBOperationUtil.closeSession(session);
            return blob;
        }
        DBOperationUtil.closeSession(session);
        return null;
    }

    private String getTmpFile() {
        String lrPath = PathUtil.getLegoRuntimePath();
        return lrPath + File.separator + LIC_FILES_TMP;
    }

    private void deleteLicenseFile(File file) {
        try {
            if (file != null && file.exists()) {
                boolean result = file.delete();
                LOGGER.debug((Object)"Delete license file: %s", new Object[]{result});
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Delete license file exception: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("delete license file exception.");
        }
    }

    private long getLicDeadlineTime(String runtime) {
        LOGGER.debug((Object)"GetLicDeadlineTime: %s", new Object[]{runtime});
        return 0L;
    }

    private void constructFeatureInfo(LicLkStore lkStore, Map<String, FeatureBo> featureMap, String fileEsn) {
        String feaRunTime = ((LicLkStoreBbom)lkStore.getBboms().get(0)).getTimeInfo().getValidInfo().getDeadLine();
        for (int i = 0; i < lkStore.getBboms().size(); ++i) {
            FeatureBo featureInfo;
            LicLkStoreBbom item = (LicLkStoreBbom)lkStore.getBboms().get(i);
            if (featureMap.containsKey(item.getFeatureName())) {
                featureInfo = featureMap.get(item.getFeatureName());
            } else {
                featureInfo = new FeatureBo();
                featureInfo.setFeaname(item.getFeatureName());
                featureInfo.setEsn(fileEsn);
                featureInfo.setOverTime(feaRunTime);
                featureInfo.setReslst(new ArrayList());
                featureInfo.setFunclst(new ArrayList());
                featureMap.put(item.getFeatureName(), featureInfo);
            }
            if (item.getType() == LicLkBbomTypeEnum.ALM_LIC_BBOM_FUNCTION) {
                FunctionItemBo fib = new FunctionItemBo();
                fib.setFeatureName(item.getFeatureName());
                fib.setFunctionItemName(item.getBbomName());
                fib.setValue("" + item.getValue());
                fib.setOverTime(feaRunTime);
                featureInfo.getFunclst().add(fib);
                continue;
            }
            if (item.getType() != LicLkBbomTypeEnum.ALM_LIC_BBOM_RESOURCE) continue;
            ResourceItemBo rib = new ResourceItemBo();
            rib.setFeatureName(item.getFeatureName());
            rib.setItemName(item.getBbomName());
            rib.setItemValue("" + item.getValue());
            rib.setOverTime(feaRunTime);
            featureInfo.getReslst().add(rib);
        }
    }

    private void checkResList(List<FeatureBo> features) {
        if (features == null || features.isEmpty()) {
            throw new LegoCheckedException(1073947422L);
        }
        FeatureBo fo = features.get(0);
        if (fo == null) {
            throw new LegoCheckedException(1073947422L);
        }
        if (fo.getReslst() == null || fo.getReslst().isEmpty()) {
            throw new LegoCheckedException(1073947422L);
        }
    }

    private void handleFeatures(List<FeatureBo> features) {
        Iterator<FeatureBo> featuresInter = features.iterator();
        while (featuresInter.hasNext()) {
            FeatureBo featureItem = featuresInter.next();
            if ("80021997".equals(featureItem.getFeaname())) {
                featuresInter.remove();
            }
            if (!"81700681".equals(featureItem.getFeaname())) continue;
            featuresInter.remove();
        }
    }

    private List<FeatureBo> createFeatureList(LicLkStore lkStore) {
        ArrayList<FeatureBo> features;
        HashMap<String, FeatureBo> featureMap = new HashMap<String, FeatureBo>();
        if (lkStore != null) {
            String fileEsn = (String)lkStore.getGeneral().getEsns().get(0);
            this.constructFeatureInfo(lkStore, featureMap, fileEsn);
        }
        if ((features = new ArrayList<FeatureBo>(featureMap.values())).size() > 1) {
            this.handleFeatures(features);
        }
        return features;
    }

    public LicenseInfoBo convert2LicBo(byte[] licFile) {
        List<FeatureBo> features;
        String softId;
        String proVersion;
        String proName;
        String fileSn;
        LicenseInfoBo licenseBo;
        String feaRunTime = null;
        try {
            licenseBo = new LicenseInfoBo();
            LOGGER.info((Object)"Check licFile size: %s", (long)licFile.length);
            LicLkStore lkStore = this.almOperService.licGeneralQuery(0);
            if (lkStore == null) {
                LOGGER.error((Object)"Convert2LicBo lkStore is null.");
                throw new LegoCheckedException("convert2LicBo lkStore is null.");
            }
            fileSn = (String)lkStore.getGeneral().getEsns().get(0);
            proName = lkStore.getGeneral().getFilePrdName();
            proVersion = lkStore.getGeneral().getFilePrdVer();
            softId = lkStore.getGeneral().getSoftId();
            if (!VerifyUtil.isEmpty((Collection)lkStore.getBboms())) {
                feaRunTime = ((LicLkStoreBbom)lkStore.getBboms().get(0)).getTimeInfo().getValidInfo().getDeadLine();
            }
            features = this.createFeatureList(lkStore);
            this.checkResList(features);
        }
        catch (LicenseException e) {
            LOGGER.error((Object)"Convert2LicBo LicenseException: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("convert2LicBo LicenseException.");
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"LicGeneralQuery in convert2LicBo failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("licGeneralQuery in convert2LicBo failed.");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unknown LicenseException in convert2LicBo: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Unknown LicenseException in convert2LicBo.");
        }
        licenseBo.setFeaBolst(features);
        licenseBo.setProductESN(fileSn);
        licenseBo.setProductName(proName);
        licenseBo.setProductVers(proVersion);
        licenseBo.setFile(licFile);
        licenseBo.setDeadlineTime(Long.valueOf(this.getLicDeadlineTime(feaRunTime)));
        licenseBo.setSoftId(softId);
        return licenseBo;
    }
}

