/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.calculator.sdk.service.IRecoveryTimeObjectiveCalculator;
import com.huawei.ism.drm.protection.checker.sdk.service.IProtectionChecker;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RecoveryTimeObjectiveChecker
implements IProtectionChecker {
    private static final Log logger = LogFactory.getInstance(RecoveryTimeObjectiveChecker.class);
    private static RecoveryTimeObjectiveChecker rtoChecker = new RecoveryTimeObjectiveChecker();
    private Map<String, IRecoveryTimeObjectiveCalculator> rtoCalculators = new HashMap<String, IRecoveryTimeObjectiveCalculator>();

    private RecoveryTimeObjectiveChecker() {
    }

    public static RecoveryTimeObjectiveChecker getInstance() {
        return rtoChecker;
    }

    public Map<String, Object> check(ProtectGroup protectGroup) {
        if (protectGroup == null) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String templateType = String.valueOf(protectGroup.getTemplate().getType());
        IRecoveryTimeObjectiveCalculator rtoCalculator = this.rtoCalculators.get(templateType);
        if (rtoCalculator == null) {
            logger.debug((Object)"IRecoveryTimeObjectiveCalculator is null! templateType[%s],protectGroup name:%s", new Object[]{templateType, protectGroup.getName(), 1073947393L});
            return new HashMap<String, Object>();
        }
        Map results = rtoCalculator.calculate(protectGroup);
        return results;
    }

    public String getName() {
        return RecoveryTimeObjectiveChecker.class.getName();
    }

    public void onBind(IRecoveryTimeObjectiveCalculator calculator, Map<?, ?> properties) {
        if (calculator == null || VerifyUtil.isEmpty((Collection)calculator.getTypes())) {
            return;
        }
        for (String supportedType : calculator.getTypes()) {
            this.rtoCalculators.put(supportedType, calculator);
        }
    }

    public void onUnbind(IRecoveryTimeObjectiveCalculator calculator, Map<?, ?> properties) {
        for (String supportedType : calculator.getTypes()) {
            this.rtoCalculators.remove(supportedType);
        }
    }

    protected IRecoveryTimeObjectiveCalculator getRTOCalculatorByType(String type) {
        return this.rtoCalculators.get(type);
    }
}

