/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.job;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.job.AbstractDrmQuartzJob;
import com.huawei.ism.drm.protection.checker.job.IJobExecutionContextAWare;
import com.huawei.ism.drm.protection.checker.manager.RateConfigServiceManager;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.template.sdk.service.IRateConfigService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.List;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;

public class ProtectionSyncRateJob
extends AbstractDrmQuartzJob {
    private static final Log logger = LogFactory.getInstance(ProtectionSyncRateJob.class);
    private Trigger quartzTrigger;
    private JobDataMap quartzJobDataMap;
    private List<ProtectGroupSyncRatePolicy> pgSyncRatePolicys;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            this.init(context);
            int rateLevel = ProtectGroupUtil.getRateLevel(this.pgSyncRatePolicys);
            ProtectGroup pg = this.pgSyncRatePolicys.get(0).getProtectGroup();
            pg = this.getSyncPg(pg.getUuid());
            if (VerifyUtil.isEmpty((Object)pg)) {
                logger.error((Object)("pg is empty, all try times" + pg.getUuid()));
                return;
            }
            logger.debug((Object)("syncRatePolicy excute,pg name:" + (VerifyUtil.isEmpty((String)pg.getName()) ? " " : pg.getName())));
            String type = Integer.toString(pg.getTemplate().getType());
            IRateConfigService service = RateConfigServiceManager.getInstance().getReplicaConfigService(type);
            if (null == service) {
                logger.error((Object)("cant get the rateconfigservice:type=" + type));
            } else {
                if (service instanceof IJobExecutionContextAWare) {
                    IJobExecutionContextAWare aware = (IJobExecutionContextAWare)service;
                    aware.setJobExecutionContext(context);
                }
                DmEnumDefine.SpeedLevelE speedLevel = DmEnumDefine.SpeedLevelE.valueOf((Integer)rateLevel);
                service.modifyRate(speedLevel, pg, this.pgSyncRatePolicys.get(0).getProtectLocation());
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("syncRatePolicy excute Fail,pg name:" + (VerifyUtil.isEmpty((String)this.pgSyncRatePolicys.get(0).getProtectGroup().getName()) ? " " : this.pgSyncRatePolicys.get(0).getProtectGroup().getName())), (Throwable)e);
        }
    }

    private void init(JobExecutionContext jobExecutionContext) {
        this.quartzTrigger = jobExecutionContext.getTrigger();
        this.quartzJobDataMap = this.quartzTrigger.getJobDataMap();
        char protectLocation = this.quartzTrigger.getJobKey().getName().charAt(this.quartzTrigger.getJobKey().getName().length() - 1);
        Object syncRateObj = this.quartzJobDataMap.get((Object)("SyncRateTask" + protectLocation));
        if (syncRateObj == null) {
            logger.error((Object)("pgSyncRatePolicys is null! protectLocation:" + protectLocation));
            throw new LegoCheckedException(1073947394L);
        }
        this.pgSyncRatePolicys = (List)syncRateObj;
        Boolean isFirstTime = (Boolean)this.quartzJobDataMap.get((Object)"isFirstTime");
        if (!VerifyUtil.isEmpty((Object)isFirstTime) && isFirstTime.booleanValue()) {
            CommonUtil.sleep((long)180000L);
        }
        logger.debug((Object)"syncRatePolicy excute,pg location:%s", new Object[]{VerifyUtil.isEmpty((Object)Character.valueOf(protectLocation)) ? " " : Character.valueOf(protectLocation)});
    }

    private ProtectGroup getSyncPg(String pgid) {
        ProtectGroup pg = null;
        for (int count = 0; count <= 3; ++count) {
            try {
                pg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(pgid);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("pg is query error" + pgid), (Throwable)e);
            }
            if (VerifyUtil.isEmpty((Object)pg)) {
                logger.error((Object)("pg is empty " + pgid));
                CommonUtil.sleep((long)10000L);
                continue;
            }
            return pg;
        }
        return pg;
    }
}

