/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.executor;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class FixedProtectionThreadPool {
    private static final Log logger = LogFactory.getInstance(FixedProtectionThreadPool.class);
    private static final int PROTECT_EXECUTEOR_NUMBER = 50;
    private static final int PROTECT_MAX_EXECUTE_NUMBER = 4;
    private static Map<FixedProtectionThreadPoolEnum, ExecutorService> allExecutorServices = new ConcurrentHashMap<FixedProtectionThreadPoolEnum, ExecutorService>(4, 1.0f);

    private FixedProtectionThreadPool() {
    }

    public static <T> Future<T> submit(FixedProtectionThreadPoolEnum executorType, Callable<T> callable) {
        return FixedProtectionThreadPool.submit(executorType, callable, 50);
    }

    public static synchronized <T> Future<T> submit(FixedProtectionThreadPoolEnum executorType, Callable<T> callable, int executorNumber) {
        if (VerifyUtil.isEmpty((Object)allExecutorServices.get((Object)executorType))) {
            if (allExecutorServices.keySet().size() >= 4) {
                logger.error((Object)("there is no executorName:" + executorType.name()), 1073947394L);
                throw new LegoCheckedException(1073947394L);
            }
            logger.info((Object)"add executor named :%s", new Object[]{executorType.name()});
            allExecutorServices.put(executorType, Executors.newFixedThreadPool(executorNumber));
        }
        return allExecutorServices.get((Object)executorType).submit(callable);
    }

    public static Future<Boolean> submit(Callable<Boolean> callable) {
        return FixedProtectionThreadPool.submit(FixedProtectionThreadPoolEnum.PROTECT_EXECUTOR, callable, 50);
    }

    public static enum FixedProtectionThreadPoolEnum {
        PROTECT_EXECUTOR,
        POLICY_TEMPLATE_EXECUTOR,
        PROTECT_MONITOR_EXECUTOR,
        PROTECT_DELETE_REPLICA_EXECUTOR;

    }
}

