/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.job;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.task.sdk.model.BaseTask;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public class ProtectionQuartzTriggerListener
implements TriggerListener {
    private static final Log logger = LogFactory.getInstance(ProtectionQuartzTriggerListener.class);
    private int fired = 0;
    private int misfired = 1;

    public String getName() {
        return "ProtectionQuartzTriggerListener";
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        logger.info((Object)"trigger completed", 90160758784000L);
    }

    public void triggerFired(Trigger trigger, JobExecutionContext jobExecutionContext) {
        JobDataMap dataMap = trigger.getJobDataMap();
        BaseTask pTask = (BaseTask)dataMap.get((Object)"TASK");
        this.info(pTask, this.fired);
    }

    public void triggerMisfired(Trigger trigger) {
        JobDataMap jobDataMap = trigger.getJobDataMap();
        ProtectionTask pTask = (ProtectionTask)jobDataMap.get((Object)"TASK");
        this.info((BaseTask)pTask, this.misfired);
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        return this.checkNextExecTime(trigger) != false;
    }

    private Boolean checkNextExecTime(Trigger trigger) {
        long currentTimeMilli;
        Date currentTime = new Date();
        JobDataMap dataMap = trigger.getJobDataMap();
        BaseTask pTask = (BaseTask)dataMap.get((Object)"TASK");
        long nextExecTime = VerifyUtil.isEmpty((String)pTask.getNextExecTime()) ? 0L : Long.parseLong(pTask.getNextExecTime());
        if (nextExecTime > (currentTimeMilli = System.currentTimeMillis()) + 15000L) {
            StringBuilder sb = new StringBuilder();
            sb.append("[veto to execute job]task uuid[").append(pTask.getTaskGroup()).append("]. Because nextExecTime[").append(new Date(nextExecTime)).append("[").append(nextExecTime).append("]").append("] is after currentTime[").append(currentTime).append("][").append(currentTimeMilli).append("](").append(currentTime.getTime()).append("), so will not to execute job!");
            logger.warn((Object)sb.toString(), 90160758784000L);
            return true;
        }
        return false;
    }

    private void info(BaseTask pTask, int fireType) {
        if (pTask == null) {
            logger.error((Object)"pTask is null!", 90160758784001L);
            return;
        }
        ISchedule schedule = pTask.getSchedule();
        if (schedule == null) {
            logger.error((Object)"schedule is null!", 90160758784001L);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("task uuid:" + pTask.getTaskGroup()).append("scheduleId : " + schedule.getScheduleId() + ", scheduleMode : " + schedule.getScheduleMode()).append("LastExecTime:" + this.convertStrToDate(pTask.getLastExecTime()) + ", nextExecTime:" + this.convertStrToDate(pTask.getNextExecTime()) + ", currentTime:" + new Date());
        if (fireType == this.misfired) {
            sb.insert(0, "[trigger misfired]");
            logger.warn((Object)sb.toString(), 90160758784001L);
        } else {
            sb.insert(0, "[trigger fired]");
            logger.info((Object)sb.toString(), 90160758784000L);
        }
    }

    private Date convertStrToDate(String timeStr) {
        if (VerifyUtil.isEmpty((String)timeStr)) {
            return null;
        }
        return new Date(CommUtil.convertToLong((Object)timeStr));
    }
}

