/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.cbb.util.OppoField;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ProtectActionConvert {
    private static final String METHOD_HEAD_GET_BOOLEAN = "is";
    private static final String METHOD_HEAD_GET = "get";
    private static final String METHOD_HEAD_SET = "set";
    private static Map<String, Object> defaultValueMap = new HashMap<String, Object>();
    private static final Log logger = LogFactory.getInstance(ProtectActionConvert.class);

    private ProtectActionConvert() {
    }

    public static void actionConvert(Object from, Object to) {
        Field[] fields;
        Class<AbstractBaseProtectAction> clazz = AbstractBaseProtectAction.class;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            if (!field.isAnnotationPresent(OppoField.class)) continue;
            OppoField oAnnotation = field.getAnnotation(OppoField.class);
            Method toMethod = ProtectActionConvert.getMethodName(to, oAnnotation.fieldName(), METHOD_HEAD_SET, oAnnotation.fieldType());
            Method fromMethod = Boolean.class.getName().equals(field.getType().getName()) || Boolean.TYPE.getName().equals(field.getType().getName()) ? ProtectActionConvert.getMethodName(from, fieldName, METHOD_HEAD_GET_BOOLEAN, new Class[0]) : ProtectActionConvert.getMethodName(from, fieldName, METHOD_HEAD_GET, new Class[0]);
            Object value = ProtectActionConvert.invokeMethd(from, fromMethod, new Object[0]);
            if (value == null) {
                value = defaultValueMap.get(field.getType().getName());
            }
            ProtectActionConvert.invokeMethd(to, toMethod, value);
        }
    }

    private static Method getMethodName(Object obj, String fieldName, String methodType, Class<?> ... parameterTypes) {
        StringBuilder methodName = new StringBuilder();
        methodName.append(methodType);
        methodName.append(fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH));
        methodName.append(fieldName.substring(1, fieldName.length()));
        try {
            return obj.getClass().getMethod(methodName.toString(), parameterTypes);
        }
        catch (Exception e) {
            logger.error((Object)("Convert field error, field name is: " + fieldName), 0x300001L);
            return null;
        }
    }

    private static Object invokeMethd(Object tag, Method method, Object ... args) {
        if (method == null) {
            logger.debug((Object)"method null,not invoke Methd.");
            return null;
        }
        try {
            return method.invoke(tag, args);
        }
        catch (Exception e) {
            logger.error((Object)("Convert field error, method name is: " + method.getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 0x300001L);
            return null;
        }
    }

    static {
        defaultValueMap.put("java.lang.String", "");
        defaultValueMap.put("java.lang.Integer", 0);
        defaultValueMap.put("java.lang.int", 0);
        defaultValueMap.put("java.lang.Double", 0.0);
        defaultValueMap.put("java.lang.double", 0.0);
        defaultValueMap.put("java.lang.Long", 0L);
        defaultValueMap.put("java.lang.long", 0L);
        defaultValueMap.put("java.lang.Byte", 0);
        defaultValueMap.put("java.lang.byte", 0);
        defaultValueMap.put("java.lang.Boolean", false);
        defaultValueMap.put("java.lang.boolean", false);
    }
}

