/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.bean.AlarmParameter;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleRangeTime;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.AbstractTrigger;

public final class ProtectionJobUtil {
    public static final String PROTECTION_QUARTZ_TRIGGER_LISTENER = "ProtectionQuartzTriggerListener";
    public static final String PROTECTION_HYPERVAULT_JOBID = "HyperVaultJobId";
    private static final Log logger = LogFactory.getInstance(ProtectionJobUtil.class);
    private static final List<Integer> ASYN_REPLICATION_TEMPLATE_TYPES = Arrays.asList(1, 3, 4, 5, 6, 17, 18, 20, 22, 28, 30, 31, 32, 33, 35, 36);
    private static final List<Integer> CHECK_HYPERMETRO_MASTER_LUN = Arrays.asList(19, 18, 28, 31, 26);
    private static final long MAX_TIME_OUT = 0x6DDD00L;
    private static Set<String> moKeySet = new HashSet<String>();
    private static ProtectionJobUtil jobUtil = new ProtectionJobUtil();

    private ProtectionJobUtil() {
    }

    public static ProtectionJobUtil getInstance() {
        return jobUtil;
    }

    public synchronized boolean getLockPg(String pgId) {
        if (moKeySet.contains(pgId)) {
            logger.debug((Object)"get lock failed!,pgId:%s", new Object[]{pgId});
            return false;
        }
        logger.info((Object)"get lock success!,pgId:%s", new Object[]{pgId});
        moKeySet.add(pgId);
        return true;
    }

    public boolean isPgLocked(String pgId) {
        return moKeySet.contains(pgId);
    }

    public boolean getLockPg(String pgId, long time, String flagName) {
        boolean lockFlag = false;
        long startTime = System.currentTimeMillis();
        logger.info((Object)"begin to try get lock.  flagName %s", new Object[]{flagName});
        while (!lockFlag) {
            long curTime = System.currentTimeMillis();
            if (time <= curTime - startTime) {
                logger.error((Object)("get lock with protectgroup time out. " + pgId + " flagName " + flagName), 90160758784001L);
                return lockFlag;
            }
            CommUtil.pauseThread((long)1000L);
            lockFlag = this.getLockPg(pgId);
        }
        return lockFlag;
    }

    public boolean getLockPg(String pgId, long time) {
        return this.getLockPg(pgId, time, "");
    }

    public synchronized void releaseLockPg(String pgId) {
        if (moKeySet.contains(pgId)) {
            logger.info((Object)"release lock success!,pgId:%s", new Object[]{pgId});
            moKeySet.remove(pgId);
        }
    }

    public void genetateAlarm(AlarmParameter param) {
        logger.debug((Object)"genetateAlarm %s", new Object[]{param.getGroupName()});
        AlarmReporter.generatePolicyUnknowErrorAlarm(param.getPgId(), param.getGroupName());
    }

    public String getSiteName(String siteId) {
        String result = "";
        if (VerifyUtil.isEmpty((String)siteId)) {
            return result;
        }
        try {
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
            if (null != site) {
                result = site.getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)("get Sitename error:" + siteId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return result;
    }

    public String getResourceName(String arraySN) {
        String result = "";
        if (VerifyUtil.isEmpty((String)arraySN)) {
            return result;
        }
        try {
            DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(arraySN);
            if (resource != null) {
                result = resource.getName();
            }
        }
        catch (Exception e) {
            logger.error((Object)("get arrayname error:" + arraySN + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return result;
    }

    public IProtectGroupService getProtectGroupService() {
        IProtectGroupService protectGroupService = null;
        for (int i = 0; i < 100; ++i) {
            try {
                IProtectGroupService pgService;
                protectGroupService = pgService = (IProtectGroupService)ServiceContext.getInstance().lookup("DRM_Base/com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService");
                break;
            }
            catch (Exception e) {
                logger.error((Object)("get protection group service failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                continue;
            }
        }
        return protectGroupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateProtectGroupStartStatus(ProtectGroup pg) {
        Session session;
        block7: {
            if (VerifyUtil.isEmpty((String)pg.getUuid())) {
                logger.debug((Object)"pd ID is empty,not update ProtectGroup startStatus");
                return;
            }
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String sql = "UPDATE ti_protectgroup SET STATUS=:status, LASTEXECTIME=:lastExecTime WHERE PGID=:pgid";
                session.beginTransaction();
                NativeQuery query = session.createSQLQuery(sql);
                query.setInteger("status", pg.getStatus());
                query.setLong("lastExecTime", pg.getLastExecTime().longValue());
                query.setString("pgid", pg.getUuid());
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (1 == updateResult) break block7;
                logger.error((Object)"updatePrtectGroupStartStatus failed!", 90160758786989L);
                throw new LegoCheckedException(-1L);
            }
            catch (LegoCheckedException e) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters(), (Log)logger);
                DBOperationUtil.closeSession(session);
            }
            catch (Exception ex) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"updateProtectGroupEndStatus failed!", (long)-1L, (String[])new String[0], (Log)logger);
                {
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void updateProtectGroupEndStatus(ProtectGroup pg) {
        Session session;
        block7: {
            if (VerifyUtil.isEmpty((String)pg.getUuid())) {
                logger.debug((Object)"pd ID is empty,not update ProtectGroup EndStatus");
                return;
            }
            session = null;
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String sql = "UPDATE ti_protectgroup SET STATUS=:status, PG_REPLICA_INDEX=:index, LASTEXECTIME=:lastExecTime, LAST_EXEC_RESULT=:lastExecResult, LAST_EXEC_ERROR_RESULT=:lastExecErrorDetail, LAST_EXEC_PARAM=:lastExecParam where PGID=:pgid";
                session.beginTransaction();
                NativeQuery query = session.createSQLQuery(sql);
                query.setInteger("status", pg.getStatus());
                query.setInteger("index", pg.getPgReplicaIndex());
                query.setParameter("lastExecTime", (Object)pg.getLastExecTime());
                query.setParameter("lastExecResult", (Object)pg.getLastExecResult());
                query.setParameter("lastExecErrorDetail", (Object)pg.getLastExecErrorDetail());
                query.setParameter("lastExecParam", (Object)pg.getLastExecParam());
                query.setString("pgid", pg.getUuid());
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (1 == updateResult) break block7;
                logger.error((Object)"updateProtectGroupEndStatus failed!", 90160758786989L);
                throw new LegoCheckedException(-1L);
            }
            catch (LegoCheckedException e) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters(), (Log)logger);
                DBOperationUtil.closeSession(session);
            }
            catch (Exception ex) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"updateProtectGroupEndStatus failed!", (long)-1L, (String[])new String[0], (Log)logger);
                {
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
    }

    public void updatePrtectGroupReplicaStatus(ProtectGroupReplica pgReplica) {
        if (VerifyUtil.isEmpty((Object)pgReplica)) {
            return;
        }
        ProtectGroupReplica replica = (ProtectGroupReplica)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(ProtectGroupReplica.class, (Serializable)((Object)pgReplica.getId()));
        if (null != replica) {
            replica.setStatus(pgReplica.getStatus());
            replica.setTimeStamp(pgReplica.getTimeStamp());
            ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).updateProtectGroupReplica(replica);
            return;
        }
        logger.error((Object)("replica is not existed! pgReplicaId:" + pgReplica.getId()));
    }

    public boolean isTimeAvailable(ProtectionTask task) {
        if (VerifyUtil.isEmpty((Object)task)) {
            return false;
        }
        if (null != task.getNextExecTime() && new Date(NumberUtil.convertToLong((Object)task.getNextExecTime())).after(new Date())) {
            logger.debug((Object)"no need to execute, next exec time=%s", new Object[]{task.getNextExecTime()});
            return false;
        }
        return true;
    }

    public boolean isTimeInRange(ISchedule schedule, Date execStartTime) {
        Set scheduleRanges = schedule.getScheduleRanges();
        if (VerifyUtil.isEmpty((Collection)scheduleRanges)) {
            logger.debug((Object)"schedule Ranges not set.");
            return true;
        }
        for (ScheduleRangeTime us : scheduleRanges) {
            logger.debug((Object)"Schedule Range check: now time:%s undoStartTime:%s undoEndTime: undoEndTime:", new Object[]{Calendar.getInstance().getTime(), us.getStartTime(), us.getEndTime()});
            if (!this.isInRangeTime(us, execStartTime)) continue;
            logger.debug((Object)"Schedule Range check is in range.", 90160758784001L);
            return true;
        }
        logger.warn((Object)("Schedule Range check has not in range. scheduleId:" + schedule.getScheduleId()), 90160758784001L);
        return false;
    }

    private boolean isInRangeTime(ScheduleRangeTime us, Date execStartTime) {
        logger.debug((Object)"isInRangeTime");
        Calendar calendar = Calendar.getInstance();
        Calendar tempNow = Calendar.getInstance();
        Calendar tempDatebase = Calendar.getInstance();
        tempNow.setTime(execStartTime);
        calendar.set(6, tempNow.get(6));
        calendar.set(11, tempNow.get(11));
        calendar.set(12, tempNow.get(12));
        calendar.set(13, 0);
        Date now = calendar.getTime();
        tempDatebase.setTime(us.getStartTime());
        calendar.set(6, tempNow.get(6));
        calendar.set(11, tempDatebase.get(11));
        calendar.set(12, tempDatebase.get(12));
        calendar.set(13, 0);
        Date start = calendar.getTime();
        tempDatebase.setTime(us.getEndTime());
        if (tempDatebase.get(12) == 59) {
            calendar.set(6, tempNow.get(6) + 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
        } else {
            calendar.set(6, tempNow.get(6));
            calendar.set(11, tempDatebase.get(11));
            calendar.set(12, tempDatebase.get(12));
        }
        calendar.set(13, 0);
        Date end = calendar.getTime();
        return now.after(start) && now.before(end) || now.equals(start) || now.equals(end);
    }

    public boolean isStatusAvailable(ProtectGroup pg) {
        logger.debug((Object)"isStatusAvailable");
        int status = pg.getStatus();
        boolean isStatusAvailable = DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus() == status || DrmEnumDefine.ProtectGroupStatus.RUNNING.getStatus() == status;
        return isStatusAvailable;
    }

    public ProtectGroupLogDetail createActionLog(String detailId, String stepTitle, Date startTime) {
        logger.debug((Object)"createActionLog");
        ProtectGroupLogDetail historyDetailLog = new ProtectGroupLogDetail();
        if (VerifyUtil.isEmpty((String)detailId)) {
            historyDetailLog.setDetailId(UUIDGenerator.getUUID());
        } else {
            historyDetailLog.setDetailId(detailId);
        }
        historyDetailLog.setTitle(stepTitle);
        historyDetailLog.setStartTime(String.valueOf(startTime.getTime()));
        historyDetailLog.setInfo("--");
        historyDetailLog.setProtectionLogDetails(new HashSet());
        return historyDetailLog;
    }

    public void checkIsNeedLock(String pgId) {
        boolean lockFlag = false;
        long startTime = System.currentTimeMillis();
        logger.info((Object)"begin to try get lock. ", 90160758784001L);
        while (!lockFlag) {
            long curTime = System.currentTimeMillis();
            if (0x6DDD00L <= curTime - startTime) {
                logger.error((Object)"get lock with protectgroup time out. ", 90160758784001L);
                throw new LegoCheckedException(1073947433L);
            }
            CommUtil.pauseThread((long)1000L);
            lockFlag = this.getLockPg(pgId);
        }
    }

    public AlarmParameter createAlarm(ActionContext actionContext, ProtectGroup pg) {
        AlarmParameter alarmParam = new AlarmParameter();
        alarmParam.setPgId(pg.getUuid());
        alarmParam.setProtectSiteId(pg.getProductSiteId());
        alarmParam.setGroupName(pg.getName());
        logger.debug((Object)"createAlarm%s", new Object[]{pg.getName()});
        return alarmParam;
    }

    public boolean getFreezeFlag(String freezeFlag) {
        int flag = 1;
        if (VerifyUtil.isEmpty((String)freezeFlag)) {
            logger.error((Object)"freezeFlag for  protectGroup is null.", 1073947393L);
        } else {
            try {
                flag = Integer.parseInt(freezeFlag);
            }
            catch (Exception e) {
                logger.error((Object)"freezeFlag for  protectGroup is null.", 1073947393L);
            }
        }
        return flag != 0;
    }

    public static boolean checkWhetherTerminateTask(ActionContext context) {
        Object pgObj = context.getObject("PG_ENTITY");
        Object pgReplicaObj = context.getObject("PG_REPLICA_ENTITY");
        if (!(pgObj instanceof ProtectGroup)) {
            logger.error((Object)"protect group from context is null!", 90160758784001L);
            return false;
        }
        if (!(pgReplicaObj instanceof ProtectGroupReplica)) {
            logger.error((Object)"ProtectGroupReplica from context is null!", 90160758784001L);
            return false;
        }
        ProtectGroup protectGroup = (ProtectGroup)pgObj;
        ProtectGroupReplica pgReplica = (ProtectGroupReplica)pgReplicaObj;
        PolicyTemplate template = protectGroup.getTemplate();
        if (!ASYN_REPLICATION_TEMPLATE_TYPES.contains(template.getType())) {
            logger.debug((Object)"the template type [%s] is not allowed to teminate task!", (long)template.getType());
            return false;
        }
        Schedule autoSchedule = ProtectionJobUtil.getAutoScheduleByProtectlocation(pgReplica, template);
        if (autoSchedule == null) {
            logger.debug((Object)"The autoSchedule is null, so will not to teminate task!", 90160758784000L);
            return false;
        }
        String abortTaskTime = autoSchedule.getAbortTaskTime();
        if (VerifyUtil.isEmpty((String)abortTaskTime) || autoSchedule.getPeriodType() != 2) {
            logger.debug((Object)"The abortTaskTime[%s] is null, or periodType[%s] is not the day type!, so will not to teminate task!", new Object[]{abortTaskTime, autoSchedule.getPeriodType()});
            return false;
        }
        if (ProtectionJobUtil.checkStartTime(autoSchedule)) {
            return false;
        }
        return ProtectionJobUtil.checkIsBeyongTheAbortTime(autoSchedule, abortTaskTime);
    }

    private static boolean checkStartTime(Schedule autoSchedule) {
        String hours = autoSchedule.getHours();
        if (VerifyUtil.isEmpty((String)hours)) {
            logger.debug((Object)"hours is null, so will not to teminate task!", 90160758784000L);
            return true;
        }
        String[] hourArray = hours.split(",");
        if (hourArray.length != 1) {
            logger.debug((Object)"hours[%s] size is not one, so will not to teminate task!", new Object[]{hours});
            return true;
        }
        return false;
    }

    private static boolean checkIsBeyongTheAbortTime(Schedule autoSchedule, String abortTaskTime) {
        String[] hourMinute = abortTaskTime.split(":");
        if (hourMinute.length != 2) {
            logger.error((Object)("abortTaskTime is not legal! abortTaskTime :" + abortTaskTime), 90160758784001L);
            return false;
        }
        Calendar nowCalendar = Calendar.getInstance();
        Calendar startTimeCalendar = Calendar.getInstance();
        Date now = new Date();
        nowCalendar.setTime(now);
        String hours = autoSchedule.getHours();
        String minutes = autoSchedule.getMinutes();
        startTimeCalendar.set(6, nowCalendar.get(6));
        startTimeCalendar.set(11, CommUtil.convertToInteger((Object)hours));
        startTimeCalendar.set(12, CommUtil.convertToInteger((Object)minutes));
        startTimeCalendar.set(13, 0);
        Calendar abortTaskTimeCalendar = Calendar.getInstance();
        String abortMinute = hourMinute[1];
        String abortHour = hourMinute[0];
        abortTaskTimeCalendar.set(6, nowCalendar.get(6));
        abortTaskTimeCalendar.set(11, CommUtil.convertToInteger((Object)abortHour));
        abortTaskTimeCalendar.set(12, CommUtil.convertToInteger((Object)abortMinute));
        abortTaskTimeCalendar.set(13, 0);
        Date startDate = startTimeCalendar.getTime();
        Date abortDate = abortTaskTimeCalendar.getTime();
        return startDate.before(abortDate) ? abortDate.before(now) || now.before(startDate) : abortDate.before(now) && now.before(startDate);
    }

    private static Schedule getAutoScheduleByProtectlocation(ProtectGroupReplica pgReplica, PolicyTemplate template) {
        logger.debug((Object)"getAutoScheduleByProtectlocation");
        Schedule autoSchedule = null;
        Set schedules = template.getSchedules();
        for (Schedule sch : schedules) {
            if (sch.getScheduleMode() != 0 || pgReplica.getProtectLocation() != sch.getProtectLocation()) continue;
            autoSchedule = sch;
            break;
        }
        return autoSchedule;
    }

    public void resetNextExecuteTime(ISchedule schedule, Date startTime, Scheduler quartzScheduler, Trigger quartzTrigger) {
        Date nextStartDate = this.getNextExeTimeWhenOutOfTimeRange(schedule, startTime);
        try {
            ((AbstractTrigger)quartzTrigger).setStartTime(nextStartDate);
            logger.info((Object)"reset next execution time successfully! Next execution time is %s", new Object[]{nextStartDate});
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"setStartTime error!", (long)1073948179L, null, (Log)logger);
        }
        try {
            quartzScheduler.rescheduleJob(new TriggerKey(quartzTrigger.getKey().getName(), quartzTrigger.getKey().getGroup()), quartzTrigger);
        }
        catch (SchedulerException e) {
            logger.error((Object)"rescheduleJob error!", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(1073948179L, (Throwable)e);
        }
        throw new LegoCheckedException(1073948179L);
    }

    public Date getNextExeTimeWhenOutOfTimeRange(ISchedule schedule, Date startTime) {
        logger.debug((Object)"getNextExeTimeWhenOutOfTimeRange");
        Set scheduleRanges = schedule.getScheduleRanges();
        Iterator iterator = scheduleRanges.iterator();
        ScheduleRangeTime scheduleRangeTime = (ScheduleRangeTime)iterator.next();
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.setTime(startTime);
        nowCalendar.set(13, 0);
        Calendar startTimeCalendar = Calendar.getInstance();
        startTimeCalendar.setTime(scheduleRangeTime.getStartTime());
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startTime);
        startCalendar.set(11, startTimeCalendar.get(11));
        startCalendar.set(12, startTimeCalendar.get(12));
        startCalendar.set(13, 0);
        int size = scheduleRanges.size();
        Date nextStartDate = this.getTimeRangeStartDate(schedule, startTime);
        if (size == 1 && startCalendar.getTime().before(nowCalendar.getTime())) {
            Calendar newNextStartCalendar = Calendar.getInstance();
            newNextStartCalendar.setTime(nextStartDate);
            newNextStartCalendar.add(5, 1);
            nextStartDate = newNextStartCalendar.getTime();
        }
        return nextStartDate;
    }

    public Date getStartTimeInRangeTime(ISchedule schedule, Date startTime) {
        logger.debug((Object)"getStartTimeInRangeTime");
        Date timeRangeStartDate = this.getTimeRangeStartDate(schedule, startTime);
        Set scheduleRanges = schedule.getScheduleRanges();
        if (scheduleRanges.size() == 2 && startTime.before(timeRangeStartDate)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timeRangeStartDate);
            calendar.add(5, -1);
            return calendar.getTime();
        }
        return timeRangeStartDate;
    }

    private Date getTimeRangeStartDate(ISchedule schedule, Date startTime) {
        Date timeRangeStartDate = null;
        Set scheduleRanges = schedule.getScheduleRanges();
        int size = scheduleRanges.size();
        for (ScheduleRangeTime us : scheduleRanges) {
            Calendar nowCalendar = Calendar.getInstance();
            nowCalendar.setTime(startTime);
            Calendar endTimeCalendar = Calendar.getInstance();
            Calendar startTimeCalendar = Calendar.getInstance();
            Date endTime = us.getEndTime();
            Date stTime = us.getStartTime();
            endTimeCalendar.setTime(endTime);
            int min = endTimeCalendar.get(12);
            if ((min != 59 || size != 2) && size != 1) continue;
            startTimeCalendar.setTime(stTime);
            nowCalendar.set(11, startTimeCalendar.get(11));
            nowCalendar.set(12, startTimeCalendar.get(12));
            nowCalendar.set(13, 0);
            timeRangeStartDate = nowCalendar.getTime();
        }
        if (timeRangeStartDate == null) {
            logger.error((Object)"startDate is null!", 90160758784001L);
            throw new LegoCheckedException(1073948179L);
        }
        return timeRangeStartDate;
    }

    public void checkHyperMetro(ProtectGroup protectGroup, ActionContext context) {
    }
}

