/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupSyncRatePolicy;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.List;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class CreateProtectGroupTransaction
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(CreateProtectGroupTransaction.class);
    private CreateProtectGroupRefineService service = null;
    private ProtectGroup protectGroup = null;

    public CreateProtectGroupTransaction(CreateProtectGroupRefineService service, ProtectGroup protectGroup) {
        this.service = service;
        this.protectGroup = protectGroup;
    }

    public Object doInTransaction(TransactionStatus tstatus) {
        try {
            ProtectGroupHelper.getInstance().checkAndBuildReplica(this.protectGroup);
            this.protectGroup.setPrimary(true);
            if (!this.service.checkGroupName(null, this.protectGroup.getName())) {
                logger.error((Object)"Protect group name repeated!", 90160758787071L);
                throw new LegoCheckedException(1073947392L);
            }
            this.saveProtectLocationPath();
            CommonDAOLocator.getBaseDao().getHibernateTemplate().save((Object)this.protectGroup);
            this.service.getRetentionManager().createRetentionTask(this.protectGroup);
            this.grantProtectGroupToUser(this.protectGroup);
            ((IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class)).createTask(this.protectGroup);
            this.createSyncRate();
        }
        catch (LegoCheckedException le) {
            if (tstatus != null) {
                tstatus.setRollbackOnly();
            }
            ExceptionUtil.rethrowException((Throwable)le, (String)("failed to create protectgroup!" + this.protectGroup.getName()), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
        }
        catch (Exception t) {
            if (tstatus != null) {
                tstatus.setRollbackOnly();
            }
            ExceptionUtil.rethrowException((Throwable)t, (String)("failed to create protectgroup!" + this.protectGroup.getName()), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return null;
    }

    private void createSyncRate() {
        try {
            PolicyTemplate policyTemplate = this.protectGroup.getTemplate();
            List<ProtectGroupSyncRatePolicy> pgsrps = ProtectGroupUtil.convertToSyncRatePolicy(policyTemplate);
            this.service.getConfigSyncRateService().createSyncRateTask(this.protectGroup, pgsrps);
            this.service.getConfigSyncRateService().runAtOnce(this.protectGroup, pgsrps, false);
        }
        catch (Exception e) {
            logger.error((Object)("create sync rate task failed!" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    private void grantProtectGroupToUser(ProtectGroup protectGroupParam) {
        logger.debug((Object)"grantProtectGroupToUser");
        ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).addObject(protectGroupParam.getOwnerId(), new String[]{protectGroupParam.getUuid()});
    }

    private void saveProtectLocationPath() {
        TemplateFilterManager manager = TemplateFilterManager.getInstance();
        IPolicyTemplateFilter filter = manager.getTemplateFilterByType(this.protectGroup.getTemplate().getType());
        if (filter == null) {
            logger.error((Object)("The policyTemplateFilter is null! PtType = " + this.protectGroup.getTemplate().getType()), 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        List paths = filter.getProtectLocationPaths(new ArrayList(this.protectGroup.getPolist()));
        this.protectGroup.getProps().put("PROTECTGROUP_PROTECTLOCATIONPATH", JSONArray.fromObject((Object)paths).toString());
    }
}

