/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class DeleteCloneConsistentGroupObserver
implements IObjectObserver {
    private static final Log logger = LogFactory.getInstance(DeleteCloneConsistentGroupObserver.class);

    public void before(MessageEvent event) {
    }

    public void after(MessageEvent event) {
        List objectList = event.getObjectList();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject drmObj : objectList) {
            ProtectGroup protectGroup;
            if (!(drmObj instanceof ProtectGroup) || event.getMessageType() != 2 || (protectGroup = (ProtectGroup)drmObj).getTemplate().getType() != 16) continue;
            this.deleteCloneConsistentGroup(protectGroup.getUuid());
        }
    }

    private void deleteCloneConsistentGroup(String pgId) {
        try {
            String queryHQL = "from CloneConsistentGroup where pgId=?";
            HibernateTemplate hibernateTpl = CommonDAOLocator.getBaseDao().getHibernateTemplate();
            List cloneCGs = hibernateTpl.find(queryHQL, new Object[]{pgId});
            for (Object object : cloneCGs) {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().delete(object);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Delete cloen consistent group failed. PgId:" + pgId + "," + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

