/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

public class UpdateProtectGroupInfoTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(UpdateProtectGroupInfoTask.class);
    private ProtectGroupServiceImpl service;
    private IBaseDao<?, ?> callBackBaseDao;
    private ProtectGroup protectGroup;

    public UpdateProtectGroupInfoTask(ProtectGroupServiceImpl service, ProtectGroup protectGroup) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)protectGroup.getName(), (String)"ism.drm.protect.group.modify", (String)"System", (String)"", null), true);
        this.service = service;
        this.callBackBaseDao = service.getBaseDao();
        this.protectGroup = protectGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doWork() {
        Session session;
        block6: {
            session = null;
            try {
                session = this.callBackBaseDao.getHibernateTemplate().getSessionFactory().openSession();
                session.beginTransaction();
                String sql = "UPDATE ti_protectgroup SET PGNAME=:pgName,PGDESC=:desc WHERE PGID=:pgid";
                NativeQuery query = session.createSQLQuery(sql);
                query.setString("pgName", this.protectGroup.getName());
                query.setString("desc", this.protectGroup.getDescription());
                query.setString("pgid", this.protectGroup.getUuid());
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (updateResult == 1) break block6;
                logger.error((Object)"Update protectGroup basic info failed!", 90160758786989L);
                throw new LegoCheckedException(-1L);
            }
            catch (LegoCheckedException e) {
                DBOperationUtil.rollbackSession(session);
                logger.error((Object)"Update protectGroup basic info failed!", e.getErrorCode());
                ExceptionUtil.rethrowException((Exception)((Object)e), (String)"Update protectGroup basic info failed!", (long)e.getErrorCode(), (String[])e.getParameters());
                DBOperationUtil.closeSession(session);
            }
            catch (Exception ex) {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"Update protectGroup basic info failed!", (long)-1L, (String[])new String[0], (Log)logger);
                {
                    catch (Throwable throwable) {
                        DBOperationUtil.closeSession(session);
                        throw throwable;
                    }
                }
                DBOperationUtil.closeSession(session);
            }
        }
        DBOperationUtil.closeSession(session);
    }
}

