/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class UpdateProtectGroupTransaction
implements TransactionCallback {
    private static final Log logger = LogFactory.getInstance(UpdateProtectGroupTransaction.class);
    private ProtectGroupServiceImpl service;
    private IBaseDao<?, ?> callBackBaseDao;
    private ProtectGroup protectGroup;
    private List<BatchOperation> resultList = new ArrayList<BatchOperation>();

    public UpdateProtectGroupTransaction(ProtectGroupServiceImpl service, ProtectGroup protectGroup, List<BatchOperation> resultList) {
        this.service = service;
        this.callBackBaseDao = service.getBaseDao();
        this.protectGroup = protectGroup;
        this.resultList = resultList;
    }

    public Object doInTransaction(TransactionStatus tStatus) {
        try {
            this.callBackBaseDao.getHibernateTemplate().saveOrUpdate((Object)this.protectGroup);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)("failed to add protectobject to potectgroup(" + this.protectGroup.getName() + ") because of sync error."), (Throwable)le, 90160758786898L);
            tStatus.setRollbackOnly();
            if (this.resultList != null) {
                ProtectGroupHelper.getInstance().updateBatchOperationResult(this.resultList, 0L == le.getErrorCode() ? -1L : le.getErrorCode());
            }
            throw le;
        }
        catch (DataAccessException e) {
            this.handleUpdatePgError(tStatus, this.protectGroup.getName(), (Exception)((Object)e));
        }
        catch (Exception ex) {
            this.handleUpdatePgError(tStatus, this.protectGroup.getName(), ex);
        }
        return this.resultList;
    }

    private void handleUpdatePgError(TransactionStatus tStatus, String protectGroupName, Exception ex) {
        logger.error((Object)("failed to add protectobject to potectgroup(" + protectGroupName + ") because of saving error." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758786898L);
        tStatus.setRollbackOnly();
        if (this.resultList == null) {
            throw ExceptionUtil.convertException((Throwable)ex, (String)"", (long)-1L, (String[])new String[0], (Log)logger);
        }
        ProtectGroupHelper.getInstance().updateBatchOperationResult(this.resultList, -1L);
    }
}

