/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.refinement;

import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.refinement.ProtectGroupServiceLocator;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;

public class BaseProtectGroupRefineService {
    private static final Log logger = LogFactory.getInstance(BaseProtectGroupRefineService.class);

    public void updateProtectObjectProperties(ProtectGroup protectGroup) {
        IProtectObjectProvider poProvider = BaseProtectGroupRefineService.getProtectObjectProvider(protectGroup.getPoType());
        if (poProvider == null) {
            logger.error((Object)("get IProtectObjectProvider failed! poType:" + protectGroup.getPoType()));
            throw new LegoCheckedException(-1L);
        }
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            protectObject.setProtectGroup(protectGroup);
            poProvider.updateProtectObjectProps(protectObject, protectObject.getProps());
        }
        poProvider.checkProtectObjectsInProtectGroup(protectGroup);
        poProvider.buildProtectObjects(protectGroup);
        try {
            ArrayList<ProtectObject> protectObjectList = new ArrayList<ProtectObject>();
            protectObjectList.addAll(protectGroup.getPolist());
            ProtectGroupHelper.getInstance().deleteProtectObjectStorageInfo(protectObjectList);
        }
        catch (Exception e) {
            logger.error((Object)("delete temp po StorageInfo error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    public static IProtectObjectProvider getProtectObjectProvider(int poType) {
        List<IProtectObjectProvider> result = ProtectGroupServiceLocator.getInstance().getServices(IProtectObjectProvider.class);
        for (IProtectObjectProvider provider : result) {
            if (provider.getProviderByType() != poType) continue;
            return provider;
        }
        return null;
    }

    private List<IObjectObserver> getObserverList() {
        ArrayList<IObjectObserver> result = new ArrayList<IObjectObserver>();
        List<IObjectObserver> observers = ProtectGroupServiceLocator.getInstance().getServices(IObjectObserver.class);
        for (IObjectObserver observer : observers) {
            if (!ProtectGroup.class.getName().equals(observer.getObserverType())) continue;
            result.add(observer);
        }
        result.sort((observer1, observer2) -> observer2.getPriority() - observer1.getPriority());
        return result;
    }

    public void notifyObserver(MessageEvent event, Runnable runnable) {
        try {
            this.notifyObserverList(event, "before");
            runnable.run();
            this.notifyObserverList(event, "after");
        }
        catch (Exception ex) {
            logger.error((Object)"Execute observer failed. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
            event.getMessageMap().put("observerError", ex);
            this.notifyObserverList(event, "onError");
            throw ex;
        }
        finally {
            this.notifyObserverList(event, "onFinal");
        }
    }

    public void notifyObserverList(MessageEvent event, String notifyType) {
        try {
            for (IObjectObserver observer : this.getObserverList()) {
                if (observer == null || !ProtectGroup.class.getName().equals(observer.getObserverType())) continue;
                observer.onMessage(event, notifyType);
            }
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"failed to notify observer.", (Throwable)le, 90160758786898L);
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to notify observer.", (long)-1L, (String[])new String[0], (Log)logger);
        }
    }
}

