/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.provider;

import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Service(name="com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate", desc="", interfaceClass=IProtectObjectProviderDelegate.class)
public class ProtectObjectProviderDelegateImpl
extends BaseService
implements IProtectObjectProviderDelegate {
    private static final Log logger = LogFactory.getInstance(ProtectObjectProviderDelegateImpl.class);
    private Map<Integer, IProtectObjectProvider> providerList = new ConcurrentHashMap<Integer, IProtectObjectProvider>();

    public List<ProtectObject> getSupportProtectObjectTypes() {
        ArrayList<ProtectObject> supportPoList = new ArrayList<ProtectObject>();
        for (Map.Entry<Integer, IProtectObjectProvider> entry : this.providerList.entrySet()) {
            IProtectObjectProvider provider = entry.getValue();
            supportPoList.addAll(provider.getSupportProtectObjectTypes());
        }
        return supportPoList;
    }

    public void onBind(IProtectObjectProvider provider, Map<?, ?> properties) {
        this.providerList.put(provider.getProviderByType(), provider);
    }

    public void onUnbind(IProtectObjectProvider provider, Map<?, ?> properties) {
        this.providerList.remove(provider.getProviderByType());
    }

    public List<ProtectObject> getAvailableProtectObject(int applicationType, String poProviderSn, Map<String, Object> extendCondition) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        return provider.getAvailableProtectObject(poProviderSn, extendCondition);
    }

    public void discoveryProtectObjectStorageInfo(int applicationType, ProtectObject po, Map<String, String> condition) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        provider.updateProtectObjectProps(po, po.getProps());
        List storageInfoList = provider.getProtectObjectStorageInfo(po);
        if (storageInfoList != null && !storageInfoList.isEmpty()) {
            HashSet storageInfoSet = new HashSet();
            storageInfoSet.addAll(storageInfoList);
            po.setUsedStorageResourceSet(storageInfoSet);
            ProtectGroupHelper.getInstance().saveProtectObjectStorageInfo(po);
        }
    }

    public IProtectObjectProvider getProviderByAppType(int applicationType) {
        IProtectObjectProvider provider = this.providerList.get(applicationType);
        if (provider == null) {
            String errorMsg = "connot get provider by " + applicationType;
            throw new LegoCheckedException(1073947395L, errorMsg);
        }
        return provider;
    }

    public boolean testProtectObject(int applicationType, ProtectObject po) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        return provider.testProtectObject(po);
    }

    public List<ProtectObject> getAddAvailableProtectObject(int applicationType, String poProviderSn, String pgId, Map<String, Object> extParamInQueryParam) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        return provider.getAddAvailableProtectObject(poProviderSn, pgId, extParamInQueryParam);
    }

    public Map<String, Object> pretreatmentParams(int applicationType, Map<String, Object> params) {
        IProtectObjectProvider provider = this.getProviderByAppType(applicationType);
        return provider.pretreatmentParams(params);
    }
}

