/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica.realtime.impl;

import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IExecuteReplicaCalculator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BaseReplicaCalculator
implements IExecuteReplicaCalculator {
    private static final Log logger = LogFactory.getInstance(BaseReplicaCalculator.class);
    private static Set<PolicyTemplateType.PolicyTemplateE> supportTemplate = new HashSet<PolicyTemplateType.PolicyTemplateE>();

    public ProtectGroupReplica calculateExecutedReplica(ProtectGroup pg, int protectLocation) {
        logger.debug((Object)"calculate pg%s protectLocation %s", new Object[]{pg.getName(), protectLocation});
        ArrayList<ProtectGroupReplica> replicaList = new ArrayList<ProtectGroupReplica>();
        replicaList.addAll(pg.getReplicaList());
        List<ProtectGroupReplica> replicas = this.getPgReplicaByProtectLocation(pg.getTemplate().getType(), replicaList, protectLocation);
        ProtectGroupReplica lastestReplica = this.getLastestReplicaListByTime(replicas);
        if (3 == lastestReplica.getStatus()) {
            return lastestReplica;
        }
        ProtectGroupHelper.getInstance().orderReplicaList(replicas);
        return replicas.get(0);
    }

    public Set<PolicyTemplateType.PolicyTemplateE> getSupportPolicyTemplate() {
        return supportTemplate;
    }

    private List<ProtectGroupReplica> getPgReplicaByProtectLocation(int pgType, List<ProtectGroupReplica> replicas, int protectLocation) {
        if (PolicyTemplateTools.getInstance().ingoreLocationType(pgType)) {
            return replicas;
        }
        ArrayList<ProtectGroupReplica> locationReplicas = new ArrayList<ProtectGroupReplica>();
        for (ProtectGroupReplica replica : replicas) {
            if (replica.getProtectLocation() != protectLocation || PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(pgType) && !replica.isStorageReplicationReplica()) continue;
            locationReplicas.add(replica);
        }
        return locationReplicas;
    }

    private ProtectGroupReplica getLastestReplicaListByTime(List<ProtectGroupReplica> replicaList) {
        Collections.sort(replicaList, new Comparator<ProtectGroupReplica>(){

            @Override
            public int compare(ProtectGroupReplica pgr0, ProtectGroupReplica pgr1) {
                return pgr0.compareTo(pgr1);
            }
        });
        return replicaList.get(0);
    }

    static {
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_REPLICA_SYNC);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_REPLICA_ASYNC);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_ASYNC_ASYNC);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_CONCURRENT_ASYNC_ASYNC);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.VIRTUAL_REPLICATION_GATEWAY);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_ASYNC_REPLICATION);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.OPENSTACK_ARRAY_REPLICA_SYNC);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.OPENSTACK_ARRAY_REPLICA_ASYNC);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_HYPER_METRO_SYNC_REPLICATION);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_SYNC_HYPER_METRO);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.OPENSTACK_HYPERMETRO);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.OPENSTACK_VHA);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_CASCADE_4DC_ASYNC_ASYNC);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_CONCURRENT_4DC_ASYNC_ASYNC);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.OPENSTACK_ASYNC_HYPER_METRO_RING);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.OPENSTACK_INTRA_CITY_ASYNC_HYPER_METRO_RING);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.FUSIONSTORAGE_REPLICA_ASYNC);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_SAN_HYPERVAULT);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_SAN_HYPERMETRO_VAULT);
        supportTemplate.add(PolicyTemplateType.PolicyTemplateE.ARRAY_SAN_VAULT_HYPERMETRO);
    }
}

