/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.task;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.framework.engine.job.ProtectionJob;
import com.huawei.ism.drm.protection.framework.service.group.ProtectionTaskExecutor;
import com.huawei.ism.drm.protection.framework.service.task.ProtectionBackTaskHandler;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.task.sdk.model.ITask;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService", desc="", interfaceClass=IProtectionTaskService.class)
public class ProtectionTaskServiceImpl
extends BaseService
implements IProtectionTaskService,
SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(ProtectionTaskServiceImpl.class);
    private static boolean started = false;
    private IBaseDao<Object, Serializable> dao;
    private ITaskManager protectionTaskManager;

    public ITaskManager getProtectionTaskManager() {
        return this.protectionTaskManager;
    }

    public void setProtectionTaskManager(ITaskManager protectionTaskManager) {
        this.protectionTaskManager = protectionTaskManager;
    }

    public IBaseDao<Object, Serializable> getDao() {
        return this.dao;
    }

    public void setDao(IBaseDao<Object, Serializable> dao) {
        this.dao = dao;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.start();
        }
    }

    private void start() {
        if (started) {
            return;
        }
        List<ProtectionTask> tasks = this.getAllAutoTasks();
        ArrayList<ProtectionTask> remove = new ArrayList<ProtectionTask>();
        for (ProtectionTask task : tasks) {
            try {
                if (1 == task.getStatus() || 3 == task.getStatus()) {
                    Date nextExecTime = this.protectionTaskManager.getNextExecTime((ITask)task, true);
                    task.setNextExecTime(nextExecTime == null ? null : String.valueOf(nextExecTime.getTime()));
                    if (nextExecTime == null) {
                        remove.add(task);
                    }
                    if (3 == task.getStatus()) {
                        task.setStatus(1);
                    }
                }
                this.dao.getHibernateTemplate().update((Object)task);
            }
            catch (Exception e) {
                logger.error((Object)("recovery task error. taskId: " + task.getTaskId()));
            }
        }
        tasks.removeAll(remove);
        this.protectionTaskManager.recoveryExistTasks(tasks);
        this.resetAllRunningTaskByHand();
        started = true;
    }

    private void resetAllRunningTaskByHand() {
        List tasks = null;
        String hql = "from ProtectionTask as t where t.schedule.scheduleMode = ?";
        try {
            tasks = this.dao.getHibernateTemplate().find(hql, new Object[]{1});
        }
        catch (DataAccessException e) {
            logger.error((Object)"get all manual tasks failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (tasks != null) {
            for (ProtectionTask protectionTask : tasks) {
                if (3 != protectionTask.getStatus()) continue;
                logger.info((Object)"resetAllRunningTaskByHand setstatus task:%s-%s", new Object[]{protectionTask.getJobClassName(), protectionTask.getTaskId(), 90160758784001L});
                protectionTask.setStatus(1);
                this.dao.getHibernateTemplate().update((Object)protectionTask);
            }
        }
    }

    public void createTask(ProtectGroup pg) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        for (Schedule schedule : pg.getTemplate().getSchedules()) {
            if (this.checkScheduleTime(schedule)) continue;
            ProtectionTask task = new ProtectionTask(pg, schedule);
            task.setJobClassName(ProtectionJob.getClassName());
            this.addTask(task);
        }
    }

    private boolean checkScheduleTime(Schedule schedule) {
        if (schedule.getScheduleMode() == 0) {
            long now = new Date().getTime();
            if (!VerifyUtil.isEmpty((String)schedule.getEndTime()) && now > Long.parseLong(schedule.getEndTime())) {
                return true;
            }
            if (schedule.getPeriodType() == 5) {
                return true;
            }
        }
        return false;
    }

    private boolean isAutoTask(ProtectionTask task) {
        return task.getSchedule().getScheduleMode() == 0;
    }

    private void addTask(ProtectionTask task) {
        if (null == task || null == task.getSchedule() || null == task.getProtectGroup() || null == task.getJobClassName()) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        task.setCreateTime(String.valueOf(new Date().getTime()));
        task.setStatus(1);
        try {
            this.dao.save((Object)task);
            if (this.isAutoTask(task)) {
                Date nextExecTime = this.protectionTaskManager.getNextExecTime((ITask)task, true);
                task.setNextExecTime(null == nextExecTime ? null : String.valueOf(nextExecTime.getTime()));
                this.dao.update((Object)task);
                if (null == nextExecTime) {
                    return;
                }
                this.protectionTaskManager.schedule((ITask)task);
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"add task failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    private void deleteTask(ProtectionTask task) {
        if (null == task) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        if (3 == task.getStatus()) {
            logger.error((Object)"task is running, can't delete it", 90160758784001L);
            throw new LegoCheckedException(1073948427L);
        }
        this.protectionTaskManager.pause((ITask)task);
        Session session = null;
        try {
            session = this.dao.getHibernateTemplate().getSessionFactory().getCurrentSession();
            HibernateUtil.beginTransaction((Session)session);
            NativeQuery query = session.createNativeQuery("DELETE from ti_drmtask where TASKID=:_taskId");
            query.setParameter("_taskId", (Object)task.getTaskId());
            query.executeUpdate();
            HibernateUtil.commit((Session)session);
            this.protectionTaskManager.unschedule((ITask)task);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"delete task failed", (Throwable)e, 90160758784001L);
                HibernateUtil.rollbackSession((Session)session);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                HibernateUtil.closeSession(session);
                throw throwable;
            }
        }
        HibernateUtil.closeSession((Session)session);
    }

    public void deleteTask(String pgId, String scheduleId, List<ProtectionTask> taskList) {
        if (VerifyUtil.isEmpty((String)pgId) || VerifyUtil.isEmpty((String)scheduleId)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectionTask task = this.getTask(scheduleId, taskList);
        if (null == task) {
            logger.error((Object)("task dosen't exist, pgId=" + pgId + ", scheduleId=" + scheduleId), 90160758784001L);
            return;
        }
        this.deleteTask(task);
    }

    public void deleteTasks(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        List<ProtectionTask> tasks = this.getTasks(pgId);
        if (null != tasks) {
            for (ProtectionTask task : tasks) {
                this.deleteTask(task);
            }
        }
    }

    public void deleteTaskAndJob(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"pgId is empty!", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        List<ProtectionTask> tasks = this.getTasks(pgId);
        if (tasks != null) {
            for (ProtectionTask task : tasks) {
                try {
                    this.dao.getHibernateTemplate().delete((Object)task);
                    this.protectionTaskManager.unschedule((ITask)task);
                    this.protectionTaskManager.deleteJob((ITask)task);
                }
                catch (DataAccessException e) {
                    logger.error((Object)"delete task failed", (Throwable)e, 90160758784001L);
                    throw new LegoCheckedException(-1L, (Throwable)e);
                }
            }
        }
    }

    public void updateTask(ProtectionTask task) {
        if (VerifyUtil.isEmpty((Object)task)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectionTask oldTask = this.getTask(task.getTaskId());
        if (null == oldTask) {
            logger.error((Object)("task dosen't exist, taskId=" + task.getTaskId()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        oldTask.setStatus(task.getStatus());
        oldTask.setLastExecTime(task.getLastExecTime());
        oldTask.setNextExecTime(task.getNextExecTime());
        try {
            this.dao.getHibernateTemplate().update((Object)oldTask);
        }
        catch (DataAccessException e) {
            logger.error((Object)"update task failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
    }

    public void updateTask(String pgId, Schedule schedule, List<ProtectionTask> taskList) {
        if (VerifyUtil.isEmpty((String)pgId) || VerifyUtil.isEmpty((Object)schedule)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        if (1 == schedule.getScheduleMode()) {
            return;
        }
        ProtectionTask task = this.getTask(schedule.getScheduleId(), taskList);
        if (task == null) {
            logger.error((Object)("task dosen't exist, pgId=" + pgId + ", scheduleId=" + schedule.getScheduleId()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        task.setSchedule(schedule);
        task.setCreateTime(String.valueOf(new Date().getTime()));
        Date nextExecTime = this.protectionTaskManager.getNextExecTime((ITask)task, true);
        task.setNextExecTime(null == nextExecTime ? null : String.valueOf(nextExecTime.getTime()));
        task.setStatus(1);
        this.dao.update((Object)task);
        if (null == nextExecTime) {
            return;
        }
        this.protectionTaskManager.updateTrigger((ITask)task);
    }

    public void updateTasks(ProtectGroup protectGroup, List<ProtectionTask> taskList, PolicyTemplate oldPt) {
        PolicyTemplate newPt = protectGroup.getTemplate();
        if (VerifyUtil.isEmpty((Object)newPt)) {
            logger.error((Object)"updateTasks param is error.", 90160758786893L);
            throw new LegoCheckedException(1073947393L);
        }
        String pgId = protectGroup.getUuid();
        Set<Schedule> oldSchedules = this.filterSecondSchedules(oldPt.getSchedules());
        Set<Schedule> newSchedules = this.filterSecondSchedules(newPt.getSchedules());
        this.updateOrDeleteTask(pgId, newSchedules, oldSchedules, taskList);
        HashSet<Schedule> toAddSchedule = new HashSet<Schedule>();
        for (Schedule schedule : newSchedules) {
            if (1 == schedule.getScheduleMode()) continue;
            if (!oldPt.getSchedules().contains(schedule)) {
                schedule.setScheduleId(UUIDGenerator.getUUID());
                toAddSchedule.add(schedule);
                continue;
            }
            Schedule schedule2 = this.getSchedule(schedule.getScheduleId(), oldPt.getSchedules());
            if (VerifyUtil.isEmpty((Object)schedule2) || schedule2.getPeriodType() != 5) continue;
            toAddSchedule.add(schedule);
        }
        Session session = null;
        try {
            session = this.dao.getHibernateTemplate().getSessionFactory().getCurrentSession();
            session.flush();
            this.dao.getHibernateTemplate().saveOrUpdate((Object)newPt);
            for (Schedule schedule : toAddSchedule) {
                ProtectionTask task = new ProtectionTask(protectGroup, schedule);
                task.setJobClassName(ProtectionJob.getClassName());
                this.addTask(task);
            }
        }
        catch (Exception exception) {
            try {
                logger.error((Object)"hibernate. save or flush got error.");
                DBOperationUtil.rollbackSession(session);
                throw exception;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
    }

    public void enableTask(String protectGroupId, String scheduleId) {
        ProtectionTask task = this.getTask(protectGroupId, scheduleId);
        if (task == null || VerifyUtil.isEmpty((Object)task.getSchedule())) {
            logger.error((Object)"Task or schecdule is null");
            throw new LegoCheckedException(2117645L);
        }
        if (task.getSchedule().getScheduleMode() == 0 && task.getSchedule().getPeriodType() != 5) {
            this.protectionTaskManager.schedule((ITask)task);
        }
        task.setStatus(1);
        this.dao.update((Object)task);
        Schedule schedule = (Schedule)this.dao.getHibernateTemplate().get(Schedule.class, (Serializable)((Object)scheduleId));
        schedule.setEnable(Boolean.valueOf(true));
        this.dao.getHibernateTemplate().update((Object)schedule);
    }

    public void disableTask(String protectGroupId, String scheduleId) {
        ProtectionTask task = this.getTask(protectGroupId, scheduleId);
        if (null == task) {
            logger.error((Object)("Cannot find protection task by pgId and scheduleId.pg Id is " + protectGroupId + " and schedule Id is " + scheduleId), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        if (3 == task.getStatus()) {
            logger.error((Object)"task is running, can't delete it", 90160758784001L);
            throw new LegoCheckedException(1073948427L);
        }
        if (task.getSchedule().getScheduleMode() == 0) {
            this.protectionTaskManager.unschedule((ITask)task);
        }
        task.setStatus(2);
        this.dao.update((Object)task);
        Schedule schedule = (Schedule)this.dao.getHibernateTemplate().get(Schedule.class, (Serializable)((Object)scheduleId));
        schedule.setEnable(Boolean.valueOf(false));
        this.dao.getHibernateTemplate().update((Object)schedule);
    }

    public void addTask(ProtectGroup protectGroup, Schedule schedule) {
        List existSchedule = protectGroup.getTemplate().getSchedules().stream().filter(schedule1 -> schedule1.getScheduleId().equals(schedule.getScheduleId())).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(existSchedule)) {
            schedule.setPolicyTemplate(protectGroup.getTemplate());
            protectGroup.getTemplate().getSchedules().add(schedule);
            this.dao.getHibernateTemplate().saveOrUpdate((Object)protectGroup.getTemplate());
        }
        if (schedule.getPeriodType() != 5) {
            ProtectionTask task = new ProtectionTask(protectGroup, schedule);
            task.setJobClassName(ProtectionJob.getClassName());
            schedule.setPolicyTemplate(protectGroup.getTemplate());
            this.addTask(task);
        }
    }

    public long runTask(String protectGroupId, String scheduleId, Map<String, Object> parameter) {
        ProtectionTask task = this.getTask(protectGroupId, scheduleId);
        if (null == task) {
            ProtectGroup protectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
            Schedule runSchedule = protectGroup.getTemplate().getSchedules().stream().filter(schedule1 -> schedule1.getScheduleId().equals(scheduleId)).findFirst().orElse(null);
            if (null == runSchedule) {
                String errorMsg = "schedule is not exists, protectGroupId is {0} and scheduleId is {1}";
                logger.error((Object)MessageFormatUtil.format((String)errorMsg, (Object[])new Object[]{protectGroupId, scheduleId}));
                throw new LegoCheckedException(1073947393L);
            }
            if (runSchedule.getPeriodType() == 5) {
                String errorMsg = "second snapshot schedule is not supported manual execute, protectGroupId is {0} and scheduleId is {1}";
                logger.error((Object)MessageFormatUtil.format((String)errorMsg, (Object[])new Object[]{protectGroupId, scheduleId}));
                throw new LegoCheckedException(1073948251L);
            }
            task = new ProtectionTask(protectGroup, runSchedule);
            task.setJobClassName(ProtectionJob.getClassName());
            runSchedule.setPolicyTemplate(protectGroup.getTemplate());
            this.addTask(task);
        }
        ProtectionTaskExecutor taskExecutor = new ProtectionTaskExecutor(task, parameter);
        return ProtectionBackTaskHandler.getInstance().submitTask(taskExecutor);
    }

    public void updateTask(String protectGroupId, Schedule schedule) {
        if (null == schedule) {
            logger.error((Object)("update task failed, because schedule is null.ProtectGroup Id is :" + protectGroupId));
            throw new LegoCheckedException(1073947394L);
        }
        if (schedule.getPeriodType() == 5) {
            return;
        }
        ProtectionTask task = this.getTask(protectGroupId, schedule.getScheduleId());
        if (null == task) {
            String errorMsg = "Protection task is not exists, protectGroupId is {0} and scheduleId is {1}";
            logger.error((Object)MessageFormatUtil.format((String)errorMsg, (Object[])new Object[]{protectGroupId, schedule.getScheduleId()}));
            throw new LegoCheckedException(1073947394L);
        }
        if (3 == task.getStatus()) {
            logger.error((Object)"task is running, can't delete it");
            throw new LegoCheckedException(1073948427L);
        }
        this.updateTask(protectGroupId, schedule, Arrays.asList(task));
    }

    private Set<Schedule> filterSecondSchedules(Set<Schedule> schedules) {
        HashSet<Schedule> results = new HashSet<Schedule>();
        if (null == schedules) {
            return results;
        }
        for (Schedule schedule : schedules) {
            if (schedule.getPeriodType() == 5) continue;
            results.add(schedule);
        }
        return results;
    }

    private void updateOrDeleteTask(String pgId, Set<Schedule> newSchedules, Set<Schedule> oldSchedules, List<ProtectionTask> taskList) {
        for (Schedule old : oldSchedules) {
            if (1 == old.getScheduleMode()) continue;
            if (newSchedules.contains(old)) {
                Schedule schedule = this.getSchedule(old.getScheduleId(), newSchedules);
                if (old.isEqual((Object)schedule)) continue;
                this.updateTask(pgId, schedule, taskList);
                continue;
            }
            this.deleteTask(pgId, old.getScheduleId(), taskList);
        }
    }

    private Schedule getSchedule(String scheduleId, Set<Schedule> schedules) {
        for (Schedule s : schedules) {
            if (!scheduleId.equals(s.getScheduleId())) continue;
            return s;
        }
        return null;
    }

    private List<ProtectionTask> getAllAutoTasks() {
        List tasks = null;
        String hql = "from ProtectionTask as t where t.schedule.scheduleMode = ?";
        try {
            tasks = this.dao.getHibernateTemplate().find(hql, new Object[]{0});
        }
        catch (DataAccessException e) {
            logger.error((Object)"get all auto tasks failed", (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return tasks;
    }

    public List<ProtectionTask> getTasks(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        List tasks = null;
        String hql = "from ProtectionTask as t where t.protectGroup.pgId =:pgId order by t.taskId";
        Session session = null;
        try {
            session = this.dao.getHibernateTemplate().getSessionFactory().openSession();
            Query query = session.createQuery(hql, ProtectionTask.class);
            query.setParameter("pgId", (Object)pgId);
            tasks = query.list();
        }
        catch (DataAccessException e) {
            try {
                logger.error((Object)("get tasks by pgId failed, pgId=" + pgId), (Throwable)e, 90160758784001L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession(session);
        return tasks;
    }

    public ProtectionTask getRunningTask(String pgId) {
        List<ProtectionTask> tasks = this.getTasks(pgId);
        ProtectionTask runningTask = null;
        if (null != tasks && !tasks.isEmpty()) {
            for (ProtectionTask task : tasks) {
                if (3 != task.getStatus()) continue;
                runningTask = task;
                break;
            }
        }
        return runningTask;
    }

    public List<Integer> getTaskIds(String pgId) {
        List<ProtectionTask> tasks = this.getTasks(pgId);
        ArrayList<Integer> taskIds = new ArrayList<Integer>();
        if (null != tasks) {
            Iterator<ProtectionTask> iter = tasks.iterator();
            while (iter.hasNext()) {
                taskIds.add(iter.next().getTaskId());
            }
        }
        return taskIds;
    }

    private ProtectionTask getTask(int taskId) {
        ProtectionTask task = null;
        try {
            task = (ProtectionTask)this.dao.getHibernateTemplate().get(ProtectionTask.class, (Serializable)Integer.valueOf(taskId));
        }
        catch (DataAccessException e) {
            logger.error((Object)("get task by taskId failed, taskId=" + taskId), (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        return task;
    }

    private ProtectionTask getTask(String scheduleId, List<ProtectionTask> taskList) {
        ProtectionTask task = null;
        if (null != taskList) {
            for (ProtectionTask tmpTask : taskList) {
                if (!tmpTask.getSchedule().getScheduleId().equals(scheduleId)) continue;
                task = tmpTask;
                break;
            }
        }
        return task;
    }

    public ProtectionTask getTask(String pgId, String scheduleId) {
        if (VerifyUtil.isEmpty((String)pgId) || VerifyUtil.isEmpty((String)scheduleId)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectionTask task = null;
        List<ProtectionTask> tasks = this.getTasks(pgId);
        if (null != tasks) {
            for (ProtectionTask tmpTask : tasks) {
                if (!tmpTask.getSchedule().getScheduleId().equals(scheduleId)) continue;
                task = tmpTask;
                break;
            }
        }
        return task;
    }

    public void runAtOnce(ProtectGroup protectGroup, Schedule schedule) {
        ProtectionTask task = this.getTask(protectGroup.getUuid(), schedule.getScheduleId());
        if (VerifyUtil.isEmpty((Object)task)) {
            logger.error((Object)("task dosen't exist, pgName=" + protectGroup.getName() + ", scheduleId=" + schedule.getScheduleId()), 90160758784001L);
            task = new ProtectionTask(protectGroup, schedule);
        }
        ProtectionTaskExecutor backTask = new ProtectionTaskExecutor(task);
        ProtectionBackTaskHandler.getInstance().submitTask(backTask);
    }

    public void resumeTask(ProtectionTask task) {
        if (null == task) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        if (2 != task.getStatus() && 1 != task.getStatus()) {
            logger.error((Object)("task status is:" + task.getStatus() + ", can't resume it"), 90160758784001L);
            throw new LegoCheckedException(1073948428L);
        }
        if (task.getSchedule().isEnable().booleanValue()) {
            if (this.isAutoTask(task) && task.getSchedule().getPeriodType() != 5) {
                if (this.protectionTaskManager.isExistTrigger((ITask)task)) {
                    Date nextExecTime = this.protectionTaskManager.getNextExecTime((ITask)task, false);
                    task.setNextExecTime(nextExecTime == null ? null : String.valueOf(nextExecTime.getTime()));
                    this.updateTask(task);
                    if (null == task.getNextExecTime()) {
                        return;
                    }
                    this.protectionTaskManager.resume((ITask)task);
                } else {
                    this.protectionTaskManager.schedule((ITask)task);
                }
            }
            task.setStatus(1);
            this.updateTask(task);
        }
    }

    public void resumeTasks(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String groupName = this.protectionTaskManager.getGroupName(pgId);
        this.protectionTaskManager.resumeGroup(groupName);
        List<ProtectionTask> tasks = this.getTasks(pgId);
        if (null != tasks && !tasks.isEmpty()) {
            for (ProtectionTask task : tasks) {
                this.resumeTask(task);
            }
        }
    }

    public void pauseTask(ProtectionTask task) {
        if (task == null) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        if (1 != task.getStatus()) {
            logger.error((Object)"task status isn't idle, can't pause it", 90160758784001L);
            throw new LegoCheckedException(1073948429L);
        }
        this.protectionTaskManager.pause((ITask)task);
        task.setStatus(2);
        this.updateTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTasks(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        String groupName = this.protectionTaskManager.getGroupName(pgId);
        this.protectionTaskManager.pauseGroup(groupName);
        if (1 != this.getPgStatus(pgId) && 2 != this.getPgStatus(pgId)) {
            logger.error((Object)"policy status isn't idle, can't pause it", 90160758784001L);
            throw new LegoCheckedException(1073948429L);
        }
        String hql = "update ProtectionTask as task set task.status =:newTaskStatus where task.protectGroup.pgId =:pgId and task.status=:oldTaskStatus";
        Session session = null;
        try {
            session = this.dao.getHibernateTemplate().getSessionFactory().openSession();
            session.beginTransaction();
            Query query = session.createQuery(hql);
            query.setInteger("newTaskStatus", 2);
            query.setString("pgId", pgId);
            query.setInteger("oldTaskStatus", 1);
            query.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)e, (String)("pause tasks by pgId failed, pgId=" + pgId), (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
    }

    public Date getPgLastExecTime(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        Date lastExecTime = null;
        List tasks = null;
        String hql = "from ProtectionTask as t where t.protectGroup.pgId = ? and t.lastExecTime != null order by t.lastExecTime desc";
        try {
            tasks = this.dao.getHibernateTemplate().find(hql, new Object[]{pgId});
        }
        catch (DataAccessException e) {
            logger.error((Object)("get last exec time for pg failed, pgId=" + pgId), (Throwable)e, 90160758784001L);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (null != tasks && !tasks.isEmpty() && !VerifyUtil.isEmpty((String)((ProtectionTask)tasks.get(0)).getLastExecTime())) {
            lastExecTime = new Date(Long.parseLong(((ProtectionTask)tasks.get(0)).getLastExecTime()));
        }
        return lastExecTime;
    }

    private int calculatePolicyStatus(List<ProtectionTask> tasks) {
        int policyStatus = 1;
        boolean idleExist = false;
        boolean runningExist = false;
        boolean suspendExist = false;
        boolean finishExist = false;
        for (ProtectionTask task : tasks) {
            if (3 == task.getStatus()) {
                runningExist = true;
                continue;
            }
            if (2 == task.getStatus()) {
                suspendExist = true;
                continue;
            }
            if (4 == task.getStatus()) {
                finishExist = true;
                continue;
            }
            idleExist = true;
        }
        if (runningExist) {
            policyStatus = 3;
        } else if (suspendExist) {
            policyStatus = 2;
        } else if (finishExist) {
            if (!idleExist) {
                policyStatus = 4;
            }
        } else {
            policyStatus = 1;
        }
        return policyStatus;
    }

    public int getPgStatus(String pgId) {
        if (VerifyUtil.isEmpty((String)pgId)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        int policyStatus = 1;
        List<ProtectionTask> tasks = this.getTasks(pgId);
        if (null != tasks) {
            policyStatus = this.calculatePolicyStatus(tasks);
        }
        return policyStatus;
    }

    public void deleteTask(String protectGroupId, String scheduleId) {
        ProtectionTask task = this.getTask(protectGroupId, scheduleId);
        this.deleteTask(task);
    }
}

