/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process;

import com.huawei.ism.drm.base.util.DrmObjectSerializableUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class RecoveryProcessorMgr {
    private static RecoveryProcessorMgr recoveryProcMgr = new RecoveryProcessorMgr();
    private Map<String, IRecoveryProcessProvider> processProviders = new HashMap<String, IRecoveryProcessProvider>();
    private Map<Integer, Class<? extends RecoveryProcessor>> syncProcessors = new HashMap<Integer, Class<? extends RecoveryProcessor>>();
    private IRecoveryProcessHandler recoveryProcessHandler;

    private RecoveryProcessorMgr() {
    }

    public static RecoveryProcessorMgr getInstance() {
        return recoveryProcMgr;
    }

    public void onBind(IRecoveryProcessProvider provider, Map<String, Object> properties) {
        ClassLoader globalClassLoader = this.getClass().getClassLoader();
        DrmObjectSerializableUtil.setGlobalClassLoader(globalClassLoader);
        for (String appType : provider.getAppType()) {
            this.processProviders.put(appType, provider);
        }
        Map regSyncProcessors = provider.registerSyncProcessor();
        if (regSyncProcessors == null || regSyncProcessors.isEmpty()) {
            return;
        }
        Set entrySet = regSyncProcessors.entrySet();
        for (Map.Entry entry : entrySet) {
            Integer repType = (Integer)entry.getKey();
            if (null != this.syncProcessors.get(repType)) continue;
            this.syncProcessors.put(repType, (Class<? extends RecoveryProcessor>)entry.getValue());
        }
    }

    public void onUnbind(IRecoveryProcessProvider provider, Map<String, Object> properties) {
        for (String appType : provider.getAppType()) {
            this.processProviders.remove(appType);
        }
        Map regSyncProcessors = provider.registerSyncProcessor();
        if (regSyncProcessors == null || regSyncProcessors.isEmpty()) {
            return;
        }
        for (Integer repType : regSyncProcessors.keySet()) {
            this.syncProcessors.remove(repType);
        }
    }

    public void setRecoveryProcessHandler(IRecoveryProcessHandler recoveryProcessHandler) {
        this.recoveryProcessHandler = recoveryProcessHandler;
    }

    public IRecoveryProcessHandler getRecoveryProcessHandler() {
        return this.recoveryProcessHandler;
    }

    public IRecoveryProcessProvider getRecoveryProcessProvider(String appType) {
        return this.processProviders.get(appType);
    }

    public Class<? extends RecoveryProcessor> getSyncProcessor(int repType) {
        return this.syncProcessors.get(repType);
    }
}

