/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.provider.RefactorConfigurationProviderMgr;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationProvider;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.reprotect.sdk.service.IReprotectService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Set;

public class RefactorConfigurationSubProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = 3880674622172150069L;
    private static final Log logger = LogFactory.getInstance(RefactorConfigurationSubProcessor.class);

    public RefactorConfigurationSubProcessor() {
        this.setIsNeedSave(false);
    }

    public RefactorConfigurationSubProcessor(RecoveryProcessor parentProcess) {
        super(parentProcess);
        this.setIsNeedSave(false);
    }

    @Override
    public boolean execute(RecoveryProcessorContext context) {
        try {
            RefactorConfigurationProviderMgr refactorCfgProviderMgr = RefactorConfigurationProviderMgr.getInstance();
            RecoveryPlan recoveryPlan = context.getRecoveryPlan();
            DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType(recoveryPlan);
            IRefactorConfigurationProvider provider = refactorCfgProviderMgr.getRefactorConfigurationProvider(appType.name());
            if (provider == null) {
                throw new LegoCheckedException(1073947393L);
            }
            provider.refactorConfiguration(recoveryPlan);
            Set protectGroups = recoveryPlan.getProtectGroups();
            for (ProtectGroup pg : protectGroups) {
                pg.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            }
            IReprotectService reprotectService = (IReprotectService)ServiceLocator.getInstance().getService(IReprotectService.class);
            reprotectService.saveReprotectUpdate(recoveryPlan);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Refactoring configuration failed.", (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Refactoring configuration failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }
}

