/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class ReprotectBaseRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -5396809361839075163L;
    private static final Log logger = LogFactory.getInstance(ReprotectBaseRecoveryProcessor.class);

    public ReprotectBaseRecoveryProcessor() {
    }

    public ReprotectBaseRecoveryProcessor(RecoveryProcessor parentProcess) {
        this();
        if (parentProcess == null) {
            return;
        }
        this.setProcName(this.getName());
        this.setProcType(parentProcess.getProcType());
        this.setPlanId(parentProcess.getPlanId());
        this.setParentProc(parentProcess);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    protected String generateResultKey() {
        return this.getName() + "_" + this.getPlanId();
    }

    protected String getRecoveryArrayByPg(ProtectGroup pg, String disasterSiteId) {
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || null == replica.getRecoverySite() || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            return replica.getRecoveryArray();
        }
        return null;
    }

    protected String getProductArrayByPg(ProtectGroup pg, String disasterSiteId) {
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || null == replica.getRecoverySite() || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            return replica.getProductArray();
        }
        return null;
    }

    protected List<String> getLunIds(ProtectGroup pg, String disasterSiteId) {
        ArrayList<String> lunIds = new ArrayList<String>();
        ProtectGroupReplica pgReplica = null;
        String recoveryArray = "";
        for (ProtectGroupReplica replica : pg.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || null == replica.getRecoverySite() || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            pgReplica = replica;
            recoveryArray = pgReplica.getRecoveryArray();
            break;
        }
        if (pgReplica == null) {
            return lunIds;
        }
        for (ProtectGroupReplica replica : pgReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : replica.getStorageInfos()) {
                if (!recoveryArray.equals(storageInfo.getStorageProviderSN())) continue;
                lunIds.add(storageInfo.getStorageId());
            }
        }
        return lunIds;
    }

    protected boolean saveProcessors(Set<RecoveryProcessor> subProcessors) {
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        boolean result = recoveryProcessService.updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }
}

