/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.provider;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.provider.DeleteProcessorByNameComparator;
import com.huawei.ism.drm.recovery.framework.provider.IComparator;
import com.huawei.ism.drm.recovery.framework.template.RecoveryProcessDefTemplateMgr;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseRecoveryProcessProvider
implements IRecoveryProcessProvider {
    private static final Log logger = LogFactory.getInstance(BaseRecoveryProcessProvider.class);
    private static List<Integer> isSuitablePTTypesForLocal = new ArrayList<Integer>();
    private static List<Integer> isSuitablePTTypesForRemote = new ArrayList<Integer>();
    private static List<Integer> supportedPolicyTplTypesForReprotect = new ArrayList<Integer>();
    private static List<Integer> unSupportedTypesForReprotectOnRemoteDisasterSite = new ArrayList<Integer>();

    public RecoveryProcessDefinition getRecoveryProcess(RecoveryPlan recoveryPlan, String disasterSiteId, DrmEnumDefine.AppType appType, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, ProtectGroup protectGroup) {
        DrmEnumDefine.RecoveryTargetType recoveryTargetTypeE = DrmEnumDefine.RecoveryTargetType.getType((String)recoveryPlan.getRecoveryTargetType());
        Integer replicaType = recoveryPlan.getReplicaType();
        RecoveryProcessDefinition rpDefinition = this.createRecoveryProcess(recoveryPlan.getPlanId(), disasterSiteId, appType, execType, recoveryTargetTypeE, replicaType, protectGroup);
        if (rpDefinition == null) {
            logger.error((Object)"the rpDefinition is null");
            throw new LegoCheckedException(-1L);
        }
        this.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, false);
        Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.resetEnableStatus(protectGroup, execType);
        }
        return rpDefinition;
    }

    public Set<RecoveryProcessDefinition> getRecoveryProcesses(RecoveryPlan recoveryPlan, DrmEnumDefine.AppType appType, ProtectGroup protectGroup) {
        DrmEnumDefine.RecoveryTargetType recoveryTargetTypeE = DrmEnumDefine.RecoveryTargetType.getType((String)recoveryPlan.getRecoveryTargetType());
        Integer replicaType = recoveryPlan.getReplicaType();
        HashSet<RecoveryProcessDefinition> rpDefinitiones = new HashSet<RecoveryProcessDefinition>();
        List<DrmEnumDefine.RecoveryPlanExecuteTypeE> procTypes = this.getSuitableProcTypes(recoveryPlan);
        for (DrmEnumDefine.RecoveryPlanExecuteTypeE procType : procTypes) {
            RecoveryProcessDefinition rpDefinition = this.createRecoveryProcess(recoveryPlan.getPlanId(), null, appType, procType, recoveryTargetTypeE, replicaType, protectGroup);
            if (rpDefinition == null) {
                logger.debug((Object)"rpDefinition is null");
                continue;
            }
            this.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, false);
            Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
            for (RecoveryProcessor processor : recoveryProcessors) {
                processor.resetEnableStatus(protectGroup, procType);
            }
            rpDefinitiones.add(rpDefinition);
        }
        return rpDefinitiones;
    }

    public int getProtectionType(ProtectGroup protectGroup) {
        logger.debug((Object)"enter getProtectionType");
        return protectGroup.getTemplate().getType();
    }

    public Map<Integer, Class<? extends RecoveryProcessor>> registerSyncProcessor() {
        logger.debug((Object)"begin registerSyncProcessor");
        return new HashMap<Integer, Class<? extends RecoveryProcessor>>();
    }

    public void setRecoveryProcessorEnableStatus(RecoveryProcessDefinition recoveryProcessDef, List<Class<? extends RecoveryProcessor>> processores, boolean isEnable) {
        if (VerifyUtil.isEmpty((Collection)recoveryProcessDef.getRecoveryProcessors())) {
            logger.debug((Object)"param is null");
            return;
        }
        for (RecoveryProcessor processor : recoveryProcessDef.getRecoveryProcessors()) {
            if (!this.isSameRecoveryProcess(processor, processores)) continue;
            processor.setIsEnabled(Boolean.valueOf(isEnable));
        }
    }

    public void insertRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> afterProcCls, RecoveryProcessor recoveryProcessor, boolean isEnable, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || recoveryProcessDef.getRecoveryProcessors().isEmpty() || afterProcCls == null || recoveryProcessor == null) {
            logger.debug((Object)"param is null");
            return;
        }
        RecoveryProcessor indexProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, afterProcCls);
        if (indexProcessor == null) {
            return;
        }
        this.addRecoveryProcessors(recoveryProcessDef, indexProcessor, indexProcessor.getNextProcessor(), recoveryProcessor, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public void insertRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor afterProcessor, RecoveryProcessor recoveryProcessor, boolean isEnable, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || recoveryProcessDef.getRecoveryProcessors().isEmpty() || afterProcessor == null || recoveryProcessor == null) {
            logger.debug((Object)"param is null");
            return;
        }
        RecoveryProcessor indexProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, afterProcessor);
        if (indexProcessor == null) {
            return;
        }
        this.addRecoveryProcessors(recoveryProcessDef, indexProcessor, indexProcessor.getNextProcessor(), recoveryProcessor, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public void insertRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> afterProcCls, List<Class<? extends RecoveryProcessor>> procClsList, boolean isEnable, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || recoveryProcessDef.getRecoveryProcessors().isEmpty() || afterProcCls == null || procClsList == null || procClsList.isEmpty()) {
            logger.debug((Object)"param is null");
            return;
        }
        RecoveryProcessor indexProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, afterProcCls);
        if (indexProcessor == null) {
            return;
        }
        this.addRecoveryProcessors(recoveryProcessDef, indexProcessor, indexProcessor.getNextProcessor(), procClsList, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public void deleteRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, final String procId, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || procId == null || procId.isEmpty()) {
            logger.debug((Object)"param is null");
            throw new LegoCheckedException(1073947393L);
        }
        IComparator<RecoveryProcessor> comparator = new IComparator<RecoveryProcessor>(){

            @Override
            public boolean isEqual(RecoveryProcessor processor) {
                return processor != null && processor.getProcId().equals(procId);
            }
        };
        this.removeRecoveryProcessors(recoveryProcessDef, comparator, isNeedUpdateDb);
    }

    public void deleteRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, List<Class<? extends RecoveryProcessor>> procClsList, boolean isNeedUpdateDb) {
        if (recoveryProcessDef == null || procClsList == null || procClsList.isEmpty()) {
            logger.debug((Object)"param is null");
            return;
        }
        for (Class<? extends RecoveryProcessor> rProcCls : procClsList) {
            DeleteProcessorByNameComparator comparator = new DeleteProcessorByNameComparator(rProcCls);
            this.removeRecoveryProcessors(recoveryProcessDef, comparator, isNeedUpdateDb);
        }
    }

    public void replaceRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> startProcCls, Class<? extends RecoveryProcessor> endProcCls, List<Class<? extends RecoveryProcessor>> procClsList, boolean isEnable, boolean isNeedUpdateDb) {
        if (this.isReplaceProcessorParamEmpty(recoveryProcessDef, startProcCls, endProcCls, procClsList)) {
            return;
        }
        RecoveryProcessor startProcessor = this.getStartRecoveryProcessor(recoveryProcessDef, startProcCls);
        if (startProcessor == null) {
            logger.error((Object)("Does not find the start processor. ClassName:" + startProcCls.getName()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        RecoveryProcessor endProcessor = null;
        ArrayList<Class<? extends RecoveryProcessor>> processors = new ArrayList<Class<? extends RecoveryProcessor>>();
        RecoveryProcessor indexProcessor = startProcessor;
        do {
            processors.add(indexProcessor.getClass());
            indexProcessor = indexProcessor.getNextProcessor();
            if (indexProcessor == null || !indexProcessor.getClass().getName().equals(endProcCls.getName())) continue;
            endProcessor = indexProcessor;
            processors.add(endProcessor.getClass());
            break;
        } while (indexProcessor != null);
        this.deleteRecoveryProcessors(recoveryProcessDef, processors, isNeedUpdateDb);
        if (endProcessor == null) {
            logger.error((Object)"Invalid end processor", 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        this.addRecoveryProcessors(recoveryProcessDef, startProcessor.getPreviousProcessor(), endProcessor.getNextProcessor(), procClsList, isEnable);
        if (isNeedUpdateDb) {
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
        }
    }

    public boolean isSuitableProtectGroup(DrmEnumDefine.RecoveryPlanTypeE planType, ProtectGroup protectGroup) {
        Integer policyTemplateType = protectGroup.getTemplate().getType();
        if (DrmEnumDefine.RecoveryPlanTypeE.LOCAL.equals((Object)planType)) {
            return isSuitablePTTypesForLocal.contains(policyTemplateType);
        }
        return isSuitablePTTypesForRemote.contains(policyTemplateType);
    }

    public void checkIfAllowReprotect(RecoveryPlan recoveryPlan) {
        if (recoveryPlan == null || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            logger.error((Object)"recoveryPlan is null or getProtectGroups is empty", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        String extAttributes = (String)recoveryPlan.getGlobalSettings().get("RECOVERY_EXTEND_ATTRIBUTES");
        if (String.valueOf(DrmEnumDefine.RecoveryExtendAttributes.REFACTOR_CONFIGURATION_SUCCESS.getValue()).equals(extAttributes)) {
            return;
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        Integer policyTemplateType = protectGroup.getTemplate().getType();
        if (!supportedPolicyTplTypesForReprotect.contains(policyTemplateType)) {
            logger.error((Object)"Reprotect is not supported for the policy template.", 90160758784001L);
            throw new LegoCheckedException(1073948736L);
        }
        if (ServiceInstaceEnumDefine.ObjectType.NAS.getValue().equals(recoveryPlan.getObjectType())) {
            logger.info((Object)"The NAS recovery plan(%s) does not need to verify ProtectGroupReplica.", new Object[]{recoveryPlan.getName()});
            return;
        }
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        ProtectGroupReplica pgReplica = null;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            pgReplica = replica;
            break;
        }
        if (pgReplica == null) {
            logger.error((Object)"There is no suited protect group replica.", 90160758784001L);
            throw new LegoCheckedException(-1L);
        }
        if (unSupportedTypesForReprotectOnRemoteDisasterSite.contains(policyTemplateType) && this.isRecoveryToRemoteDisasterSite(pgReplica)) {
            logger.error((Object)"Reprotect is not supported after switching to remote disaster center.", 90160758784001L);
            throw new LegoCheckedException(1073948737L);
        }
    }

    public Map<String, Object> checkRecoveryContext(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, User operator) {
        logger.debug((Object)"return new HashMap<String, Object>()");
        return new HashMap<String, Object>();
    }

    public boolean checkIfAllowDelete(RecoveryProcessor recoveryProcessor) {
        logger.debug((Object)"enter checkIfAllowDelete");
        if (recoveryProcessor == null) {
            logger.debug((Object)"param is null");
            return true;
        }
        return recoveryProcessor.getIsPreset() == false;
    }

    public String getRecoverySiteId(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        logger.debug((Object)"return null");
        return "";
    }

    public String getRecoverySiteId(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        return "";
    }

    public void encryptProperties(RecoveryPlan recoveryPlan) {
        logger.debug((Object)"enter encryptProperties");
    }

    public void decryptPropreties(RecoveryPlan recoveryPlan) {
        logger.debug((Object)"enter decryptPropreties");
    }

    protected boolean isSameRecoveryProcess(RecoveryProcessor recoveryProcessor, List<Class<? extends RecoveryProcessor>> classes) {
        if (recoveryProcessor == null || VerifyUtil.isEmpty(classes)) {
            logger.debug((Object)"param is null");
            return false;
        }
        for (Class<? extends RecoveryProcessor> cls : classes) {
            if (!recoveryProcessor.getClass().getName().equals(cls.getName())) continue;
            return true;
        }
        return false;
    }

    protected String getDisterSiteId(String defaultSiteId, ProtectGroup pg) {
        logger.debug((Object)"enter getDisterSiteId");
        ProtectGroupReplica rep = RecoveryProcessUtil.getProtectGroupReplicaBySiteId(pg, defaultSiteId);
        if (rep != null) {
            return rep.getRecoverySite();
        }
        return defaultSiteId;
    }

    private void removeRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, IComparator<RecoveryProcessor> comparator, boolean isNeedUpdateDb) {
        RecoveryProcessor delProcessor = this.getDeletedRecoveryProcessor(recoveryProcessDef, comparator);
        if (delProcessor == null) {
            logger.error((Object)"The processor does not exist.", 90160758784001L);
            return;
        }
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        RecoveryProcessor preProcessor = delProcessor.getPreviousProcessor();
        RecoveryProcessor nextProcessor = delProcessor.getNextProcessor();
        if (preProcessor != null) {
            preProcessor.setNextProcessor(nextProcessor);
        }
        if (nextProcessor != null) {
            nextProcessor.setPreviousProcessor(preProcessor);
        }
        delProcessor.setPreviousProcessor(null);
        delProcessor.setNextProcessor(null);
        if (isNeedUpdateDb) {
            recoveryProcessService.updateRecoveryProcessDefinition(recoveryProcessDef);
            recoveryProcessService.deleteRecoveryProcessor(delProcessor);
        }
        recoveryProcessDef.getRecoveryProcessors().remove(delProcessor);
    }

    private RecoveryProcessor getDeletedRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, IComparator<RecoveryProcessor> comparator) {
        RecoveryProcessor delProcessor = null;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (RecoveryProcessor rProcessor : recoveryProcessors) {
            if (!comparator.isEqual(rProcessor)) {
                logger.debug((Object)"the tow is not same");
                continue;
            }
            delProcessor = rProcessor;
            break;
        }
        return delProcessor;
    }

    private RecoveryProcessor getStartRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> startProcCls) {
        RecoveryProcessor startProcessor = null;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (RecoveryProcessor recoveryProcessor : recoveryProcessors) {
            if (!recoveryProcessor.getClass().getName().equals(startProcCls.getName())) {
                logger.debug((Object)"the two not same");
                continue;
            }
            startProcessor = recoveryProcessor;
            break;
        }
        return startProcessor;
    }

    private RecoveryProcessor getStartRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor startProcessor) {
        RecoveryProcessor newStartProcessor = null;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (RecoveryProcessor recoveryProcessor : recoveryProcessors) {
            if (!recoveryProcessor.getProcId().equals(startProcessor.getProcId())) {
                logger.debug((Object)"the two not same");
                continue;
            }
            newStartProcessor = recoveryProcessor;
            break;
        }
        return newStartProcessor;
    }

    private void addRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor startRProcessor, RecoveryProcessor endRProcessor, RecoveryProcessor processor, boolean isEnable) {
        RecoveryProcessor indexStartRProcessor = startRProcessor;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        recoveryProcessors.add(processor);
        processor.setProcType(recoveryProcessDef.getProcType());
        processor.setIsEnabled(Boolean.valueOf(isEnable));
        indexStartRProcessor.setNextProcessor(processor);
        processor.setPreviousProcessor(indexStartRProcessor);
        RecoveryProcessor indexEndRProcessor = endRProcessor;
        if (indexEndRProcessor == null) {
            logger.debug((Object)"param is null");
            return;
        }
        processor.setNextProcessor(indexEndRProcessor);
        indexEndRProcessor.setPreviousProcessor(processor);
    }

    private void addRecoveryProcessors(RecoveryProcessDefinition recoveryProcessDef, RecoveryProcessor startRProcessor, RecoveryProcessor endRProcessor, List<Class<? extends RecoveryProcessor>> procClsList, boolean isEnable) {
        RecoveryProcessor indexStartRProcessor = startRProcessor;
        RecoveryProcessor indexEndRProcessor = endRProcessor;
        Set recoveryProcessors = recoveryProcessDef.getRecoveryProcessors();
        for (Class<? extends RecoveryProcessor> processorCls : procClsList) {
            RecoveryProcessor processor = this.createRecoveryProcessor(processorCls);
            processor.setProcName(processor.getName());
            processor.setProcType(recoveryProcessDef.getProcType());
            processor.setIsEnabled(Boolean.valueOf(isEnable));
            if (startRProcessor == null) {
                indexStartRProcessor = processor;
                logger.debug((Object)"param is null");
                continue;
            }
            indexStartRProcessor.setNextProcessor(processor);
            processor.setPreviousProcessor(indexStartRProcessor);
            recoveryProcessors.add(processor);
            indexStartRProcessor = processor;
        }
        if (indexEndRProcessor != null) {
            indexStartRProcessor.setNextProcessor(indexEndRProcessor);
            indexEndRProcessor.setPreviousProcessor(indexStartRProcessor);
        }
    }

    private RecoveryProcessor createRecoveryProcessor(Class<? extends RecoveryProcessor> processorCls) {
        RecoveryProcessor processor = null;
        try {
            processor = processorCls.newInstance();
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Creating recovery processor failed. ClsName:" + processorCls.getName()), (long)-1L, (String[])new String[0], (Log)logger);
        }
        return processor;
    }

    private RecoveryProcessDefinition createRecoveryProcess(String planId, String disasterSiteId, DrmEnumDefine.AppType appType, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, DrmEnumDefine.RecoveryTargetType recoveryTargetType, Integer replicaType, ProtectGroup protectGroup) {
        int protectionType = replicaType != null ? replicaType.intValue() : this.getProtectionType(protectGroup);
        RecoveryProcessDefTemplateMgr templateMgr = RecoveryProcessDefTemplateMgr.getInstance();
        Set<RecoveryProcessor> recoveryProcessors = templateMgr.createRecoveryProcessors(appType, execType, recoveryTargetType, protectionType);
        if (recoveryProcessors == null || recoveryProcessors.isEmpty()) {
            logger.debug((Object)"param is null");
            return null;
        }
        RecoveryProcessDefinition rpDefinition = new RecoveryProcessDefinition();
        this.initRecoveryProcessors(recoveryProcessors, planId, rpDefinition.getProcessId());
        rpDefinition.setPlanId(planId);
        rpDefinition.setDisasterSiteId(disasterSiteId);
        rpDefinition.setProcType(execType.getValue());
        rpDefinition.setAppType(appType.getValue());
        rpDefinition.setProtectionType(protectionType);
        rpDefinition.setVersion(templateMgr.getVersion(appType, execType, recoveryTargetType, protectionType));
        rpDefinition.setRecoveryProcessors(recoveryProcessors);
        return rpDefinition;
    }

    private void initRecoveryProcessors(Set<RecoveryProcessor> recoveryProcessors, String planId, String processId) {
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.setProcessId(processId);
            processor.setPlanId(planId);
            if (VerifyUtil.isEmpty((Collection)processor.getChildProc())) continue;
            logger.debug((Object)"the param is not null");
            this.initRecoveryProcessors(processor.getChildProc(), planId, processId);
        }
    }

    private List<DrmEnumDefine.RecoveryPlanExecuteTypeE> getSuitableProcTypes(RecoveryPlan recoveryPlan) {
        ArrayList<DrmEnumDefine.RecoveryPlanExecuteTypeE> procTypes = new ArrayList<DrmEnumDefine.RecoveryPlanExecuteTypeE>();
        logger.debug((Object)("recoveryPlan.getPlanType()=" + recoveryPlan.getPlanType()));
        if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == recoveryPlan.getPlanType()) {
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT);
        } else {
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
            procTypes.add(DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING);
        }
        return procTypes;
    }

    private boolean isRecoveryToRemoteDisasterSite(ProtectGroupReplica pgReplica) {
        logger.debug((Object)"enter isRecoveryToRemoteDisasterSite");
        return DrmEnumDefine.ProtectLocation.A_C.getValue() == pgReplica.getProtectLocation() || DrmEnumDefine.ProtectLocation.B_C.getValue() == pgReplica.getProtectLocation() || DrmEnumDefine.ProtectLocation.C_C.getValue() == pgReplica.getProtectLocation();
    }

    private boolean isReplaceProcessorParamEmpty(RecoveryProcessDefinition recoveryProcessDef, Class<? extends RecoveryProcessor> startProcCls, Class<? extends RecoveryProcessor> endProcCls, List<Class<? extends RecoveryProcessor>> procClsList) {
        logger.debug((Object)"check param is null");
        return recoveryProcessDef == null || VerifyUtil.isEmpty((Collection)recoveryProcessDef.getRecoveryProcessors()) || startProcCls == null || endProcCls == null || VerifyUtil.isEmpty(procClsList);
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
        logger.debug((Object)"enter checkRecoverySettings");
    }

    public List<RecoveryProcessor> filterProcessor(List<RecoveryProcessor> processors, Map<String, String> filters) {
        return null;
    }

    static {
        isSuitablePTTypesForRemote.add(21);
        isSuitablePTTypesForRemote.add(22);
        isSuitablePTTypesForRemote.add(25);
        isSuitablePTTypesForRemote.add(34);
        isSuitablePTTypesForRemote.add(37);
        isSuitablePTTypesForRemote.add(38);
        supportedPolicyTplTypesForReprotect.add(21);
        supportedPolicyTplTypesForReprotect.add(22);
        supportedPolicyTplTypesForReprotect.add(25);
        supportedPolicyTplTypesForReprotect.add(34);
        supportedPolicyTplTypesForReprotect.add(37);
        supportedPolicyTplTypesForReprotect.add(38);
        supportedPolicyTplTypesForReprotect.add(39);
    }
}

