/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.provider;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.service.ITaskManager;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.task.sdk.service.IProtectionTaskService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationProvider;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.RecoveryUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public abstract class BaseRefactorConfigurationProvider
implements IRefactorConfigurationProvider {
    private static final Log logger = LogFactory.getInstance(BaseRefactorConfigurationProvider.class);
    private static final Set<Integer> TEMPLATE3DC = new HashSet<Integer>();
    private static final Set<Integer> TEMPLATE4DC = new HashSet<Integer>();
    private static List<Integer> lagReversalReplicaTypeList = Arrays.asList(33);
    private static Map<Integer, Integer> mapTemplate = new HashMap<Integer, Integer>();
    private ThreadLocal<String> isReversed = new ThreadLocal();

    protected Boolean getIsReversed() {
        logger.debug((Object)"getIsReversed");
        if (this.isReversed != null && "true".equalsIgnoreCase(this.isReversed.get())) {
            return true;
        }
        return false;
    }

    protected void setIsReversed(String reversedValue) {
        if (this.isReversed == null) {
            logger.error((Object)"isReversed is null");
            return;
        }
        this.isReversed.set(reversedValue);
    }

    public void refactorConfiguration(RecoveryPlan recoveryPlan) {
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String disasterSiteId = (String)globalSettings.get("DISASTER_SITE_ID");
        if (ServiceInstaceEnumDefine.ObjectType.NAS.getValue().equals(recoveryPlan.getObjectType())) {
            disasterSiteId = recoveryPlan.getProtectGroup().getProductSiteId();
        }
        logger.debug((Object)"disasterSiteId:%s, recoveryPlan name=%s", new Object[]{disasterSiteId, recoveryPlan.getName()});
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site disasterSite = siteService.getSiteById(disasterSiteId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("DISASTER_SITE_ID", disasterSiteId);
        if (!VerifyUtil.isEmpty((String)((String)globalSettings.get("PRODUCT_SITE_ID")))) {
            params.put("PRODUCT_SITE_ID", globalSettings.get("PRODUCT_SITE_ID"));
        }
        if (!VerifyUtil.isEmpty((String)((String)globalSettings.get("SELECT_DISASTER_SITE_KEY")))) {
            params.put("SELECT_DISASTER_SITE_KEY", globalSettings.get("SELECT_DISASTER_SITE_KEY"));
        }
        this.extractGlobalSettingToParams(globalSettings, params, "pg_hypermetro_domain");
        this.extractGlobalSettingToParams(globalSettings, params, "pg_hypermetro_domain_id");
        HashMap<String, String> pgAndDisasterHosts = new HashMap<String, String>();
        params.put("PG_DISASTER_HOST", pgAndDisasterHosts);
        String isReversedInGlobalSetting = (String)globalSettings.get("isReserved");
        this.setIsReversed(isReversedInGlobalSetting);
        params.put("isReserved", isReversedInGlobalSetting);
        params.put("RecoveryPlan", recoveryPlan);
        this.refactorConfigurationDoMethod(recoveryPlan, disasterSiteId, disasterSite, params, pgAndDisasterHosts);
        this.refactorRecoveryPlan(recoveryPlan, params);
    }

    private void extractGlobalSettingToParams(Map<String, String> globalSettings, Map<String, Object> params, String key) {
        if (!VerifyUtil.isEmpty((String)globalSettings.get(key))) {
            params.put(key, globalSettings.get(key));
        }
    }

    private void refactorConfigurationDoMethod(RecoveryPlan recoveryPlan, String disasterSiteId, Site disasterSite, Map<String, Object> params, Map<String, String> pgAndDisasterHosts) {
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            RecoverySetting setting = RecoveryUtil.getRecoverySetting((String)recoveryPlan.getPlanId(), (String)protectGroup.getUuid(), (String)"PG_DISASTER_HOST", (Set)recoveryPlan.getRecoverySettings());
            if (setting != null) {
                pgAndDisasterHosts.put(protectGroup.getUuid(), setting.getValue());
            }
            protectGroup.setProductSiteId(disasterSiteId);
            protectGroup.setProductSiteName(disasterSite.getName());
            this.refactorProtectGroup(protectGroup, params);
            int oldTemplateType = protectGroup.getTemplate().getType();
            PolicyTemplate newTemplate = ProtectGroupHelper.getInstance().matchAvailableTemplate(protectGroup);
            if (!VerifyUtil.isEmpty((Object)newTemplate)) {
                protectGroup.setTemplate(newTemplate);
            } else {
                this.refactorPolicyTemplate(protectGroup);
            }
            if (!lagReversalReplicaTypeList.contains(oldTemplateType)) {
                this.refactorLocalScheduleAndProps(protectGroup, oldTemplateType);
            } else {
                protectGroup.getProps().put("FS_last_recovery_plan_execute_type", String.valueOf(recoveryPlan.getLastExecuteType()));
            }
            logger.debug((Object)"after refactorLocalScheduleAndPropsrecoveryPlan name=%s", new Object[]{recoveryPlan.getName()});
            if (25 != protectGroup.getTemplate().getType() && !PolicyTemplateTools.getInstance().isCshaCsdrWithinRegionRecovery(protectGroup) && protectGroup.getPoType() != 17) {
                logger.debug((Object)"CleanRemote and buildReplica, protectGroupName=%s", new Object[]{protectGroup.getName()});
                ProtectGroupUtil.clearRemoteReplicas(protectGroup.getReplicaList());
                ProtectGroupHelper.getInstance().buildReplica(protectGroup, false);
                this.refactorLocalReplica(protectGroup, params);
            }
            if (lagReversalReplicaTypeList.contains(oldTemplateType)) {
                this.refactorLocalScheduleAndProps(protectGroup, oldTemplateType);
                protectGroup.getProps().remove("FS_last_recovery_plan_execute_type");
            }
            this.resumeGroup(protectGroup);
        }
    }

    private void updateDRRingScheduleProtectLocationPath(Map<Integer, ProtectLocationPath> locationMap, int policyTemplateType, Schedule schedule) {
        boolean flag = false;
        if (!VerifyUtil.isEmpty(locationMap) && locationMap.keySet().contains(DrmEnumDefine.ProtectLocation.C_C.getValue())) {
            flag = true;
        }
        if (flag && (schedule.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_C.getValue() || schedule.getProtectLocation() == DrmEnumDefine.ProtectLocation.B_C.getValue())) {
            schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.C_C.getValue());
        } else if (!(flag || policyTemplateType != 3 || schedule.getProtectLocation() != DrmEnumDefine.ProtectLocation.C_C.getValue() && schedule.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_C.getValue())) {
            schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.B_C.getValue());
        } else if (!(flag || policyTemplateType != 5 || schedule.getProtectLocation() != DrmEnumDefine.ProtectLocation.C_C.getValue() && schedule.getProtectLocation() != DrmEnumDefine.ProtectLocation.B_C.getValue())) {
            schedule.setProtectLocation(DrmEnumDefine.ProtectLocation.A_C.getValue());
        }
    }

    public void saveConfiguration(RecoveryPlan recoveryPlan) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan oldRecoveryPlan = planService.getRecoveryPlan(recoveryPlan.getPlanId());
        if (oldRecoveryPlan == null) {
            logger.error((Object)("The recovery plan does not exist. PlanName:" + recoveryPlan.getPlanId()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        String isReversedInGlobalSetting = (String)recoveryPlan.getGlobalSettings().get("isReserved");
        this.setIsReversed(isReversedInGlobalSetting);
        this.updateRecoveryPlan(oldRecoveryPlan, recoveryPlan);
        IProtectionTaskService protectionTaskService = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
        for (ProtectGroup oldProtectGroup : oldRecoveryPlan.getProtectGroups()) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)oldProtectGroup.getTemplate());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)oldProtectGroup);
            protectionTaskService.createTask(oldProtectGroup);
            this.deleteProtectActions(oldProtectGroup.getUuid());
        }
        this.deleteRemovedRecoverySettings(oldRecoveryPlan.getRecoverySettings(), recoveryPlan.getRecoverySettings());
        this.updateRecoveryProcessDef(recoveryPlan);
        oldRecoveryPlan.getRecoverySettings().clear();
        oldRecoveryPlan.getRecoverySettings().addAll(recoveryPlan.getRecoverySettings());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)oldRecoveryPlan);
    }

    protected void updateRecoveryPlan(RecoveryPlan recoveryPlanInDb, RecoveryPlan newRecoveryPlan) {
        recoveryPlanInDb.getGlobalSettings().clear();
        recoveryPlanInDb.getGlobalSettings().putAll(newRecoveryPlan.getGlobalSettings());
        Set oldProtectGroups = recoveryPlanInDb.getProtectGroups();
        Set newProtectGroups = newRecoveryPlan.getProtectGroups();
        for (ProtectGroup oldProtectGroup : oldProtectGroups) {
            DRMObject drmObject = this.getMatchedDrmObject(newProtectGroups, (DRMObject)oldProtectGroup);
            if (drmObject == null) {
                logger.debug((Object)"drmObject is null!");
                continue;
            }
            ProtectGroup newProtectGroup = (ProtectGroup)drmObject;
            this.updateProtectGroup(oldProtectGroup, newProtectGroup);
        }
    }

    protected void refactorRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, Object> params) {
        logger.debug((Object)"refactorRecoveryPlan");
        HashMap<String, String> newGlobalSettings = new HashMap<String, String>();
        newGlobalSettings.put("RECOVERY_EXTEND_ATTRIBUTES", String.valueOf(DrmEnumDefine.RecoveryExtendAttributes.REFACTOR_CONFIGURATION_SUCCESS.getValue()));
        newGlobalSettings.put("DISASTER_SITE_ID", params.get("DISASTER_SITE_ID").toString());
        newGlobalSettings.put("isReserved", String.valueOf(params.get("isReserved")));
        if (!VerifyUtil.isEmpty((Object)params.get("PRODUCT_SITE_ID"))) {
            newGlobalSettings.put("PRODUCT_SITE_ID", String.valueOf(params.get("PRODUCT_SITE_ID")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("SELECT_DISASTER_SITE_KEY"))) {
            newGlobalSettings.put("SELECT_DISASTER_SITE_KEY", String.valueOf(params.get("SELECT_DISASTER_SITE_KEY")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("pg_hypermetro_domain"))) {
            newGlobalSettings.put("pg_hypermetro_domain", String.valueOf(params.get("pg_hypermetro_domain")));
        }
        if (!VerifyUtil.isEmpty((Object)params.get("pg_hypermetro_domain_id"))) {
            newGlobalSettings.put("pg_hypermetro_domain_id", String.valueOf(params.get("pg_hypermetro_domain_id")));
        }
        recoveryPlan.setGlobalSettings(newGlobalSettings);
        HashSet<RecoverySetting> needRemovedSettings = new HashSet<RecoverySetting>();
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        for (RecoverySetting recoverySetting : recoverySettings) {
            if (!"PG_DISASTER_HOST".equals(recoverySetting.getName())) continue;
            needRemovedSettings.add(recoverySetting);
        }
        for (RecoverySetting setting : needRemovedSettings) {
            recoverySettings.remove(setting);
        }
    }

    protected void updateProtectGroup(ProtectGroup oldProtectGroup, ProtectGroup newProtectGroup) {
        oldProtectGroup.setProductSiteId(newProtectGroup.getProductSiteId());
        oldProtectGroup.setProductSiteName(newProtectGroup.getProductSiteName());
        oldProtectGroup.setStatus(newProtectGroup.getStatus());
        oldProtectGroup.setPrimary(newProtectGroup.isPrimary());
        oldProtectGroup.setPoProviderSN(newProtectGroup.getPoProviderSN());
        oldProtectGroup.setProps(this.updateExtendedProps(oldProtectGroup.getProps(), newProtectGroup.getProps()));
        PolicyTemplate oldTemplate = oldProtectGroup.getTemplate();
        PolicyTemplate newTemplate = newProtectGroup.getTemplate();
        oldTemplate.setType(newTemplate.getType());
        oldTemplate.setSketch(newTemplate.getSketch());
        oldTemplate.setEditTemplateUrl(newTemplate.getEditTemplateUrl());
        oldTemplate.setViewTemplateUrl(newTemplate.getViewTemplateUrl());
        oldTemplate.setName(newTemplate.getName());
        oldTemplate.setDescription(newTemplate.getDescription());
        oldTemplate.setProps(this.updateExtendedProps(oldTemplate.getProps(), newTemplate.getProps()));
        this.deleteProtectionTasks(oldProtectGroup.getUuid());
        oldTemplate.getSchedules().clear();
        oldTemplate.getSchedules().addAll(newTemplate.getSchedules());
        ProtectGroupUtil.clearRemoteReplicas(oldProtectGroup.getReplicaList());
        oldProtectGroup.getReplicaList().addAll(newProtectGroup.getReplicaList());
        Set oldProtectObjects = oldProtectGroup.getPolist();
        Set newProtectObjects = newProtectGroup.getPolist();
        for (ProtectObject oldProtectObject : oldProtectObjects) {
            DRMObject drmObject = this.getMatchedDrmObject(newProtectObjects, (DRMObject)oldProtectObject);
            if (drmObject == null) {
                logger.debug((Object)"drmObject is null!");
                continue;
            }
            ProtectObject newProtectObject = (ProtectObject)drmObject;
            this.updateProtectObject(oldProtectObject, newProtectObject);
        }
    }

    protected void refactorProtectGroup(ProtectGroup protectGroup, Map<String, Object> params) {
        protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
        protectGroup.setPrimary(true);
        protectGroup.setLastExecResult(null);
        this.reverseProtectGroupAttributes(protectGroup, params);
        logger.debug((Object)"after reverseProtectGroupAttributes:recoveryPlan name%s", new Object[]{protectGroup.getName()});
        for (ProtectObject po : protectGroup.getPolist()) {
            po.setPoRecoveryStatus(DrmEnumDefine.ProtectObjectRecoveryStatusE.NOT_STARTED.getValue());
            this.refactorProtectObject(po, params);
        }
    }

    protected void updateProtectObject(ProtectObject oldProtectObject, ProtectObject newProtectObject) {
        logger.debug((Object)"updateProtectObject");
        oldProtectObject.setMoUuid(newProtectObject.getMoUuid());
        oldProtectObject.setProviderSN(newProtectObject.getProviderSN());
        oldProtectObject.setPoRecoveryStatus(newProtectObject.getPoRecoveryStatus());
        oldProtectObject.setName(newProtectObject.getName());
        oldProtectObject.setProps(this.updateExtendedProps(oldProtectObject.getProps(), newProtectObject.getProps()));
        Set oldPoStorageInfos = oldProtectObject.getUsedStorageResourceSet();
        Set newPoStorageInfos = newProtectObject.getUsedStorageResourceSet();
        Iterator oldIterator = oldPoStorageInfos.iterator();
        while (oldIterator.hasNext()) {
            ProtectObjectStorageInfo oldPoStorageInfo = (ProtectObjectStorageInfo)oldIterator.next();
            boolean isExist = false;
            Iterator newIterator = newPoStorageInfos.iterator();
            while (newIterator.hasNext()) {
                ProtectObjectStorageInfo newPoStorageInfo = (ProtectObjectStorageInfo)newIterator.next();
                if (!oldPoStorageInfo.getId().equals(newPoStorageInfo.getId())) continue;
                this.updateProtectObjectStorageInfo(oldPoStorageInfo, newPoStorageInfo);
                newIterator.remove();
                isExist = true;
                break;
            }
            if (isExist) continue;
            CommonDAOLocator.getBaseDao().getHibernateTemplate().delete((Object)oldPoStorageInfo);
            oldIterator.remove();
            oldIterator = oldPoStorageInfos.iterator();
        }
        for (ProtectObjectStorageInfo newPoStorageInfo : newPoStorageInfos) {
            newPoStorageInfo.setProtectObject(oldProtectObject);
            oldProtectObject.getUsedStorageResourceSet().add(newPoStorageInfo);
        }
    }

    protected void refactorProtectObject(ProtectObject protectObject, Map<String, Object> params) {
        this.refactorProtectObjectStorageInfos(protectObject, params);
        long start = System.currentTimeMillis();
        this.reverseProtectObjectAttributes(protectObject, params);
        logger.debug((Object)"reverseProtectObjectAttributes cost time:%s", System.currentTimeMillis() - start);
    }

    protected void updateProtectObjectStorageInfo(ProtectObjectStorageInfo oldPoStorageInfo, ProtectObjectStorageInfo newPoStorageInfo) {
        logger.debug((Object)"updateProtectObjectStorageInfo");
        oldPoStorageInfo.setResourceProviderSN(newPoStorageInfo.getResourceProviderSN());
        oldPoStorageInfo.setResourceId(newPoStorageInfo.getResourceId());
        oldPoStorageInfo.setLunWWN(newPoStorageInfo.getLunWWN());
    }

    protected void caculateOToNewWwnMap(List<ProtectObjectStorageInfo> oldStorageInfoList, ProtectObject protectObject, Map<String, Object> params) {
        HashMap oldStorageInfoWwnMap = new HashMap();
        oldStorageInfoList.stream().forEach(storageInfo -> oldStorageInfoWwnMap.put(storageInfo.getResourceProviderSN() + ':' + storageInfo.getResourceId(), storageInfo.getLunWWN()));
        ProtectObjectReplica curPoReplica = this.getProtectObjectReplica(protectObject, params);
        HashMap devResourceIdList = new HashMap();
        for (RelicaStorageInfo storageInfo2 : curPoReplica.getStorageInfos()) {
            CommUtil.addToMap(devResourceIdList, (String)storageInfo2.getSrcStorageProviderSN(), (Object)storageInfo2.getSrcStorageId());
            CommUtil.addToMap(devResourceIdList, (String)storageInfo2.getStorageProviderSN(), (Object)storageInfo2.getStorageId());
        }
        HashMap olToNewWwnMap = new HashMap();
        params.put("olToNewWwnMap", olToNewWwnMap);
    }

    protected void refactorProtectObjectStorageInfos(ProtectObject protectObject, Map<String, Object> params) {
        Iterator iterator = protectObject.getUsedStorageResourceSet().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = protectObject.getProtectGroup();
        if (pg == null) {
            return;
        }
        HashMap olToNewWwnMap = new HashMap();
        params.put("olToNewWwnMap", olToNewWwnMap);
    }

    protected void refactorPolicyTemplate(ProtectGroup pg) {
        IPolicyTemplateManager policyTemplateManager;
        PolicyTemplate newTemplate;
        Integer newTemplateType = mapTemplate.get(pg.getTemplate().getType());
        if (newTemplateType == null) {
            newTemplateType = pg.getTemplate().getType();
        }
        if ((newTemplate = (policyTemplateManager = (IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).clonePolicyTemlate(newTemplateType.intValue())) == null) {
            logger.error((Object)("There is no matched template in db. Type:" + newTemplateType), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        PolicyTemplate oldTemplate = pg.getTemplate();
        oldTemplate.setType(newTemplate.getType());
        oldTemplate.setSketch(newTemplate.getSketch());
        oldTemplate.setEditTemplateUrl(newTemplate.getEditTemplateUrl());
        oldTemplate.setViewTemplateUrl(newTemplate.getViewTemplateUrl());
        oldTemplate.setName(newTemplate.getName());
        oldTemplate.setDescription(newTemplate.getDescription());
        Set schedules = newTemplate.getSchedules();
        if (!VerifyUtil.isEmpty((Collection)schedules)) {
            for (Schedule schedule : schedules) {
                schedule.setScheduleId(UUIDGenerator.getUUID());
            }
        }
        if (TEMPLATE3DC.contains(newTemplate.getType()) || TEMPLATE4DC.contains(newTemplate.getType()) || !this.getIsReversed().booleanValue()) {
            oldTemplate.setSchedules(schedules);
            if (oldTemplate.getProps().containsKey("syncRateRecords")) {
                oldTemplate.getProps().put("syncRateRecords", "[]");
            }
        }
    }

    protected abstract void reverseProtectObjectAttributes(ProtectObject var1, Map<String, Object> var2);

    protected abstract void reverseProtectGroupAttributes(ProtectGroup var1, Map<String, Object> var2);

    protected ProtectObjectReplica getProtectObjectReplica(ProtectObject protectObject, Map<String, Object> params) {
        String disasterSiteId = String.valueOf(params.get("DISASTER_SITE_ID"));
        String productSiteId = String.valueOf(params.get("PRODUCT_SITE_ID"));
        ProtectGroupReplica pgReplica = null;
        Set pgReplicas = protectObject.getProtectGroup().getReplicaList();
        for (ProtectGroupReplica replica : pgReplicas) {
            if (ProtectGroupUtil.isLocalStorageReplica(replica) || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            pgReplica = replica;
            break;
        }
        if (pgReplica == null) {
            Set<String> productSiteIds = this.getProductSiteByPo(protectObject);
            for (ProtectGroupReplica replica : pgReplicas) {
                if (ProtectGroupUtil.isLocalStorageReplica(replica) || !productSiteIds.contains(replica.getRecoverySite()) && !productSiteId.equals(replica.getRecoverySite())) continue;
                pgReplica = replica;
                break;
            }
        }
        ProtectObjectReplica curPoReplica = null;
        if (pgReplica != null) {
            for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
                if (!poReplica.getPoId().equals(protectObject.getUuid())) continue;
                curPoReplica = poReplica;
                break;
            }
        }
        if (curPoReplica == null) {
            logger.error((Object)"curPoReplica is null!");
            throw new LegoCheckedException(-1L);
        }
        return curPoReplica;
    }

    private Set<String> getProductSiteByPo(ProtectObject protectObject) {
        HashSet<String> productSiteIds = new HashSet<String>();
        Set storageInfos = protectObject.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)storageInfos)) {
            logger.error((Object)"storageInfos is empty, poName: %s", new Object[]{protectObject.getName()});
            return productSiteIds;
        }
        return productSiteIds;
    }

    private Map<String, String> updateExtendedProps(Map<String, String> oldProps, Map<String, String> newProps) {
        if (VerifyUtil.isEmpty(newProps)) {
            logger.debug((Object)"newProps is empty!");
            return oldProps;
        }
        if (oldProps == null) {
            oldProps = new HashMap<String, String>();
        }
        for (Map.Entry<String, String> entry : newProps.entrySet()) {
            oldProps.put(entry.getKey(), entry.getValue());
        }
        ArrayList<String> oldKeys = new ArrayList<String>();
        for (Map.Entry<String, String> entry : oldProps.entrySet()) {
            if (newProps.containsKey(entry.getKey())) continue;
            oldKeys.add(entry.getKey());
        }
        for (String oldKey : oldKeys) {
            oldProps.remove(oldKey);
        }
        return oldProps;
    }

    private void resumeGroup(ProtectGroup pg) {
        ITaskManager protectionTaskManager = (ITaskManager)ServiceLocator.getInstance().getService(ITaskManager.class);
        String groupName = protectionTaskManager.getGroupName(pg.getUuid());
        protectionTaskManager.resumeGroup(groupName);
        logger.debug((Object)"uuid:%s, groupName:%s", new Object[]{pg.getUuid(), groupName});
    }

    private void deleteRemovedRecoverySettings(Set<RecoverySetting> oldRecoverySettings, Set<RecoverySetting> newRecoverySettings) {
        logger.debug((Object)"deleteRemovedRecoverySettings");
        for (RecoverySetting setting : oldRecoverySettings) {
            if (newRecoverySettings.contains(setting)) continue;
            CommonDAOLocator.getMoDao().getHibernateTemplate().delete((Object)setting);
        }
    }

    private void deleteProtectionTasks(String protectGroupId) {
        logger.info((Object)"protectGroupId:%s", new Object[]{protectGroupId});
        List<ProtectionTask> tasks = this.getProtectionTasks(protectGroupId);
        if (tasks != null) {
            for (ProtectionTask task : tasks) {
                CommonDAOLocator.getMoDao().getHibernateTemplate().delete((Object)task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProtectionTask> getProtectionTasks(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            logger.error((Object)"invalid parameter", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        List tasks = null;
        Session session = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(ProtectionTask.class);
            criteria.add((Criterion)Restrictions.eq((String)"protectGroup.pgId", (Object)protectGroupId));
            tasks = criteria.list();
        }
        catch (Exception e) {
            try {
                ExceptionUtil.rethrowException((Throwable)e, (String)("get tasks by pgId failed, pgId=" + protectGroupId), (long)-1L, (String[])new String[0], (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession(session);
        }
        DBOperationUtil.closeSession(session);
        return tasks;
    }

    private void updateRecoveryProcessDef(RecoveryPlan recoveryPlan) {
        IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        RecoveryPlan planWithProcess = planService.getRecoveryPlanWithProcess(recoveryPlan.getPlanId());
        if (planWithProcess == null) {
            logger.error((Object)("The recovery plan does not exist. Name:" + recoveryPlan.getName()), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        Set definitions = planWithProcess.getRecoveryProcesses();
        if (VerifyUtil.isEmpty((Collection)definitions)) {
            return;
        }
        IRecoveryProcessProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider(recoveryPlan);
        if (provider == null) {
            logger.error((Object)("provicer is null: " + recoveryPlan.getPlanId()), 90160758784001L);
            throw new LegoCheckedException(1073947395L);
        }
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        for (RecoveryProcessDefinition definition : definitions) {
            Integer newProtectionType = mapTemplate.get(definition.getProtectionType());
            if (newProtectionType == null) continue;
            definition.setProtectionType(newProtectionType.intValue());
            recoveryProcessService.updateRecoveryProcessDefinition(definition);
        }
    }

    private void deleteProtectActions(String pgId) {
        logger.debug((Object)"pgId:%s", new Object[]{pgId});
        String hql = "from AbstractBaseProtectAction action where action.protectGroupId=?";
        List actions = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{pgId});
        if (!VerifyUtil.isEmpty((Collection)actions)) {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().deleteAll((Collection)actions);
        }
    }

    private DRMObject getMatchedDrmObject(Set<? extends DRMObject> drmObjects, DRMObject drmObject) {
        for (DRMObject dRMObject : drmObjects) {
            if (!dRMObject.getUuid().equals(drmObject.getUuid())) continue;
            return dRMObject;
        }
        logger.warn((Object)"getMatchedDrmObject return null.");
        return null;
    }

    private boolean refactorLocalReplica(ProtectGroup pg, Map<String, Object> params) {
        boolean changed = false;
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Collection)pg.getReplicaList())) {
            return changed;
        }
        ProtectGroupReplica remotePgReplica = pg.getAnyoneReplicationReplica();
        if (VerifyUtil.isEmpty((Object)remotePgReplica)) {
            return changed;
        }
        HashMap<String, ProtectObject> poMap = new HashMap<String, ProtectObject>();
        for (ProtectObject po : pg.getPolist()) {
            poMap.put(po.getUuid(), po);
        }
        for (ProtectGroupReplica pgr : pg.getReplicaList()) {
            if (!pgr.isSanSnapshotReplica() && !pgr.isBackUpReplica()) continue;
            if (remotePgReplica.getProductArray().equals(pgr.getStorageDeviceId()) && pgr.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_A.getValue()) {
                changed = true;
                pgr.setProtectLocation(DrmEnumDefine.ProtectLocation.A_A.getValue());
                pgr.setProductArray(remotePgReplica.getProductArray());
            } else if (remotePgReplica.getRecoveryArray().equals(pgr.getStorageDeviceId()) && pgr.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_B.getValue()) {
                changed = true;
                pgr.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
                pgr.setProductArray(remotePgReplica.getProductArray());
            }
            Set replicas = pgr.getReplicas();
            this.refactorLocalPoReplica(remotePgReplica, replicas, poMap, params);
        }
        if (changed) {
            CommonDAOLocator.getBaseDao().saveOrUpdateAll((Collection)pg.getReplicaList());
        }
        return changed;
    }

    protected void refactorLocalPoReplica(ProtectGroupReplica remotePgReplica, Set<ProtectObjectReplica> replicas, Map<String, ProtectObject> poMap, Map<String, Object> params) {
        if (VerifyUtil.isEmpty(replicas) || VerifyUtil.isEmpty((Object)remotePgReplica)) {
            return;
        }
        for (ProtectObjectReplica poReplica : replicas) {
            this.refactorRelicaStorageInfo(remotePgReplica, poReplica, params);
            ProtectObject po = poMap.get(poReplica.getPoId());
            if (!VerifyUtil.isEmpty((Object)po)) {
                poReplica.setProtectObject(po);
                continue;
            }
            logger.error((Object)("po not found:" + poReplica.getPoId()));
        }
    }

    protected void refactorRelicaStorageInfo(ProtectGroupReplica remotePgReplica, ProtectObjectReplica poReplica, Map<String, Object> params) {
        Set storageInfos = poReplica.getStorageInfos();
        ProtectObject po = poReplica.getProtectObject();
        if (VerifyUtil.isEmpty((Object)remotePgReplica) || VerifyUtil.isEmpty((Collection)storageInfos)) {
            return;
        }
        this.caculateOToNewWwnMap(new ArrayList<ProtectObjectStorageInfo>(po.getUsedStorageResourceSet()), (ProtectObject)CommonUtil.getFirstElement((Collection)remotePgReplica.getPg().getPolist()), params);
        HashSet remoteStorageInfos = new HashSet();
        Set remotePoReplicas = remotePgReplica.getReplicas();
        if (!VerifyUtil.isEmpty((Collection)remotePoReplicas)) {
            for (ProtectObjectReplica remotePoReplica : remotePoReplicas) {
                remoteStorageInfos.addAll(remotePoReplica.getStorageInfos());
            }
        }
        Map olToNewWwnMap = (Map)params.get("olToNewWwnMap");
        block1: for (RelicaStorageInfo storageInfo : storageInfos) {
            for (RelicaStorageInfo remoteStorageInfo : remoteStorageInfos) {
                if (!remoteStorageInfo.getSrcStorageId().equals(storageInfo.getSrcStorageId()) && !remoteStorageInfo.getStorageId().equals(storageInfo.getSrcStorageId()) && (olToNewWwnMap == null || !remoteStorageInfo.getProtectObjectStorageWwn().equals(olToNewWwnMap.get(storageInfo.getProtectObjectStorageWwn()))) && !remoteStorageInfo.getProtectObjectStorageWwn().equals(storageInfo.getProtectObjectStorageWwn())) continue;
                storageInfo.setProtectObjectStorageWwn(remoteStorageInfo.getProtectObjectStorageWwn());
                continue block1;
            }
        }
        for (RelicaStorageInfo storageInfo : po.getUsedStorageResourceSet()) {
            if (olToNewWwnMap == null) {
                return;
            }
            String newWwn = (String)olToNewWwnMap.get(storageInfo.getLunWWN());
            if (newWwn == null) continue;
            storageInfo.setLunWWN(newWwn);
        }
    }

    protected void resetWwnMap(ProtectObject po, ProtectGroupReplica remotePgReplica, Map<String, Object> params) {
    }

    private void refactorLocalScheduleAndProps(ProtectGroup pg, int oldPolicytemplateType) {
        TemplateFilterManager manager;
        IPolicyTemplateFilter filter;
        List<ProtectLocationPath> paths;
        if (VerifyUtil.isEmpty((Object)pg) || VerifyUtil.isEmpty((Object)pg.getTemplate())) {
            return;
        }
        PolicyTemplate template = pg.getTemplate();
        if (PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(template.getType())) {
            return;
        }
        if (null != template.getProps().get("AUTOMOUNTCONFIGS")) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"enabled", (Object)false);
            template.getProps().put("AUTOMOUNTCONFIGS", jsonObject.toString());
        }
        if ((paths = (filter = (manager = TemplateFilterManager.getInstance()).getTemplateFilterByType(template.getType())).getProtectLocationPaths(new ArrayList(pg.getPolist()))) == null) {
            logger.debug((Object)"paths is null");
            paths = Collections.emptyList();
        }
        pg.getProps().put("PROTECTGROUP_PROTECTLOCATIONPATH", JSONArray.fromObject(paths).toString());
        Set schedules = template.getSchedules();
        if (VerifyUtil.isEmpty((Collection)schedules)) {
            logger.error((Object)"no need reverse schedule.");
            return;
        }
        HashMap<String, ProtectLocationPath> pathMap = new HashMap<String, ProtectLocationPath>();
        for (ProtectLocationPath path : paths) {
            pathMap.put(path.getRecoverySiteId(), path);
        }
        HashMap<Integer, ProtectLocationPath> locationMap = new HashMap<Integer, ProtectLocationPath>();
        for (ProtectLocationPath path : paths) {
            locationMap.put(path.getProtectLocation(), path);
        }
        for (Schedule schedule : schedules) {
            this.updateSchedule(pg, pathMap, locationMap, schedule, oldPolicytemplateType, template.getType());
        }
    }

    private void updateSchedule(ProtectGroup protectGroup, Map<String, ProtectLocationPath> pathMap, Map<Integer, ProtectLocationPath> locationMap, Schedule schedule, int oldTemplateType, int newTemplateType) {
        if (11 == protectGroup.getPoType()) {
            schedule.setAppConsistent(Boolean.valueOf(false));
        }
        if (!ScheduleProtectedType.getAllProtectedTypes().contains(schedule.getProtectedType())) {
            this.updateDRRingScheduleProtectLocationPath(locationMap, newTemplateType, schedule);
            ProtectLocationPath path = locationMap.get(schedule.getProtectLocation());
            schedule.setSourceSiteId(path.getProtectedSiteId());
            schedule.setTargetSiteId(path.getRecoverySiteId());
            schedule.setName(path.getProtectedSiteId() + ";" + path.getRecoverySiteId());
            schedule.setSourceSn(path.getProtectedStorageSN());
            schedule.setTargetSn(path.getRecoveryStorageSN());
            if (schedule.getProtectedType() == -1 || schedule.getProtectedType() == oldTemplateType) {
                schedule.setProtectedType(newTemplateType);
            }
            return;
        }
        if (null == schedule.getSourceSiteId()) {
            this.setScheduleManual(protectGroup, schedule);
            return;
        }
        ProtectLocationPath path = pathMap.get(schedule.getSourceSiteId());
        if (path == null) {
            schedule.setEnable(Boolean.valueOf(false));
        } else {
            Integer location = path.getProtectLocation();
            schedule.setSourceSiteId(path.getRecoverySiteId());
            schedule.setTargetSiteId(path.getRecoverySiteId());
            schedule.setProtectLocation(location.intValue());
        }
        if (schedule.getPeriodType() == 5) {
            this.setScheduleManual(protectGroup, schedule);
        }
        schedule.setScheduleMode(1);
    }

    private void setScheduleManual(ProtectGroup protectGroup, Schedule schedule) {
        if (schedule == null) {
            return;
        }
        IProtectionTaskService service = (IProtectionTaskService)ServiceLocator.getInstance().getService(IProtectionTaskService.class);
        schedule.setScheduleMode(1);
        schedule.setPeriodType(2);
        if (null != schedule.getRetentionPolicy()) {
            schedule.getRetentionPolicy().setLatestCopies(5);
            schedule.getRetentionPolicy().setDailyCopies(0);
            schedule.getRetentionPolicy().setWeeklyCopies(0);
            schedule.getRetentionPolicy().setMonthlyCopyies(0);
        }
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)service.getTask(protectGroup.getUuid(), schedule.getScheduleId()))) {
            service.addTask(protectGroup, schedule);
        }
    }

    static {
        mapTemplate.put(4, 6);
        mapTemplate.put(6, 4);
        mapTemplate.put(3, 5);
        mapTemplate.put(5, 3);
        mapTemplate.put(18, 20);
        mapTemplate.put(20, 18);
        mapTemplate.put(23, 24);
        mapTemplate.put(24, 23);
        mapTemplate.put(31, 32);
        mapTemplate.put(32, 31);
        mapTemplate.put(35, 36);
        mapTemplate.put(36, 35);
        mapTemplate.put(26, 27);
        mapTemplate.put(27, 26);
        TEMPLATE3DC.add(4);
        TEMPLATE3DC.add(6);
        TEMPLATE3DC.add(3);
        TEMPLATE3DC.add(5);
        TEMPLATE3DC.add(26);
        TEMPLATE3DC.add(27);
        TEMPLATE4DC.add(35);
        TEMPLATE4DC.add(36);
    }
}

