/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.drm.util.FusionCloudUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class FixedRecoveryThreadPool {
    private static final Log logger = LogFactory.getInstance(FixedRecoveryThreadPool.class);
    private static final String STR_DEFAULT_POOL_SIZE = "80";
    private static final String STR_LARGE_SPECIFICATION_POOL_SIZE = "260";
    private static final int MIN_RECOVERY_POOL_SIZE = 10;
    private static final int MAX_RECOVERY_POOL_SIZE = 300;
    private static final String STR_DEFAULT_SFS_POOL_SIZE = "5";
    private static final int MIN_SFS_POOL_SIZE = 1;
    private static final int MAX_SFS_POOL_SIZE = 50;
    private static ExecutorService executorService;
    private static ExecutorService executorServiceForSfs;

    private FixedRecoveryThreadPool() {
    }

    private static int getRecoveryPoolSize() {
        int poolSize = Integer.parseInt(LegoConfig.getInstance().getKeyValue("recovery.thread.pool.size", STR_DEFAULT_POOL_SIZE));
        if (Runtime.getRuntime().availableProcessors() >= 8 && FusionCloudUtil.isCurrentFCVersionHighThanParamVerion((String)"6.3")) {
            poolSize = Integer.parseInt(LegoConfig.getInstance().getKeyValue("recovery.large.specifications.thread.pool.size", STR_LARGE_SPECIFICATION_POOL_SIZE));
        }
        poolSize = Math.max(10, poolSize);
        poolSize = Math.min(300, poolSize);
        logger.info((Object)"Fixed recovery ThreadPool, poolSize=%s", new Object[]{String.valueOf(poolSize)});
        return poolSize;
    }

    private static int getSfsPoolSize() {
        int sfsPoolSize = Integer.parseInt(LegoConfig.getInstance().getKeyValue("sfs.recovery.thread.pool.size", STR_DEFAULT_SFS_POOL_SIZE));
        sfsPoolSize = Math.max(1, sfsPoolSize);
        sfsPoolSize = Math.min(50, sfsPoolSize);
        logger.info((Object)"Fixed recovery ThreadPool, sfsPoolSize=%s", new Object[]{String.valueOf(sfsPoolSize)});
        return sfsPoolSize;
    }

    public static Future<Boolean> submit(Callable<Boolean> callable) {
        return executorService.submit(callable);
    }

    public static Future<Boolean> submitSfsReq(Callable<Boolean> callable) {
        return executorServiceForSfs.submit(callable);
    }

    static {
        int poolSize = Integer.parseInt(STR_DEFAULT_POOL_SIZE);
        int sfsPoolSize = Integer.parseInt(STR_DEFAULT_SFS_POOL_SIZE);
        try {
            poolSize = FixedRecoveryThreadPool.getRecoveryPoolSize();
            sfsPoolSize = FixedRecoveryThreadPool.getSfsPoolSize();
        }
        catch (Exception e) {
            logger.error((Object)"Getting the config [thread.pool.size] failed, ErrMsg: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        executorService = Executors.newFixedThreadPool(poolSize);
        executorServiceForSfs = new ThreadPoolExecutor(sfsPoolSize, sfsPoolSize, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE));
    }
}

