/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanObserverManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.util.MotionPausedUtils;
import com.huawei.ism.drm.recovery.process.IInitialChildProcessor;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.ism.drm.recovery.task.IRecoveryBackTask;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.base.util.KeyLocker;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncaughtExceptionHandler;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class RecoveryBackTask
implements IRecoveryBackTask {
    private static final Log logger = LogFactory.getInstance(RecoveryBackTask.class);
    public static final KeyLocker RUN_TASK_LOCKER = new KeyLocker(RecoveryBackTask.class, "RUN_TASK_LOCK");
    private static final String SEPARATOR = ":";
    private static ConcurrentHashMap<String, AtomicInteger> concurrentHashMap;
    private RecoveryPlan recoveryPlan;
    private DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType;
    private User operator;
    private RecoveryProcessSerialExecutor recoveryProcessTemplate;
    private Map<String, Object> preProcessResults = new HashMap<String, Object>();
    private Map<String, Object> initialContextData = new HashMap<String, Object>();
    private ICallBackExcuteRecoveryTask callBaskTask;

    public static final synchronized ConcurrentHashMap getConcurrentHashMapInstance() {
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap();
        }
        return concurrentHashMap;
    }

    public void setCallBaskTask(ICallBackExcuteRecoveryTask callBaskTask) {
        this.callBaskTask = callBaskTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        String regionId = this.getRegionId("regionId");
        String drRegionId = this.getRegionId("drRegionId");
        try {
            if (this.tryLockRecoveryPlan(this.recoveryPlan.getPlanId(), regionId, drRegionId)) {
                return;
            }
            String planIdPrefix = this.recoveryPlan.getPlanId().substring(0, 8);
            Thread.currentThread().setName("RecoveryTask_" + planIdPrefix + "_" + this.recoveryPlanExecuteType.getValue());
            Thread.currentThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LegoUncaughtExceptionHandler.getInstance());
            RecoveryProcessorContext context = new RecoveryProcessorContext();
            this.initializeRecoveryContext(context, this.preProcessResults);
            this.initializeRecoveryContext(context, this.initialContextData);
            context.setRecoveryPlan(this.recoveryPlan);
            if (this.recoveryPlan.getGlobalSettings().containsKey("isReserved")) {
                context.setAttribute("isReserved", this.recoveryPlan.getGlobalSettings().get("isReserved"));
            }
            RecoveryProcessResult processResult = new RecoveryProcessResult();
            context.setProcessResult(processResult);
            if (this.contextSetProperties(context)) {
                return;
            }
            this.execute(context);
        }
        finally {
            this.unLockRecoveryPlan(this.recoveryPlan.getPlanId(), regionId, drRegionId);
        }
    }

    private boolean contextSetProperties(RecoveryProcessorContext context) {
        String recoveryLogId;
        String productionSiteId = RecoveryServiceUtil.getProductSiteId(this.recoveryPlan);
        context.setAttribute("PRODUCT_SITE_ID", (Object)productionSiteId);
        String disasterSiteId = (String)this.recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        context.setDisasterSiteId(disasterSiteId);
        String selDisasterSiteId = (String)this.recoveryPlan.getGlobalSettings().get("SELECT_DISASTER_SITE_KEY");
        if (null != selDisasterSiteId) {
            context.setAttribute("SELECT_DISASTER_SITE_KEY", (Object)selDisasterSiteId);
        }
        if (this.isPaused()) {
            RecoveryLog log = this.queryRecoveryLog(productionSiteId, disasterSiteId);
            if (log == null) {
                logger.error((Object)"RecoverLog is null.");
                throw new LegoCheckedException("RecoverLog is null.");
            }
            recoveryLogId = log.getLogId();
        } else {
            recoveryLogId = this.addRecoveryLog(null, productionSiteId, disasterSiteId, (RecoveryProcessDefinition)context.getAttribute("RecoveryProcessDefinition"));
        }
        if (recoveryLogId == null) {
            logger.error((Object)"Adding recovery log failed.", 90160758784001L);
            return true;
        }
        context.setRecoveryLogId(recoveryLogId);
        context.setProcessStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        context.setAttribute("PLAN_EXEXUTE_TYPE", (Object)this.recoveryPlanExecuteType);
        return false;
    }

    private String getRegionId(String key) {
        ProtectGroup pg = this.recoveryPlan.getProtectGroup();
        String regionId = (String)pg.getProps().get(key);
        if (!VerifyUtil.isEmpty((String)regionId) && regionId.contains(SEPARATOR)) {
            regionId = regionId.split(SEPARATOR)[1];
        }
        return regionId;
    }

    private boolean isPaused() {
        return DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)this.recoveryPlanExecuteType) && DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue() == this.recoveryPlan.getPlanStatus();
    }

    protected boolean tryLockRecoveryPlan(String planId, String regionId, String drRegionId) {
        int remoteRegionNum;
        ConcurrentHashMap parallelMap = RecoveryBackTask.getConcurrentHashMapInstance();
        if (!RUN_TASK_LOCKER.tryLock(planId)) {
            logger.error((Object)"The recovery plan is executing. PlanId:%s", new Object[]{this.recoveryPlan.getPlanId(), 90160758784001L});
            return true;
        }
        if (VerifyUtil.isEmpty((String)regionId) && VerifyUtil.isEmpty((String)drRegionId)) {
            return false;
        }
        if (regionId != null && regionId.equals(drRegionId)) {
            this.setParallelValue(regionId, parallelMap);
        } else {
            this.setParallelValue(regionId, parallelMap);
            this.setParallelValue(drRegionId, parallelMap);
        }
        long count = LegoConfig.getInstance().getNumber("region.parallel.run.quantity.config", 10L);
        int localRegionNum = regionId != null && !VerifyUtil.isEmpty(parallelMap.get(regionId)) ? ((AtomicInteger)parallelMap.get(regionId)).intValue() : 0;
        int n = remoteRegionNum = drRegionId != null && !VerifyUtil.isEmpty(parallelMap.get(drRegionId)) ? ((AtomicInteger)parallelMap.get(drRegionId)).intValue() : 0;
        if ((long)localRegionNum > count || (long)remoteRegionNum > count) {
            logger.error((Object)"Recovery parallel run is more than [%s]", new Object[]{String.valueOf(count)});
            throw new SpecCheckedException("recovery_parallel_execution_quantity", count, (long)Math.max(localRegionNum, remoteRegionNum));
        }
        return false;
    }

    private void releaseParallelValue(String id, ConcurrentHashMap<String, AtomicInteger> releaseMap) {
        AtomicInteger times;
        if (!VerifyUtil.isEmpty((String)id) && releaseMap.containsKey(id) && (times = releaseMap.get(id)).intValue() > 0) {
            times.decrementAndGet();
        }
    }

    private void setParallelValue(String id, ConcurrentHashMap<String, AtomicInteger> parallelMap) {
        if (VerifyUtil.isEmpty((String)id)) {
            return;
        }
        if (parallelMap.containsKey(id)) {
            AtomicInteger times = parallelMap.get(id);
            times.incrementAndGet();
        } else {
            parallelMap.put(id, new AtomicInteger(1));
        }
    }

    protected void unLockRecoveryPlan(String planId, String regionId, String drRegionId) {
        ConcurrentHashMap concurrentMap = RecoveryBackTask.getConcurrentHashMapInstance();
        if (RUN_TASK_LOCKER.isHeldByCurrentThread(planId)) {
            if (!VerifyUtil.isEmpty((String)regionId) && regionId.equals(drRegionId)) {
                this.releaseParallelValue(regionId, concurrentMap);
            } else {
                this.releaseParallelValue(regionId, concurrentMap);
                this.releaseParallelValue(drRegionId, concurrentMap);
            }
        }
        RUN_TASK_LOCKER.unlock(planId);
    }

    public RecoveryPlan getRecoveryPlan() {
        return this.recoveryPlan;
    }

    public DrmEnumDefine.RecoveryPlanExecuteTypeE getRecoveryPlanExecuteType() {
        return this.recoveryPlanExecuteType;
    }

    public User getOperator() {
        return this.operator;
    }

    public RecoveryProcessSerialExecutor getRecoveryProcessTemplate() {
        return this.recoveryProcessTemplate;
    }

    public void setOperator(User operator) {
        this.operator = operator;
    }

    public void setRecoveryPlan(RecoveryPlan recoveryPlan) {
        this.recoveryPlan = recoveryPlan;
    }

    public void setRecoveryProcessTemplate(IProcessor recoveryProcessTemplate) {
        this.recoveryProcessTemplate = (RecoveryProcessSerialExecutor)recoveryProcessTemplate;
    }

    public void setRecoveryPlanExecuteType(DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType) {
        logger.debug((Object)"recoveryPlanExecuteType");
        this.recoveryPlanExecuteType = recoveryPlanExecuteType;
    }

    protected void afterExecuteRecoveryPlan(boolean result, RecoveryProcessorContext context) {
        logger.debug((Object)"afterExecuteRecoveryPlan result:%s", new Object[]{result});
        int planStatus = this.calcRecoveryPlanStatus(result, context);
        Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap = this.calcPoRecoveryStatus(context, DrmEnumDefine.RecoveryPlanStatusE.getType((int)planStatus));
        Integer planProgress = 100;
        if (!result) {
            planProgress = null;
        }
        if (result && DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.recoveryPlanExecuteType.getValue() && planStatus == DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue()) {
            planProgress = this.calcPausedPlanProgress(context);
        }
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(this.recoveryPlan.getPlanId(), planStatus, this.recoveryPlanExecuteType, poRecoveryStatusMap, planProgress, context.getProcessStatus());
        if (this.callBaskTask != null) {
            this.callBaskTask.afterExecuteRecoveryPlan(context, this.recoveryPlan);
        }
    }

    private Integer calcPausedPlanProgress(RecoveryProcessorContext context) {
        Integer planProgress = 0;
        Object radio = context.getAttribute("PLAN_PROGRESS_RATIO");
        Object completedNum = context.getAttribute("PLAN_PROGRESS_COMPLETED_NUM");
        if (radio != null || completedNum != null) {
            try {
                planProgress = Integer.parseInt(String.valueOf(radio)) * Integer.parseInt(String.valueOf(completedNum));
            }
            catch (NumberFormatException ex) {
                logger.error((Object)"PlanProgress radio is %s,completedNum is %s.", new Object[]{radio, completedNum});
                planProgress = 0;
            }
        }
        return planProgress;
    }

    protected void beforeExecuteRecoveryPlan(RecoveryProcessorContext context) {
        boolean isPaused;
        this.cleanRecoveryProcesses();
        int planStatus = this.getRecoveryPlanExecuteType().getPlanRunningStatus();
        Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap = this.calcPoRecoveryStatus(context, DrmEnumDefine.RecoveryPlanStatusE.getType((int)planStatus));
        int planProgress = 0;
        boolean bl = isPaused = DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue() == this.recoveryPlan.getPlanStatus();
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)this.recoveryPlanExecuteType) && isPaused) {
            planProgress = this.recoveryPlan.getPlanProgress();
        }
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(this.recoveryPlan.getPlanId(), planStatus, this.recoveryPlanExecuteType, poRecoveryStatusMap, Integer.valueOf(planProgress), context.getProcessStatus());
        if (this.callBaskTask != null) {
            logger.debug((Object)"callBaskTask is not null!");
            this.callBaskTask.beforeExecuteRecoveryPlan(context, this.recoveryPlan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(RecoveryProcessorContext context) {
        Boolean result = null;
        try {
            MessageEvent event = new MessageEvent();
            HashMap<String, DrmEnumDefine.RecoveryPlanExecuteTypeE> messageMap = new HashMap<String, DrmEnumDefine.RecoveryPlanExecuteTypeE>();
            messageMap.put("message_event_excute_type", this.recoveryPlanExecuteType);
            event.setMessageMap(messageMap);
            event.setMessageType(6);
            ArrayList<RecoveryPlan> objectList = new ArrayList<RecoveryPlan>();
            objectList.add(context.getRecoveryPlan());
            event.setObjectList(objectList);
            IRecoveryPlanObserverManager observerManager = (IRecoveryPlanObserverManager)ServiceLocator.getInstance().getService(IRecoveryPlanObserverManager.class);
            observerManager.notifyObserverList(event, "before");
            this.beforeExecuteRecoveryPlan(context);
            result = this.recoveryProcessTemplate.checkMotionCancel(context, this.recoveryPlan) ? this.recoveryProcessTemplate.changeProcessorDetailStatus(context) : Boolean.valueOf(this.recoveryProcessTemplate.process(context));
            this.afterExecuteRecoveryPlan(result, context);
            event.getMessageMap().put("IS_CONTINUE_PROCESS", context.getAttribute("IS_CONTINUE_PROCESS"));
            observerManager.notifyObserverList(event, "after");
            DrmEnumDefine.RecoveryPlanExecuteResultE procResult = this.calcExecutionResult(result, context);
            if (null == procResult) {
                procResult = DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER;
            }
            this.updateRecoveryLog(context.getRecoveryLogId(), procResult);
            this.cleanRecoveryProcessesAfterOperation(procResult);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Executing recovery plan failed. PlanId:" + this.recoveryPlan.getPlanId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                this.executeException(context, result);
            }
            catch (Throwable throwable) {
                Object lockResult = context.getAttribute("LockProtectGroup");
                logger.info((Object)"LockProtectGroup=%s", new Object[]{lockResult});
                if (null != lockResult && ((Boolean)lockResult).booleanValue()) {
                    this.unlockProtectGroups(context, this.recoveryPlanExecuteType);
                }
                throw throwable;
            }
            Object lockResult = context.getAttribute("LockProtectGroup");
            logger.info((Object)"LockProtectGroup=%s", new Object[]{lockResult});
            if (null != lockResult && ((Boolean)lockResult).booleanValue()) {
                this.unlockProtectGroups(context, this.recoveryPlanExecuteType);
            }
        }
        Object lockResult = context.getAttribute("LockProtectGroup");
        logger.info((Object)"LockProtectGroup=%s", new Object[]{lockResult});
        if (null != lockResult && ((Boolean)lockResult).booleanValue()) {
            this.unlockProtectGroups(context, this.recoveryPlanExecuteType);
        }
    }

    private void executeException(RecoveryProcessorContext context, Boolean result) {
        this.updateRecoveryLog(context.getRecoveryLogId(), DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED);
        if (null != result) {
            DrmEnumDefine.RecoveryPlanExecuteResultE procResult = this.calcExecutionResult(result, context);
            if (procResult == null) {
                procResult = DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER;
            }
            this.updateRecoveryLog(context.getRecoveryLogId(), procResult);
            this.cleanRecoveryProcessesAfterOperation(procResult);
        }
    }

    private String addRecoveryLog(String recoveryLogName, String productionSiteId, String recoverySiteId, RecoveryProcessDefinition processes) {
        logger.debug((Object)"recoveryPlan:%s, executeType:%s, productionSiteId:%s", new Object[]{this.recoveryPlan.getName(), this.recoveryPlanExecuteType.getValue(), productionSiteId});
        RecoveryLog recoveryLog = new RecoveryLog();
        Date curDate = new Date();
        recoveryLog.setStartTime(String.valueOf(curDate.getTime()));
        recoveryLog.setLogName(recoveryLogName);
        recoveryLog.setLogStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.RUNNING.getValue());
        recoveryLog.setLogType(this.recoveryPlanExecuteType.getValue());
        recoveryLog.setOperator(this.operator.getUserName());
        recoveryLog.setPlanId(this.recoveryPlan.getPlanId());
        recoveryLog.setProductionSiteId(productionSiteId);
        recoveryLog.setRecoverySiteId(recoverySiteId);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        return rpService.createRecoveryLog(recoveryLog, processes);
    }

    private RecoveryLog queryRecoveryLog(String productionSiteId, String recoverySiteId) {
        RecoveryLog log = new RecoveryLog();
        log.setLogType(this.recoveryPlanExecuteType.getValue());
        log.setPlanId(this.recoveryPlan.getPlanId());
        log.setLogStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED.getValue());
        log.setRecoverySiteId(recoverySiteId);
        log.setProductionSiteId(productionSiteId);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        return rpService.queryRecoveryLog(log);
    }

    protected Map<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> calcPoRecoveryStatus(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanStatusE planStatus) {
        logger.debug((Object)"planStatus:%s", new Object[]{planStatus});
        int procType = this.recoveryPlanExecuteType.getValue();
        RecoveryProcessResult processResult = context.getProcessResult();
        HashMap<String, DrmEnumDefine.ProtectObjectRecoveryStatusE> poRecoveryStatusMap = new HashMap<String, DrmEnumDefine.ProtectObjectRecoveryStatusE>();
        Set protectObjects = context.getRecoveryProtectObjects();
        if (VerifyUtil.isEmpty((Collection)protectObjects)) {
            return poRecoveryStatusMap;
        }
        DrmEnumDefine.ProtectObjectRecoveryStatusE poRecoveryStatusForAllPo = this.calcPoRecoveryStatusForAll(planStatus);
        this.resetRecoveryProtectObjects(processResult, protectObjects);
        for (ProtectObject po : protectObjects) {
            DrmEnumDefine.ProtectObjectRecoveryStatusE newPoRecoveryStatus = this.calcPoRecoveryStatus(procType, processResult, poRecoveryStatusForAllPo, po.getUuid(), po.getPoType());
            poRecoveryStatusMap.put(po.getUuid(), newPoRecoveryStatus);
        }
        return poRecoveryStatusMap;
    }

    private void resetRecoveryProtectObjects(RecoveryProcessResult processResult, Set<ProtectObject> protectObjects) {
        Set<ProtectObject> recoveryPoSet = this.getRecoveryProtectObjects(processResult);
        if (VerifyUtil.isEmpty(recoveryPoSet)) {
            logger.debug((Object)"recoveryPoSet is empty!");
            return;
        }
        for (ProtectObject protectObject : protectObjects) {
            Iterator<ProtectObject> iter = recoveryPoSet.iterator();
            while (iter.hasNext()) {
                if (!protectObject.getUuid().equals(iter.next().getUuid())) continue;
                iter.remove();
                iter = recoveryPoSet.iterator();
            }
        }
        protectObjects.addAll(recoveryPoSet);
    }

    private Set<ProtectObject> getRecoveryProtectObjects(RecoveryProcessResult processResult) {
        if (processResult == null) {
            throw new LegoCheckedException("Result of process is null.");
        }
        HashSet<ProtectObject> protectObjects = new HashSet<ProtectObject>();
        Map procResults = processResult.getProcessResults("PoRecoveryStatus");
        if (VerifyUtil.isEmpty((Map)procResults)) {
            logger.debug((Object)"procResults is empty!");
            return protectObjects;
        }
        Set entrySet = procResults.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            String[] strArray = key.split(SEPARATOR);
            if (4 != strArray.length) continue;
            ProtectObject po = new ProtectObject();
            po.setUuid(strArray[2]);
            po.setPoType(NumberUtil.convertToInteger((Object)strArray[3]).intValue());
            protectObjects.add(po);
        }
        return protectObjects;
    }

    private DrmEnumDefine.ProtectObjectRecoveryStatusE calcPoRecoveryStatus(int procType, RecoveryProcessResult processResult, DrmEnumDefine.ProtectObjectRecoveryStatusE allPoRecoveryStatus, String poUuid, int poType) {
        String key;
        boolean result;
        DrmEnumDefine.ProtectObjectRecoveryStatusE newPoRecoveryStatus = allPoRecoveryStatus;
        if (DrmEnumDefine.ProtectObjectRecoveryStatusE.FAILED.getValue() == allPoRecoveryStatus.getValue() && (result = processResult.getProcessResult(key = RecoveryProcessResult.getPoRecoveryStatusKey((int)procType, (String)poUuid, (int)poType)))) {
            newPoRecoveryStatus = DrmEnumDefine.ProtectObjectRecoveryStatusE.COMPLETED;
        }
        logger.debug((Object)"newPoRecoveryStatus:%s", new Object[]{newPoRecoveryStatus});
        return newPoRecoveryStatus;
    }

    private boolean updateRecoveryLog(String recoveryLogId, DrmEnumDefine.RecoveryPlanExecuteResultE result) {
        IRecoveryProcessService recoveryPlanInterCalledService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        logger.debug((Object)"recoveryLogId:%s", new Object[]{recoveryLogId});
        return recoveryPlanInterCalledService.updateRecoveryLog(recoveryLogId, result.getValue(), String.valueOf(new Date().getTime()));
    }

    private void cleanRecoveryProcesses() {
        DrmEnumDefine.RecoveryPlanStatusE status = DrmEnumDefine.RecoveryPlanStatusE.getType((int)this.recoveryPlan.getPlanStatus());
        if (status == null) {
            return;
        }
        boolean cleanFlag = status.containsExecuteType(this.recoveryPlanExecuteType.getValue());
        logger.debug((Object)"cleanFlag:%s", new Object[]{cleanFlag});
        if (cleanFlag) {
            this.cleanRecoverySubProcessor(this.recoveryPlan, this.recoveryPlanExecuteType);
        }
    }

    protected void cleanRecoverySubProcessor(RecoveryPlan recoveryPlanParam, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        if (recoveryPlanParam == null || type == null) {
            logger.warn((Object)"The parameter is invalid.", 90160758784001L);
            return;
        }
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        RecoveryProcessDefinition rpDefinition = recoveryPlanParam.getRecoveryProcess(type);
        if (null == rpDefinition) {
            logger.warn((Object)("There is no matched recovery process definition. ExecType:" + type.getValue()), 90160758784001L);
            return;
        }
        Set recoveryProcesses = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor process : recoveryProcesses) {
            process.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            if (process.getProcType() != type.getValue() || null != process.getParentProc()) continue;
            if (process instanceof IInitialChildProcessor) {
                this.dealInitianlProcessor(type, recoveryProcessService, process);
                continue;
            }
            this.clearChildProc(recoveryProcessService, process);
        }
        recoveryProcessService.updateRecoveryPlan(recoveryPlanParam);
    }

    private void dealInitianlProcessor(DrmEnumDefine.RecoveryPlanExecuteTypeE type, IRecoveryProcessService recoveryProcessService, RecoveryProcessor process) {
        process.getChildProc().forEach(proc -> {
            proc.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
            if (proc.getProcType() == type.getValue()) {
                this.clearChildProc(recoveryProcessService, (RecoveryProcessor)proc);
            }
        });
    }

    private void clearChildProc(IRecoveryProcessService recoveryProcessService, RecoveryProcessor process) {
        if (null != process.getChildProc() && !process.getChildProc().isEmpty()) {
            recoveryProcessService.deleteSubRecoveryProcessor(process.getProcId());
            process.getChildProc().clear();
        }
    }

    private DrmEnumDefine.RecoveryPlanExecuteResultE calcExecutionResult(boolean result, RecoveryProcessorContext context) {
        DrmEnumDefine.RecoveryPlanExecuteResultE procResult;
        boolean isAllProcessorCompleted = this.recoveryProcessTemplate.isAllProcessorCompleted();
        if (!isAllProcessorCompleted) {
            boolean isPausedProcess;
            procResult = result ? DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS : DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED;
            Object pausedProcess = context == null ? null : context.getAttribute("IS_PAUSED_PROCESS");
            boolean bl = isPausedProcess = pausedProcess != null && Boolean.parseBoolean(String.valueOf(pausedProcess));
            if (result && context != null && isPausedProcess) {
                procResult = DrmEnumDefine.RecoveryPlanExecuteResultE.PAUSED;
            }
        } else {
            procResult = this.recoveryProcessTemplate.getLastProcessorResult();
        }
        logger.debug((Object)"procResult:%s", new Object[]{procResult});
        return procResult;
    }

    protected int calcRecoveryPlanStatus(boolean result, RecoveryProcessorContext context) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE executeType = this.recoveryPlanExecuteType;
        int planStatus = result ? executeType.getPlanSuccessStatus() : executeType.getPlanFailedStatus();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)this.recoveryPlan.getProtectGroups());
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.recoveryPlanExecuteType.getValue() && null != pg && PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(pg.getTemplate().getType())) {
            boolean isPausedProcess;
            planStatus = result ? DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() : DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue();
            Object pausedProcess = context.getAttribute("IS_PAUSED_PROCESS");
            boolean bl = isPausedProcess = pausedProcess != null && Boolean.parseBoolean(String.valueOf(pausedProcess));
            if (result && isPausedProcess && MotionPausedUtils.isMotionPaused(context)) {
                planStatus = executeType.getPlanPausedStatus();
            }
        }
        logger.debug((Object)"planStatus:%s", (long)planStatus);
        return planStatus;
    }

    protected DrmEnumDefine.ProtectObjectRecoveryStatusE calcPoRecoveryStatusForAll(DrmEnumDefine.RecoveryPlanStatusE planStatus) {
        DrmEnumDefine.ProtectObjectRecoveryStatusE poRecoveryStatusForAllPo = DrmEnumDefine.ProtectObjectRecoveryStatusE.NOT_STARTED;
        switch (planStatus) {
            case PLANED_MOTION_PAUSED: 
            case PLANED_MOTION_COMPLETED: 
            case DISASTER_RECOVERY_COMPLETED: {
                poRecoveryStatusForAllPo = DrmEnumDefine.ProtectObjectRecoveryStatusE.COMPLETED;
                break;
            }
            case PLANED_MOTION_RUNNING: 
            case DISASTER_RECOVERY_RUNNING: {
                poRecoveryStatusForAllPo = DrmEnumDefine.ProtectObjectRecoveryStatusE.RUNNING;
                break;
            }
            case PLANED_MOTION_FAILED: 
            case DISASTER_RECOVERY_FAILED: {
                poRecoveryStatusForAllPo = DrmEnumDefine.ProtectObjectRecoveryStatusE.FAILED;
                break;
            }
            default: {
                poRecoveryStatusForAllPo = DrmEnumDefine.ProtectObjectRecoveryStatusE.NOT_STARTED;
            }
        }
        logger.debug((Object)"poRecoveryStatusForAllPo:%s", new Object[]{poRecoveryStatusForAllPo});
        return poRecoveryStatusForAllPo;
    }

    private void cleanRecoveryProcessesAfterOperation(DrmEnumDefine.RecoveryPlanExecuteResultE result) {
        int excuteType = this.recoveryPlanExecuteType.getValue();
        logger.info((Object)"excuteType:%s", new Object[]{String.valueOf(excuteType)});
        DrmEnumDefine.RecoveryPlanExecuteTypeE executeTypeEnum = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)excuteType);
        if (result != null && DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == result.getValue()) {
            IRecoveryPlanService planService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
            RecoveryPlan plan = planService.getRecoveryPlan(this.recoveryPlan.getPlanId(), true, false);
            switch (executeTypeEnum) {
                case CLEAN_DRILLING: {
                    this.cleanRecoverySubProcessor(plan, this.recoveryPlanExecuteType);
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
                    break;
                }
                case REPROTECT: {
                    this.cleanRecoverySubProcessor(plan, this.recoveryPlanExecuteType);
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
                    break;
                }
                case PLANED_MOTION: {
                    ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)this.recoveryPlan.getProtectGroups());
                    if (pg == null || !PolicyTemplateType.OPENSTACK_POLICYTEMPLATE.contains(pg.getTemplate().getType())) break;
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
                    break;
                }
                case HOT_MIGRATION: {
                    this.cleanRecoverySubProcessor(plan, DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION);
                    break;
                }
            }
        }
    }

    private void unlockProtectGroups(RecoveryProcessorContext context, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        HashSet<DrmEnumDefine.RecoveryPlanExecuteTypeE> needUnlockType = new HashSet<DrmEnumDefine.RecoveryPlanExecuteTypeE>(Arrays.asList(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION));
        logger.debug((Object)("type:" + type));
        if (needUnlockType.contains(type) || DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue() == this.recoveryPlan.getPlanType()) {
            IRecoveryProcessHandler recoveryProcessHandler = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
            recoveryProcessHandler.unlockProtectGroups(context.getRecoveryPlan().getProtectGroups());
        }
    }

    public void setPreProcessResults(Map<String, Object> results) {
        logger.debug((Object)"setPreProcessResults");
        if (null != results) {
            this.preProcessResults.putAll(results);
        }
    }

    public Object getPreProcessResult(String key) {
        logger.info((Object)"key:%s", new Object[]{key});
        return this.preProcessResults.get(key);
    }

    public void setInitialContextData(Map<String, Object> initialContextData) {
        logger.debug((Object)"setInitialContextData");
        if (initialContextData != null) {
            this.initialContextData.putAll(initialContextData);
        }
    }

    private void initializeRecoveryContext(RecoveryProcessorContext context, Map<String, Object> initialData) {
        if (VerifyUtil.isEmpty(initialData)) {
            logger.debug((Object)"initialData is null,not initialize RecoveryContext.");
            return;
        }
        logger.info((Object)"result=%s", new Object[]{initialData});
        for (Map.Entry<String, Object> next : initialData.entrySet()) {
            context.setAttribute(next.getKey(), next.getValue());
        }
    }
}

